/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.modules.sys.security;

import com.jeeplus.common.config.Global;
import com.jeeplus.common.utils.Encodes;
import com.jeeplus.common.utils.SpringContextHolder;
import com.jeeplus.common.web.Servlets;
import com.jeeplus.modules.sys.entity.Menu;
import com.jeeplus.modules.sys.entity.Role;
import com.jeeplus.modules.sys.entity.User;
import com.jeeplus.modules.sys.security.SystemAuthorizingRealm;
import com.jeeplus.modules.sys.security.UsernamePasswordToken;
import com.jeeplus.modules.sys.service.SystemService;
import com.jeeplus.modules.sys.utils.LogUtils;
import com.jeeplus.modules.sys.utils.UserUtils;
import com.jeeplus.modules.sys.web.LoginController;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemAuthorizingRealm
extends AuthorizingRealm {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SystemService systemService;
    @Autowired
    HttpServletRequest request;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) {
        User user;
        boolean mobile;
        UsernamePasswordToken token = (UsernamePasswordToken)authcToken;
        int activeSessionSize = this.getSystemService().getSessionDao().getActiveSessions(false).size();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("login submit, active session size: {}, username: {}", (Object)activeSessionSize, (Object)token.getUsername());
        }
        if (!(mobile = WebUtils.isTrue((ServletRequest)this.request, (String)"mobileLogin")) && LoginController.isValidateCodeLogin((String)token.getUsername(), (boolean)false, (boolean)false)) {
            Session session = UserUtils.getSession();
            String code = (String)session.getAttribute((Object)"validateCode");
            if (token.getCaptcha() == null || !token.getCaptcha().toUpperCase().equals(code)) {
                throw new AuthenticationException("msg:\u9a8c\u8bc1\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5.");
            }
        }
        if ((user = this.getSystemService().getUserByLoginName(token.getUsername())) != null) {
            if (user.getLocked() == Global.ENABLE) {
                throw new AuthenticationException("msg:\u8be5\u5df2\u5e10\u53f7\u7981\u6b62\u767b\u5f55.");
            }
            byte[] salt = Encodes.decodeHex((String)user.getPassword().substring(0, 16));
            return new SimpleAuthenticationInfo((Object)new Principal(user, token.isMobileLogin()), (Object)user.getPassword().substring(16), ByteSource.Util.bytes((byte[])salt), this.getName());
        }
        return null;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        User user;
        Collection sessions;
        Principal principal = (Principal)this.getAvailablePrincipal(principals);
        if (!"true".equals(Global.getConfig((String)"user.multiAccountLogin")) && (sessions = this.getSystemService().getSessionDao().getActiveSessions(true, (Object)principal, UserUtils.getSession())).size() > 0) {
            if (UserUtils.getSubject().isAuthenticated()) {
                for (Session session : sessions) {
                    this.getSystemService().getSessionDao().delete(session);
                }
            } else {
                UserUtils.getSubject().logout();
                throw new AuthenticationException("msg:\u8d26\u53f7\u5df2\u5728\u5176\u5b83\u5730\u65b9\u767b\u5f55\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55\u3002");
            }
        }
        if ((user = this.getSystemService().getUserByLoginName(principal.getLoginName())) != null) {
            SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
            List list = UserUtils.getMenuList();
            for (Menu menu : list) {
                if (!StringUtils.isNotBlank((CharSequence)menu.getPermission())) continue;
                for (String permission : StringUtils.split((String)menu.getPermission(), (String)",")) {
                    info.addStringPermission(permission);
                }
            }
            info.addStringPermission("user");
            for (Role role : user.getRoleList()) {
                info.addRole(role.getEnname());
            }
            this.getSystemService().updateUserLoginInfo(user);
            LogUtils.saveLog((HttpServletRequest)Servlets.getRequest(), (String)"\u7cfb\u7edf\u767b\u5f55");
            return info;
        }
        return null;
    }

    protected void checkPermission(Permission permission, AuthorizationInfo info) {
        this.authorizationValidate(permission);
        super.checkPermission(permission, info);
    }

    protected boolean[] isPermitted(List<Permission> permissions, AuthorizationInfo info) {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission permission : permissions) {
                this.authorizationValidate(permission);
            }
        }
        return super.isPermitted(permissions, info);
    }

    public boolean isPermitted(PrincipalCollection principals, Permission permission) {
        this.authorizationValidate(permission);
        return super.isPermitted(principals, permission);
    }

    protected boolean isPermittedAll(Collection<Permission> permissions, AuthorizationInfo info) {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission permission : permissions) {
                this.authorizationValidate(permission);
            }
        }
        return super.isPermittedAll(permissions, info);
    }

    private void authorizationValidate(Permission permission) {
    }

    @PostConstruct
    public void initCredentialsMatcher() {
        HashedCredentialsMatcher matcher = new HashedCredentialsMatcher("SHA-1");
        matcher.setHashIterations(1024);
        this.setCredentialsMatcher((CredentialsMatcher)matcher);
    }

    @Deprecated
    public void clearAllCachedAuthorizationInfo() {
    }

    public SystemService getSystemService() {
        if (this.systemService == null) {
            this.systemService = (SystemService)SpringContextHolder.getBean(SystemService.class);
        }
        return this.systemService;
    }
}

