/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.modules.sys.service;

import com.jeeplus.common.bean.Node;
import com.jeeplus.common.bean.TreeNode;
import com.jeeplus.common.persistence.DataEntity;
import com.jeeplus.common.persistence.TreeEntity;
import com.jeeplus.common.service.TreeService;
import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.common.utils.TreeNodeUtils;
import com.jeeplus.modules.sys.dao.AreaDao;
import com.jeeplus.modules.sys.entity.Area;
import com.jeeplus.modules.sys.utils.UserUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestParam;

@Service
@Transactional(readOnly=true)
public class AreaService
extends TreeService<AreaDao, Area> {
    public List<Area> findAll() {
        return UserUtils.getAreaList();
    }

    @Transactional(readOnly=false)
    public void save(Area area) {
        super.save((TreeEntity)area);
        UserUtils.removeCache((String)"areaList");
    }

    @Transactional(readOnly=false)
    public void delete(Area area) {
        super.delete((DataEntity)area);
        UserUtils.removeCache((String)"areaList");
    }

    public List<TreeNode> tree(@RequestParam(required=false) String extId) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        List list = this.findAll();
        String rootId = "86";
        for (int i = 0; i < list.size(); ++i) {
            Area e = (Area)list.get(i);
            if (rootId.equals(e.getId()) || !StringUtils.isBlank((CharSequence)extId) && (extId == null || extId.equals(e.getId()) || e.getParentIds().indexOf("," + extId + ",") != -1)) continue;
            Node node = new Node();
            node.setId(e.getId());
            node.setParentId(e.getParentId());
            node.setLabel(e.getName());
            nodes.add(node);
        }
        return TreeNodeUtils.generateTree(nodes, (String)rootId);
    }
}

