/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.modules.sys.service;

import com.jeeplus.common.config.Global;
import com.jeeplus.common.persistence.Page;
import com.jeeplus.common.security.Digests;
import com.jeeplus.common.security.shiro.session.SessionDAO;
import com.jeeplus.common.service.BaseService;
import com.jeeplus.common.service.ServiceException;
import com.jeeplus.common.utils.CacheUtils;
import com.jeeplus.common.utils.Encodes;
import com.jeeplus.common.utils.IdUtils;
import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.modules.sys.dao.MenuDao;
import com.jeeplus.modules.sys.dao.RoleDao;
import com.jeeplus.modules.sys.dao.UserDao;
import com.jeeplus.modules.sys.entity.Menu;
import com.jeeplus.modules.sys.entity.Role;
import com.jeeplus.modules.sys.entity.User;
import com.jeeplus.modules.sys.security.SystemAuthorizingRealm;
import com.jeeplus.modules.sys.utils.UserUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.shiro.session.Session;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Transactional(readOnly=true)
public class SystemService
extends BaseService
implements InitializingBean {
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;
    public static final int SALT_SIZE = 8;
    @Autowired
    private UserDao userDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private MenuDao menuDao;
    @Autowired
    private SessionDAO sessionDao;
    @Autowired
    private SystemAuthorizingRealm systemRealm;

    public SessionDAO getSessionDao() {
        return this.sessionDao;
    }

    public User getUser(String id) {
        return UserUtils.get((String)id);
    }

    public User getUserByLoginName(String loginName) {
        return UserUtils.getByLoginName((String)loginName);
    }

    public Page<User> findUser(Page<User> page, User user) {
        user.setPage(page);
        page.setList(this.userDao.findList((Object)user));
        return page;
    }

    public List<User> findUser(User user) {
        List list = this.userDao.findList((Object)user);
        return list;
    }

    @Transactional(readOnly=false)
    public void saveUser(User user) {
        if (IdUtils.isBlank((Serializable)((Object)user.getId()), (String[])new String[0])) {
            user.preInsert();
            this.userDao.insert((Object)user);
        } else {
            user.preUpdate();
            this.userDao.update((Object)user);
        }
        if (IdUtils.isNotBlank((Serializable)((Object)user.getId()), (String[])new String[0])) {
            this.userDao.deleteUserRole(user);
            if (user.getRoleList() == null || user.getRoleList().size() <= 0) {
                throw new ServiceException(user.getLoginName() + "\u6ca1\u6709\u8bbe\u7f6e\u89d2\u8272\uff01");
            }
            this.userDao.insertUserRole(user);
            UserUtils.clearCache((User)user);
        }
    }

    @Transactional(readOnly=false)
    public void updateUserInfo(User user) {
        user.preUpdate();
        this.userDao.updateUserInfo(user);
        UserUtils.clearCache((User)user);
    }

    @Transactional(readOnly=false)
    public void deleteUser(User user) {
        this.userDao.delete((Object)user);
        UserUtils.clearCache((User)user);
    }

    @Transactional(readOnly=false)
    public void updatePasswordById(String id, String loginName, String newPassword) {
        User user = new User(id);
        user.setPassword(SystemService.entryptPassword((String)newPassword));
        this.userDao.updatePasswordById(user);
        user.setLoginName(loginName);
        UserUtils.clearCache((User)user);
    }

    @Transactional(readOnly=false)
    public void updateUserLoginInfo(User user) {
        user.setOldLoginIp(user.getLoginIp());
        user.setOldLoginDate(user.getLoginDate());
        user.setLoginIp(UserUtils.getSession().getHost());
        user.setLoginDate(new Date());
        this.userDao.updateLoginInfo(user);
    }

    public static String entryptPassword(String plainPassword) {
        byte[] salt = Digests.generateSalt((int)8);
        byte[] hashPassword = Digests.sha1((byte[])plainPassword.getBytes(), (byte[])salt, (int)1024);
        return Encodes.encodeHex((byte[])salt) + Encodes.encodeHex((byte[])hashPassword);
    }

    public static boolean validatePassword(String plainPassword, String password) {
        byte[] salt = Encodes.decodeHex((String)password.substring(0, 16));
        byte[] hashPassword = Digests.sha1((byte[])plainPassword.getBytes(), (byte[])salt, (int)1024);
        return password.equals(Encodes.encodeHex((byte[])salt) + Encodes.encodeHex((byte[])hashPassword));
    }

    public Collection<Session> getActiveSessions() {
        return this.sessionDao.getActiveSessions(false);
    }

    public Role getRole(String id) {
        return (Role)this.roleDao.get(id);
    }

    public Role getRoleByName(String name) {
        Role r = new Role();
        r.setName(name);
        return this.roleDao.getByName(r);
    }

    public Role getRoleByEnname(String enname) {
        Role r = new Role();
        r.setEnname(enname);
        return this.roleDao.getByEnname(r);
    }

    public List<Role> findRole(Role role) {
        return this.roleDao.findList((Object)role);
    }

    public List<Role> findAllRole() {
        return UserUtils.getRoleList();
    }

    @Transactional(readOnly=false)
    public void saveRole(Role role) {
        if (StringUtils.isBlank((CharSequence)role.getId())) {
            role.preInsert();
            this.roleDao.insert((Object)role);
        } else {
            role.preUpdate();
            this.roleDao.update((Object)role);
        }
        this.roleDao.deleteRoleMenu(role);
        if (role.getMenuList().size() > 0) {
            this.roleDao.insertRoleMenu(role);
        }
        UserUtils.removeCache((String)"roleList");
    }

    @Transactional(readOnly=false)
    public void deleteRole(Role role) {
        this.roleDao.delete((Object)role);
        UserUtils.removeCache((String)"roleList");
    }

    @Transactional(readOnly=false)
    public Boolean outUserInRole(Role role, User user) {
        List roles = user.getRoleList();
        for (Role e : roles) {
            if (!e.getId().equals(role.getId())) continue;
            roles.remove(e);
            this.saveUser(user);
            return true;
        }
        return false;
    }

    @Transactional(readOnly=false)
    public User assignUserToRole(Role role, User user) {
        if (user == null) {
            return null;
        }
        List roleIds = user.getRoleIdList();
        if (roleIds.contains(role.getId())) {
            return null;
        }
        user.getRoleList().add(role);
        this.saveUser(user);
        return user;
    }

    public Menu getMenu(String id) {
        return (Menu)this.menuDao.get(id);
    }

    public List<Menu> findAllMenu() {
        return UserUtils.getMenuList();
    }

    @Transactional(readOnly=false)
    public void saveMenu(Menu menu) {
        menu.setParent(this.getMenu(menu.getParent().getId()));
        String oldParentIds = menu.getParentIds();
        menu.setParentIds(menu.getParent().getParentIds() + menu.getParent().getId() + ",");
        if (StringUtils.isBlank((CharSequence)menu.getId())) {
            menu.preInsert();
            this.menuDao.insert((Object)menu);
        } else {
            menu.preUpdate();
            this.menuDao.update((Object)menu);
        }
        Menu m = new Menu();
        m.setParentIds("%," + menu.getId() + ",%");
        List list = this.menuDao.findByParentIdsLike(m);
        for (Menu e : list) {
            e.setParentIds(e.getParentIds().replace(oldParentIds, menu.getParentIds()));
            this.menuDao.updateParentIds(e);
        }
        UserUtils.removeCache((String)"menuList");
        CacheUtils.remove((String)"menuNamePathMap");
    }

    @Transactional(readOnly=false)
    public void updateMenuSort(Menu menu) {
        this.menuDao.updateSort(menu);
        UserUtils.removeCache((String)"menuList");
        CacheUtils.remove((String)"menuNamePathMap");
    }

    @Transactional(readOnly=false)
    public void deleteMenu(Menu menu) {
        this.menuDao.delete((Object)menu);
        UserUtils.removeCache((String)"menuList");
        CacheUtils.remove((String)"menuNamePathMap");
    }

    public static boolean printKeyLoadMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n======================================================================\r\n");
        sb.append("\r\n  " + Global.getConfig((String)"productName") + " - \u521d\u59cb\u5316  \r\n");
        sb.append("\r\n======================================================================\r\n");
        System.out.println(sb.toString());
        return true;
    }

    public void afterPropertiesSet() throws Exception {
    }
}

