/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.modules.sys.utils;

import com.jeeplus.common.utils.CacheUtils;
import com.jeeplus.common.utils.SpringContextHolder;
import com.jeeplus.modules.sys.dao.AreaDao;
import com.jeeplus.modules.sys.dao.MenuDao;
import com.jeeplus.modules.sys.dao.RoleDao;
import com.jeeplus.modules.sys.dao.UserDao;
import com.jeeplus.modules.sys.entity.Area;
import com.jeeplus.modules.sys.entity.Menu;
import com.jeeplus.modules.sys.entity.Role;
import com.jeeplus.modules.sys.entity.User;
import com.jeeplus.modules.sys.security.SystemAuthorizingRealm;
import java.util.Date;
import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.session.InvalidSessionException;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserUtils {
    private static UserDao userDao = (UserDao)SpringContextHolder.getBean(UserDao.class);
    private static RoleDao roleDao = (RoleDao)SpringContextHolder.getBean(RoleDao.class);
    private static MenuDao menuDao = (MenuDao)SpringContextHolder.getBean(MenuDao.class);
    private static AreaDao areaDao = (AreaDao)SpringContextHolder.getBean(AreaDao.class);
    public static final String USER_CACHE = "userCache";
    public static final String USER_CACHE_ID_ = "id_";
    public static final String USER_CACHE_LOGIN_NAME_ = "ln";
    public static final String USER_CACHE_LIST_BY_OFFICE_ID_ = "oid_";
    public static final String CACHE_ROLE_LIST = "roleList";
    public static final String CACHE_MENU_LIST = "menuList";
    public static final String CACHE_AREA_LIST = "areaList";

    public static User get(String id) {
        User user = (User)CacheUtils.get((String)"userCache", (String)("id_" + id));
        if (user == null) {
            user = (User)userDao.get(id);
            if (user == null) {
                return null;
            }
            user.setRoleList(roleDao.findList((Object)new Role(user)));
            CacheUtils.put((String)"userCache", (String)("id_" + user.getId()), (Object)user);
            CacheUtils.put((String)"userCache", (String)("ln" + user.getLoginName()), (Object)user);
        }
        return user;
    }

    public static User getByLoginName(String loginName) {
        User user = (User)CacheUtils.get((String)"userCache", (String)("ln" + loginName));
        if (user == null) {
            user = userDao.getByLoginName(new User(null, loginName));
            if (user == null) {
                return null;
            }
            user.setRoleList(roleDao.findList((Object)new Role(user)));
            CacheUtils.put((String)"userCache", (String)("id_" + user.getId()), (Object)user);
            CacheUtils.put((String)"userCache", (String)("ln" + user.getLoginName()), (Object)user);
        }
        return user;
    }

    public static void clearCache() {
        UserUtils.removeCache((String)"roleList");
        UserUtils.removeCache((String)"menuList");
        UserUtils.removeCache((String)"areaList");
        UserUtils.clearCache((User)UserUtils.getUser());
    }

    public static void clearCache(User user) {
        CacheUtils.remove((String)"userCache", (String)("id_" + user.getId()));
        CacheUtils.remove((String)"userCache", (String)("ln" + user.getLoginName()));
        CacheUtils.remove((String)"userCache", (String)("ln" + user.getOldLoginName()));
    }

    public static User getUser() {
        SystemAuthorizingRealm.Principal principal = UserUtils.getPrincipal();
        if (principal != null) {
            User user = UserUtils.get((String)principal.getId());
            if (user != null) {
                return user;
            }
            return new User();
        }
        return new User();
    }

    public static List<Role> getRoleList() {
        List roleList = (List)UserUtils.getCache((String)"roleList");
        if (roleList == null) {
            User user = UserUtils.getUser();
            if (user.isAdmin()) {
                roleList = roleDao.findAllList((Object)new Role());
            } else {
                Role role = new Role();
                roleList = roleDao.findList((Object)role);
            }
            UserUtils.putCache((String)"roleList", (Object)roleList);
        }
        return roleList;
    }

    public static List<Menu> getMenuList() {
        List menuList = (List)UserUtils.getCache((String)"menuList");
        if (menuList == null || menuList.size() == 0) {
            User user = UserUtils.getUser();
            if (user.isAdmin()) {
                menuList = menuDao.findAllList((Object)new Menu());
            } else {
                Menu m = new Menu();
                m.setUserId(user.getId());
                menuList = menuDao.findByUserId(m);
            }
            UserUtils.putCache((String)"menuList", (Object)menuList);
        }
        return menuList;
    }

    public static Menu getTopMenu() {
        List list = UserUtils.getMenuList();
        if (list.size() > 0) {
            return (Menu)UserUtils.getMenuList().get(0);
        }
        return null;
    }

    public static List<Area> getAreaList() {
        List areaList = (List)UserUtils.getCache((String)"areaList");
        if (areaList == null) {
            areaList = areaDao.findAllList((Object)new Area());
            UserUtils.putCache((String)"areaList", (Object)areaList);
        }
        return areaList;
    }

    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static SystemAuthorizingRealm.Principal getPrincipal() {
        try {
            Subject subject = SecurityUtils.getSubject();
            SystemAuthorizingRealm.Principal principal = (SystemAuthorizingRealm.Principal)subject.getPrincipal();
            if (principal != null) {
                return principal;
            }
        }
        catch (UnavailableSecurityManagerException unavailableSecurityManagerException) {
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
        return null;
    }

    public static Session getSession() {
        try {
            Subject subject = SecurityUtils.getSubject();
            Session session = subject.getSession(false);
            if (session == null) {
                session = subject.getSession();
            }
            if (session != null) {
                return session;
            }
        }
        catch (InvalidSessionException invalidSessionException) {
            // empty catch block
        }
        return null;
    }

    public static Object getCache(String key) {
        return UserUtils.getCache((String)key, null);
    }

    public static Object getCache(String key, Object defaultValue) {
        Object obj = UserUtils.getSession().getAttribute((Object)key);
        return obj == null ? defaultValue : obj;
    }

    public static void putCache(String key, Object value) {
        UserUtils.getSession().setAttribute((Object)key, value);
    }

    public static void removeCache(String key) {
        UserUtils.getSession().removeAttribute((Object)key);
    }

    public static String getTime(Date date) {
        StringBuffer time = new StringBuffer();
        Date date2 = new Date();
        long temp = date2.getTime() - date.getTime();
        long days = temp / 1000L / 3600L / 24L;
        if (days > 0L) {
            time.append(days + "\u5929");
        }
        long temp1 = temp % 86400000L;
        long hours = temp1 / 1000L / 3600L;
        if (days > 0L || hours > 0L) {
            time.append(hours + "\u5c0f\u65f6");
        }
        long temp2 = temp1 % 3600000L;
        long mins = temp2 / 1000L / 60L;
        time.append(mins + "\u5206\u949f");
        return time.toString();
    }

    public static User getByUserName(String name) {
        User u = new User();
        u.setName(name);
        List list = userDao.findList((Object)u);
        if (list.size() > 0) {
            return (User)list.get(0);
        }
        return new User();
    }

    public static Area getByAreaName(String name) {
        Area a = new Area();
        a.setName(name);
        List list = areaDao.findList((Object)a);
        if (list.size() > 0) {
            return (Area)list.get(0);
        }
        return new Area();
    }
}

