/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.modules.sys.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jeeplus.common.config.Global;
import com.jeeplus.common.persistence.DataEntity;
import com.jeeplus.common.persistence.Page;
import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.common.web.BaseController;
import com.jeeplus.modules.sys.entity.Dict;
import com.jeeplus.modules.sys.service.DictService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"${adminPath}/sys/dict"})
public class DictController
extends BaseController {
    @Autowired
    private DictService dictService;

    @ModelAttribute
    public Dict get(@RequestParam(required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return (Dict)this.dictService.get(id);
        }
        return new Dict();
    }

    @RequiresPermissions(value={"sys:dict:list"})
    @RequestMapping(value={"list", ""})
    public String list(Dict dict, HttpServletRequest request, HttpServletResponse response, Model model) {
        List typeList = this.dictService.findTypeList();
        model.addAttribute("typeList", (Object)typeList);
        Page page = this.dictService.findPage(new Page(request, response), (DataEntity)dict);
        model.addAttribute("page", (Object)page);
        return "modules/sys/dictList";
    }

    @RequiresPermissions(value={"sys:dict:view", "sys:dict:add", "sys:dict:edit"}, logical=Logical.OR)
    @RequestMapping(value={"form"})
    public String form(Dict dict, Model model) {
        model.addAttribute("dict", (Object)dict);
        return "modules/sys/dictForm";
    }

    @RequiresPermissions(value={"sys:dict:add", "sys:dict:edit"}, logical=Logical.OR)
    @RequestMapping(value={"save"})
    public String save(Dict dict, Model model, RedirectAttributes redirectAttributes) {
        if (Global.isDemoMode().booleanValue()) {
            this.addMessage(redirectAttributes, new String[]{"\u6f14\u793a\u6a21\u5f0f\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"});
            return "redirect:" + this.adminPath + "/sys/dict/?repage&type=" + dict.getType();
        }
        if (!this.beanValidator(model, (Object)dict, new Class[0])) {
            return this.form(dict, model);
        }
        this.dictService.save(dict);
        this.addMessage(redirectAttributes, new String[]{"\u4fdd\u5b58\u5b57\u5178'" + dict.getLabel() + "'\u6210\u529f"});
        return "redirect:" + this.adminPath + "/sys/dict/?repage&type=" + dict.getType();
    }

    @RequiresPermissions(value={"sys:dict:del"})
    @RequestMapping(value={"delete"})
    public String delete(Dict dict, Model model, RedirectAttributes redirectAttributes) {
        if (Global.isDemoMode().booleanValue()) {
            this.addMessage(redirectAttributes, new String[]{"\u6f14\u793a\u6a21\u5f0f\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"});
            return "redirect:" + this.adminPath + "/sys/dict/?repage";
        }
        this.dictService.delete(dict);
        model.addAttribute("dict", (Object)dict);
        this.addMessage(redirectAttributes, new String[]{"\u5220\u9664\u5b57\u5178\u6210\u529f"});
        return "redirect:" + this.adminPath + "/sys/dict/?repage&type=" + dict.getType();
    }

    @RequiresPermissions(value={"sys:role:del"})
    @RequestMapping(value={"deleteAll"})
    public String deleteAll(String ids, RedirectAttributes redirectAttributes) {
        String[] idArray;
        if (Global.isDemoMode().booleanValue()) {
            this.addMessage(redirectAttributes, new String[]{"\u6f14\u793a\u6a21\u5f0f\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"});
            return "redirect:" + this.adminPath + "/sys/dict/?repage";
        }
        for (String id : idArray = ids.split(",")) {
            Dict dict = (Dict)this.dictService.get(id);
            this.dictService.delete(dict);
        }
        this.addMessage(redirectAttributes, new String[]{"\u5220\u9664\u5b57\u5178\u6210\u529f"});
        return "redirect:" + this.adminPath + "/sys/dict/?repage";
    }

    @RequiresPermissions(value={"user"})
    @ResponseBody
    @RequestMapping(value={"treeData"})
    public List<Map<String, Object>> treeData(@RequestParam(required=false) String type, HttpServletResponse response) {
        ArrayList mapList = Lists.newArrayList();
        Dict dict = new Dict();
        dict.setType(type);
        List list = this.dictService.findList((DataEntity)dict);
        for (int i = 0; i < list.size(); ++i) {
            Dict e = (Dict)list.get(i);
            HashMap map = Maps.newHashMap();
            map.put("id", e.getId());
            map.put("pId", e.getParentId());
            map.put("name", StringUtils.replace((String)e.getLabel(), (String)" ", (String)""));
            mapList.add(map);
        }
        return mapList;
    }

    @ResponseBody
    @RequestMapping(value={"listData"})
    public List<Dict> listData(@RequestParam(required=false) String type) {
        Dict dict = new Dict();
        dict.setType(type);
        return this.dictService.findList((DataEntity)dict);
    }
}

