/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.modules.sys.web;

import com.google.common.collect.Maps;
import com.jeeplus.common.config.Global;
import com.jeeplus.common.json.AjaxJson;
import com.jeeplus.common.security.shiro.session.SessionDAO;
import com.jeeplus.common.utils.CacheUtils;
import com.jeeplus.common.utils.CookieUtils;
import com.jeeplus.common.utils.IdGen;
import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.common.web.BaseController;
import com.jeeplus.modules.sys.security.SystemAuthorizingRealm;
import com.jeeplus.modules.sys.utils.UserUtils;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.web.util.SavedRequest;
import org.apache.shiro.web.util.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
public class LoginController
extends BaseController {
    @Autowired
    private SessionDAO sessionDAO;

    @RequestMapping(value={"${adminPath}/login"})
    public String login(HttpServletRequest request, HttpServletResponse response, Model model) throws IOException {
        String queryStr;
        SystemAuthorizingRealm.Principal principal = UserUtils.getPrincipal();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("login, active session size: {}", (Object)this.sessionDAO.getActiveSessions(false).size());
        }
        if ("true".equals(Global.getConfig((String)"notAllowRefreshIndex"))) {
            CookieUtils.setCookie((HttpServletResponse)response, (String)"LOGINED", (String)"false");
        }
        if (principal != null && !principal.isMobileLogin()) {
            return "redirect:" + this.adminPath;
        }
        SavedRequest savedRequest = WebUtils.getSavedRequest((ServletRequest)request);
        if (savedRequest != null && (queryStr = savedRequest.getQueryString()) != null && (queryStr.contains("__ajax") || queryStr.contains("mobileLogin"))) {
            AjaxJson j = new AjaxJson();
            j.setSuccess(false);
            j.setErrorCode("0");
            j.setMsg("\u6ca1\u6709\u767b\u5f55!");
            return this.renderString(response, (Object)j);
        }
        return "modules/sys/sysLogin";
    }

    @RequestMapping(value={"${adminPath}/login"}, method={RequestMethod.POST})
    public String loginFail(HttpServletRequest request, HttpServletResponse response, Model model) {
        SystemAuthorizingRealm.Principal principal = UserUtils.getPrincipal();
        if (principal != null) {
            return "redirect:" + this.adminPath;
        }
        String username = WebUtils.getCleanParam((ServletRequest)request, (String)"username");
        boolean rememberMe = WebUtils.isTrue((ServletRequest)request, (String)"rememberMe");
        boolean mobile = WebUtils.isTrue((ServletRequest)request, (String)"mobileLogin");
        String exception = (String)request.getAttribute("shiroLoginFailure");
        String message = (String)request.getAttribute("message");
        if (StringUtils.isBlank((CharSequence)message) || StringUtils.equals((CharSequence)message, (CharSequence)"null")) {
            message = "\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5.";
        }
        model.addAttribute("username", (Object)username);
        model.addAttribute("rememberMe", (Object)rememberMe);
        model.addAttribute("mobileLogin", (Object)mobile);
        model.addAttribute("shiroLoginFailure", (Object)exception);
        model.addAttribute("message", (Object)message);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("login fail, active session size: {}, message: {}, exception: {}", new Object[]{this.sessionDAO.getActiveSessions(false).size(), message, exception});
        }
        if (!UnauthorizedException.class.getName().equals(exception)) {
            model.addAttribute("isValidateCodeLogin", (Object)LoginController.isValidateCodeLogin((String)username, (boolean)true, (boolean)false));
        }
        request.getSession().setAttribute("validateCode", (Object)IdGen.uuid());
        if (mobile) {
            AjaxJson j = new AjaxJson();
            j.setSuccess(false);
            j.setMsg(message);
            j.put("username", (Object)username);
            j.put("name", (Object)"");
            j.put("mobileLogin", (Object)mobile);
            j.put("JSESSIONID", (Object)"");
            return this.renderString(response, j.getJsonStr());
        }
        return "modules/sys/sysLogin";
    }

    @RequestMapping(value={"${adminPath}/logout"}, method={RequestMethod.GET})
    public String logout(HttpServletRequest request, HttpServletResponse response, Model model) throws IOException {
        String ajax;
        SystemAuthorizingRealm.Principal principal = UserUtils.getPrincipal();
        if (principal != null) {
            UserUtils.getSubject().logout();
        }
        if ((ajax = request.getParameter("__ajax")) != null) {
            model.addAttribute("success", (Object)"1");
            model.addAttribute("msg", (Object)"\u9000\u51fa\u6210\u529f");
            return this.renderString(response, (Object)model);
        }
        return "redirect:" + this.adminPath + "/login";
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"${adminPath}"})
    public String index(HttpServletRequest request, HttpServletResponse response) {
        SystemAuthorizingRealm.Principal principal = UserUtils.getPrincipal();
        LoginController.isValidateCodeLogin((String)principal.getLoginName(), (boolean)false, (boolean)true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("show index, active session size: {}", (Object)this.sessionDAO.getActiveSessions(false).size());
        }
        if ("true".equals(Global.getConfig((String)"notAllowRefreshIndex"))) {
            String logined = CookieUtils.getCookie((HttpServletRequest)request, (String)"LOGINED");
            if (StringUtils.isBlank((CharSequence)logined) || "false".equals(logined)) {
                CookieUtils.setCookie((HttpServletResponse)response, (String)"LOGINED", (String)"true");
            } else if (StringUtils.equals((CharSequence)logined, (CharSequence)"true")) {
                UserUtils.getSubject().logout();
                return "redirect:" + this.adminPath + "/login";
            }
        }
        if (principal.isMobileLogin()) {
            if (request.getParameter("login") != null) {
                return this.renderString(response, (Object)principal);
            }
            if (request.getParameter("index") != null) {
                return "modules/sys/sysIndex";
            }
            return "redirect:" + this.adminPath + "/login";
        }
        return "modules/sys/sysIndex";
    }

    @RequestMapping(value={"/theme/{theme}"})
    public String getThemeInCookie(@PathVariable String theme, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isNotBlank((CharSequence)theme)) {
            CookieUtils.setCookie((HttpServletResponse)response, (String)"theme", (String)theme);
        } else {
            theme = CookieUtils.getCookie((HttpServletRequest)request, (String)"theme");
        }
        return "redirect:" + request.getParameter("url");
    }

    public static boolean isValidateCodeLogin(String useruame, boolean isFail, boolean clean) {
        Integer loginFailNum;
        Map loginFailMap = (Map)CacheUtils.get((String)"loginFailMap");
        if (loginFailMap == null) {
            loginFailMap = Maps.newHashMap();
            CacheUtils.put((String)"loginFailMap", (Object)loginFailMap);
        }
        if ((loginFailNum = (Integer)loginFailMap.get(useruame)) == null) {
            loginFailNum = 0;
        }
        if (isFail) {
            Integer n = loginFailNum;
            Integer n2 = loginFailNum = Integer.valueOf(loginFailNum + 1);
            loginFailMap.put(useruame, loginFailNum);
        }
        if (clean) {
            loginFailMap.remove(useruame);
        }
        return loginFailNum >= 3;
    }

    @RequestMapping(value={"${adminPath}/home"})
    public String home(HttpServletRequest request, HttpServletResponse response, Model model) throws IOException {
        return "modules/sys/sysHome";
    }
}

