/*
 * Decompiled with CFR 0.152.
 */
package com.jeeplus.modules.sys.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jeeplus.common.config.Global;
import com.jeeplus.common.utils.StringUtils;
import com.jeeplus.common.web.BaseController;
import com.jeeplus.modules.sys.entity.Menu;
import com.jeeplus.modules.sys.service.SystemService;
import com.jeeplus.modules.sys.utils.UserUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"${adminPath}/sys/menu"})
public class MenuController
extends BaseController {
    @Autowired
    private SystemService systemService;

    @ModelAttribute(value="menu")
    public Menu get(@RequestParam(required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return this.systemService.getMenu(id);
        }
        return new Menu();
    }

    @RequiresPermissions(value={"sys:menu:list"})
    @RequestMapping(value={"list", ""})
    public String list(Model model) {
        ArrayList list = Lists.newArrayList();
        List sourcelist = this.systemService.findAllMenu();
        Menu.sortList((List)list, (List)sourcelist, (String)Menu.getRootId(), (boolean)true);
        model.addAttribute("list", (Object)list);
        return "modules/sys/menuList";
    }

    @RequiresPermissions(value={"sys:menu:view", "sys:menu:add", "sys:menu:edit"}, logical=Logical.OR)
    @RequestMapping(value={"form"})
    public String form(Menu menu, Model model) {
        if (menu.getParent() == null || menu.getParent().getId() == null) {
            menu.setParent(new Menu(Menu.getRootId()));
        }
        menu.setParent(this.systemService.getMenu(menu.getParent().getId()));
        if (StringUtils.isBlank((CharSequence)menu.getId())) {
            ArrayList list = Lists.newArrayList();
            List sourcelist = this.systemService.findAllMenu();
            Menu.sortList((List)list, (List)sourcelist, (String)menu.getParentId(), (boolean)false);
            if (list.size() > 0) {
                menu.setSort(Integer.valueOf(((Menu)list.get(list.size() - 1)).getSort() + 30));
            }
        }
        model.addAttribute("menu", (Object)menu);
        return "modules/sys/menuForm";
    }

    @RequiresPermissions(value={"sys:menu:add", "sys:menu:edit"}, logical=Logical.OR)
    @RequestMapping(value={"save"})
    public String save(Menu menu, Model model, RedirectAttributes redirectAttributes) {
        if (!UserUtils.getUser().isAdmin()) {
            this.addMessage(redirectAttributes, new String[]{"\u8d8a\u6743\u64cd\u4f5c\uff0c\u53ea\u6709\u8d85\u7ea7\u7ba1\u7406\u5458\u624d\u80fd\u6dfb\u52a0\u6216\u4fee\u6539\u6570\u636e\uff01"});
            return "redirect:" + this.adminPath + "/sys/role/?repage";
        }
        if (Global.isDemoMode().booleanValue()) {
            this.addMessage(redirectAttributes, new String[]{"\u6f14\u793a\u6a21\u5f0f\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"});
            return "redirect:" + this.adminPath + "/sys/menu/";
        }
        if (!this.beanValidator(model, (Object)menu, new Class[0])) {
            return this.form(menu, model);
        }
        this.systemService.saveMenu(menu);
        this.addMessage(redirectAttributes, new String[]{"\u4fdd\u5b58\u83dc\u5355'" + menu.getName() + "'\u6210\u529f"});
        return "redirect:" + this.adminPath + "/sys/menu/";
    }

    @RequiresPermissions(value={"sys:menu:del"})
    @RequestMapping(value={"delete"})
    public String delete(Menu menu, RedirectAttributes redirectAttributes) {
        if (Global.isDemoMode().booleanValue()) {
            this.addMessage(redirectAttributes, new String[]{"\u6f14\u793a\u6a21\u5f0f\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"});
            return "redirect:" + this.adminPath + "/sys/menu/";
        }
        this.systemService.deleteMenu(menu);
        this.addMessage(redirectAttributes, new String[]{"\u5220\u9664\u83dc\u5355\u6210\u529f"});
        return "redirect:" + this.adminPath + "/sys/menu/";
    }

    @RequiresPermissions(value={"sys:menu:del"})
    @RequestMapping(value={"deleteAll"})
    public String deleteAll(String ids, RedirectAttributes redirectAttributes) {
        String[] idArray;
        if (Global.isDemoMode().booleanValue()) {
            this.addMessage(redirectAttributes, new String[]{"\u6f14\u793a\u6a21\u5f0f\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"});
            return "redirect:" + this.adminPath + "/sys/menu/";
        }
        for (String id : idArray = ids.split(",")) {
            Menu menu = this.systemService.getMenu(id);
            if (menu == null) continue;
            this.systemService.deleteMenu(this.systemService.getMenu(id));
        }
        this.addMessage(redirectAttributes, new String[]{"\u5220\u9664\u83dc\u5355\u6210\u529f"});
        return "redirect:" + this.adminPath + "/sys/menu/";
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"tree"})
    public String tree() {
        return "modules/sys/menuTree";
    }

    @RequiresPermissions(value={"user"})
    @RequestMapping(value={"treeselect"})
    public String treeselect(String parentId, Model model) {
        model.addAttribute("parentId", (Object)parentId);
        return "modules/sys/menuTreeselect";
    }

    @RequiresPermissions(value={"sys:menu:updateSort"})
    @RequestMapping(value={"updateSort"})
    public String updateSort(String[] ids, Integer[] sorts, RedirectAttributes redirectAttributes) {
        if (Global.isDemoMode().booleanValue()) {
            this.addMessage(redirectAttributes, new String[]{"\u6f14\u793a\u6a21\u5f0f\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\uff01"});
            return "redirect:" + this.adminPath + "/sys/menu/";
        }
        for (int i = 0; i < ids.length; ++i) {
            Menu menu = new Menu(ids[i]);
            menu.setSort(sorts[i]);
            this.systemService.updateMenuSort(menu);
        }
        this.addMessage(redirectAttributes, new String[]{"\u4fdd\u5b58\u83dc\u5355\u6392\u5e8f\u6210\u529f!"});
        return "redirect:" + this.adminPath + "/sys/menu/";
    }

    @RequiresPermissions(value={"user"})
    @ResponseBody
    @RequestMapping(value={"treeData"})
    public List<Map<String, Object>> treeData(@RequestParam(required=false) String extId, @RequestParam(required=false) String isShowHide, HttpServletResponse response) {
        ArrayList mapList = Lists.newArrayList();
        List list = this.systemService.findAllMenu();
        for (int i = 0; i < list.size(); ++i) {
            Menu e = (Menu)list.get(i);
            if (!StringUtils.isBlank((CharSequence)extId) && (extId == null || extId.equals(e.getId()) || e.getParentIds().indexOf("," + extId + ",") != -1) || isShowHide != null && isShowHide.equals("0") && e.getIsShow().equals("0")) continue;
            HashMap map = Maps.newHashMap();
            map.put("id", e.getId());
            map.put("pId", e.getParentId());
            map.put("name", e.getName());
            mapList.add(map);
        }
        return mapList;
    }
}

