/*
Navicat MySQL Data Transfer

Source Server         : 119.23.140.154
Source Server Version : 50711
Source Host           : 119.23.140.154:3306
Source Database       : jeequick

Target Server Type    : MYSQL
Target Server Version : 50711
File Encoding         : 65001

Date: 2017-04-14 22:49:29
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for article
-- ----------------------------
DROP TABLE IF EXISTS `article`;
CREATE TABLE `article` (
  `id` int(11) NOT NULL COMMENT '文章ID',
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `cover` varchar(255) DEFAULT NULL COMMENT '封面图片',
  `banners` varchar(255) DEFAULT NULL COMMENT '轮播图片',
  `summary` varchar(255) DEFAULT NULL COMMENT '简介',
  `content` text COMMENT '内容',
  `state` tinyint(1) DEFAULT NULL COMMENT 'state',
  `displayorder` int(11) DEFAULT NULL COMMENT '排序值',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='文章';

-- ----------------------------
-- Records of article
-- ----------------------------

-- ----------------------------
-- Table structure for gen_scheme
-- ----------------------------
DROP TABLE IF EXISTS `gen_scheme`;
CREATE TABLE `gen_scheme` (
  `id` varchar(64) NOT NULL COMMENT '编号',
  `name` varchar(200) DEFAULT NULL COMMENT '名称',
  `category` varchar(2000) DEFAULT NULL COMMENT '分类',
  `package_name` varchar(500) DEFAULT NULL COMMENT '生成包路径',
  `module_name` varchar(30) DEFAULT NULL COMMENT '生成模块名',
  `sub_module_name` varchar(30) DEFAULT NULL COMMENT '生成子模块名',
  `function_name` varchar(500) DEFAULT NULL COMMENT '生成功能名',
  `function_name_simple` varchar(100) DEFAULT NULL COMMENT '生成功能名（简写）',
  `function_author` varchar(100) DEFAULT NULL COMMENT '生成功能作者',
  `gen_table_id` varchar(200) DEFAULT NULL COMMENT '生成表编号',
  `create_by` int(11) DEFAULT NULL COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` int(11) DEFAULT NULL COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '删除标记（0：正常；1：删除）',
  PRIMARY KEY (`id`),
  KEY `gen_scheme_del_flag` (`is_del`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='生成方案';

-- ----------------------------
-- Records of gen_scheme
-- ----------------------------
INSERT INTO `gen_scheme` VALUES ('14661169-6b21-4319-b6df-43910b2042d4', null, 'curd', 'com.jeeplus.modules', 'cms', 'article', '文章', '文章', 'rubekid', '82fd6044-9a25-4d11-b467-7e3e5b50befa', '1', '2017-04-14 21:24:57', '1', '2017-04-14 22:44:09', '0');

-- ----------------------------
-- Table structure for gen_table
-- ----------------------------
DROP TABLE IF EXISTS `gen_table`;
CREATE TABLE `gen_table` (
  `id` varchar(64) NOT NULL COMMENT '编号',
  `name` varchar(200) DEFAULT NULL COMMENT '名称',
  `comments` varchar(500) DEFAULT NULL COMMENT '描述',
  `class_name` varchar(100) DEFAULT NULL COMMENT '实体类名称',
  `parent_table` varchar(200) DEFAULT NULL COMMENT '关联父表',
  `parent_table_fk` varchar(100) DEFAULT NULL COMMENT '关联父表外键',
  `create_by` int(11) DEFAULT NULL COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` int(11) DEFAULT NULL COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '删除标记（0：正常；1：删除）',
  `issync` tinyint(1) DEFAULT NULL COMMENT '同步',
  `table_type` varchar(45) DEFAULT NULL COMMENT '表类型',
  PRIMARY KEY (`id`),
  KEY `gen_table_name` (`name`),
  KEY `gen_table_del_flag` (`is_del`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='业务表';

-- ----------------------------
-- Records of gen_table
-- ----------------------------
INSERT INTO `gen_table` VALUES ('82fd6044-9a25-4d11-b467-7e3e5b50befa', 'article', '文章', 'Article', '', '', '1', '2017-04-14 21:04:07', '1', '2017-04-14 22:31:45', '0', '1', '0');

-- ----------------------------
-- Table structure for gen_table_column
-- ----------------------------
DROP TABLE IF EXISTS `gen_table_column`;
CREATE TABLE `gen_table_column` (
  `id` varchar(64) NOT NULL COMMENT '编号',
  `gen_table_id` varchar(64) DEFAULT NULL COMMENT '归属表编号',
  `name` varchar(200) DEFAULT NULL COMMENT '名称',
  `comments` varchar(500) DEFAULT NULL COMMENT '描述',
  `jdbc_type` varchar(100) DEFAULT NULL COMMENT '列的数据类型的字节长度',
  `java_type` varchar(500) DEFAULT NULL COMMENT 'JAVA类型',
  `java_field` varchar(200) DEFAULT NULL COMMENT 'JAVA字段名',
  `is_pk` char(1) DEFAULT NULL COMMENT '是否主键',
  `is_null` char(1) DEFAULT NULL COMMENT '是否可为空',
  `is_insert` char(1) DEFAULT NULL COMMENT '是否为插入字段',
  `is_edit` char(1) DEFAULT NULL COMMENT '是否编辑字段',
  `is_list` char(1) DEFAULT NULL COMMENT '是否列表字段',
  `is_query` char(1) DEFAULT NULL COMMENT '是否查询字段',
  `query_type` varchar(200) DEFAULT NULL COMMENT '查询方式（等于、不等于、大于、小于、范围、左LIKE、右LIKE、左右LIKE）',
  `show_type` varchar(200) DEFAULT NULL COMMENT '字段生成方案（文本框、文本域、下拉框、复选框、单选框、字典选择、人员选择、部门选择、区域选择）',
  `dict_type` varchar(200) DEFAULT NULL COMMENT '字典类型',
  `settings` varchar(2000) DEFAULT NULL COMMENT '其它设置（扩展字段JSON）',
  `sort` decimal(10,0) DEFAULT NULL COMMENT '排序（升序）',
  `create_by` int(11) DEFAULT NULL COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` int(11) DEFAULT NULL COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '删除标记（0：正常；1：删除）',
  `is_form` varchar(45) DEFAULT NULL COMMENT '是否表单显示',
  `tableName` varchar(45) DEFAULT NULL COMMENT '管理的查询表名',
  `fieldLabels` varchar(512) DEFAULT NULL,
  `fieldKeys` varchar(512) DEFAULT NULL,
  `searchLabel` varchar(45) DEFAULT NULL,
  `searchKey` varchar(45) DEFAULT NULL,
  `validateType` varchar(45) DEFAULT NULL,
  `min_length` varchar(45) DEFAULT NULL,
  `max_length` varchar(45) DEFAULT NULL,
  `min_value` varchar(45) DEFAULT NULL,
  `max_value` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gen_table_column_table_id` (`gen_table_id`),
  KEY `gen_table_column_name` (`name`),
  KEY `gen_table_column_sort` (`sort`),
  KEY `gen_table_column_del_flag` (`is_del`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='业务表字段';

-- ----------------------------
-- Records of gen_table_column
-- ----------------------------
INSERT INTO `gen_table_column` VALUES ('1954f35b-405c-4557-9d87-ede6332e22aa', '82fd6044-9a25-4d11-b467-7e3e5b50befa', 'displayorder', '排序值', 'int(11)', 'Integer', 'displayorder', '0', '0', '1', '1', '0', '0', '=', 'input', '', null, '7', '1', '2017-04-14 22:31:45', '1', '2017-04-14 22:31:45', '0', '1', '', '', '', '', '', null, null, null, null, null);
INSERT INTO `gen_table_column` VALUES ('230426b1-02b5-4730-a145-42e57a1174c6', '82fd6044-9a25-4d11-b467-7e3e5b50befa', 'state', 'state', 'tinyint(1)', 'String', 'state', '0', '0', '1', '1', '0', '0', '=', 'radiobox', '', null, '6', '1', '2017-04-14 22:31:45', '1', '2017-04-14 22:31:45', '0', '1', '', '', '', '', '', null, null, null, null, null);
INSERT INTO `gen_table_column` VALUES ('2f3b5a69-f133-4d63-a4b8-3774810b2981', '82fd6044-9a25-4d11-b467-7e3e5b50befa', 'banners', '轮播图片', 'varchar(255)', 'String', 'banners', '0', '0', '1', '1', '0', '0', '=', 'fileselect', '', null, '3', '1', '2017-04-14 22:31:45', '1', '2017-04-14 22:31:45', '0', '1', '', '', '', '', '', null, null, null, null, null);
INSERT INTO `gen_table_column` VALUES ('73acd423-d8ce-4a9b-86a1-51c197336948', '82fd6044-9a25-4d11-b467-7e3e5b50befa', 'create_time', '创建时间', 'datetime', 'java.util.Date', 'createTime', '0', '0', '1', '1', '1', '0', '=', 'dateselect', '', null, '8', '1', '2017-04-14 22:31:45', '1', '2017-04-14 22:31:45', '0', '0', '', '', '', '', '', null, null, null, null, null);
INSERT INTO `gen_table_column` VALUES ('8f8e506d-4ee2-40b6-87d3-672110614c0a', '82fd6044-9a25-4d11-b467-7e3e5b50befa', 'id', '文章ID', 'int(11)', 'Long', 'id', '1', '0', '1', '0', '0', '0', '=', 'input', '', null, '0', '1', '2017-04-14 22:31:45', '1', '2017-04-14 22:31:45', '0', '0', '', '', '', '', '', null, null, null, null, null);
INSERT INTO `gen_table_column` VALUES ('90486460-a65a-4dc3-8a20-e87dbee2a516', '82fd6044-9a25-4d11-b467-7e3e5b50befa', 'cover', '封面图片', 'varchar(255)', 'String', 'cover', '0', '0', '1', '1', '1', '0', '=', 'fileselect', '', null, '2', '1', '2017-04-14 22:31:45', '1', '2017-04-14 22:31:45', '0', '1', '', '', '', '', '', null, null, null, null, null);
INSERT INTO `gen_table_column` VALUES ('997971b4-16d7-4345-ae2f-b0e63fa29907', '82fd6044-9a25-4d11-b467-7e3e5b50befa', 'summary', '简介', 'varchar(255)', 'String', 'summary', '0', '0', '1', '1', '0', '0', '=', 'textarea', '', null, '4', '1', '2017-04-14 22:31:45', '1', '2017-04-14 22:31:45', '0', '1', '', '', '', '', '', null, null, null, null, null);
INSERT INTO `gen_table_column` VALUES ('ab5ce66f-3ae7-43d1-a45e-b4a2e99497b4', '82fd6044-9a25-4d11-b467-7e3e5b50befa', 'title', '标题', 'varchar(255)', 'String', 'title', '0', '0', '1', '1', '1', '1', 'like', 'input', '', null, '1', '1', '2017-04-14 22:31:45', '1', '2017-04-14 22:31:45', '0', '1', '', '', '', '', '', null, null, null, null, null);
INSERT INTO `gen_table_column` VALUES ('de4d087b-32be-4fee-bf29-922cd45b9c1d', '82fd6044-9a25-4d11-b467-7e3e5b50befa', 'update_time', '更新时间', 'datetime', 'java.util.Date', 'updateTime', '0', '0', '1', '1', '1', '0', '=', 'dateselect', '', null, '9', '1', '2017-04-14 22:31:45', '1', '2017-04-14 22:31:45', '0', '0', '', '', '', '', '', null, null, null, null, null);
INSERT INTO `gen_table_column` VALUES ('f5be4684-4616-48a4-93de-d20744017836', '82fd6044-9a25-4d11-b467-7e3e5b50befa', 'content', '内容', 'text', 'String', 'content', '0', '0', '1', '1', '0', '0', '=', 'umeditor', '', null, '5', '1', '2017-04-14 22:31:45', '1', '2017-04-14 22:31:45', '0', '1', '', '', '', '', '', null, null, null, null, null);

-- ----------------------------
-- Table structure for gen_template
-- ----------------------------
DROP TABLE IF EXISTS `gen_template`;
CREATE TABLE `gen_template` (
  `id` varchar(64) NOT NULL COMMENT '编号',
  `name` varchar(200) DEFAULT NULL COMMENT '名称',
  `category` varchar(2000) DEFAULT NULL COMMENT '分类',
  `file_path` varchar(500) DEFAULT NULL COMMENT '生成文件路径',
  `file_name` varchar(200) DEFAULT NULL COMMENT '生成文件名',
  `content` text COMMENT '内容',
  `create_by` int(11) DEFAULT NULL COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` int(11) DEFAULT NULL COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '删除标记（0：正常；1：删除）',
  PRIMARY KEY (`id`),
  KEY `gen_template_del_falg` (`is_del`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='代码模板表';

-- ----------------------------
-- Records of gen_template
-- ----------------------------
INSERT INTO `gen_template` VALUES ('0', '0', ',,', '0', '0', '0', null, null, '1', '2017-04-14 22:47:14', '0');

-- ----------------------------
-- Table structure for monitor
-- ----------------------------
DROP TABLE IF EXISTS `monitor`;
CREATE TABLE `monitor` (
  `id` varchar(64) NOT NULL DEFAULT '' COMMENT '主键',
  `cpu` varchar(64) DEFAULT NULL COMMENT 'cpu使用率',
  `jvm` varchar(64) DEFAULT NULL COMMENT 'jvm使用率',
  `ram` varchar(64) DEFAULT NULL COMMENT '内存使用率',
  `toemail` varchar(64) DEFAULT NULL COMMENT '警告通知邮箱',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='系统监控';

-- ----------------------------
-- Records of monitor
-- ----------------------------

-- ----------------------------
-- Table structure for sys_area
-- ----------------------------
DROP TABLE IF EXISTS `sys_area`;
CREATE TABLE `sys_area` (
  `id` varchar(64) NOT NULL COMMENT '编号',
  `parent_id` varchar(64) NOT NULL COMMENT '父级编号',
  `parent_ids` varchar(2000) NOT NULL COMMENT '所有父级编号',
  `name` varchar(100) NOT NULL COMMENT '名称',
  `sort` decimal(10,0) NOT NULL DEFAULT '30' COMMENT '排序',
  `code` varchar(100) DEFAULT NULL COMMENT '区域编码',
  `type` char(1) DEFAULT NULL COMMENT '区域类型',
  `create_by` int(11) DEFAULT NULL COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` int(11) DEFAULT NULL COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `sys_area_parent_id` (`parent_id`),
  KEY `sys_area_del_flag` (`is_del`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='区域表';

-- ----------------------------
-- Records of sys_area
-- ----------------------------
INSERT INTO `sys_area` VALUES ('110000', '86', '0,86', '北京', '30', '110000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110100', '110000', '0,86,110000', '北京市', '30', '110100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110101', '110100', '0,86,110000,8610100', '东城区', '30', '110101', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110102', '110100', '0,86,110000,8610100', '西城区', '30', '110102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110103', '110100', '0,86,110000,8610100', '崇文区', '30', '110103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110104', '110100', '0,86,110000,8610100', '宣武区', '30', '110104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110105', '110100', '0,86,110000,8610100', '朝阳区', '30', '110105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110106', '110100', '0,86,110000,8610100', '丰台区', '30', '110106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110107', '110100', '0,86,110000,8610100', '石景山区', '30', '110107', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110108', '110100', '0,86,110000,8610100', '海淀区', '30', '110108', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110109', '110100', '0,86,110000,8610100', '门头沟区', '30', '110109', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110111', '110100', '0,86,110000,8610100', '房山区', '30', '110111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110112', '110100', '0,86,110000,8610100', '通州区', '30', '110112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110113', '110100', '0,86,110000,8610100', '顺义区', '30', '110113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110114', '110100', '0,86,110000,8610100', '昌平区', '30', '110114', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110115', '110100', '0,86,110000,8610100', '大兴区', '30', '110115', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110116', '110100', '0,86,110000,8610100', '怀柔区', '30', '110116', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110117', '110100', '0,86,110000,8610100', '平谷区', '30', '110117', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110228', '110100', '0,86,110000,8610100', '密云县', '30', '110228', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110229', '110100', '0,86,110000,8610100', '延庆县', '30', '110229', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('110230', '110100', '0,86,110000,8610100', '其它区', '30', '110230', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120000', '86', '0,86', '天津', '30', '120000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120100', '120000', '0,86,120000', '天津市', '30', '120100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120101', '120100', '0,86,120000,8620100', '和平区', '30', '120101', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120102', '120100', '0,86,120000,8620100', '河东区', '30', '120102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120103', '120100', '0,86,120000,8620100', '河西区', '30', '120103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120104', '120100', '0,86,120000,8620100', '南开区', '30', '120104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120105', '120100', '0,86,120000,8620100', '河北区', '30', '120105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120106', '120100', '0,86,120000,8620100', '红桥区', '30', '120106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120107', '120100', '0,86,120000,8620100', '古塘区', '30', '120107', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120108', '120100', '0,86,120000,8620100', '汉沽区', '30', '120108', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120109', '120100', '0,86,120000,8620100', '大港区', '30', '120109', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120110', '120100', '0,86,120000,8620100', '东丽区', '30', '120110', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120111', '120100', '0,86,120000,8620100', '西青区', '30', '120111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120112', '120100', '0,86,120000,8620100', '津南区', '30', '120112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120113', '120100', '0,86,120000,8620100', '北辰区', '30', '120113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120114', '120100', '0,86,120000,8620100', '武清区', '30', '120114', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120115', '120100', '0,86,120000,8620100', '宝坻区', '30', '120115', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120116', '120100', '0,86,120000,8620100', '滨海新区', '30', '120116', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120221', '120100', '0,86,120000,8620100', '宁河县', '30', '120221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120223', '120100', '0,86,120000,8620100', '静海县', '30', '120223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120225', '120100', '0,86,120000,8620100', '蓟县', '30', '120225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('120226', '120100', '0,86,120000,8620100', '其它区', '30', '120226', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130000', '86', '0,86', '河北省', '30', '130000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130100', '130000', '0,86,130000', '石家庄市', '30', '130100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130102', '130100', '0,86,130000,8630100', '长安区', '30', '130102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130103', '130100', '0,86,130000,8630100', '桥东区', '30', '130103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130104', '130100', '0,86,130000,8630100', '桥西区', '30', '130104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130105', '130100', '0,86,130000,8630100', '新华区', '30', '130105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130107', '130100', '0,86,130000,8630100', '井陉矿区', '30', '130107', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130108', '130100', '0,86,130000,8630100', '裕华区', '30', '130108', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130109', '130100', '0,86,130000,8630100', '栾城区', '30', '130109', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130110', '130100', '0,86,130000,8630100', '鹿泉区', '30', '130110', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130111', '130100', '0,86,130000,8630100', '栾城区', '30', '130111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130121', '130100', '0,86,130000,8630100', '井陉县', '30', '130121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130123', '130100', '0,86,130000,8630100', '正定县', '30', '130123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130125', '130100', '0,86,130000,8630100', '行唐县', '30', '130125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130126', '130100', '0,86,130000,8630100', '灵寿县', '30', '130126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130127', '130100', '0,86,130000,8630100', '高邑县', '30', '130127', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130128', '130100', '0,86,130000,8630100', '深泽县', '30', '130128', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130129', '130100', '0,86,130000,8630100', '赞皇县', '30', '130129', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130130', '130100', '0,86,130000,8630100', '无极县', '30', '130130', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130131', '130100', '0,86,130000,8630100', '平山县', '30', '130131', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130132', '130100', '0,86,130000,8630100', '元氏县', '30', '130132', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130133', '130100', '0,86,130000,8630100', '赵县', '30', '130133', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130181', '130100', '0,86,130000,8630100', '辛集市', '30', '130181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130182', '130100', '0,86,130000,8630100', '藁城区', '30', '130182', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130183', '130100', '0,86,130000,8630100', '晋州市', '30', '130183', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130184', '130100', '0,86,130000,8630100', '新乐市', '30', '130184', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130185', '130100', '0,86,130000,8630100', '鹿泉区', '30', '130185', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130186', '130100', '0,86,130000,8630100', '其它区', '30', '130186', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130200', '130000', '0,86,130000', '唐山市', '30', '130200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130202', '130200', '0,86,130000,8630200', '路南区', '30', '130202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130203', '130200', '0,86,130000,8630200', '路北区', '30', '130203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130204', '130200', '0,86,130000,8630200', '古冶区', '30', '130204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130205', '130200', '0,86,130000,8630200', '开平区', '30', '130205', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130207', '130200', '0,86,130000,8630200', '丰南区', '30', '130207', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130208', '130200', '0,86,130000,8630200', '丰润区', '30', '130208', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130209', '130200', '0,86,130000,8630200', '曹妃甸区', '30', '130209', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130223', '130200', '0,86,130000,8630200', '滦县', '30', '130223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130224', '130200', '0,86,130000,8630200', '滦南县', '30', '130224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130225', '130200', '0,86,130000,8630200', '乐亭县', '30', '130225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130227', '130200', '0,86,130000,8630200', '迁西县', '30', '130227', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130229', '130200', '0,86,130000,8630200', '玉田县', '30', '130229', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130230', '130200', '0,86,130000,8630200', '唐海县', '30', '130230', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130281', '130200', '0,86,130000,8630200', '遵化市', '30', '130281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130283', '130200', '0,86,130000,8630200', '迁安市', '30', '130283', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130284', '130200', '0,86,130000,8630200', '其它区', '30', '130284', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130300', '130000', '0,86,130000', '秦皇岛市', '30', '130300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130302', '130300', '0,86,130000,8630300', '海港区', '30', '130302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130303', '130300', '0,86,130000,8630300', '山海关区', '30', '130303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130304', '130300', '0,86,130000,8630300', '北戴河区', '30', '130304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130321', '130300', '0,86,130000,8630300', '青龙满族自治县', '30', '130321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130322', '130300', '0,86,130000,8630300', '昌黎县', '30', '130322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130323', '130300', '0,86,130000,8630300', '抚宁县', '30', '130323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130324', '130300', '0,86,130000,8630300', '卢龙县', '30', '130324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130325', '130300', '0,86,130000,8630300', '其它区', '30', '130325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130326', '130300', '0,86,130000,8630300', '经济技术开发区', '30', '130326', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130400', '130000', '0,86,130000', '邯郸市', '30', '130400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130402', '130400', '0,86,130000,8630400', '邯山区', '30', '130402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130403', '130400', '0,86,130000,8630400', '丛台区', '30', '130403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130404', '130400', '0,86,130000,8630400', '复兴区', '30', '130404', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130406', '130400', '0,86,130000,8630400', '峰峰矿区', '30', '130406', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130421', '130400', '0,86,130000,8630400', '邯郸县', '30', '130421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130423', '130400', '0,86,130000,8630400', '临漳县', '30', '130423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130424', '130400', '0,86,130000,8630400', '成安县', '30', '130424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130425', '130400', '0,86,130000,8630400', '大名县', '30', '130425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130426', '130400', '0,86,130000,8630400', '涉县', '30', '130426', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130427', '130400', '0,86,130000,8630400', '磁县', '30', '130427', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130428', '130400', '0,86,130000,8630400', '肥乡县', '30', '130428', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130429', '130400', '0,86,130000,8630400', '永年县', '30', '130429', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130430', '130400', '0,86,130000,8630400', '邱县', '30', '130430', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130431', '130400', '0,86,130000,8630400', '鸡泽县', '30', '130431', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130432', '130400', '0,86,130000,8630400', '广平县', '30', '130432', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130433', '130400', '0,86,130000,8630400', '馆陶县', '30', '130433', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130434', '130400', '0,86,130000,8630400', '魏县', '30', '130434', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130435', '130400', '0,86,130000,8630400', '曲周县', '30', '130435', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130481', '130400', '0,86,130000,8630400', '武安市', '30', '130481', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130482', '130400', '0,86,130000,8630400', '其它区', '30', '130482', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130500', '130000', '0,86,130000', '邢台市', '30', '130500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130502', '130500', '0,86,130000,8630500', '桥东区', '30', '130502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130503', '130500', '0,86,130000,8630500', '桥西区', '30', '130503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130521', '130500', '0,86,130000,8630500', '邢台县', '30', '130521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130522', '130500', '0,86,130000,8630500', '临城县', '30', '130522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130523', '130500', '0,86,130000,8630500', '内丘县', '30', '130523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130524', '130500', '0,86,130000,8630500', '柏乡县', '30', '130524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130525', '130500', '0,86,130000,8630500', '隆尧县', '30', '130525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130526', '130500', '0,86,130000,8630500', '任县', '30', '130526', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130527', '130500', '0,86,130000,8630500', '南和县', '30', '130527', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130528', '130500', '0,86,130000,8630500', '宁晋县', '30', '130528', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130529', '130500', '0,86,130000,8630500', '巨鹿县', '30', '130529', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130530', '130500', '0,86,130000,8630500', '新河县', '30', '130530', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130531', '130500', '0,86,130000,8630500', '广宗县', '30', '130531', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130532', '130500', '0,86,130000,8630500', '平乡县', '30', '130532', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130533', '130500', '0,86,130000,8630500', '威县', '30', '130533', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130534', '130500', '0,86,130000,8630500', '清河县', '30', '130534', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130535', '130500', '0,86,130000,8630500', '临西县', '30', '130535', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130581', '130500', '0,86,130000,8630500', '南宫市', '30', '130581', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130582', '130500', '0,86,130000,8630500', '沙河市', '30', '130582', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130583', '130500', '0,86,130000,8630500', '其它区', '30', '130583', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130600', '130000', '0,86,130000', '保定市', '30', '130600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130602', '130600', '0,86,130000,8630600', '竞秀区', '30', '130602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130603', '130600', '0,86,130000,8630600', '莲池区', '30', '130603', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130604', '130600', '0,86,130000,8630600', '新市区', '30', '130604', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130605', '130600', '0,86,130000,8630600', '北市区', '30', '130605', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130606', '130600', '0,86,130000,8630600', '南市区', '30', '130606', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130621', '130600', '0,86,130000,8630600', '满城县', '30', '130621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130622', '130600', '0,86,130000,8630600', '清苑县', '30', '130622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130623', '130600', '0,86,130000,8630600', '涞水县', '30', '130623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130624', '130600', '0,86,130000,8630600', '阜平县', '30', '130624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130625', '130600', '0,86,130000,8630600', '徐水县', '30', '130625', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130626', '130600', '0,86,130000,8630600', '定兴县', '30', '130626', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130627', '130600', '0,86,130000,8630600', '唐县', '30', '130627', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130628', '130600', '0,86,130000,8630600', '高阳县', '30', '130628', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130629', '130600', '0,86,130000,8630600', '容城县', '30', '130629', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130630', '130600', '0,86,130000,8630600', '涞源县', '30', '130630', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130631', '130600', '0,86,130000,8630600', '望都县', '30', '130631', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130632', '130600', '0,86,130000,8630600', '安新县', '30', '130632', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130633', '130600', '0,86,130000,8630600', '易县', '30', '130633', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130634', '130600', '0,86,130000,8630600', '曲阳县', '30', '130634', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130635', '130600', '0,86,130000,8630600', '蠡县', '30', '130635', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130636', '130600', '0,86,130000,8630600', '顺平县', '30', '130636', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130637', '130600', '0,86,130000,8630600', '博野县', '30', '130637', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130638', '130600', '0,86,130000,8630600', '雄县', '30', '130638', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130681', '130600', '0,86,130000,8630600', '涿州市', '30', '130681', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130682', '130600', '0,86,130000,8630600', '定州市', '30', '130682', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130683', '130600', '0,86,130000,8630600', '安国市', '30', '130683', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130684', '130600', '0,86,130000,8630600', '高碑店市', '30', '130684', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130685', '130600', '0,86,130000,8630600', '高开区', '30', '130685', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130686', '130600', '0,86,130000,8630600', '其它区', '30', '130686', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130700', '130000', '0,86,130000', '张家口市', '30', '130700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130702', '130700', '0,86,130000,8630700', '桥东区', '30', '130702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130703', '130700', '0,86,130000,8630700', '桥西区', '30', '130703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130705', '130700', '0,86,130000,8630700', '宣化区', '30', '130705', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130706', '130700', '0,86,130000,8630700', '下花园区', '30', '130706', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130721', '130700', '0,86,130000,8630700', '宣化县', '30', '130721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130722', '130700', '0,86,130000,8630700', '张北县', '30', '130722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130723', '130700', '0,86,130000,8630700', '康保县', '30', '130723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130724', '130700', '0,86,130000,8630700', '沽源县', '30', '130724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130725', '130700', '0,86,130000,8630700', '尚义县', '30', '130725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130726', '130700', '0,86,130000,8630700', '蔚县', '30', '130726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130727', '130700', '0,86,130000,8630700', '阳原县', '30', '130727', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130728', '130700', '0,86,130000,8630700', '怀安县', '30', '130728', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130729', '130700', '0,86,130000,8630700', '万全县', '30', '130729', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130730', '130700', '0,86,130000,8630700', '怀来县', '30', '130730', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130731', '130700', '0,86,130000,8630700', '涿鹿县', '30', '130731', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130732', '130700', '0,86,130000,8630700', '赤城县', '30', '130732', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130733', '130700', '0,86,130000,8630700', '崇礼县', '30', '130733', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130734', '130700', '0,86,130000,8630700', '其它区', '30', '130734', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130800', '130000', '0,86,130000', '承德市', '30', '130800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130802', '130800', '0,86,130000,8630800', '双桥区', '30', '130802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130803', '130800', '0,86,130000,8630800', '双滦区', '30', '130803', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130804', '130800', '0,86,130000,8630800', '鹰手营子矿区', '30', '130804', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130821', '130800', '0,86,130000,8630800', '承德县', '30', '130821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130822', '130800', '0,86,130000,8630800', '兴隆县', '30', '130822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130823', '130800', '0,86,130000,8630800', '平泉县', '30', '130823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130824', '130800', '0,86,130000,8630800', '滦平县', '30', '130824', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130825', '130800', '0,86,130000,8630800', '隆化县', '30', '130825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130826', '130800', '0,86,130000,8630800', '丰宁满族自治县', '30', '130826', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130827', '130800', '0,86,130000,8630800', '宽城满族自治县', '30', '130827', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130828', '130800', '0,86,130000,8630800', '围场满族蒙古族自治县', '30', '130828', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130829', '130800', '0,86,130000,8630800', '其它区', '30', '130829', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130900', '130000', '0,86,130000', '沧州市', '30', '130900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130902', '130900', '0,86,130000,8630900', '新华区', '30', '130902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130903', '130900', '0,86,130000,8630900', '运河区', '30', '130903', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130921', '130900', '0,86,130000,8630900', '沧县', '30', '130921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130922', '130900', '0,86,130000,8630900', '青县', '30', '130922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130923', '130900', '0,86,130000,8630900', '东光县', '30', '130923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130924', '130900', '0,86,130000,8630900', '海兴县', '30', '130924', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130925', '130900', '0,86,130000,8630900', '盐山县', '30', '130925', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130926', '130900', '0,86,130000,8630900', '肃宁县', '30', '130926', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130927', '130900', '0,86,130000,8630900', '南皮县', '30', '130927', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130928', '130900', '0,86,130000,8630900', '吴桥县', '30', '130928', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130929', '130900', '0,86,130000,8630900', '献县', '30', '130929', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130930', '130900', '0,86,130000,8630900', '孟村回族自治县', '30', '130930', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130981', '130900', '0,86,130000,8630900', '泊头市', '30', '130981', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130982', '130900', '0,86,130000,8630900', '任丘市', '30', '130982', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130983', '130900', '0,86,130000,8630900', '黄骅市', '30', '130983', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130984', '130900', '0,86,130000,8630900', '河间市', '30', '130984', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('130985', '130900', '0,86,130000,8630900', '其它区', '30', '130985', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131000', '130000', '0,86,130000', '廊坊市', '30', '131000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131002', '131000', '0,86,130000,8631000', '安次区', '30', '131002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131003', '131000', '0,86,130000,8631000', '广阳区', '30', '131003', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131022', '131000', '0,86,130000,8631000', '固安县', '30', '131022', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131023', '131000', '0,86,130000,8631000', '永清县', '30', '131023', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131024', '131000', '0,86,130000,8631000', '香河县', '30', '131024', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131025', '131000', '0,86,130000,8631000', '大城县', '30', '131025', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131026', '131000', '0,86,130000,8631000', '文安县', '30', '131026', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131028', '131000', '0,86,130000,8631000', '大厂回族自治县', '30', '131028', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131029', '131000', '0,86,130000,8631000', '开发区县', '30', '131029', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131030', '131000', '0,86,130000,8631000', '燕郊经济技术开发区', '30', '131030', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131081', '131000', '0,86,130000,8631000', '霸州市', '30', '131081', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131082', '131000', '0,86,130000,8631000', '三河市', '30', '131082', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131083', '131000', '0,86,130000,8631000', '其它区', '30', '131083', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131100', '130000', '0,86,130000', '衡水市', '30', '131100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131102', '131100', '0,86,130000,8631100', '桃城区', '30', '131102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131121', '131100', '0,86,130000,8631100', '枣强县', '30', '131121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131122', '131100', '0,86,130000,8631100', '武邑县', '30', '131122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131123', '131100', '0,86,130000,8631100', '武强县', '30', '131123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131124', '131100', '0,86,130000,8631100', '饶阳县', '30', '131124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131125', '131100', '0,86,130000,8631100', '安平县', '30', '131125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131126', '131100', '0,86,130000,8631100', '故城县', '30', '131126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131127', '131100', '0,86,130000,8631100', '景县', '30', '131127', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131128', '131100', '0,86,130000,8631100', '阜城县', '30', '131128', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131181', '131100', '0,86,130000,8631100', '冀州市', '30', '131181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131182', '131100', '0,86,130000,8631100', '深州市', '30', '131182', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('131183', '131100', '0,86,130000,8631100', '其它区', '30', '131183', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140000', '86', '0,86', '山西省', '30', '140000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140100', '140000', '0,86,140000', '太原市', '30', '140100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140105', '140100', '0,86,140000,8640100', '小店区', '30', '140105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140106', '140100', '0,86,140000,8640100', '迎泽区', '30', '140106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140107', '140100', '0,86,140000,8640100', '杏花岭区', '30', '140107', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140108', '140100', '0,86,140000,8640100', '尖草坪区', '30', '140108', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140109', '140100', '0,86,140000,8640100', '万柏林区', '30', '140109', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140110', '140100', '0,86,140000,8640100', '晋源区', '30', '140110', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140121', '140100', '0,86,140000,8640100', '清徐县', '30', '140121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140122', '140100', '0,86,140000,8640100', '阳曲县', '30', '140122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140123', '140100', '0,86,140000,8640100', '娄烦县', '30', '140123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140181', '140100', '0,86,140000,8640100', '古交市', '30', '140181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140182', '140100', '0,86,140000,8640100', '其它区', '30', '140182', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140200', '140000', '0,86,140000', '大同市', '30', '140200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140202', '140200', '0,86,140000,8640200', '城区', '30', '140202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140203', '140200', '0,86,140000,8640200', '矿区', '30', '140203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140211', '140200', '0,86,140000,8640200', '南郊区', '30', '140211', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140212', '140200', '0,86,140000,8640200', '新荣区', '30', '140212', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140221', '140200', '0,86,140000,8640200', '阳高县', '30', '140221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140222', '140200', '0,86,140000,8640200', '天镇县', '30', '140222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140223', '140200', '0,86,140000,8640200', '广灵县', '30', '140223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140224', '140200', '0,86,140000,8640200', '灵丘县', '30', '140224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140225', '140200', '0,86,140000,8640200', '浑源县', '30', '140225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140226', '140200', '0,86,140000,8640200', '左云县', '30', '140226', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140227', '140200', '0,86,140000,8640200', '大同县', '30', '140227', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140300', '140000', '0,86,140000', '阳泉市', '30', '140300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140302', '140300', '0,86,140000,8640300', '城区', '30', '140302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140303', '140300', '0,86,140000,8640300', '矿区', '30', '140303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140311', '140300', '0,86,140000,8640300', '郊区', '30', '140311', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140321', '140300', '0,86,140000,8640300', '平定县', '30', '140321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140322', '140300', '0,86,140000,8640300', '盂县', '30', '140322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140323', '140300', '0,86,140000,8640300', '其它区', '30', '140323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140400', '140000', '0,86,140000', '长治市', '30', '140400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140402', '140400', '0,86,140000,8640400', '城区', '30', '140402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140411', '140400', '0,86,140000,8640400', '郊区', '30', '140411', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140421', '140400', '0,86,140000,8640400', '长治县', '30', '140421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140423', '140400', '0,86,140000,8640400', '襄垣县', '30', '140423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140424', '140400', '0,86,140000,8640400', '屯留县', '30', '140424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140425', '140400', '0,86,140000,8640400', '平顺县', '30', '140425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140426', '140400', '0,86,140000,8640400', '黎城县', '30', '140426', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140427', '140400', '0,86,140000,8640400', '壶关县', '30', '140427', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140428', '140400', '0,86,140000,8640400', '长子县', '30', '140428', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140429', '140400', '0,86,140000,8640400', '武乡县', '30', '140429', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140430', '140400', '0,86,140000,8640400', '沁县', '30', '140430', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140431', '140400', '0,86,140000,8640400', '沁源县', '30', '140431', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140481', '140400', '0,86,140000,8640400', '潞城市', '30', '140481', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140482', '140400', '0,86,140000,8640400', '高新区', '30', '140482', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140483', '140400', '0,86,140000,8640400', '其它区', '30', '140483', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140500', '140000', '0,86,140000', '晋城市', '30', '140500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140502', '140500', '0,86,140000,8640500', '城区', '30', '140502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140521', '140500', '0,86,140000,8640500', '沁水县', '30', '140521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140522', '140500', '0,86,140000,8640500', '阳城县', '30', '140522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140524', '140500', '0,86,140000,8640500', '陵川县', '30', '140524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140525', '140500', '0,86,140000,8640500', '泽州县', '30', '140525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140581', '140500', '0,86,140000,8640500', '高平市', '30', '140581', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140582', '140500', '0,86,140000,8640500', '其它区', '30', '140582', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140600', '140000', '0,86,140000', '朔州市', '30', '140600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140602', '140600', '0,86,140000,8640600', '朔城区', '30', '140602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140603', '140600', '0,86,140000,8640600', '平鲁区', '30', '140603', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140621', '140600', '0,86,140000,8640600', '山阴县', '30', '140621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140622', '140600', '0,86,140000,8640600', '应县', '30', '140622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140623', '140600', '0,86,140000,8640600', '右玉县', '30', '140623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140624', '140600', '0,86,140000,8640600', '怀仁县', '30', '140624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140625', '140600', '0,86,140000,8640600', '其它区', '30', '140625', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140700', '140000', '0,86,140000', '晋中市', '30', '140700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140702', '140700', '0,86,140000,8640700', '榆次区', '30', '140702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140721', '140700', '0,86,140000,8640700', '榆社县', '30', '140721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140722', '140700', '0,86,140000,8640700', '左权县', '30', '140722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140723', '140700', '0,86,140000,8640700', '和顺县', '30', '140723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140724', '140700', '0,86,140000,8640700', '昔阳县', '30', '140724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140725', '140700', '0,86,140000,8640700', '寿阳县', '30', '140725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140726', '140700', '0,86,140000,8640700', '太谷县', '30', '140726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140727', '140700', '0,86,140000,8640700', '祁县', '30', '140727', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140728', '140700', '0,86,140000,8640700', '平遥县', '30', '140728', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140729', '140700', '0,86,140000,8640700', '灵石县', '30', '140729', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140781', '140700', '0,86,140000,8640700', '介休市', '30', '140781', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140782', '140700', '0,86,140000,8640700', '其它区', '30', '140782', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140800', '140000', '0,86,140000', '运城市', '30', '140800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140802', '140800', '0,86,140000,8640800', '盐湖区', '30', '140802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140821', '140800', '0,86,140000,8640800', '临猗县', '30', '140821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140822', '140800', '0,86,140000,8640800', '万荣县', '30', '140822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140823', '140800', '0,86,140000,8640800', '闻喜县', '30', '140823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140824', '140800', '0,86,140000,8640800', '稷山县', '30', '140824', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140825', '140800', '0,86,140000,8640800', '新绛县', '30', '140825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140826', '140800', '0,86,140000,8640800', '绛县', '30', '140826', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140827', '140800', '0,86,140000,8640800', '垣曲县', '30', '140827', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140828', '140800', '0,86,140000,8640800', '夏县', '30', '140828', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140829', '140800', '0,86,140000,8640800', '平陆县', '30', '140829', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140830', '140800', '0,86,140000,8640800', '芮城县', '30', '140830', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140881', '140800', '0,86,140000,8640800', '永济市', '30', '140881', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140882', '140800', '0,86,140000,8640800', '河津市', '30', '140882', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140883', '140800', '0,86,140000,8640800', '其它区', '30', '140883', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140900', '140000', '0,86,140000', '忻州市', '30', '140900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140902', '140900', '0,86,140000,8640900', '忻府区', '30', '140902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140921', '140900', '0,86,140000,8640900', '定襄县', '30', '140921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140922', '140900', '0,86,140000,8640900', '五台县', '30', '140922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140923', '140900', '0,86,140000,8640900', '代县', '30', '140923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140924', '140900', '0,86,140000,8640900', '繁峙县', '30', '140924', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140925', '140900', '0,86,140000,8640900', '宁武县', '30', '140925', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140926', '140900', '0,86,140000,8640900', '静乐县', '30', '140926', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140927', '140900', '0,86,140000,8640900', '神池县', '30', '140927', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140928', '140900', '0,86,140000,8640900', '五寨县', '30', '140928', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140929', '140900', '0,86,140000,8640900', '岢岚县', '30', '140929', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140930', '140900', '0,86,140000,8640900', '河曲县', '30', '140930', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140931', '140900', '0,86,140000,8640900', '保德县', '30', '140931', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140932', '140900', '0,86,140000,8640900', '偏关县', '30', '140932', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140981', '140900', '0,86,140000,8640900', '原平市', '30', '140981', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('140982', '140900', '0,86,140000,8640900', '其它区', '30', '140982', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141000', '140000', '0,86,140000', '临汾市', '30', '141000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141002', '141000', '0,86,140000,8641000', '尧都区', '30', '141002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141021', '141000', '0,86,140000,8641000', '曲沃县', '30', '141021', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141022', '141000', '0,86,140000,8641000', '翼城县', '30', '141022', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141023', '141000', '0,86,140000,8641000', '襄汾县', '30', '141023', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141024', '141000', '0,86,140000,8641000', '洪洞县', '30', '141024', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141025', '141000', '0,86,140000,8641000', '古县', '30', '141025', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141026', '141000', '0,86,140000,8641000', '安泽县', '30', '141026', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141027', '141000', '0,86,140000,8641000', '浮山县', '30', '141027', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141028', '141000', '0,86,140000,8641000', '吉县', '30', '141028', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141029', '141000', '0,86,140000,8641000', '乡宁县', '30', '141029', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141030', '141000', '0,86,140000,8641000', '大宁县', '30', '141030', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141031', '141000', '0,86,140000,8641000', '隰县', '30', '141031', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141032', '141000', '0,86,140000,8641000', '永和县', '30', '141032', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141033', '141000', '0,86,140000,8641000', '蒲县', '30', '141033', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141034', '141000', '0,86,140000,8641000', '汾西县', '30', '141034', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141081', '141000', '0,86,140000,8641000', '侯马市', '30', '141081', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141082', '141000', '0,86,140000,8641000', '霍州市', '30', '141082', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141083', '141000', '0,86,140000,8641000', '其它区', '30', '141083', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141100', '140000', '0,86,140000', '吕梁市', '30', '141100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141102', '141100', '0,86,140000,8641100', '离石区', '30', '141102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141121', '141100', '0,86,140000,8641100', '文水县', '30', '141121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141122', '141100', '0,86,140000,8641100', '交城县', '30', '141122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141123', '141100', '0,86,140000,8641100', '兴县', '30', '141123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141124', '141100', '0,86,140000,8641100', '临县', '30', '141124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141125', '141100', '0,86,140000,8641100', '柳林县', '30', '141125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141126', '141100', '0,86,140000,8641100', '石楼县', '30', '141126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141127', '141100', '0,86,140000,8641100', '岚县', '30', '141127', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141128', '141100', '0,86,140000,8641100', '方山县', '30', '141128', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141129', '141100', '0,86,140000,8641100', '中阳县', '30', '141129', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141130', '141100', '0,86,140000,8641100', '交口县', '30', '141130', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141181', '141100', '0,86,140000,8641100', '孝义市', '30', '141181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141182', '141100', '0,86,140000,8641100', '汾阳市', '30', '141182', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('141183', '141100', '0,86,140000,8641100', '其它区', '30', '141183', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150000', '86', '0,86', '内蒙古自治区', '30', '150000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150100', '150000', '0,86,150000', '呼和浩特市', '30', '150100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150102', '150100', '0,86,150000,8650100', '新城区', '30', '150102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150103', '150100', '0,86,150000,8650100', '回民区', '30', '150103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150104', '150100', '0,86,150000,8650100', '玉泉区', '30', '150104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150105', '150100', '0,86,150000,8650100', '赛罕区', '30', '150105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150121', '150100', '0,86,150000,8650100', '土默特左旗', '30', '150121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150122', '150100', '0,86,150000,8650100', '托克托县', '30', '150122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150123', '150100', '0,86,150000,8650100', '和林格尔县', '30', '150123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150124', '150100', '0,86,150000,8650100', '清水河县', '30', '150124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150125', '150100', '0,86,150000,8650100', '武川县', '30', '150125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150126', '150100', '0,86,150000,8650100', '其它区', '30', '150126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150200', '150000', '0,86,150000', '包头市', '30', '150200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150202', '150200', '0,86,150000,8650200', '东河区', '30', '150202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150203', '150200', '0,86,150000,8650200', '昆都仑区', '30', '150203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150204', '150200', '0,86,150000,8650200', '青山区', '30', '150204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150205', '150200', '0,86,150000,8650200', '石拐区', '30', '150205', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150206', '150200', '0,86,150000,8650200', '白云鄂博矿区', '30', '150206', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150207', '150200', '0,86,150000,8650200', '九原区', '30', '150207', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150221', '150200', '0,86,150000,8650200', '土默特右旗', '30', '150221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150222', '150200', '0,86,150000,8650200', '固阳县', '30', '150222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150223', '150200', '0,86,150000,8650200', '达尔罕茂明安联合旗', '30', '150223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150224', '150200', '0,86,150000,8650200', '其它区', '30', '150224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150300', '150000', '0,86,150000', '乌海市', '30', '150300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150302', '150300', '0,86,150000,8650300', '海勃湾区', '30', '150302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150303', '150300', '0,86,150000,8650300', '海南区', '30', '150303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150304', '150300', '0,86,150000,8650300', '乌达区', '30', '150304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150305', '150300', '0,86,150000,8650300', '其它区', '30', '150305', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150400', '150000', '0,86,150000', '赤峰市', '30', '150400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150402', '150400', '0,86,150000,8650400', '红山区', '30', '150402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150403', '150400', '0,86,150000,8650400', '元宝山区', '30', '150403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150404', '150400', '0,86,150000,8650400', '松山区', '30', '150404', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150421', '150400', '0,86,150000,8650400', '阿鲁科尔沁旗', '30', '150421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150422', '150400', '0,86,150000,8650400', '巴林左旗', '30', '150422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150423', '150400', '0,86,150000,8650400', '巴林右旗', '30', '150423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150424', '150400', '0,86,150000,8650400', '林西县', '30', '150424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150425', '150400', '0,86,150000,8650400', '克什克腾旗', '30', '150425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150426', '150400', '0,86,150000,8650400', '翁牛特旗', '30', '150426', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150428', '150400', '0,86,150000,8650400', '喀喇沁旗', '30', '150428', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150429', '150400', '0,86,150000,8650400', '宁城县', '30', '150429', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150430', '150400', '0,86,150000,8650400', '敖汉旗', '30', '150430', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150431', '150400', '0,86,150000,8650400', '其它区', '30', '150431', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150500', '150000', '0,86,150000', '通辽市', '30', '150500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150502', '150500', '0,86,150000,8650500', '科尔沁区', '30', '150502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150521', '150500', '0,86,150000,8650500', '科尔沁左翼中旗', '30', '150521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150522', '150500', '0,86,150000,8650500', '科尔沁左翼后旗', '30', '150522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150523', '150500', '0,86,150000,8650500', '开鲁县', '30', '150523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150524', '150500', '0,86,150000,8650500', '库伦旗', '30', '150524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150525', '150500', '0,86,150000,8650500', '奈曼旗', '30', '150525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150526', '150500', '0,86,150000,8650500', '扎鲁特旗', '30', '150526', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150581', '150500', '0,86,150000,8650500', '霍林郭勒市', '30', '150581', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150582', '150500', '0,86,150000,8650500', '其它区', '30', '150582', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150600', '150000', '0,86,150000', '鄂尔多斯市', '30', '150600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150602', '150600', '0,86,150000,8650600', '东胜区', '30', '150602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150621', '150600', '0,86,150000,8650600', '达拉特旗', '30', '150621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150622', '150600', '0,86,150000,8650600', '准格尔旗', '30', '150622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150623', '150600', '0,86,150000,8650600', '鄂托克前旗', '30', '150623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150624', '150600', '0,86,150000,8650600', '鄂托克旗', '30', '150624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150625', '150600', '0,86,150000,8650600', '杭锦旗', '30', '150625', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150626', '150600', '0,86,150000,8650600', '乌审旗', '30', '150626', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150627', '150600', '0,86,150000,8650600', '伊金霍洛旗', '30', '150627', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150628', '150600', '0,86,150000,8650600', '其它区', '30', '150628', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150700', '150000', '0,86,150000', '呼伦贝尔市', '30', '150700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150702', '150700', '0,86,150000,8650700', '海拉尔区', '30', '150702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150703', '150700', '0,86,150000,8650700', '扎赉诺尔区', '30', '150703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150721', '150700', '0,86,150000,8650700', '阿荣旗', '30', '150721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150722', '150700', '0,86,150000,8650700', '莫力达瓦达斡尔族自治旗', '30', '150722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150723', '150700', '0,86,150000,8650700', '鄂伦春自治旗', '30', '150723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150724', '150700', '0,86,150000,8650700', '鄂温克族自治旗', '30', '150724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150725', '150700', '0,86,150000,8650700', '陈巴尔虎旗', '30', '150725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150726', '150700', '0,86,150000,8650700', '新巴尔虎左旗', '30', '150726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150727', '150700', '0,86,150000,8650700', '新巴尔虎右旗', '30', '150727', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150781', '150700', '0,86,150000,8650700', '满洲里市', '30', '150781', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150782', '150700', '0,86,150000,8650700', '牙克石市', '30', '150782', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150783', '150700', '0,86,150000,8650700', '扎兰屯市', '30', '150783', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150784', '150700', '0,86,150000,8650700', '额尔古纳市', '30', '150784', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150785', '150700', '0,86,150000,8650700', '根河市', '30', '150785', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150800', '150000', '0,86,150000', '巴彦淖尔市', '30', '150800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150802', '150800', '0,86,150000,8650800', '临河区', '30', '150802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150821', '150800', '0,86,150000,8650800', '五原县', '30', '150821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150822', '150800', '0,86,150000,8650800', '磴口县', '30', '150822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150823', '150800', '0,86,150000,8650800', '乌拉特前旗', '30', '150823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150824', '150800', '0,86,150000,8650800', '乌拉特中旗', '30', '150824', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150825', '150800', '0,86,150000,8650800', '乌拉特后旗', '30', '150825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150826', '150800', '0,86,150000,8650800', '杭锦后旗', '30', '150826', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150900', '150000', '0,86,150000', '乌兰察布市', '30', '150900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150902', '150900', '0,86,150000,8650900', '集宁区', '30', '150902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150921', '150900', '0,86,150000,8650900', '卓资县', '30', '150921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150922', '150900', '0,86,150000,8650900', '化德县', '30', '150922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150923', '150900', '0,86,150000,8650900', '商都县', '30', '150923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150924', '150900', '0,86,150000,8650900', '兴和县', '30', '150924', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150925', '150900', '0,86,150000,8650900', '凉城县', '30', '150925', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150926', '150900', '0,86,150000,8650900', '察哈尔右翼前旗', '30', '150926', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150927', '150900', '0,86,150000,8650900', '察哈尔右翼中旗', '30', '150927', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150928', '150900', '0,86,150000,8650900', '察哈尔右翼后旗', '30', '150928', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150929', '150900', '0,86,150000,8650900', '四子王旗', '30', '150929', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('150981', '150900', '0,86,150000,8650900', '丰镇市', '30', '150981', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152200', '150000', '0,86,150000', '兴安盟', '30', '152200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152201', '152200', '0,86,150000,8652200', '乌兰浩特市', '30', '152201', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152202', '152200', '0,86,150000,8652200', '阿尔山市', '30', '152202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152221', '152200', '0,86,150000,8652200', '科尔沁右翼前旗', '30', '152221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152222', '152200', '0,86,150000,8652200', '科尔沁右翼中旗', '30', '152222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152223', '152200', '0,86,150000,8652200', '扎赉特旗', '30', '152223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152224', '152200', '0,86,150000,8652200', '突泉县', '30', '152224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152500', '150000', '0,86,150000', '锡林郭勒盟', '30', '152500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152501', '152500', '0,86,150000,8652500', '二连浩特市', '30', '152501', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152502', '152500', '0,86,150000,8652500', '锡林浩特市', '30', '152502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152522', '152500', '0,86,150000,8652500', '阿巴嘎旗', '30', '152522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152523', '152500', '0,86,150000,8652500', '苏尼特左旗', '30', '152523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152524', '152500', '0,86,150000,8652500', '苏尼特右旗', '30', '152524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152525', '152500', '0,86,150000,8652500', '东乌珠穆沁旗', '30', '152525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152526', '152500', '0,86,150000,8652500', '西乌珠穆沁旗', '30', '152526', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152527', '152500', '0,86,150000,8652500', '太仆寺旗', '30', '152527', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152528', '152500', '0,86,150000,8652500', '镶黄旗', '30', '152528', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152529', '152500', '0,86,150000,8652500', '正镶白旗', '30', '152529', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152530', '152500', '0,86,150000,8652500', '正蓝旗', '30', '152530', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152531', '152500', '0,86,150000,8652500', '多伦县', '30', '152531', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152900', '150000', '0,86,150000', '阿拉善盟', '30', '152900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152921', '152900', '0,86,150000,8652900', '阿拉善左旗', '30', '152921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152922', '152900', '0,86,150000,8652900', '阿拉善右旗', '30', '152922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('152923', '152900', '0,86,150000,8652900', '额济纳旗', '30', '152923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210000', '86', '0,86', '辽宁省', '30', '210000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210100', '210000', '0,86,210000', '沈阳市', '30', '210100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210102', '210100', '0,86,210000,210100', '和平区', '30', '210102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210103', '210100', '0,86,210000,210100', '沈河区', '30', '210103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210104', '210100', '0,86,210000,210100', '大东区', '30', '210104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210105', '210100', '0,86,210000,210100', '皇姑区', '30', '210105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210106', '210100', '0,86,210000,210100', '铁西区', '30', '210106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210111', '210100', '0,86,210000,210100', '苏家屯区', '30', '210111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210112', '210100', '0,86,210000,210100', '浑南区', '30', '210112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210113', '210100', '0,86,210000,210100', '沈北新区', '30', '210113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210114', '210100', '0,86,210000,210100', '于洪区', '30', '210114', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210115', '210100', '0,86,210000,210100', '新城子区', '30', '210115', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210122', '210100', '0,86,210000,210100', '辽中县', '30', '210122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210123', '210100', '0,86,210000,210100', '康平县', '30', '210123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210124', '210100', '0,86,210000,210100', '法库县', '30', '210124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210181', '210100', '0,86,210000,210100', '新民市', '30', '210181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210182', '210100', '0,86,210000,210100', '浑南新区', '30', '210182', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210183', '210100', '0,86,210000,210100', '张士开发区', '30', '210183', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210200', '210000', '0,86,210000', '大连市', '30', '210200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210202', '210200', '0,86,210000,210200', '中山区', '30', '210202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210203', '210200', '0,86,210000,210200', '西岗区', '30', '210203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210204', '210200', '0,86,210000,210200', '沙河口区', '30', '210204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210211', '210200', '0,86,210000,210200', '甘井子区', '30', '210211', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210212', '210200', '0,86,210000,210200', '旅顺口区', '30', '210212', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210213', '210200', '0,86,210000,210200', '金州区', '30', '210213', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210224', '210200', '0,86,210000,210200', '长海县', '30', '210224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210281', '210200', '0,86,210000,210200', '瓦房店市', '30', '210281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210282', '210200', '0,86,210000,210200', '普兰店市', '30', '210282', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210283', '210200', '0,86,210000,210200', '庄河市', '30', '210283', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210284', '210200', '0,86,210000,210200', '岭前区', '30', '210284', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210285', '210200', '0,86,210000,210200', '开发区', '30', '210285', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210300', '210000', '0,86,210000', '鞍山市', '30', '210300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210302', '210300', '0,86,210000,210300', '铁东区', '30', '210302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210303', '210300', '0,86,210000,210300', '铁西区', '30', '210303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210304', '210300', '0,86,210000,210300', '立山区', '30', '210304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210311', '210300', '0,86,210000,210300', '千山区', '30', '210311', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210321', '210300', '0,86,210000,210300', '台安县', '30', '210321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210323', '210300', '0,86,210000,210300', '岫岩满族自治县', '30', '210323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210381', '210300', '0,86,210000,210300', '海城市', '30', '210381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210382', '210300', '0,86,210000,210300', '高新区', '30', '210382', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210400', '210000', '0,86,210000', '抚顺市', '30', '210400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210402', '210400', '0,86,210000,210400', '新抚区', '30', '210402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210403', '210400', '0,86,210000,210400', '东洲区', '30', '210403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210404', '210400', '0,86,210000,210400', '望花区', '30', '210404', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210411', '210400', '0,86,210000,210400', '顺城区', '30', '210411', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210421', '210400', '0,86,210000,210400', '抚顺县', '30', '210421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210422', '210400', '0,86,210000,210400', '新宾满族自治县', '30', '210422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210423', '210400', '0,86,210000,210400', '清原满族自治县', '30', '210423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210500', '210000', '0,86,210000', '本溪市', '30', '210500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210502', '210500', '0,86,210000,210500', '平山区', '30', '210502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210503', '210500', '0,86,210000,210500', '溪湖区', '30', '210503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210504', '210500', '0,86,210000,210500', '明山区', '30', '210504', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210505', '210500', '0,86,210000,210500', '南芬区', '30', '210505', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210521', '210500', '0,86,210000,210500', '本溪满族自治县', '30', '210521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210522', '210500', '0,86,210000,210500', '桓仁满族自治县', '30', '210522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210600', '210000', '0,86,210000', '丹东市', '30', '210600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210602', '210600', '0,86,210000,210600', '元宝区', '30', '210602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210603', '210600', '0,86,210000,210600', '振兴区', '30', '210603', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210604', '210600', '0,86,210000,210600', '振安区', '30', '210604', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210624', '210600', '0,86,210000,210600', '宽甸满族自治县', '30', '210624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210681', '210600', '0,86,210000,210600', '东港市', '30', '210681', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210682', '210600', '0,86,210000,210600', '凤城市', '30', '210682', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210700', '210000', '0,86,210000', '锦州市', '30', '210700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210702', '210700', '0,86,210000,210700', '古塔区', '30', '210702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210703', '210700', '0,86,210000,210700', '凌河区', '30', '210703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210711', '210700', '0,86,210000,210700', '太和区', '30', '210711', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210726', '210700', '0,86,210000,210700', '黑山县', '30', '210726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210727', '210700', '0,86,210000,210700', '义县', '30', '210727', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210781', '210700', '0,86,210000,210700', '凌海市', '30', '210781', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210782', '210700', '0,86,210000,210700', '北镇市', '30', '210782', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210800', '210000', '0,86,210000', '营口市', '30', '210800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210802', '210800', '0,86,210000,210800', '站前区', '30', '210802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210803', '210800', '0,86,210000,210800', '西市区', '30', '210803', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210804', '210800', '0,86,210000,210800', '鲅鱼圈区', '30', '210804', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210811', '210800', '0,86,210000,210800', '老边区', '30', '210811', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210881', '210800', '0,86,210000,210800', '盖州市', '30', '210881', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210882', '210800', '0,86,210000,210800', '大石桥市', '30', '210882', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210900', '210000', '0,86,210000', '阜新市', '30', '210900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210902', '210900', '0,86,210000,210900', '海州区', '30', '210902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210903', '210900', '0,86,210000,210900', '新邱区', '30', '210903', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210904', '210900', '0,86,210000,210900', '太平区', '30', '210904', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210905', '210900', '0,86,210000,210900', '清河门区', '30', '210905', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210911', '210900', '0,86,210000,210900', '细河区', '30', '210911', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210921', '210900', '0,86,210000,210900', '阜新蒙古族自治县', '30', '210921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('210922', '210900', '0,86,210000,210900', '彰武县', '30', '210922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211000', '210000', '0,86,210000', '辽阳市', '30', '211000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211002', '211000', '0,86,210000,211000', '白塔区', '30', '211002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211003', '211000', '0,86,210000,211000', '文圣区', '30', '211003', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211004', '211000', '0,86,210000,211000', '宏伟区', '30', '211004', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211005', '211000', '0,86,210000,211000', '弓长岭区', '30', '211005', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211011', '211000', '0,86,210000,211000', '太子河区', '30', '211011', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211021', '211000', '0,86,210000,211000', '辽阳县', '30', '211021', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211081', '211000', '0,86,210000,211000', '灯塔市', '30', '211081', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211100', '210000', '0,86,210000', '盘锦市', '30', '211100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211102', '211100', '0,86,210000,211100', '双台子区', '30', '211102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211103', '211100', '0,86,210000,211100', '兴隆台区', '30', '211103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211121', '211100', '0,86,210000,211100', '大洼县', '30', '211121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211122', '211100', '0,86,210000,211100', '盘山县', '30', '211122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211200', '210000', '0,86,210000', '铁岭市', '30', '211200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211202', '211200', '0,86,210000,211200', '银州区', '30', '211202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211204', '211200', '0,86,210000,211200', '清河区', '30', '211204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211221', '211200', '0,86,210000,211200', '铁岭县', '30', '211221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211223', '211200', '0,86,210000,211200', '西丰县', '30', '211223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211224', '211200', '0,86,210000,211200', '昌图县', '30', '211224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211281', '211200', '0,86,210000,211200', '调兵山市', '30', '211281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211282', '211200', '0,86,210000,211200', '开原市', '30', '211282', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211300', '210000', '0,86,210000', '朝阳市', '30', '211300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211302', '211300', '0,86,210000,211300', '双塔区', '30', '211302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211303', '211300', '0,86,210000,211300', '龙城区', '30', '211303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211321', '211300', '0,86,210000,211300', '朝阳县', '30', '211321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211322', '211300', '0,86,210000,211300', '建平县', '30', '211322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211324', '211300', '0,86,210000,211300', '喀喇沁左翼蒙古族自治县', '30', '211324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211381', '211300', '0,86,210000,211300', '北票市', '30', '211381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211382', '211300', '0,86,210000,211300', '凌源市', '30', '211382', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211400', '210000', '0,86,210000', '葫芦岛市', '30', '211400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211402', '211400', '0,86,210000,211400', '连山区', '30', '211402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211403', '211400', '0,86,210000,211400', '龙港区', '30', '211403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211404', '211400', '0,86,210000,211400', '南票区', '30', '211404', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211421', '211400', '0,86,210000,211400', '绥中县', '30', '211421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211422', '211400', '0,86,210000,211400', '建昌县', '30', '211422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('211481', '211400', '0,86,210000,211400', '兴城市', '30', '211481', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220000', '86', '0,86', '吉林省', '30', '220000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220100', '220000', '0,86,220000', '长春市', '30', '220100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220102', '220100', '0,86,220000,220100', '南关区', '30', '220102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220103', '220100', '0,86,220000,220100', '宽城区', '30', '220103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220104', '220100', '0,86,220000,220100', '朝阳区', '30', '220104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220105', '220100', '0,86,220000,220100', '二道区', '30', '220105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220106', '220100', '0,86,220000,220100', '绿园区', '30', '220106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220112', '220100', '0,86,220000,220100', '双阳区', '30', '220112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220113', '220100', '0,86,220000,220100', '九台区', '30', '220113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220122', '220100', '0,86,220000,220100', '农安县', '30', '220122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220182', '220100', '0,86,220000,220100', '榆树市', '30', '220182', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220183', '220100', '0,86,220000,220100', '德惠市', '30', '220183', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220184', '220100', '0,86,220000,220100', '高薪技术产业开发区', '30', '220184', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220185', '220100', '0,86,220000,220100', '汽车产业开发区', '30', '220185', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220186', '220100', '0,86,220000,220100', '经济技术开发区', '30', '220186', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220187', '220100', '0,86,220000,220100', '净月旅游开发区', '30', '220187', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220188', '220100', '0,86,220000,220100', '其他区', '30', '220188', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220200', '220000', '0,86,220000', '吉林市', '30', '220200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220202', '220200', '0,86,220000,220200', '昌邑区', '30', '220202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220203', '220200', '0,86,220000,220200', '龙潭区', '30', '220203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220204', '220200', '0,86,220000,220200', '船营区', '30', '220204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220211', '220200', '0,86,220000,220200', '丰满区', '30', '220211', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220221', '220200', '0,86,220000,220200', '永吉县', '30', '220221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220281', '220200', '0,86,220000,220200', '蛟河市', '30', '220281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220282', '220200', '0,86,220000,220200', '桦甸市', '30', '220282', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220283', '220200', '0,86,220000,220200', '舒兰市', '30', '220283', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220284', '220200', '0,86,220000,220200', '磐石市', '30', '220284', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220285', '220200', '0,86,220000,220200', '其他区', '30', '220285', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220300', '220000', '0,86,220000', '四平市', '30', '220300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220302', '220300', '0,86,220000,220300', '铁西区', '30', '220302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220303', '220300', '0,86,220000,220300', '铁东区', '30', '220303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220322', '220300', '0,86,220000,220300', '梨树县', '30', '220322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220323', '220300', '0,86,220000,220300', '伊通满族自治县', '30', '220323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220381', '220300', '0,86,220000,220300', '公主岭市', '30', '220381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220382', '220300', '0,86,220000,220300', '双辽市', '30', '220382', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220383', '220300', '0,86,220000,220300', '其他区', '30', '220383', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220400', '220000', '0,86,220000', '辽源市', '30', '220400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220402', '220400', '0,86,220000,220400', '龙山区', '30', '220402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220403', '220400', '0,86,220000,220400', '西安区', '30', '220403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220421', '220400', '0,86,220000,220400', '东丰县', '30', '220421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220422', '220400', '0,86,220000,220400', '东辽县', '30', '220422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220423', '220400', '0,86,220000,220400', '其他区', '30', '220423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220500', '220000', '0,86,220000', '通化市', '30', '220500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220502', '220500', '0,86,220000,220500', '东昌区', '30', '220502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220503', '220500', '0,86,220000,220500', '二道江区', '30', '220503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220521', '220500', '0,86,220000,220500', '通化县', '30', '220521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220523', '220500', '0,86,220000,220500', '辉南县', '30', '220523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220524', '220500', '0,86,220000,220500', '柳河县', '30', '220524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220581', '220500', '0,86,220000,220500', '梅河口市', '30', '220581', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220582', '220500', '0,86,220000,220500', '集安市', '30', '220582', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220583', '220500', '0,86,220000,220500', '其他区', '30', '220583', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220600', '220000', '0,86,220000', '白山市', '30', '220600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220602', '220600', '0,86,220000,220600', '浑江区', '30', '220602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220605', '220600', '0,86,220000,220600', '江源区', '30', '220605', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220621', '220600', '0,86,220000,220600', '抚松县', '30', '220621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220622', '220600', '0,86,220000,220600', '靖宇县', '30', '220622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220623', '220600', '0,86,220000,220600', '长白朝鲜族自治县', '30', '220623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220681', '220600', '0,86,220000,220600', '临江市', '30', '220681', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220682', '220600', '0,86,220000,220600', '其他区', '30', '220682', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220700', '220000', '0,86,220000', '松原市', '30', '220700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220702', '220700', '0,86,220000,220700', '宁江区', '30', '220702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220721', '220700', '0,86,220000,220700', '前郭尔罗斯蒙古族自治县', '30', '220721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220722', '220700', '0,86,220000,220700', '长岭县', '30', '220722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220723', '220700', '0,86,220000,220700', '乾安县', '30', '220723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220781', '220700', '0,86,220000,220700', '扶余市', '30', '220781', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220800', '220000', '0,86,220000', '白城市', '30', '220800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220802', '220800', '0,86,220000,220800', '洮北区', '30', '220802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220821', '220800', '0,86,220000,220800', '镇赉县', '30', '220821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220822', '220800', '0,86,220000,220800', '通榆县', '30', '220822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220881', '220800', '0,86,220000,220800', '洮南市', '30', '220881', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('220882', '220800', '0,86,220000,220800', '大安市', '30', '220882', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('222400', '220000', '0,86,220000', '延边朝鲜族自治州', '30', '222400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('222401', '222400', '0,86,220000,222400', '延吉市', '30', '222401', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('222402', '222400', '0,86,220000,222400', '图们市', '30', '222402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('222403', '222400', '0,86,220000,222400', '敦化市', '30', '222403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('222404', '222400', '0,86,220000,222400', '珲春市', '30', '222404', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('222405', '222400', '0,86,220000,222400', '龙井市', '30', '222405', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('222406', '222400', '0,86,220000,222400', '和龙市', '30', '222406', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('222424', '222400', '0,86,220000,222400', '汪清县', '30', '222424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('222426', '222400', '0,86,220000,222400', '安图县', '30', '222426', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230000', '86', '0,86', '黑龙江省', '30', '230000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230100', '230000', '0,86,230000', '哈尔滨市', '30', '230100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230102', '230100', '0,86,230000,230100', '道里区', '30', '230102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230103', '230100', '0,86,230000,230100', '南岗区', '30', '230103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230104', '230100', '0,86,230000,230100', '道外区', '30', '230104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230105', '230100', '0,86,230000,230100', '动力区', '30', '230105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230108', '230100', '0,86,230000,230100', '平房区', '30', '230108', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230109', '230100', '0,86,230000,230100', '松北区', '30', '230109', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230110', '230100', '0,86,230000,230100', '香坊区', '30', '230110', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230111', '230100', '0,86,230000,230100', '呼兰区', '30', '230111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230112', '230100', '0,86,230000,230100', '阿城区', '30', '230112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230113', '230100', '0,86,230000,230100', '双城区', '30', '230113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230123', '230100', '0,86,230000,230100', '依兰县', '30', '230123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230124', '230100', '0,86,230000,230100', '方正县', '30', '230124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230125', '230100', '0,86,230000,230100', '宾县', '30', '230125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230126', '230100', '0,86,230000,230100', '巴彦县', '30', '230126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230127', '230100', '0,86,230000,230100', '木兰县', '30', '230127', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230128', '230100', '0,86,230000,230100', '通河县', '30', '230128', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230129', '230100', '0,86,230000,230100', '延寿县', '30', '230129', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230183', '230100', '0,86,230000,230100', '尚志市', '30', '230183', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230184', '230100', '0,86,230000,230100', '五常市', '30', '230184', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230200', '230000', '0,86,230000', '齐齐哈尔市', '30', '230200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230202', '230200', '0,86,230000,230200', '龙沙区', '30', '230202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230203', '230200', '0,86,230000,230200', '建华区', '30', '230203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230204', '230200', '0,86,230000,230200', '铁锋区', '30', '230204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230205', '230200', '0,86,230000,230200', '昂昂溪区', '30', '230205', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230206', '230200', '0,86,230000,230200', '富拉尔基区', '30', '230206', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230207', '230200', '0,86,230000,230200', '碾子山区', '30', '230207', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230208', '230200', '0,86,230000,230200', '梅里斯达斡尔族区', '30', '230208', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230221', '230200', '0,86,230000,230200', '龙江县', '30', '230221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230223', '230200', '0,86,230000,230200', '依安县', '30', '230223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230224', '230200', '0,86,230000,230200', '泰来县', '30', '230224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230225', '230200', '0,86,230000,230200', '甘南县', '30', '230225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230227', '230200', '0,86,230000,230200', '富裕县', '30', '230227', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230229', '230200', '0,86,230000,230200', '克山县', '30', '230229', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230230', '230200', '0,86,230000,230200', '克东县', '30', '230230', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230231', '230200', '0,86,230000,230200', '拜泉县', '30', '230231', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230281', '230200', '0,86,230000,230200', '讷河市', '30', '230281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230300', '230000', '0,86,230000', '鸡西市', '30', '230300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230302', '230300', '0,86,230000,230300', '鸡冠区', '30', '230302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230303', '230300', '0,86,230000,230300', '恒山区', '30', '230303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230304', '230300', '0,86,230000,230300', '滴道区', '30', '230304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230305', '230300', '0,86,230000,230300', '梨树区', '30', '230305', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230306', '230300', '0,86,230000,230300', '城子河区', '30', '230306', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230307', '230300', '0,86,230000,230300', '麻山区', '30', '230307', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230321', '230300', '0,86,230000,230300', '鸡东县', '30', '230321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230381', '230300', '0,86,230000,230300', '虎林市', '30', '230381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230382', '230300', '0,86,230000,230300', '密山市', '30', '230382', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230400', '230000', '0,86,230000', '鹤岗市', '30', '230400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230402', '230400', '0,86,230000,230400', '向阳区', '30', '230402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230403', '230400', '0,86,230000,230400', '工农区', '30', '230403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230404', '230400', '0,86,230000,230400', '南山区', '30', '230404', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230405', '230400', '0,86,230000,230400', '兴安区', '30', '230405', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230406', '230400', '0,86,230000,230400', '东山区', '30', '230406', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230407', '230400', '0,86,230000,230400', '兴山区', '30', '230407', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230421', '230400', '0,86,230000,230400', '萝北县', '30', '230421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230422', '230400', '0,86,230000,230400', '绥滨县', '30', '230422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230500', '230000', '0,86,230000', '双鸭山市', '30', '230500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230502', '230500', '0,86,230000,230500', '尖山区', '30', '230502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230503', '230500', '0,86,230000,230500', '岭东区', '30', '230503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230505', '230500', '0,86,230000,230500', '四方台区', '30', '230505', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230506', '230500', '0,86,230000,230500', '宝山区', '30', '230506', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230521', '230500', '0,86,230000,230500', '集贤县', '30', '230521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230522', '230500', '0,86,230000,230500', '友谊县', '30', '230522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230523', '230500', '0,86,230000,230500', '宝清县', '30', '230523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230524', '230500', '0,86,230000,230500', '饶河县', '30', '230524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230600', '230000', '0,86,230000', '大庆市', '30', '230600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230602', '230600', '0,86,230000,230600', '萨尔图区', '30', '230602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230603', '230600', '0,86,230000,230600', '龙凤区', '30', '230603', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230604', '230600', '0,86,230000,230600', '让胡路区', '30', '230604', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230605', '230600', '0,86,230000,230600', '红岗区', '30', '230605', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230606', '230600', '0,86,230000,230600', '大同区', '30', '230606', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230621', '230600', '0,86,230000,230600', '肇州县', '30', '230621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230622', '230600', '0,86,230000,230600', '肇源县', '30', '230622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230623', '230600', '0,86,230000,230600', '林甸县', '30', '230623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230624', '230600', '0,86,230000,230600', '杜尔伯特蒙古族自治县', '30', '230624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230700', '230000', '0,86,230000', '伊春市', '30', '230700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230702', '230700', '0,86,230000,230700', '伊春区', '30', '230702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230703', '230700', '0,86,230000,230700', '南岔区', '30', '230703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230704', '230700', '0,86,230000,230700', '友好区', '30', '230704', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230705', '230700', '0,86,230000,230700', '西林区', '30', '230705', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230706', '230700', '0,86,230000,230700', '翠峦区', '30', '230706', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230707', '230700', '0,86,230000,230700', '新青区', '30', '230707', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230708', '230700', '0,86,230000,230700', '美溪区', '30', '230708', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230709', '230700', '0,86,230000,230700', '金山屯区', '30', '230709', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230710', '230700', '0,86,230000,230700', '五营区', '30', '230710', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230711', '230700', '0,86,230000,230700', '乌马河区', '30', '230711', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230712', '230700', '0,86,230000,230700', '汤旺河区', '30', '230712', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230713', '230700', '0,86,230000,230700', '带岭区', '30', '230713', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230714', '230700', '0,86,230000,230700', '乌伊岭区', '30', '230714', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230715', '230700', '0,86,230000,230700', '红星区', '30', '230715', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230716', '230700', '0,86,230000,230700', '上甘岭区', '30', '230716', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230722', '230700', '0,86,230000,230700', '嘉荫县', '30', '230722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230781', '230700', '0,86,230000,230700', '铁力市', '30', '230781', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230800', '230000', '0,86,230000', '佳木斯市', '30', '230800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230802', '230800', '0,86,230000,230800', '永红区', '30', '230802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230803', '230800', '0,86,230000,230800', '向阳区', '30', '230803', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230804', '230800', '0,86,230000,230800', '前进区', '30', '230804', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230805', '230800', '0,86,230000,230800', '东风区', '30', '230805', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230811', '230800', '0,86,230000,230800', '郊区', '30', '230811', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230822', '230800', '0,86,230000,230800', '桦南县', '30', '230822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230826', '230800', '0,86,230000,230800', '桦川县', '30', '230826', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230828', '230800', '0,86,230000,230800', '汤原县', '30', '230828', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230833', '230800', '0,86,230000,230800', '抚远县', '30', '230833', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230881', '230800', '0,86,230000,230800', '同江市', '30', '230881', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230882', '230800', '0,86,230000,230800', '富锦市', '30', '230882', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230900', '230000', '0,86,230000', '七台河市', '30', '230900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230902', '230900', '0,86,230000,230900', '新兴区', '30', '230902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230903', '230900', '0,86,230000,230900', '桃山区', '30', '230903', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230904', '230900', '0,86,230000,230900', '茄子河区', '30', '230904', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('230921', '230900', '0,86,230000,230900', '勃利县', '30', '230921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231000', '230000', '0,86,230000', '牡丹江市', '30', '231000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231002', '231000', '0,86,230000,231000', '东安区', '30', '231002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231003', '231000', '0,86,230000,231000', '阳明区', '30', '231003', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231004', '231000', '0,86,230000,231000', '爱民区', '30', '231004', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231005', '231000', '0,86,230000,231000', '西安区', '30', '231005', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231024', '231000', '0,86,230000,231000', '东宁县', '30', '231024', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231025', '231000', '0,86,230000,231000', '林口县', '30', '231025', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231081', '231000', '0,86,230000,231000', '绥芬河市', '30', '231081', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231083', '231000', '0,86,230000,231000', '海林市', '30', '231083', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231084', '231000', '0,86,230000,231000', '宁安市', '30', '231084', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231085', '231000', '0,86,230000,231000', '穆棱市', '30', '231085', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231100', '230000', '0,86,230000', '黑河市', '30', '231100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231102', '231100', '0,86,230000,231100', '爱辉区', '30', '231102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231121', '231100', '0,86,230000,231100', '嫩江县', '30', '231121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231123', '231100', '0,86,230000,231100', '逊克县', '30', '231123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231124', '231100', '0,86,230000,231100', '孙吴县', '30', '231124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231181', '231100', '0,86,230000,231100', '北安市', '30', '231181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231182', '231100', '0,86,230000,231100', '五大连池市', '30', '231182', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231200', '230000', '0,86,230000', '绥化市', '30', '231200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231202', '231200', '0,86,230000,231200', '北林区', '30', '231202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231221', '231200', '0,86,230000,231200', '望奎县', '30', '231221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231222', '231200', '0,86,230000,231200', '兰西县', '30', '231222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231223', '231200', '0,86,230000,231200', '青冈县', '30', '231223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231224', '231200', '0,86,230000,231200', '庆安县', '30', '231224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231225', '231200', '0,86,230000,231200', '明水县', '30', '231225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231226', '231200', '0,86,230000,231200', '绥棱县', '30', '231226', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231281', '231200', '0,86,230000,231200', '安达市', '30', '231281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231282', '231200', '0,86,230000,231200', '肇东市', '30', '231282', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('231283', '231200', '0,86,230000,231200', '海伦市', '30', '231283', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('232700', '230000', '0,86,230000', '大兴安岭地区', '30', '232700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('232701', '232700', '0,86,230000,232700', '加格达奇区', '30', '232701', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('232721', '232700', '0,86,230000,232700', '呼玛县', '30', '232721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('232722', '232700', '0,86,230000,232700', '塔河县', '30', '232722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('232723', '232700', '0,86,230000,232700', '漠河县', '30', '232723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('232724', '232700', '0,86,230000,232700', '松岭区', '30', '232724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('232725', '232700', '0,86,230000,232700', '新林区', '30', '232725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('232726', '232700', '0,86,230000,232700', '呼中区', '30', '232726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310000', '86', '0,86', '上海', '30', '310000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310100', '310000', '0,86,310000', '上海市', '30', '310100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310101', '310100', '0,86,310000,310100', '黄浦区', '30', '310101', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310102', '310100', '0,86,310000,310100', '卢湾区', '30', '310102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310104', '310100', '0,86,310000,310100', '徐汇区', '30', '310104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310105', '310100', '0,86,310000,310100', '长宁区', '30', '310105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310106', '310100', '0,86,310000,310100', '静安区', '30', '310106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310107', '310100', '0,86,310000,310100', '普陀区', '30', '310107', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310108', '310100', '0,86,310000,310100', '闸北区', '30', '310108', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310109', '310100', '0,86,310000,310100', '虹口区', '30', '310109', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310110', '310100', '0,86,310000,310100', '杨浦区', '30', '310110', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310112', '310100', '0,86,310000,310100', '闵行区', '30', '310112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310113', '310100', '0,86,310000,310100', '宝山区', '30', '310113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310114', '310100', '0,86,310000,310100', '嘉定区', '30', '310114', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310115', '310100', '0,86,310000,310100', '浦东新区', '30', '310115', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310116', '310100', '0,86,310000,310100', '金山区', '30', '310116', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310117', '310100', '0,86,310000,310100', '松江区', '30', '310117', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310118', '310100', '0,86,310000,310100', '青浦区', '30', '310118', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310120', '310100', '0,86,310000,310100', '奉贤区', '30', '310120', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310121', '310100', '0,86,310000,310100', '川沙区', '30', '310121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('310230', '310100', '0,86,310000,310100', '崇明县', '30', '310230', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320000', '86', '0,86', '江苏省', '30', '320000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320100', '320000', '0,86,320000', '南京市', '30', '320100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320102', '320100', '0,86,320000,320100', '玄武区', '30', '320102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320103', '320100', '0,86,320000,320100', '白下区', '30', '320103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320104', '320100', '0,86,320000,320100', '秦淮区', '30', '320104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320105', '320100', '0,86,320000,320100', '建邺区', '30', '320105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320106', '320100', '0,86,320000,320100', '鼓楼区', '30', '320106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320107', '320100', '0,86,320000,320100', '下关区', '30', '320107', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320111', '320100', '0,86,320000,320100', '浦口区', '30', '320111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320113', '320100', '0,86,320000,320100', '栖霞区', '30', '320113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320114', '320100', '0,86,320000,320100', '雨花台区', '30', '320114', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320115', '320100', '0,86,320000,320100', '江宁区', '30', '320115', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320116', '320100', '0,86,320000,320100', '六合区', '30', '320116', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320117', '320100', '0,86,320000,320100', '溧水区', '30', '320117', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320118', '320100', '0,86,320000,320100', '高淳区', '30', '320118', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320200', '320000', '0,86,320000', '无锡市', '30', '320200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320202', '320200', '0,86,320000,320200', '崇安区', '30', '320202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320203', '320200', '0,86,320000,320200', '南长区', '30', '320203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320204', '320200', '0,86,320000,320200', '北塘区', '30', '320204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320205', '320200', '0,86,320000,320200', '锡山区', '30', '320205', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320206', '320200', '0,86,320000,320200', '惠山区', '30', '320206', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320211', '320200', '0,86,320000,320200', '滨湖区', '30', '320211', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320281', '320200', '0,86,320000,320200', '江阴市', '30', '320281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320282', '320200', '0,86,320000,320200', '宜兴市', '30', '320282', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320283', '320200', '0,86,320000,320200', '新区', '30', '320283', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320300', '320000', '0,86,320000', '徐州市', '30', '320300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320302', '320300', '0,86,320000,320300', '鼓楼区', '30', '320302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320303', '320300', '0,86,320000,320300', '云龙区', '30', '320303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320304', '320300', '0,86,320000,320300', '九里区', '30', '320304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320305', '320300', '0,86,320000,320300', '贾汪区', '30', '320305', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320311', '320300', '0,86,320000,320300', '泉山区', '30', '320311', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320312', '320300', '0,86,320000,320300', '铜山区', '30', '320312', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320321', '320300', '0,86,320000,320300', '丰县', '30', '320321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320322', '320300', '0,86,320000,320300', '沛县', '30', '320322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320324', '320300', '0,86,320000,320300', '睢宁县', '30', '320324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320381', '320300', '0,86,320000,320300', '新沂市', '30', '320381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320382', '320300', '0,86,320000,320300', '邳州市', '30', '320382', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320400', '320000', '0,86,320000', '常州市', '30', '320400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320402', '320400', '0,86,320000,320400', '天宁区', '30', '320402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320404', '320400', '0,86,320000,320400', '钟楼区', '30', '320404', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320405', '320400', '0,86,320000,320400', '戚墅堰区', '30', '320405', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320411', '320400', '0,86,320000,320400', '新北区', '30', '320411', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320412', '320400', '0,86,320000,320400', '武进区', '30', '320412', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320481', '320400', '0,86,320000,320400', '溧阳市', '30', '320481', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320482', '320400', '0,86,320000,320400', '金坛市', '30', '320482', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320500', '320000', '0,86,320000', '苏州市', '30', '320500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320501', '320500', '0,86,320000,320500', '沧浪区', '30', '320501', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320502', '320500', '0,86,320000,320500', '平江区', '30', '320502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320503', '320500', '0,86,320000,320500', '金阊区', '30', '320503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320505', '320500', '0,86,320000,320500', '虎丘区', '30', '320505', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320506', '320500', '0,86,320000,320500', '吴中区', '30', '320506', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320507', '320500', '0,86,320000,320500', '相城区', '30', '320507', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320508', '320500', '0,86,320000,320500', '姑苏区', '30', '320508', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320509', '320500', '0,86,320000,320500', '吴江区', '30', '320509', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320581', '320500', '0,86,320000,320500', '常熟市', '30', '320581', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320582', '320500', '0,86,320000,320500', '张家港市', '30', '320582', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320583', '320500', '0,86,320000,320500', '昆山市', '30', '320583', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320585', '320500', '0,86,320000,320500', '太仓市', '30', '320585', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320586', '320500', '0,86,320000,320500', '新区', '30', '320586', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320587', '320500', '0,86,320000,320500', '园区', '30', '320587', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320600', '320000', '0,86,320000', '南通市', '30', '320600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320602', '320600', '0,86,320000,320600', '崇川区', '30', '320602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320611', '320600', '0,86,320000,320600', '港闸区', '30', '320611', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320612', '320600', '0,86,320000,320600', '通州区', '30', '320612', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320621', '320600', '0,86,320000,320600', '海安县', '30', '320621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320623', '320600', '0,86,320000,320600', '如东县', '30', '320623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320681', '320600', '0,86,320000,320600', '启东市', '30', '320681', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320682', '320600', '0,86,320000,320600', '如皋市', '30', '320682', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320683', '320600', '0,86,320000,320600', '通州市', '30', '320683', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320684', '320600', '0,86,320000,320600', '海门市', '30', '320684', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320685', '320600', '0,86,320000,320600', '开发区', '30', '320685', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320700', '320000', '0,86,320000', '连云港市', '30', '320700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320703', '320700', '0,86,320000,320700', '连云区', '30', '320703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320704', '320700', '0,86,320000,320700', '新浦区', '30', '320704', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320706', '320700', '0,86,320000,320700', '海州区', '30', '320706', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320707', '320700', '0,86,320000,320700', '赣榆区', '30', '320707', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320722', '320700', '0,86,320000,320700', '东海县', '30', '320722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320723', '320700', '0,86,320000,320700', '灌云县', '30', '320723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320724', '320700', '0,86,320000,320700', '灌南县', '30', '320724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320800', '320000', '0,86,320000', '淮安市', '30', '320800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320802', '320800', '0,86,320000,320800', '清河区', '30', '320802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320803', '320800', '0,86,320000,320800', '淮安区', '30', '320803', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320804', '320800', '0,86,320000,320800', '淮阴区', '30', '320804', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320811', '320800', '0,86,320000,320800', '清浦区', '30', '320811', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320826', '320800', '0,86,320000,320800', '涟水县', '30', '320826', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320829', '320800', '0,86,320000,320800', '洪泽县', '30', '320829', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320830', '320800', '0,86,320000,320800', '盱眙县', '30', '320830', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320831', '320800', '0,86,320000,320800', '金湖县', '30', '320831', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320900', '320000', '0,86,320000', '盐城市', '30', '320900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320902', '320900', '0,86,320000,320900', '亭湖区', '30', '320902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320903', '320900', '0,86,320000,320900', '盐都区', '30', '320903', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320921', '320900', '0,86,320000,320900', '响水县', '30', '320921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320922', '320900', '0,86,320000,320900', '滨海县', '30', '320922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320923', '320900', '0,86,320000,320900', '阜宁县', '30', '320923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320924', '320900', '0,86,320000,320900', '射阳县', '30', '320924', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320925', '320900', '0,86,320000,320900', '建湖县', '30', '320925', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320981', '320900', '0,86,320000,320900', '东台市', '30', '320981', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('320982', '320900', '0,86,320000,320900', '大丰市', '30', '320982', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321000', '320000', '0,86,320000', '扬州市', '30', '321000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321002', '321000', '0,86,320000,321000', '广陵区', '30', '321002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321003', '321000', '0,86,320000,321000', '邗江区', '30', '321003', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321012', '321000', '0,86,320000,321000', '江都区', '30', '321012', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321014', '321000', '0,86,320000,321000', '维扬区', '30', '321014', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321023', '321000', '0,86,320000,321000', '宝应县', '30', '321023', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321081', '321000', '0,86,320000,321000', '仪征市', '30', '321081', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321084', '321000', '0,86,320000,321000', '高邮市', '30', '321084', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321085', '321000', '0,86,320000,321000', '经济开发区', '30', '321085', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321100', '320000', '0,86,320000', '镇江市', '30', '321100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321102', '321100', '0,86,320000,321100', '京口区', '30', '321102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321111', '321100', '0,86,320000,321100', '润州区', '30', '321111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321112', '321100', '0,86,320000,321100', '丹徒区', '30', '321112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321181', '321100', '0,86,320000,321100', '丹阳市', '30', '321181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321182', '321100', '0,86,320000,321100', '扬中市', '30', '321182', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321183', '321100', '0,86,320000,321100', '句容市', '30', '321183', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321200', '320000', '0,86,320000', '泰州市', '30', '321200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321202', '321200', '0,86,320000,321200', '海陵区', '30', '321202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321203', '321200', '0,86,320000,321200', '高港区', '30', '321203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321204', '321200', '0,86,320000,321200', '姜堰区', '30', '321204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321281', '321200', '0,86,320000,321200', '兴化市', '30', '321281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321282', '321200', '0,86,320000,321200', '靖江市', '30', '321282', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321283', '321200', '0,86,320000,321200', '泰兴市', '30', '321283', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321300', '320000', '0,86,320000', '宿迁市', '30', '321300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321302', '321300', '0,86,320000,321300', '宿城区', '30', '321302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321311', '321300', '0,86,320000,321300', '宿豫区', '30', '321311', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321322', '321300', '0,86,320000,321300', '沭阳县', '30', '321322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321323', '321300', '0,86,320000,321300', '泗阳县', '30', '321323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('321324', '321300', '0,86,320000,321300', '泗洪县', '30', '321324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330000', '86', '0,86', '浙江省', '30', '330000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330100', '330000', '0,86,330000', '杭州市', '30', '330100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330102', '330100', '0,86,330000,330100', '上城区', '30', '330102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330103', '330100', '0,86,330000,330100', '下城区', '30', '330103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330104', '330100', '0,86,330000,330100', '江干区', '30', '330104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330105', '330100', '0,86,330000,330100', '拱墅区', '30', '330105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330106', '330100', '0,86,330000,330100', '西湖区', '30', '330106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330108', '330100', '0,86,330000,330100', '滨江区', '30', '330108', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330109', '330100', '0,86,330000,330100', '萧山区', '30', '330109', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330110', '330100', '0,86,330000,330100', '余杭区', '30', '330110', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330111', '330100', '0,86,330000,330100', '富阳区', '30', '330111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330122', '330100', '0,86,330000,330100', '桐庐县', '30', '330122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330127', '330100', '0,86,330000,330100', '淳安县', '30', '330127', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330182', '330100', '0,86,330000,330100', '建德市', '30', '330182', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330183', '330100', '0,86,330000,330100', '富阳区', '30', '330183', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330185', '330100', '0,86,330000,330100', '临安市', '30', '330185', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330200', '330000', '0,86,330000', '宁波市', '30', '330200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330203', '330200', '0,86,330000,330200', '海曙区', '30', '330203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330204', '330200', '0,86,330000,330200', '江东区', '30', '330204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330205', '330200', '0,86,330000,330200', '江北区', '30', '330205', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330206', '330200', '0,86,330000,330200', '北仑区', '30', '330206', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330211', '330200', '0,86,330000,330200', '镇海区', '30', '330211', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330212', '330200', '0,86,330000,330200', '鄞州区', '30', '330212', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330225', '330200', '0,86,330000,330200', '象山县', '30', '330225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330226', '330200', '0,86,330000,330200', '宁海县', '30', '330226', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330281', '330200', '0,86,330000,330200', '余姚市', '30', '330281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330282', '330200', '0,86,330000,330200', '慈溪市', '30', '330282', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330283', '330200', '0,86,330000,330200', '奉化市', '30', '330283', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330300', '330000', '0,86,330000', '温州市', '30', '330300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330302', '330300', '0,86,330000,330300', '鹿城区', '30', '330302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330303', '330300', '0,86,330000,330300', '龙湾区', '30', '330303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330304', '330300', '0,86,330000,330300', '瓯海区', '30', '330304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330322', '330300', '0,86,330000,330300', '洞头县', '30', '330322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330324', '330300', '0,86,330000,330300', '永嘉县', '30', '330324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330326', '330300', '0,86,330000,330300', '平阳县', '30', '330326', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330327', '330300', '0,86,330000,330300', '苍南县', '30', '330327', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330328', '330300', '0,86,330000,330300', '文成县', '30', '330328', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330329', '330300', '0,86,330000,330300', '泰顺县', '30', '330329', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330381', '330300', '0,86,330000,330300', '瑞安市', '30', '330381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330382', '330300', '0,86,330000,330300', '乐清市', '30', '330382', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330400', '330000', '0,86,330000', '嘉兴市', '30', '330400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330402', '330400', '0,86,330000,330400', '南湖区', '30', '330402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330411', '330400', '0,86,330000,330400', '秀洲区', '30', '330411', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330421', '330400', '0,86,330000,330400', '嘉善县', '30', '330421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330424', '330400', '0,86,330000,330400', '海盐县', '30', '330424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330481', '330400', '0,86,330000,330400', '海宁市', '30', '330481', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330482', '330400', '0,86,330000,330400', '平湖市', '30', '330482', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330483', '330400', '0,86,330000,330400', '桐乡市', '30', '330483', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330500', '330000', '0,86,330000', '湖州市', '30', '330500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330502', '330500', '0,86,330000,330500', '吴兴区', '30', '330502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330503', '330500', '0,86,330000,330500', '南浔区', '30', '330503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330521', '330500', '0,86,330000,330500', '德清县', '30', '330521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330522', '330500', '0,86,330000,330500', '长兴县', '30', '330522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330523', '330500', '0,86,330000,330500', '安吉县', '30', '330523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330600', '330000', '0,86,330000', '绍兴市', '30', '330600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330602', '330600', '0,86,330000,330600', '越城区', '30', '330602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330603', '330600', '0,86,330000,330600', '柯桥区', '30', '330603', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330604', '330600', '0,86,330000,330600', '上虞区', '30', '330604', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330624', '330600', '0,86,330000,330600', '新昌县', '30', '330624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330681', '330600', '0,86,330000,330600', '诸暨市', '30', '330681', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330683', '330600', '0,86,330000,330600', '嵊州市', '30', '330683', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330700', '330000', '0,86,330000', '金华市', '30', '330700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330702', '330700', '0,86,330000,330700', '婺城区', '30', '330702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330703', '330700', '0,86,330000,330700', '金东区', '30', '330703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330723', '330700', '0,86,330000,330700', '武义县', '30', '330723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330726', '330700', '0,86,330000,330700', '浦江县', '30', '330726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330727', '330700', '0,86,330000,330700', '磐安县', '30', '330727', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330781', '330700', '0,86,330000,330700', '兰溪市', '30', '330781', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330782', '330700', '0,86,330000,330700', '义乌市', '30', '330782', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330783', '330700', '0,86,330000,330700', '东阳市', '30', '330783', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330784', '330700', '0,86,330000,330700', '永康市', '30', '330784', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330800', '330000', '0,86,330000', '衢州市', '30', '330800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330802', '330800', '0,86,330000,330800', '柯城区', '30', '330802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330803', '330800', '0,86,330000,330800', '衢江区', '30', '330803', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330822', '330800', '0,86,330000,330800', '常山县', '30', '330822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330824', '330800', '0,86,330000,330800', '开化县', '30', '330824', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330825', '330800', '0,86,330000,330800', '龙游县', '30', '330825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330881', '330800', '0,86,330000,330800', '江山市', '30', '330881', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330900', '330000', '0,86,330000', '舟山市', '30', '330900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330902', '330900', '0,86,330000,330900', '定海区', '30', '330902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330903', '330900', '0,86,330000,330900', '普陀区', '30', '330903', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330921', '330900', '0,86,330000,330900', '岱山县', '30', '330921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('330922', '330900', '0,86,330000,330900', '嵊泗县', '30', '330922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331000', '330000', '0,86,330000', '台州市', '30', '331000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331002', '331000', '0,86,330000,331000', '椒江区', '30', '331002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331003', '331000', '0,86,330000,331000', '黄岩区', '30', '331003', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331004', '331000', '0,86,330000,331000', '路桥区', '30', '331004', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331021', '331000', '0,86,330000,331000', '玉环县', '30', '331021', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331022', '331000', '0,86,330000,331000', '三门县', '30', '331022', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331023', '331000', '0,86,330000,331000', '天台县', '30', '331023', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331024', '331000', '0,86,330000,331000', '仙居县', '30', '331024', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331081', '331000', '0,86,330000,331000', '温岭市', '30', '331081', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331082', '331000', '0,86,330000,331000', '临海市', '30', '331082', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331100', '330000', '0,86,330000', '丽水市', '30', '331100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331102', '331100', '0,86,330000,331100', '莲都区', '30', '331102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331121', '331100', '0,86,330000,331100', '青田县', '30', '331121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331122', '331100', '0,86,330000,331100', '缙云县', '30', '331122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331123', '331100', '0,86,330000,331100', '遂昌县', '30', '331123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331124', '331100', '0,86,330000,331100', '松阳县', '30', '331124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331125', '331100', '0,86,330000,331100', '云和县', '30', '331125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331126', '331100', '0,86,330000,331100', '庆元县', '30', '331126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331127', '331100', '0,86,330000,331100', '景宁畲族自治县', '30', '331127', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('331181', '331100', '0,86,330000,331100', '龙泉市', '30', '331181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340000', '86', '0,86', '安徽省', '30', '340000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340100', '340000', '0,86,340000', '合肥市', '30', '340100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340102', '340100', '0,86,340000,340100', '瑶海区', '30', '340102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340103', '340100', '0,86,340000,340100', '庐阳区', '30', '340103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340104', '340100', '0,86,340000,340100', '蜀山区', '30', '340104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340111', '340100', '0,86,340000,340100', '包河区', '30', '340111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340121', '340100', '0,86,340000,340100', '长丰县', '30', '340121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340122', '340100', '0,86,340000,340100', '肥东县', '30', '340122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340123', '340100', '0,86,340000,340100', '肥西县', '30', '340123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340124', '340100', '0,86,340000,340100', '庐江县', '30', '340124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340125', '340100', '0,86,340000,340100', '高新区', '30', '340125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340126', '340100', '0,86,340000,340100', '中区', '30', '340126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340181', '340100', '0,86,340000,340100', '巢湖市', '30', '340181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340182', '340100', '0,86,340000,340100', '居巢区', '30', '340182', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340183', '340100', '0,86,340000,340100', '庐江区', '30', '340183', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340200', '340000', '0,86,340000', '芜湖市', '30', '340200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340202', '340200', '0,86,340000,340200', '镜湖区', '30', '340202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340203', '340200', '0,86,340000,340200', '弋江区', '30', '340203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340207', '340200', '0,86,340000,340200', '鸠江区', '30', '340207', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340208', '340200', '0,86,340000,340200', '三山区', '30', '340208', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340221', '340200', '0,86,340000,340200', '芜湖县', '30', '340221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340222', '340200', '0,86,340000,340200', '繁昌县', '30', '340222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340223', '340200', '0,86,340000,340200', '南陵县', '30', '340223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340225', '340200', '0,86,340000,340200', '无为县', '30', '340225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340300', '340000', '0,86,340000', '蚌埠市', '30', '340300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340302', '340300', '0,86,340000,340300', '龙子湖区', '30', '340302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340303', '340300', '0,86,340000,340300', '蚌山区', '30', '340303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340304', '340300', '0,86,340000,340300', '禹会区', '30', '340304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340311', '340300', '0,86,340000,340300', '淮上区', '30', '340311', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340321', '340300', '0,86,340000,340300', '怀远县', '30', '340321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340322', '340300', '0,86,340000,340300', '五河县', '30', '340322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340323', '340300', '0,86,340000,340300', '固镇县', '30', '340323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340400', '340000', '0,86,340000', '淮南市', '30', '340400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340402', '340400', '0,86,340000,340400', '大通区', '30', '340402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340403', '340400', '0,86,340000,340400', '田家庵区', '30', '340403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340404', '340400', '0,86,340000,340400', '谢家集区', '30', '340404', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340405', '340400', '0,86,340000,340400', '八公山区', '30', '340405', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340406', '340400', '0,86,340000,340400', '潘集区', '30', '340406', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340421', '340400', '0,86,340000,340400', '凤台县', '30', '340421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340500', '340000', '0,86,340000', '马鞍山市', '30', '340500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340501', '340500', '0,86,340000,340500', '金家庄区', '30', '340501', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340503', '340500', '0,86,340000,340500', '花山区', '30', '340503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340504', '340500', '0,86,340000,340500', '雨山区', '30', '340504', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340506', '340500', '0,86,340000,340500', '博望区', '30', '340506', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340521', '340500', '0,86,340000,340500', '当涂县', '30', '340521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340522', '340500', '0,86,340000,340500', '含山县', '30', '340522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340523', '340500', '0,86,340000,340500', '和县', '30', '340523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340600', '340000', '0,86,340000', '淮北市', '30', '340600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340602', '340600', '0,86,340000,340600', '杜集区', '30', '340602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340603', '340600', '0,86,340000,340600', '相山区', '30', '340603', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340604', '340600', '0,86,340000,340600', '烈山区', '30', '340604', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340621', '340600', '0,86,340000,340600', '濉溪县', '30', '340621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340700', '340000', '0,86,340000', '铜陵市', '30', '340700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340702', '340700', '0,86,340000,340700', '铜官山区', '30', '340702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340703', '340700', '0,86,340000,340700', '狮子山区', '30', '340703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340711', '340700', '0,86,340000,340700', '郊区', '30', '340711', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340721', '340700', '0,86,340000,340700', '铜陵县', '30', '340721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340722', '340700', '0,86,340000,340700', '枞阳县', '30', '340722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340800', '340000', '0,86,340000', '安庆市', '30', '340800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340802', '340800', '0,86,340000,340800', '迎江区', '30', '340802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340803', '340800', '0,86,340000,340800', '大观区', '30', '340803', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340811', '340800', '0,86,340000,340800', '宜秀区', '30', '340811', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340822', '340800', '0,86,340000,340800', '怀宁县', '30', '340822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340823', '340800', '0,86,340000,340800', '枞阳县', '30', '340823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340824', '340800', '0,86,340000,340800', '潜山县', '30', '340824', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340825', '340800', '0,86,340000,340800', '太湖县', '30', '340825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340826', '340800', '0,86,340000,340800', '宿松县', '30', '340826', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340827', '340800', '0,86,340000,340800', '望江县', '30', '340827', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340828', '340800', '0,86,340000,340800', '岳西县', '30', '340828', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('340881', '340800', '0,86,340000,340800', '桐城市', '30', '340881', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341000', '340000', '0,86,340000', '黄山市', '30', '341000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341002', '341000', '0,86,340000,341000', '屯溪区', '30', '341002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341003', '341000', '0,86,340000,341000', '黄山区', '30', '341003', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341004', '341000', '0,86,340000,341000', '徽州区', '30', '341004', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341021', '341000', '0,86,340000,341000', '歙县', '30', '341021', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341022', '341000', '0,86,340000,341000', '休宁县', '30', '341022', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341023', '341000', '0,86,340000,341000', '黟县', '30', '341023', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341024', '341000', '0,86,340000,341000', '祁门县', '30', '341024', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341100', '340000', '0,86,340000', '滁州市', '30', '341100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341102', '341100', '0,86,340000,341100', '琅琊区', '30', '341102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341103', '341100', '0,86,340000,341100', '南谯区', '30', '341103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341122', '341100', '0,86,340000,341100', '来安县', '30', '341122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341124', '341100', '0,86,340000,341100', '全椒县', '30', '341124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341125', '341100', '0,86,340000,341100', '定远县', '30', '341125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341126', '341100', '0,86,340000,341100', '凤阳县', '30', '341126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341181', '341100', '0,86,340000,341100', '天长市', '30', '341181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341182', '341100', '0,86,340000,341100', '明光市', '30', '341182', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341200', '340000', '0,86,340000', '阜阳市', '30', '341200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341202', '341200', '0,86,340000,341200', '颍州区', '30', '341202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341203', '341200', '0,86,340000,341200', '颍东区', '30', '341203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341204', '341200', '0,86,340000,341200', '颍泉区', '30', '341204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341221', '341200', '0,86,340000,341200', '临泉县', '30', '341221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341222', '341200', '0,86,340000,341200', '太和县', '30', '341222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341225', '341200', '0,86,340000,341200', '阜南县', '30', '341225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341226', '341200', '0,86,340000,341200', '颍上县', '30', '341226', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341282', '341200', '0,86,340000,341200', '界首市', '30', '341282', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341300', '340000', '0,86,340000', '宿州市', '30', '341300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341302', '341300', '0,86,340000,341300', '埇桥区', '30', '341302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341321', '341300', '0,86,340000,341300', '砀山县', '30', '341321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341322', '341300', '0,86,340000,341300', '萧县', '30', '341322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341323', '341300', '0,86,340000,341300', '灵璧县', '30', '341323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341324', '341300', '0,86,340000,341300', '泗县', '30', '341324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341500', '340000', '0,86,340000', '六安市', '30', '341500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341502', '341500', '0,86,340000,341500', '金安区', '30', '341502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341503', '341500', '0,86,340000,341500', '裕安区', '30', '341503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341521', '341500', '0,86,340000,341500', '寿县', '30', '341521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341522', '341500', '0,86,340000,341500', '霍邱县', '30', '341522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341523', '341500', '0,86,340000,341500', '舒城县', '30', '341523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341524', '341500', '0,86,340000,341500', '金寨县', '30', '341524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341525', '341500', '0,86,340000,341500', '霍山县', '30', '341525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341600', '340000', '0,86,340000', '亳州市', '30', '341600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341602', '341600', '0,86,340000,341600', '谯城区', '30', '341602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341621', '341600', '0,86,340000,341600', '涡阳县', '30', '341621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341622', '341600', '0,86,340000,341600', '蒙城县', '30', '341622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341623', '341600', '0,86,340000,341600', '利辛县', '30', '341623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341700', '340000', '0,86,340000', '池州市', '30', '341700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341702', '341700', '0,86,340000,341700', '贵池区', '30', '341702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341721', '341700', '0,86,340000,341700', '东至县', '30', '341721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341722', '341700', '0,86,340000,341700', '石台县', '30', '341722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341723', '341700', '0,86,340000,341700', '青阳县', '30', '341723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341800', '340000', '0,86,340000', '宣城市', '30', '341800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341802', '341800', '0,86,340000,341800', '宣州区', '30', '341802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341821', '341800', '0,86,340000,341800', '郎溪县', '30', '341821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341822', '341800', '0,86,340000,341800', '广德县', '30', '341822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341823', '341800', '0,86,340000,341800', '泾县', '30', '341823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341824', '341800', '0,86,340000,341800', '绩溪县', '30', '341824', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341825', '341800', '0,86,340000,341800', '旌德县', '30', '341825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('341881', '341800', '0,86,340000,341800', '宁国市', '30', '341881', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350000', '86', '0,86', '福建省', '30', '350000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350100', '350000', '0,86,350000', '福州市', '30', '350100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350102', '350100', '0,86,350000,350100', '鼓楼区', '30', '350102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350103', '350100', '0,86,350000,350100', '台江区', '30', '350103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350104', '350100', '0,86,350000,350100', '仓山区', '30', '350104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350105', '350100', '0,86,350000,350100', '马尾区', '30', '350105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350111', '350100', '0,86,350000,350100', '晋安区', '30', '350111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350121', '350100', '0,86,350000,350100', '闽侯县', '30', '350121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350122', '350100', '0,86,350000,350100', '连江县', '30', '350122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350123', '350100', '0,86,350000,350100', '罗源县', '30', '350123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350124', '350100', '0,86,350000,350100', '闽清县', '30', '350124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350125', '350100', '0,86,350000,350100', '永泰县', '30', '350125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350128', '350100', '0,86,350000,350100', '平潭县', '30', '350128', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350181', '350100', '0,86,350000,350100', '福清市', '30', '350181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350182', '350100', '0,86,350000,350100', '长乐市', '30', '350182', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350200', '350000', '0,86,350000', '厦门市', '30', '350200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350203', '350200', '0,86,350000,350200', '思明区', '30', '350203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350205', '350200', '0,86,350000,350200', '海沧区', '30', '350205', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350206', '350200', '0,86,350000,350200', '湖里区', '30', '350206', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350211', '350200', '0,86,350000,350200', '集美区', '30', '350211', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350212', '350200', '0,86,350000,350200', '同安区', '30', '350212', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350213', '350200', '0,86,350000,350200', '翔安区', '30', '350213', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350300', '350000', '0,86,350000', '莆田市', '30', '350300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350302', '350300', '0,86,350000,350300', '城厢区', '30', '350302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350303', '350300', '0,86,350000,350300', '涵江区', '30', '350303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350304', '350300', '0,86,350000,350300', '荔城区', '30', '350304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350305', '350300', '0,86,350000,350300', '秀屿区', '30', '350305', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350322', '350300', '0,86,350000,350300', '仙游县', '30', '350322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350400', '350000', '0,86,350000', '三明市', '30', '350400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350402', '350400', '0,86,350000,350400', '梅列区', '30', '350402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350403', '350400', '0,86,350000,350400', '三元区', '30', '350403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350421', '350400', '0,86,350000,350400', '明溪县', '30', '350421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350423', '350400', '0,86,350000,350400', '清流县', '30', '350423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350424', '350400', '0,86,350000,350400', '宁化县', '30', '350424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350425', '350400', '0,86,350000,350400', '大田县', '30', '350425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350426', '350400', '0,86,350000,350400', '尤溪县', '30', '350426', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350427', '350400', '0,86,350000,350400', '沙县', '30', '350427', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350428', '350400', '0,86,350000,350400', '将乐县', '30', '350428', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350429', '350400', '0,86,350000,350400', '泰宁县', '30', '350429', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350430', '350400', '0,86,350000,350400', '建宁县', '30', '350430', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350481', '350400', '0,86,350000,350400', '永安市', '30', '350481', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350500', '350000', '0,86,350000', '泉州市', '30', '350500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350502', '350500', '0,86,350000,350500', '鲤城区', '30', '350502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350503', '350500', '0,86,350000,350500', '丰泽区', '30', '350503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350504', '350500', '0,86,350000,350500', '洛江区', '30', '350504', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350505', '350500', '0,86,350000,350500', '泉港区', '30', '350505', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350521', '350500', '0,86,350000,350500', '惠安县', '30', '350521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350524', '350500', '0,86,350000,350500', '安溪县', '30', '350524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350525', '350500', '0,86,350000,350500', '永春县', '30', '350525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350526', '350500', '0,86,350000,350500', '德化县', '30', '350526', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350527', '350500', '0,86,350000,350500', '金门县', '30', '350527', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350581', '350500', '0,86,350000,350500', '石狮市', '30', '350581', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350582', '350500', '0,86,350000,350500', '晋江市', '30', '350582', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350583', '350500', '0,86,350000,350500', '南安市', '30', '350583', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350600', '350000', '0,86,350000', '漳州市', '30', '350600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350602', '350600', '0,86,350000,350600', '芗城区', '30', '350602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350603', '350600', '0,86,350000,350600', '龙文区', '30', '350603', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350622', '350600', '0,86,350000,350600', '云霄县', '30', '350622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350623', '350600', '0,86,350000,350600', '漳浦县', '30', '350623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350624', '350600', '0,86,350000,350600', '诏安县', '30', '350624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350625', '350600', '0,86,350000,350600', '长泰县', '30', '350625', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350626', '350600', '0,86,350000,350600', '东山县', '30', '350626', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350627', '350600', '0,86,350000,350600', '南靖县', '30', '350627', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350628', '350600', '0,86,350000,350600', '平和县', '30', '350628', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350629', '350600', '0,86,350000,350600', '华安县', '30', '350629', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350681', '350600', '0,86,350000,350600', '龙海市', '30', '350681', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350700', '350000', '0,86,350000', '南平市', '30', '350700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350702', '350700', '0,86,350000,350700', '延平区', '30', '350702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350703', '350700', '0,86,350000,350700', '建阳区', '30', '350703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350721', '350700', '0,86,350000,350700', '顺昌县', '30', '350721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350722', '350700', '0,86,350000,350700', '浦城县', '30', '350722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350723', '350700', '0,86,350000,350700', '光泽县', '30', '350723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350724', '350700', '0,86,350000,350700', '松溪县', '30', '350724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350725', '350700', '0,86,350000,350700', '政和县', '30', '350725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350781', '350700', '0,86,350000,350700', '邵武市', '30', '350781', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350782', '350700', '0,86,350000,350700', '武夷山市', '30', '350782', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350783', '350700', '0,86,350000,350700', '建瓯市', '30', '350783', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350800', '350000', '0,86,350000', '龙岩市', '30', '350800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350802', '350800', '0,86,350000,350800', '新罗区', '30', '350802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350803', '350800', '0,86,350000,350800', '永定区', '30', '350803', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350821', '350800', '0,86,350000,350800', '长汀县', '30', '350821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350823', '350800', '0,86,350000,350800', '上杭县', '30', '350823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350824', '350800', '0,86,350000,350800', '武平县', '30', '350824', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350825', '350800', '0,86,350000,350800', '连城县', '30', '350825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350881', '350800', '0,86,350000,350800', '漳平市', '30', '350881', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350900', '350000', '0,86,350000', '宁德市', '30', '350900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350902', '350900', '0,86,350000,350900', '蕉城区', '30', '350902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350921', '350900', '0,86,350000,350900', '霞浦县', '30', '350921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350922', '350900', '0,86,350000,350900', '古田县', '30', '350922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350923', '350900', '0,86,350000,350900', '屏南县', '30', '350923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350924', '350900', '0,86,350000,350900', '寿宁县', '30', '350924', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350925', '350900', '0,86,350000,350900', '周宁县', '30', '350925', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350926', '350900', '0,86,350000,350900', '柘荣县', '30', '350926', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350981', '350900', '0,86,350000,350900', '福安市', '30', '350981', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('350982', '350900', '0,86,350000,350900', '福鼎市', '30', '350982', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360000', '86', '0,86', '江西省', '30', '360000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360100', '360000', '0,86,360000', '南昌市', '30', '360100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360102', '360100', '0,86,360000,360100', '东湖区', '30', '360102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360103', '360100', '0,86,360000,360100', '西湖区', '30', '360103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360104', '360100', '0,86,360000,360100', '青云谱区', '30', '360104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360105', '360100', '0,86,360000,360100', '湾里区', '30', '360105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360111', '360100', '0,86,360000,360100', '青山湖区', '30', '360111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360121', '360100', '0,86,360000,360100', '南昌县', '30', '360121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360122', '360100', '0,86,360000,360100', '新建县', '30', '360122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360123', '360100', '0,86,360000,360100', '安义县', '30', '360123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360124', '360100', '0,86,360000,360100', '进贤县', '30', '360124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360125', '360100', '0,86,360000,360100', '红谷滩新区', '30', '360125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360126', '360100', '0,86,360000,360100', '经济技术开发区', '30', '360126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360127', '360100', '0,86,360000,360100', '昌北区', '30', '360127', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360200', '360000', '0,86,360000', '景德镇市', '30', '360200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360202', '360200', '0,86,360000,360200', '昌江区', '30', '360202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360203', '360200', '0,86,360000,360200', '珠山区', '30', '360203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360222', '360200', '0,86,360000,360200', '浮梁县', '30', '360222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360281', '360200', '0,86,360000,360200', '乐平市', '30', '360281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360300', '360000', '0,86,360000', '萍乡市', '30', '360300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360302', '360300', '0,86,360000,360300', '安源区', '30', '360302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360313', '360300', '0,86,360000,360300', '湘东区', '30', '360313', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360321', '360300', '0,86,360000,360300', '莲花县', '30', '360321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360322', '360300', '0,86,360000,360300', '上栗县', '30', '360322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360323', '360300', '0,86,360000,360300', '芦溪县', '30', '360323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360400', '360000', '0,86,360000', '九江市', '30', '360400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360402', '360400', '0,86,360000,360400', '庐山区', '30', '360402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360403', '360400', '0,86,360000,360400', '浔阳区', '30', '360403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360421', '360400', '0,86,360000,360400', '九江县', '30', '360421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360423', '360400', '0,86,360000,360400', '武宁县', '30', '360423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360424', '360400', '0,86,360000,360400', '修水县', '30', '360424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360425', '360400', '0,86,360000,360400', '永修县', '30', '360425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360426', '360400', '0,86,360000,360400', '德安县', '30', '360426', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360427', '360400', '0,86,360000,360400', '星子县', '30', '360427', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360428', '360400', '0,86,360000,360400', '都昌县', '30', '360428', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360429', '360400', '0,86,360000,360400', '湖口县', '30', '360429', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360430', '360400', '0,86,360000,360400', '彭泽县', '30', '360430', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360481', '360400', '0,86,360000,360400', '瑞昌市', '30', '360481', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360482', '360400', '0,86,360000,360400', '共青城市', '30', '360482', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360500', '360000', '0,86,360000', '新余市', '30', '360500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360502', '360500', '0,86,360000,360500', '渝水区', '30', '360502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360521', '360500', '0,86,360000,360500', '分宜县', '30', '360521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360600', '360000', '0,86,360000', '鹰潭市', '30', '360600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360602', '360600', '0,86,360000,360600', '月湖区', '30', '360602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360622', '360600', '0,86,360000,360600', '余江县', '30', '360622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360681', '360600', '0,86,360000,360600', '贵溪市', '30', '360681', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360700', '360000', '0,86,360000', '赣州市', '30', '360700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360702', '360700', '0,86,360000,360700', '章贡区', '30', '360702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360703', '360700', '0,86,360000,360700', '南康区', '30', '360703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360721', '360700', '0,86,360000,360700', '赣县', '30', '360721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360722', '360700', '0,86,360000,360700', '信丰县', '30', '360722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360723', '360700', '0,86,360000,360700', '大余县', '30', '360723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360724', '360700', '0,86,360000,360700', '上犹县', '30', '360724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360725', '360700', '0,86,360000,360700', '崇义县', '30', '360725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360726', '360700', '0,86,360000,360700', '安远县', '30', '360726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360727', '360700', '0,86,360000,360700', '龙南县', '30', '360727', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360728', '360700', '0,86,360000,360700', '定南县', '30', '360728', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360729', '360700', '0,86,360000,360700', '全南县', '30', '360729', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360730', '360700', '0,86,360000,360700', '宁都县', '30', '360730', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360731', '360700', '0,86,360000,360700', '于都县', '30', '360731', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360732', '360700', '0,86,360000,360700', '兴国县', '30', '360732', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360733', '360700', '0,86,360000,360700', '会昌县', '30', '360733', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360734', '360700', '0,86,360000,360700', '寻乌县', '30', '360734', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360735', '360700', '0,86,360000,360700', '石城县', '30', '360735', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360736', '360700', '0,86,360000,360700', '黄金区', '30', '360736', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360781', '360700', '0,86,360000,360700', '瑞金市', '30', '360781', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360800', '360000', '0,86,360000', '吉安市', '30', '360800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360802', '360800', '0,86,360000,360800', '吉州区', '30', '360802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360803', '360800', '0,86,360000,360800', '青原区', '30', '360803', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360821', '360800', '0,86,360000,360800', '吉安县', '30', '360821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360822', '360800', '0,86,360000,360800', '吉水县', '30', '360822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360823', '360800', '0,86,360000,360800', '峡江县', '30', '360823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360824', '360800', '0,86,360000,360800', '新干县', '30', '360824', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360825', '360800', '0,86,360000,360800', '永丰县', '30', '360825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360826', '360800', '0,86,360000,360800', '泰和县', '30', '360826', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360827', '360800', '0,86,360000,360800', '遂川县', '30', '360827', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360828', '360800', '0,86,360000,360800', '万安县', '30', '360828', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360829', '360800', '0,86,360000,360800', '安福县', '30', '360829', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360830', '360800', '0,86,360000,360800', '永新县', '30', '360830', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360881', '360800', '0,86,360000,360800', '井冈山市', '30', '360881', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360900', '360000', '0,86,360000', '宜春市', '30', '360900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360902', '360900', '0,86,360000,360900', '袁州区', '30', '360902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360921', '360900', '0,86,360000,360900', '奉新县', '30', '360921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360922', '360900', '0,86,360000,360900', '万载县', '30', '360922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360923', '360900', '0,86,360000,360900', '上高县', '30', '360923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360924', '360900', '0,86,360000,360900', '宜丰县', '30', '360924', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360925', '360900', '0,86,360000,360900', '靖安县', '30', '360925', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360926', '360900', '0,86,360000,360900', '铜鼓县', '30', '360926', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360981', '360900', '0,86,360000,360900', '丰城市', '30', '360981', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360982', '360900', '0,86,360000,360900', '樟树市', '30', '360982', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('360983', '360900', '0,86,360000,360900', '高安市', '30', '360983', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361000', '360000', '0,86,360000', '抚州市', '30', '361000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361002', '361000', '0,86,360000,361000', '临川区', '30', '361002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361021', '361000', '0,86,360000,361000', '南城县', '30', '361021', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361022', '361000', '0,86,360000,361000', '黎川县', '30', '361022', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361023', '361000', '0,86,360000,361000', '南丰县', '30', '361023', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361024', '361000', '0,86,360000,361000', '崇仁县', '30', '361024', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361025', '361000', '0,86,360000,361000', '乐安县', '30', '361025', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361026', '361000', '0,86,360000,361000', '宜黄县', '30', '361026', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361027', '361000', '0,86,360000,361000', '金溪县', '30', '361027', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361028', '361000', '0,86,360000,361000', '资溪县', '30', '361028', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361029', '361000', '0,86,360000,361000', '东乡县', '30', '361029', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361030', '361000', '0,86,360000,361000', '广昌县', '30', '361030', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361100', '360000', '0,86,360000', '上饶市', '30', '361100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361102', '361100', '0,86,360000,361100', '信州区', '30', '361102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361103', '361100', '0,86,360000,361100', '广丰区', '30', '361103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361121', '361100', '0,86,360000,361100', '上饶县', '30', '361121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361123', '361100', '0,86,360000,361100', '玉山县', '30', '361123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361124', '361100', '0,86,360000,361100', '铅山县', '30', '361124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361125', '361100', '0,86,360000,361100', '横峰县', '30', '361125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361126', '361100', '0,86,360000,361100', '弋阳县', '30', '361126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361127', '361100', '0,86,360000,361100', '余干县', '30', '361127', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361128', '361100', '0,86,360000,361100', '鄱阳县', '30', '361128', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361129', '361100', '0,86,360000,361100', '万年县', '30', '361129', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361130', '361100', '0,86,360000,361100', '婺源县', '30', '361130', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('361181', '361100', '0,86,360000,361100', '德兴市', '30', '361181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370000', '86', '0,86', '山东省', '30', '370000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370100', '370000', '0,86,370000', '济南市', '30', '370100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370102', '370100', '0,86,370000,370100', '历下区', '30', '370102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370103', '370100', '0,86,370000,370100', '市中区', '30', '370103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370104', '370100', '0,86,370000,370100', '槐荫区', '30', '370104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370105', '370100', '0,86,370000,370100', '天桥区', '30', '370105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370112', '370100', '0,86,370000,370100', '历城区', '30', '370112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370113', '370100', '0,86,370000,370100', '长清区', '30', '370113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370124', '370100', '0,86,370000,370100', '平阴县', '30', '370124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370125', '370100', '0,86,370000,370100', '济阳县', '30', '370125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370126', '370100', '0,86,370000,370100', '商河县', '30', '370126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370181', '370100', '0,86,370000,370100', '章丘市', '30', '370181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370200', '370000', '0,86,370000', '青岛市', '30', '370200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370202', '370200', '0,86,370000,370200', '市南区', '30', '370202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370203', '370200', '0,86,370000,370200', '市北区', '30', '370203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370204', '370200', '0,86,370000,370200', '四方区', '30', '370204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370211', '370200', '0,86,370000,370200', '黄岛区', '30', '370211', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370212', '370200', '0,86,370000,370200', '崂山区', '30', '370212', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370213', '370200', '0,86,370000,370200', '李沧区', '30', '370213', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370214', '370200', '0,86,370000,370200', '城阳区', '30', '370214', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370215', '370200', '0,86,370000,370200', '开发区', '30', '370215', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370281', '370200', '0,86,370000,370200', '胶州市', '30', '370281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370282', '370200', '0,86,370000,370200', '即墨市', '30', '370282', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370283', '370200', '0,86,370000,370200', '平度市', '30', '370283', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370284', '370200', '0,86,370000,370200', '胶南市', '30', '370284', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370285', '370200', '0,86,370000,370200', '莱西市', '30', '370285', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370300', '370000', '0,86,370000', '淄博市', '30', '370300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370302', '370300', '0,86,370000,370300', '淄川区', '30', '370302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370303', '370300', '0,86,370000,370300', '张店区', '30', '370303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370304', '370300', '0,86,370000,370300', '博山区', '30', '370304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370305', '370300', '0,86,370000,370300', '临淄区', '30', '370305', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370306', '370300', '0,86,370000,370300', '周村区', '30', '370306', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370321', '370300', '0,86,370000,370300', '桓台县', '30', '370321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370322', '370300', '0,86,370000,370300', '高青县', '30', '370322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370323', '370300', '0,86,370000,370300', '沂源县', '30', '370323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370400', '370000', '0,86,370000', '枣庄市', '30', '370400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370402', '370400', '0,86,370000,370400', '市中区', '30', '370402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370403', '370400', '0,86,370000,370400', '薛城区', '30', '370403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370404', '370400', '0,86,370000,370400', '峄城区', '30', '370404', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370405', '370400', '0,86,370000,370400', '台儿庄区', '30', '370405', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370406', '370400', '0,86,370000,370400', '山亭区', '30', '370406', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370481', '370400', '0,86,370000,370400', '滕州市', '30', '370481', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370500', '370000', '0,86,370000', '东营市', '30', '370500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370502', '370500', '0,86,370000,370500', '东营区', '30', '370502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370503', '370500', '0,86,370000,370500', '河口区', '30', '370503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370521', '370500', '0,86,370000,370500', '垦利县', '30', '370521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370522', '370500', '0,86,370000,370500', '利津县', '30', '370522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370523', '370500', '0,86,370000,370500', '广饶县', '30', '370523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370524', '370500', '0,86,370000,370500', '西城区', '30', '370524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370525', '370500', '0,86,370000,370500', '东城区', '30', '370525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370600', '370000', '0,86,370000', '烟台市', '30', '370600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370602', '370600', '0,86,370000,370600', '芝罘区', '30', '370602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370611', '370600', '0,86,370000,370600', '福山区', '30', '370611', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370612', '370600', '0,86,370000,370600', '牟平区', '30', '370612', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370613', '370600', '0,86,370000,370600', '莱山区', '30', '370613', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370634', '370600', '0,86,370000,370600', '长岛县', '30', '370634', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370681', '370600', '0,86,370000,370600', '龙口市', '30', '370681', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370682', '370600', '0,86,370000,370600', '莱阳市', '30', '370682', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370683', '370600', '0,86,370000,370600', '莱州市', '30', '370683', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370684', '370600', '0,86,370000,370600', '蓬莱市', '30', '370684', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370685', '370600', '0,86,370000,370600', '招远市', '30', '370685', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370686', '370600', '0,86,370000,370600', '栖霞市', '30', '370686', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370687', '370600', '0,86,370000,370600', '海阳市', '30', '370687', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370700', '370000', '0,86,370000', '潍坊市', '30', '370700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370702', '370700', '0,86,370000,370700', '潍城区', '30', '370702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370703', '370700', '0,86,370000,370700', '寒亭区', '30', '370703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370704', '370700', '0,86,370000,370700', '坊子区', '30', '370704', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370705', '370700', '0,86,370000,370700', '奎文区', '30', '370705', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370724', '370700', '0,86,370000,370700', '临朐县', '30', '370724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370725', '370700', '0,86,370000,370700', '昌乐县', '30', '370725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370726', '370700', '0,86,370000,370700', '开发区', '30', '370726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370781', '370700', '0,86,370000,370700', '青州市', '30', '370781', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370782', '370700', '0,86,370000,370700', '诸城市', '30', '370782', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370783', '370700', '0,86,370000,370700', '寿光市', '30', '370783', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370784', '370700', '0,86,370000,370700', '安丘市', '30', '370784', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370785', '370700', '0,86,370000,370700', '高密市', '30', '370785', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370786', '370700', '0,86,370000,370700', '昌邑市', '30', '370786', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370800', '370000', '0,86,370000', '济宁市', '30', '370800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370810', '370800', '0,86,370000,370800', '市中区', '30', '370810', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370811', '370800', '0,86,370000,370800', '任城区', '30', '370811', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370812', '370800', '0,86,370000,370800', '兖州区', '30', '370812', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370826', '370800', '0,86,370000,370800', '微山县', '30', '370826', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370827', '370800', '0,86,370000,370800', '鱼台县', '30', '370827', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370828', '370800', '0,86,370000,370800', '金乡县', '30', '370828', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370829', '370800', '0,86,370000,370800', '嘉祥县', '30', '370829', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370830', '370800', '0,86,370000,370800', '汶上县', '30', '370830', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370831', '370800', '0,86,370000,370800', '泗水县', '30', '370831', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370832', '370800', '0,86,370000,370800', '梁山县', '30', '370832', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370881', '370800', '0,86,370000,370800', '曲阜市', '30', '370881', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370883', '370800', '0,86,370000,370800', '邹城市', '30', '370883', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370900', '370000', '0,86,370000', '泰安市', '30', '370900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370902', '370900', '0,86,370000,370900', '泰山区', '30', '370902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370911', '370900', '0,86,370000,370900', '岱岳区', '30', '370911', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370921', '370900', '0,86,370000,370900', '宁阳县', '30', '370921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370923', '370900', '0,86,370000,370900', '东平县', '30', '370923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370982', '370900', '0,86,370000,370900', '新泰市', '30', '370982', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('370983', '370900', '0,86,370000,370900', '肥城市', '30', '370983', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371000', '370000', '0,86,370000', '威海市', '30', '371000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371002', '371000', '0,86,370000,371000', '环翠区', '30', '371002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371003', '371000', '0,86,370000,371000', '文登区', '30', '371003', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371082', '371000', '0,86,370000,371000', '荣成市', '30', '371082', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371083', '371000', '0,86,370000,371000', '乳山市', '30', '371083', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371100', '370000', '0,86,370000', '日照市', '30', '371100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371102', '371100', '0,86,370000,371100', '东港区', '30', '371102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371103', '371100', '0,86,370000,371100', '岚山区', '30', '371103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371121', '371100', '0,86,370000,371100', '五莲县', '30', '371121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371122', '371100', '0,86,370000,371100', '莒县', '30', '371122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371200', '370000', '0,86,370000', '莱芜市', '30', '371200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371202', '371200', '0,86,370000,371200', '莱城区', '30', '371202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371203', '371200', '0,86,370000,371200', '钢城区', '30', '371203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371300', '370000', '0,86,370000', '临沂市', '30', '371300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371302', '371300', '0,86,370000,371300', '兰山区', '30', '371302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371311', '371300', '0,86,370000,371300', '罗庄区', '30', '371311', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371312', '371300', '0,86,370000,371300', '河东区', '30', '371312', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371321', '371300', '0,86,370000,371300', '沂南县', '30', '371321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371322', '371300', '0,86,370000,371300', '郯城县', '30', '371322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371323', '371300', '0,86,370000,371300', '沂水县', '30', '371323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371324', '371300', '0,86,370000,371300', '兰陵县', '30', '371324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371325', '371300', '0,86,370000,371300', '费县', '30', '371325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371326', '371300', '0,86,370000,371300', '平邑县', '30', '371326', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371327', '371300', '0,86,370000,371300', '莒南县', '30', '371327', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371328', '371300', '0,86,370000,371300', '蒙阴县', '30', '371328', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371329', '371300', '0,86,370000,371300', '临沭县', '30', '371329', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371400', '370000', '0,86,370000', '德州市', '30', '371400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371402', '371400', '0,86,370000,371400', '德城区', '30', '371402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371403', '371400', '0,86,370000,371400', '陵城区', '30', '371403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371422', '371400', '0,86,370000,371400', '宁津县', '30', '371422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371423', '371400', '0,86,370000,371400', '庆云县', '30', '371423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371424', '371400', '0,86,370000,371400', '临邑县', '30', '371424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371425', '371400', '0,86,370000,371400', '齐河县', '30', '371425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371426', '371400', '0,86,370000,371400', '平原县', '30', '371426', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371427', '371400', '0,86,370000,371400', '夏津县', '30', '371427', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371428', '371400', '0,86,370000,371400', '武城县', '30', '371428', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371429', '371400', '0,86,370000,371400', '开发区', '30', '371429', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371481', '371400', '0,86,370000,371400', '乐陵市', '30', '371481', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371482', '371400', '0,86,370000,371400', '禹城市', '30', '371482', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371500', '370000', '0,86,370000', '聊城市', '30', '371500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371502', '371500', '0,86,370000,371500', '东昌府区', '30', '371502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371521', '371500', '0,86,370000,371500', '阳谷县', '30', '371521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371522', '371500', '0,86,370000,371500', '莘县', '30', '371522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371523', '371500', '0,86,370000,371500', '茌平县', '30', '371523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371524', '371500', '0,86,370000,371500', '东阿县', '30', '371524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371525', '371500', '0,86,370000,371500', '冠县', '30', '371525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371526', '371500', '0,86,370000,371500', '高唐县', '30', '371526', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371581', '371500', '0,86,370000,371500', '临清市', '30', '371581', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371600', '370000', '0,86,370000', '滨州市', '30', '371600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371602', '371600', '0,86,370000,371600', '滨城区', '30', '371602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371603', '371600', '0,86,370000,371600', '沾化区', '30', '371603', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371621', '371600', '0,86,370000,371600', '惠民县', '30', '371621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371622', '371600', '0,86,370000,371600', '阳信县', '30', '371622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371623', '371600', '0,86,370000,371600', '无棣县', '30', '371623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371625', '371600', '0,86,370000,371600', '博兴县', '30', '371625', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371626', '371600', '0,86,370000,371600', '邹平县', '30', '371626', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371700', '370000', '0,86,370000', '菏泽市', '30', '371700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371702', '371700', '0,86,370000,371700', '牡丹区', '30', '371702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371721', '371700', '0,86,370000,371700', '曹县', '30', '371721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371722', '371700', '0,86,370000,371700', '单县', '30', '371722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371723', '371700', '0,86,370000,371700', '成武县', '30', '371723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371724', '371700', '0,86,370000,371700', '巨野县', '30', '371724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371725', '371700', '0,86,370000,371700', '郓城县', '30', '371725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371726', '371700', '0,86,370000,371700', '鄄城县', '30', '371726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371727', '371700', '0,86,370000,371700', '定陶县', '30', '371727', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('371728', '371700', '0,86,370000,371700', '东明县', '30', '371728', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410000', '86', '0,86', '河南省', '30', '410000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410100', '410000', '0,86,410000', '郑州市', '30', '410100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410102', '410100', '0,86,410000,410100', '中原区', '30', '410102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410103', '410100', '0,86,410000,410100', '二七区', '30', '410103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410104', '410100', '0,86,410000,410100', '管城回族区', '30', '410104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410105', '410100', '0,86,410000,410100', '金水区', '30', '410105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410106', '410100', '0,86,410000,410100', '上街区', '30', '410106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410108', '410100', '0,86,410000,410100', '惠济区', '30', '410108', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410122', '410100', '0,86,410000,410100', '中牟县', '30', '410122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410181', '410100', '0,86,410000,410100', '巩义市', '30', '410181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410182', '410100', '0,86,410000,410100', '荥阳市', '30', '410182', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410183', '410100', '0,86,410000,410100', '新密市', '30', '410183', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410184', '410100', '0,86,410000,410100', '新郑市', '30', '410184', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410185', '410100', '0,86,410000,410100', '登封市', '30', '410185', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410186', '410100', '0,86,410000,410100', '郑东新区', '30', '410186', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410187', '410100', '0,86,410000,410100', '高新区', '30', '410187', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410200', '410000', '0,86,410000', '开封市', '30', '410200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410202', '410200', '0,86,410000,410200', '龙亭区', '30', '410202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410203', '410200', '0,86,410000,410200', '顺河回族区', '30', '410203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410204', '410200', '0,86,410000,410200', '鼓楼区', '30', '410204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410205', '410200', '0,86,410000,410200', '禹王台区', '30', '410205', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410206', '410200', '0,86,410000,410200', '金明区', '30', '410206', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410212', '410200', '0,86,410000,410200', '祥符区', '30', '410212', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410221', '410200', '0,86,410000,410200', '杞县', '30', '410221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410222', '410200', '0,86,410000,410200', '通许县', '30', '410222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410223', '410200', '0,86,410000,410200', '尉氏县', '30', '410223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410225', '410200', '0,86,410000,410200', '兰考县', '30', '410225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410300', '410000', '0,86,410000', '洛阳市', '30', '410300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410302', '410300', '0,86,410000,410300', '老城区', '30', '410302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410303', '410300', '0,86,410000,410300', '西工区', '30', '410303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410304', '410300', '0,86,410000,410300', '瀍河回族区', '30', '410304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410305', '410300', '0,86,410000,410300', '涧西区', '30', '410305', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410306', '410300', '0,86,410000,410300', '吉利区', '30', '410306', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410311', '410300', '0,86,410000,410300', '洛龙区', '30', '410311', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410322', '410300', '0,86,410000,410300', '孟津县', '30', '410322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410323', '410300', '0,86,410000,410300', '新安县', '30', '410323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410324', '410300', '0,86,410000,410300', '栾川县', '30', '410324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410325', '410300', '0,86,410000,410300', '嵩县', '30', '410325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410326', '410300', '0,86,410000,410300', '汝阳县', '30', '410326', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410327', '410300', '0,86,410000,410300', '宜阳县', '30', '410327', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410328', '410300', '0,86,410000,410300', '洛宁县', '30', '410328', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410329', '410300', '0,86,410000,410300', '伊川县', '30', '410329', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410381', '410300', '0,86,410000,410300', '偃师市', '30', '410381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410382', '410300', '0,86,410000,410300', '高新区', '30', '410382', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410400', '410000', '0,86,410000', '平顶山市', '30', '410400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410402', '410400', '0,86,410000,410400', '新华区', '30', '410402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410403', '410400', '0,86,410000,410400', '卫东区', '30', '410403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410404', '410400', '0,86,410000,410400', '石龙区', '30', '410404', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410411', '410400', '0,86,410000,410400', '湛河区', '30', '410411', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410421', '410400', '0,86,410000,410400', '宝丰县', '30', '410421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410422', '410400', '0,86,410000,410400', '叶县', '30', '410422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410423', '410400', '0,86,410000,410400', '鲁山县', '30', '410423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410425', '410400', '0,86,410000,410400', '郏县', '30', '410425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410481', '410400', '0,86,410000,410400', '舞钢市', '30', '410481', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410482', '410400', '0,86,410000,410400', '汝州市', '30', '410482', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410500', '410000', '0,86,410000', '安阳市', '30', '410500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410502', '410500', '0,86,410000,410500', '文峰区', '30', '410502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410503', '410500', '0,86,410000,410500', '北关区', '30', '410503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410505', '410500', '0,86,410000,410500', '殷都区', '30', '410505', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410506', '410500', '0,86,410000,410500', '龙安区', '30', '410506', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410522', '410500', '0,86,410000,410500', '安阳县', '30', '410522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410523', '410500', '0,86,410000,410500', '汤阴县', '30', '410523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410526', '410500', '0,86,410000,410500', '滑县', '30', '410526', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410527', '410500', '0,86,410000,410500', '内黄县', '30', '410527', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410581', '410500', '0,86,410000,410500', '林州市', '30', '410581', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410600', '410000', '0,86,410000', '鹤壁市', '30', '410600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410602', '410600', '0,86,410000,410600', '鹤山区', '30', '410602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410603', '410600', '0,86,410000,410600', '山城区', '30', '410603', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410611', '410600', '0,86,410000,410600', '淇滨区', '30', '410611', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410621', '410600', '0,86,410000,410600', '浚县', '30', '410621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410622', '410600', '0,86,410000,410600', '淇县', '30', '410622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410700', '410000', '0,86,410000', '新乡市', '30', '410700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410702', '410700', '0,86,410000,410700', '红旗区', '30', '410702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410703', '410700', '0,86,410000,410700', '卫滨区', '30', '410703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410704', '410700', '0,86,410000,410700', '凤泉区', '30', '410704', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410711', '410700', '0,86,410000,410700', '牧野区', '30', '410711', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410721', '410700', '0,86,410000,410700', '新乡县', '30', '410721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410724', '410700', '0,86,410000,410700', '获嘉县', '30', '410724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410725', '410700', '0,86,410000,410700', '原阳县', '30', '410725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410726', '410700', '0,86,410000,410700', '延津县', '30', '410726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410727', '410700', '0,86,410000,410700', '封丘县', '30', '410727', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410728', '410700', '0,86,410000,410700', '长垣县', '30', '410728', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410781', '410700', '0,86,410000,410700', '卫辉市', '30', '410781', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410782', '410700', '0,86,410000,410700', '辉县市', '30', '410782', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410800', '410000', '0,86,410000', '焦作市', '30', '410800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410802', '410800', '0,86,410000,410800', '解放区', '30', '410802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410803', '410800', '0,86,410000,410800', '中站区', '30', '410803', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410804', '410800', '0,86,410000,410800', '马村区', '30', '410804', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410811', '410800', '0,86,410000,410800', '山阳区', '30', '410811', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410821', '410800', '0,86,410000,410800', '修武县', '30', '410821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410822', '410800', '0,86,410000,410800', '博爱县', '30', '410822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410823', '410800', '0,86,410000,410800', '武陟县', '30', '410823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410825', '410800', '0,86,410000,410800', '温县', '30', '410825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410882', '410800', '0,86,410000,410800', '沁阳市', '30', '410882', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410883', '410800', '0,86,410000,410800', '孟州市', '30', '410883', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410900', '410000', '0,86,410000', '濮阳市', '30', '410900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410902', '410900', '0,86,410000,410900', '华龙区', '30', '410902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410922', '410900', '0,86,410000,410900', '清丰县', '30', '410922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410923', '410900', '0,86,410000,410900', '南乐县', '30', '410923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410926', '410900', '0,86,410000,410900', '范县', '30', '410926', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410927', '410900', '0,86,410000,410900', '台前县', '30', '410927', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('410928', '410900', '0,86,410000,410900', '濮阳县', '30', '410928', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411000', '410000', '0,86,410000', '许昌市', '30', '411000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411002', '411000', '0,86,410000,411000', '魏都区', '30', '411002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411023', '411000', '0,86,410000,411000', '许昌县', '30', '411023', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411024', '411000', '0,86,410000,411000', '鄢陵县', '30', '411024', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411025', '411000', '0,86,410000,411000', '襄城县', '30', '411025', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411081', '411000', '0,86,410000,411000', '禹州市', '30', '411081', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411082', '411000', '0,86,410000,411000', '长葛市', '30', '411082', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411100', '410000', '0,86,410000', '漯河市', '30', '411100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411102', '411100', '0,86,410000,411100', '源汇区', '30', '411102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411103', '411100', '0,86,410000,411100', '郾城区', '30', '411103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411104', '411100', '0,86,410000,411100', '召陵区', '30', '411104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411121', '411100', '0,86,410000,411100', '舞阳县', '30', '411121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411122', '411100', '0,86,410000,411100', '临颍县', '30', '411122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411200', '410000', '0,86,410000', '三门峡市', '30', '411200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411202', '411200', '0,86,410000,411200', '湖滨区', '30', '411202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411203', '411200', '0,86,410000,411200', '陕州区', '30', '411203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411221', '411200', '0,86,410000,411200', '渑池县', '30', '411221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411224', '411200', '0,86,410000,411200', '卢氏县', '30', '411224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411281', '411200', '0,86,410000,411200', '义马市', '30', '411281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411282', '411200', '0,86,410000,411200', '灵宝市', '30', '411282', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411300', '410000', '0,86,410000', '南阳市', '30', '411300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411302', '411300', '0,86,410000,411300', '宛城区', '30', '411302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411303', '411300', '0,86,410000,411300', '卧龙区', '30', '411303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411321', '411300', '0,86,410000,411300', '南召县', '30', '411321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411322', '411300', '0,86,410000,411300', '方城县', '30', '411322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411323', '411300', '0,86,410000,411300', '西峡县', '30', '411323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411324', '411300', '0,86,410000,411300', '镇平县', '30', '411324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411325', '411300', '0,86,410000,411300', '内乡县', '30', '411325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411326', '411300', '0,86,410000,411300', '淅川县', '30', '411326', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411327', '411300', '0,86,410000,411300', '社旗县', '30', '411327', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411328', '411300', '0,86,410000,411300', '唐河县', '30', '411328', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411329', '411300', '0,86,410000,411300', '新野县', '30', '411329', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411330', '411300', '0,86,410000,411300', '桐柏县', '30', '411330', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411381', '411300', '0,86,410000,411300', '邓州市', '30', '411381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411400', '410000', '0,86,410000', '商丘市', '30', '411400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411402', '411400', '0,86,410000,411400', '梁园区', '30', '411402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411403', '411400', '0,86,410000,411400', '睢阳区', '30', '411403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411421', '411400', '0,86,410000,411400', '民权县', '30', '411421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411422', '411400', '0,86,410000,411400', '睢县', '30', '411422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411423', '411400', '0,86,410000,411400', '宁陵县', '30', '411423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411424', '411400', '0,86,410000,411400', '柘城县', '30', '411424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411425', '411400', '0,86,410000,411400', '虞城县', '30', '411425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411426', '411400', '0,86,410000,411400', '夏邑县', '30', '411426', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411481', '411400', '0,86,410000,411400', '永城市', '30', '411481', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411500', '410000', '0,86,410000', '信阳市', '30', '411500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411502', '411500', '0,86,410000,411500', '浉河区', '30', '411502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411503', '411500', '0,86,410000,411500', '平桥区', '30', '411503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411521', '411500', '0,86,410000,411500', '罗山县', '30', '411521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411522', '411500', '0,86,410000,411500', '光山县', '30', '411522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411523', '411500', '0,86,410000,411500', '新县', '30', '411523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411524', '411500', '0,86,410000,411500', '商城县', '30', '411524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411525', '411500', '0,86,410000,411500', '固始县', '30', '411525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411526', '411500', '0,86,410000,411500', '潢川县', '30', '411526', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411527', '411500', '0,86,410000,411500', '淮滨县', '30', '411527', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411528', '411500', '0,86,410000,411500', '息县', '30', '411528', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411600', '410000', '0,86,410000', '周口市', '30', '411600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411602', '411600', '0,86,410000,411600', '川汇区', '30', '411602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411621', '411600', '0,86,410000,411600', '扶沟县', '30', '411621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411622', '411600', '0,86,410000,411600', '西华县', '30', '411622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411623', '411600', '0,86,410000,411600', '商水县', '30', '411623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411624', '411600', '0,86,410000,411600', '沈丘县', '30', '411624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411625', '411600', '0,86,410000,411600', '郸城县', '30', '411625', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411626', '411600', '0,86,410000,411600', '淮阳县', '30', '411626', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411627', '411600', '0,86,410000,411600', '太康县', '30', '411627', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411628', '411600', '0,86,410000,411600', '鹿邑县', '30', '411628', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411681', '411600', '0,86,410000,411600', '项城市', '30', '411681', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411700', '410000', '0,86,410000', '驻马店市', '30', '411700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411702', '411700', '0,86,410000,411700', '驿城区', '30', '411702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411721', '411700', '0,86,410000,411700', '西平县', '30', '411721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411722', '411700', '0,86,410000,411700', '上蔡县', '30', '411722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411723', '411700', '0,86,410000,411700', '平舆县', '30', '411723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411724', '411700', '0,86,410000,411700', '正阳县', '30', '411724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411725', '411700', '0,86,410000,411700', '确山县', '30', '411725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411726', '411700', '0,86,410000,411700', '泌阳县', '30', '411726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411727', '411700', '0,86,410000,411700', '汝南县', '30', '411727', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411728', '411700', '0,86,410000,411700', '遂平县', '30', '411728', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('411729', '411700', '0,86,410000,411700', '新蔡县', '30', '411729', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('419001', '410000', '0,86,410000', '济源市', '30', '419001', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420000', '86', '0,86', '湖北省', '30', '420000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420100', '420000', '0,86,420000', '武汉市', '30', '420100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420102', '420100', '0,86,420000,420100', '江岸区', '30', '420102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420103', '420100', '0,86,420000,420100', '江汉区', '30', '420103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420104', '420100', '0,86,420000,420100', '硚口区', '30', '420104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420105', '420100', '0,86,420000,420100', '汉阳区', '30', '420105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420106', '420100', '0,86,420000,420100', '武昌区', '30', '420106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420107', '420100', '0,86,420000,420100', '青山区', '30', '420107', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420111', '420100', '0,86,420000,420100', '洪山区', '30', '420111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420112', '420100', '0,86,420000,420100', '东西湖区', '30', '420112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420113', '420100', '0,86,420000,420100', '汉南区', '30', '420113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420114', '420100', '0,86,420000,420100', '蔡甸区', '30', '420114', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420115', '420100', '0,86,420000,420100', '江夏区', '30', '420115', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420116', '420100', '0,86,420000,420100', '黄陂区', '30', '420116', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420117', '420100', '0,86,420000,420100', '新洲区', '30', '420117', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420200', '420000', '0,86,420000', '黄石市', '30', '420200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420202', '420200', '0,86,420000,420200', '黄石港区', '30', '420202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420203', '420200', '0,86,420000,420200', '西塞山区', '30', '420203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420204', '420200', '0,86,420000,420200', '下陆区', '30', '420204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420205', '420200', '0,86,420000,420200', '铁山区', '30', '420205', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420222', '420200', '0,86,420000,420200', '阳新县', '30', '420222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420281', '420200', '0,86,420000,420200', '大冶市', '30', '420281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420300', '420000', '0,86,420000', '十堰市', '30', '420300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420302', '420300', '0,86,420000,420300', '茅箭区', '30', '420302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420303', '420300', '0,86,420000,420300', '张湾区', '30', '420303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420304', '420300', '0,86,420000,420300', '郧阳区', '30', '420304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420322', '420300', '0,86,420000,420300', '郧西县', '30', '420322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420323', '420300', '0,86,420000,420300', '竹山县', '30', '420323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420324', '420300', '0,86,420000,420300', '竹溪县', '30', '420324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420325', '420300', '0,86,420000,420300', '房县', '30', '420325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420381', '420300', '0,86,420000,420300', '丹江口市', '30', '420381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420382', '420300', '0,86,420000,420300', '城区', '30', '420382', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420500', '420000', '0,86,420000', '宜昌市', '30', '420500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420502', '420500', '0,86,420000,420500', '西陵区', '30', '420502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420503', '420500', '0,86,420000,420500', '伍家岗区', '30', '420503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420504', '420500', '0,86,420000,420500', '点军区', '30', '420504', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420505', '420500', '0,86,420000,420500', '猇亭区', '30', '420505', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420506', '420500', '0,86,420000,420500', '夷陵区', '30', '420506', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420525', '420500', '0,86,420000,420500', '远安县', '30', '420525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420526', '420500', '0,86,420000,420500', '兴山县', '30', '420526', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420527', '420500', '0,86,420000,420500', '秭归县', '30', '420527', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420528', '420500', '0,86,420000,420500', '长阳土家族自治县', '30', '420528', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420529', '420500', '0,86,420000,420500', '五峰土家族自治县', '30', '420529', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420530', '420500', '0,86,420000,420500', '葛洲坝区', '30', '420530', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420531', '420500', '0,86,420000,420500', '开发区', '30', '420531', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420581', '420500', '0,86,420000,420500', '宜都市', '30', '420581', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420582', '420500', '0,86,420000,420500', '当阳市', '30', '420582', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420583', '420500', '0,86,420000,420500', '枝江市', '30', '420583', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420600', '420000', '0,86,420000', '襄阳市', '30', '420600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420602', '420600', '0,86,420000,420600', '襄城区', '30', '420602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420606', '420600', '0,86,420000,420600', '樊城区', '30', '420606', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420607', '420600', '0,86,420000,420600', '襄州区', '30', '420607', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420624', '420600', '0,86,420000,420600', '南漳县', '30', '420624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420625', '420600', '0,86,420000,420600', '谷城县', '30', '420625', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420626', '420600', '0,86,420000,420600', '保康县', '30', '420626', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420682', '420600', '0,86,420000,420600', '老河口市', '30', '420682', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420683', '420600', '0,86,420000,420600', '枣阳市', '30', '420683', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420684', '420600', '0,86,420000,420600', '宜城市', '30', '420684', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420700', '420000', '0,86,420000', '鄂州市', '30', '420700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420702', '420700', '0,86,420000,420700', '梁子湖区', '30', '420702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420703', '420700', '0,86,420000,420700', '华容区', '30', '420703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420704', '420700', '0,86,420000,420700', '鄂城区', '30', '420704', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420800', '420000', '0,86,420000', '荆门市', '30', '420800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420802', '420800', '0,86,420000,420800', '东宝区', '30', '420802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420804', '420800', '0,86,420000,420800', '掇刀区', '30', '420804', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420821', '420800', '0,86,420000,420800', '京山县', '30', '420821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420822', '420800', '0,86,420000,420800', '沙洋县', '30', '420822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420881', '420800', '0,86,420000,420800', '钟祥市', '30', '420881', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420900', '420000', '0,86,420000', '孝感市', '30', '420900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420902', '420900', '0,86,420000,420900', '孝南区', '30', '420902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420921', '420900', '0,86,420000,420900', '孝昌县', '30', '420921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420922', '420900', '0,86,420000,420900', '大悟县', '30', '420922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420923', '420900', '0,86,420000,420900', '云梦县', '30', '420923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420981', '420900', '0,86,420000,420900', '应城市', '30', '420981', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420982', '420900', '0,86,420000,420900', '安陆市', '30', '420982', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('420984', '420900', '0,86,420000,420900', '汉川市', '30', '420984', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421000', '420000', '0,86,420000', '荆州市', '30', '421000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421002', '421000', '0,86,420000,421000', '沙市区', '30', '421002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421003', '421000', '0,86,420000,421000', '荆州区', '30', '421003', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421022', '421000', '0,86,420000,421000', '公安县', '30', '421022', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421023', '421000', '0,86,420000,421000', '监利县', '30', '421023', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421024', '421000', '0,86,420000,421000', '江陵县', '30', '421024', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421081', '421000', '0,86,420000,421000', '石首市', '30', '421081', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421083', '421000', '0,86,420000,421000', '洪湖市', '30', '421083', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421087', '421000', '0,86,420000,421000', '松滋市', '30', '421087', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421100', '420000', '0,86,420000', '黄冈市', '30', '421100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421102', '421100', '0,86,420000,421100', '黄州区', '30', '421102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421121', '421100', '0,86,420000,421100', '团风县', '30', '421121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421122', '421100', '0,86,420000,421100', '红安县', '30', '421122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421123', '421100', '0,86,420000,421100', '罗田县', '30', '421123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421124', '421100', '0,86,420000,421100', '英山县', '30', '421124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421125', '421100', '0,86,420000,421100', '浠水县', '30', '421125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421126', '421100', '0,86,420000,421100', '蕲春县', '30', '421126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421127', '421100', '0,86,420000,421100', '黄梅县', '30', '421127', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421181', '421100', '0,86,420000,421100', '麻城市', '30', '421181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421182', '421100', '0,86,420000,421100', '武穴市', '30', '421182', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421200', '420000', '0,86,420000', '咸宁市', '30', '421200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421202', '421200', '0,86,420000,421200', '咸安区', '30', '421202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421221', '421200', '0,86,420000,421200', '嘉鱼县', '30', '421221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421222', '421200', '0,86,420000,421200', '通城县', '30', '421222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421223', '421200', '0,86,420000,421200', '崇阳县', '30', '421223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421224', '421200', '0,86,420000,421200', '通山县', '30', '421224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421281', '421200', '0,86,420000,421200', '赤壁市', '30', '421281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421282', '421200', '0,86,420000,421200', '温泉城区', '30', '421282', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421300', '420000', '0,86,420000', '随州市', '30', '421300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421303', '421300', '0,86,420000,421300', '曾都区', '30', '421303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421321', '421300', '0,86,420000,421300', '随县', '30', '421321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('421381', '421300', '0,86,420000,421300', '广水市', '30', '421381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('422800', '420000', '0,86,420000', '恩施土家族苗族自治州', '30', '422800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('422801', '422800', '0,86,420000,422800', '恩施市', '30', '422801', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('422802', '422800', '0,86,420000,422800', '利川市', '30', '422802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('422822', '422800', '0,86,420000,422800', '建始县', '30', '422822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('422823', '422800', '0,86,420000,422800', '巴东县', '30', '422823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('422825', '422800', '0,86,420000,422800', '宣恩县', '30', '422825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('422826', '422800', '0,86,420000,422800', '咸丰县', '30', '422826', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('422827', '422800', '0,86,420000,422800', '来凤县', '30', '422827', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('422828', '422800', '0,86,420000,422800', '鹤峰县', '30', '422828', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('429004', '420000', '0,86,420000', '仙桃市', '30', '429004', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('429005', '420000', '0,86,420000', '潜江市', '30', '429005', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('429006', '420000', '0,86,420000', '天门市', '30', '429006', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('429021', '420000', '0,86,420000', '神农架林区', '30', '429021', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430000', '86', '0,86', '湖南省', '30', '430000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430100', '430000', '0,86,430000', '长沙市', '30', '430100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430102', '430100', '0,86,430000,430100', '芙蓉区', '30', '430102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430103', '430100', '0,86,430000,430100', '天心区', '30', '430103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430104', '430100', '0,86,430000,430100', '岳麓区', '30', '430104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430105', '430100', '0,86,430000,430100', '开福区', '30', '430105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430111', '430100', '0,86,430000,430100', '雨花区', '30', '430111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430112', '430100', '0,86,430000,430100', '望城区', '30', '430112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430121', '430100', '0,86,430000,430100', '长沙县', '30', '430121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430124', '430100', '0,86,430000,430100', '宁乡县', '30', '430124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430181', '430100', '0,86,430000,430100', '浏阳市', '30', '430181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430200', '430000', '0,86,430000', '株洲市', '30', '430200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430202', '430200', '0,86,430000,430200', '荷塘区', '30', '430202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430203', '430200', '0,86,430000,430200', '芦淞区', '30', '430203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430204', '430200', '0,86,430000,430200', '石峰区', '30', '430204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430211', '430200', '0,86,430000,430200', '天元区', '30', '430211', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430221', '430200', '0,86,430000,430200', '株洲县', '30', '430221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430223', '430200', '0,86,430000,430200', '攸县', '30', '430223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430224', '430200', '0,86,430000,430200', '茶陵县', '30', '430224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430225', '430200', '0,86,430000,430200', '炎陵县', '30', '430225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430281', '430200', '0,86,430000,430200', '醴陵市', '30', '430281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430300', '430000', '0,86,430000', '湘潭市', '30', '430300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430302', '430300', '0,86,430000,430300', '雨湖区', '30', '430302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430304', '430300', '0,86,430000,430300', '岳塘区', '30', '430304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430321', '430300', '0,86,430000,430300', '湘潭县', '30', '430321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430381', '430300', '0,86,430000,430300', '湘乡市', '30', '430381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430382', '430300', '0,86,430000,430300', '韶山市', '30', '430382', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430400', '430000', '0,86,430000', '衡阳市', '30', '430400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430405', '430400', '0,86,430000,430400', '珠晖区', '30', '430405', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430406', '430400', '0,86,430000,430400', '雁峰区', '30', '430406', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430407', '430400', '0,86,430000,430400', '石鼓区', '30', '430407', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430408', '430400', '0,86,430000,430400', '蒸湘区', '30', '430408', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430412', '430400', '0,86,430000,430400', '南岳区', '30', '430412', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430421', '430400', '0,86,430000,430400', '衡阳县', '30', '430421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430422', '430400', '0,86,430000,430400', '衡南县', '30', '430422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430423', '430400', '0,86,430000,430400', '衡山县', '30', '430423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430424', '430400', '0,86,430000,430400', '衡东县', '30', '430424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430426', '430400', '0,86,430000,430400', '祁东县', '30', '430426', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430481', '430400', '0,86,430000,430400', '耒阳市', '30', '430481', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430482', '430400', '0,86,430000,430400', '常宁市', '30', '430482', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430500', '430000', '0,86,430000', '邵阳市', '30', '430500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430502', '430500', '0,86,430000,430500', '双清区', '30', '430502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430503', '430500', '0,86,430000,430500', '大祥区', '30', '430503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430511', '430500', '0,86,430000,430500', '北塔区', '30', '430511', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430521', '430500', '0,86,430000,430500', '邵东县', '30', '430521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430522', '430500', '0,86,430000,430500', '新邵县', '30', '430522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430523', '430500', '0,86,430000,430500', '邵阳县', '30', '430523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430524', '430500', '0,86,430000,430500', '隆回县', '30', '430524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430525', '430500', '0,86,430000,430500', '洞口县', '30', '430525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430527', '430500', '0,86,430000,430500', '绥宁县', '30', '430527', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430528', '430500', '0,86,430000,430500', '新宁县', '30', '430528', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430529', '430500', '0,86,430000,430500', '城步苗族自治县', '30', '430529', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430581', '430500', '0,86,430000,430500', '武冈市', '30', '430581', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430600', '430000', '0,86,430000', '岳阳市', '30', '430600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430602', '430600', '0,86,430000,430600', '岳阳楼区', '30', '430602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430603', '430600', '0,86,430000,430600', '云溪区', '30', '430603', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430611', '430600', '0,86,430000,430600', '君山区', '30', '430611', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430621', '430600', '0,86,430000,430600', '岳阳县', '30', '430621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430623', '430600', '0,86,430000,430600', '华容县', '30', '430623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430624', '430600', '0,86,430000,430600', '湘阴县', '30', '430624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430626', '430600', '0,86,430000,430600', '平江县', '30', '430626', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430681', '430600', '0,86,430000,430600', '汨罗市', '30', '430681', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430682', '430600', '0,86,430000,430600', '临湘市', '30', '430682', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430700', '430000', '0,86,430000', '常德市', '30', '430700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430702', '430700', '0,86,430000,430700', '武陵区', '30', '430702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430703', '430700', '0,86,430000,430700', '鼎城区', '30', '430703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430721', '430700', '0,86,430000,430700', '安乡县', '30', '430721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430722', '430700', '0,86,430000,430700', '汉寿县', '30', '430722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430723', '430700', '0,86,430000,430700', '澧县', '30', '430723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430724', '430700', '0,86,430000,430700', '临澧县', '30', '430724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430725', '430700', '0,86,430000,430700', '桃源县', '30', '430725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430726', '430700', '0,86,430000,430700', '石门县', '30', '430726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430781', '430700', '0,86,430000,430700', '津市市', '30', '430781', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430800', '430000', '0,86,430000', '张家界市', '30', '430800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430802', '430800', '0,86,430000,430800', '永定区', '30', '430802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430811', '430800', '0,86,430000,430800', '武陵源区', '30', '430811', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430821', '430800', '0,86,430000,430800', '慈利县', '30', '430821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430822', '430800', '0,86,430000,430800', '桑植县', '30', '430822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430900', '430000', '0,86,430000', '益阳市', '30', '430900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430902', '430900', '0,86,430000,430900', '资阳区', '30', '430902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430903', '430900', '0,86,430000,430900', '赫山区', '30', '430903', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430921', '430900', '0,86,430000,430900', '南县', '30', '430921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430922', '430900', '0,86,430000,430900', '桃江县', '30', '430922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430923', '430900', '0,86,430000,430900', '安化县', '30', '430923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('430981', '430900', '0,86,430000,430900', '沅江市', '30', '430981', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431000', '430000', '0,86,430000', '郴州市', '30', '431000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431002', '431000', '0,86,430000,431000', '北湖区', '30', '431002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431003', '431000', '0,86,430000,431000', '苏仙区', '30', '431003', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431021', '431000', '0,86,430000,431000', '桂阳县', '30', '431021', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431022', '431000', '0,86,430000,431000', '宜章县', '30', '431022', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431023', '431000', '0,86,430000,431000', '永兴县', '30', '431023', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431024', '431000', '0,86,430000,431000', '嘉禾县', '30', '431024', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431025', '431000', '0,86,430000,431000', '临武县', '30', '431025', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431026', '431000', '0,86,430000,431000', '汝城县', '30', '431026', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431027', '431000', '0,86,430000,431000', '桂东县', '30', '431027', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431028', '431000', '0,86,430000,431000', '安仁县', '30', '431028', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431081', '431000', '0,86,430000,431000', '资兴市', '30', '431081', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431100', '430000', '0,86,430000', '永州市', '30', '431100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431102', '431100', '0,86,430000,431100', '零陵区', '30', '431102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431103', '431100', '0,86,430000,431100', '冷水滩区', '30', '431103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431121', '431100', '0,86,430000,431100', '祁阳县', '30', '431121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431122', '431100', '0,86,430000,431100', '东安县', '30', '431122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431123', '431100', '0,86,430000,431100', '双牌县', '30', '431123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431124', '431100', '0,86,430000,431100', '道县', '30', '431124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431125', '431100', '0,86,430000,431100', '江永县', '30', '431125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431126', '431100', '0,86,430000,431100', '宁远县', '30', '431126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431127', '431100', '0,86,430000,431100', '蓝山县', '30', '431127', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431128', '431100', '0,86,430000,431100', '新田县', '30', '431128', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431129', '431100', '0,86,430000,431100', '江华瑶族自治县', '30', '431129', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431200', '430000', '0,86,430000', '怀化市', '30', '431200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431202', '431200', '0,86,430000,431200', '鹤城区', '30', '431202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431221', '431200', '0,86,430000,431200', '中方县', '30', '431221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431222', '431200', '0,86,430000,431200', '沅陵县', '30', '431222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431223', '431200', '0,86,430000,431200', '辰溪县', '30', '431223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431224', '431200', '0,86,430000,431200', '溆浦县', '30', '431224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431225', '431200', '0,86,430000,431200', '会同县', '30', '431225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431226', '431200', '0,86,430000,431200', '麻阳苗族自治县', '30', '431226', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431227', '431200', '0,86,430000,431200', '新晃侗族自治县', '30', '431227', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431228', '431200', '0,86,430000,431200', '芷江侗族自治县', '30', '431228', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431229', '431200', '0,86,430000,431200', '靖州苗族侗族自治县', '30', '431229', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431230', '431200', '0,86,430000,431200', '通道侗族自治县', '30', '431230', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431281', '431200', '0,86,430000,431200', '洪江市', '30', '431281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431300', '430000', '0,86,430000', '娄底市', '30', '431300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431302', '431300', '0,86,430000,431300', '娄星区', '30', '431302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431321', '431300', '0,86,430000,431300', '双峰县', '30', '431321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431322', '431300', '0,86,430000,431300', '新化县', '30', '431322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431381', '431300', '0,86,430000,431300', '冷水江市', '30', '431381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('431382', '431300', '0,86,430000,431300', '涟源市', '30', '431382', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('433100', '430000', '0,86,430000', '湘西土家族苗族自治州', '30', '433100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('433101', '433100', '0,86,430000,433100', '吉首市', '30', '433101', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('433122', '433100', '0,86,430000,433100', '泸溪县', '30', '433122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('433123', '433100', '0,86,430000,433100', '凤凰县', '30', '433123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('433124', '433100', '0,86,430000,433100', '花垣县', '30', '433124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('433125', '433100', '0,86,430000,433100', '保靖县', '30', '433125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('433126', '433100', '0,86,430000,433100', '古丈县', '30', '433126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('433127', '433100', '0,86,430000,433100', '永顺县', '30', '433127', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('433130', '433100', '0,86,430000,433100', '龙山县', '30', '433130', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440000', '86', '0,86', '广东省', '30', '440000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440100', '440000', '0,86,440000', '广州市', '30', '440100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440103', '440100', '0,86,440000,440100', '荔湾区', '30', '440103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440104', '440100', '0,86,440000,440100', '越秀区', '30', '440104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440105', '440100', '0,86,440000,440100', '海珠区', '30', '440105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440106', '440100', '0,86,440000,440100', '天河区', '30', '440106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440111', '440100', '0,86,440000,440100', '白云区', '30', '440111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440112', '440100', '0,86,440000,440100', '黄埔区', '30', '440112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440113', '440100', '0,86,440000,440100', '番禺区', '30', '440113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440114', '440100', '0,86,440000,440100', '花都区', '30', '440114', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440115', '440100', '0,86,440000,440100', '南沙区', '30', '440115', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440116', '440100', '0,86,440000,440100', '萝岗区', '30', '440116', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440117', '440100', '0,86,440000,440100', '从化区', '30', '440117', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440118', '440100', '0,86,440000,440100', '增城区', '30', '440118', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440119', '440100', '0,86,440000,440100', '东山区', '30', '440119', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440200', '440000', '0,86,440000', '韶关市', '30', '440200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440203', '440200', '0,86,440000,440200', '武江区', '30', '440203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440204', '440200', '0,86,440000,440200', '浈江区', '30', '440204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440205', '440200', '0,86,440000,440200', '曲江区', '30', '440205', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440222', '440200', '0,86,440000,440200', '始兴县', '30', '440222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440224', '440200', '0,86,440000,440200', '仁化县', '30', '440224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440229', '440200', '0,86,440000,440200', '翁源县', '30', '440229', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440232', '440200', '0,86,440000,440200', '乳源瑶族自治县', '30', '440232', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440233', '440200', '0,86,440000,440200', '新丰县', '30', '440233', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440281', '440200', '0,86,440000,440200', '乐昌市', '30', '440281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440282', '440200', '0,86,440000,440200', '南雄市', '30', '440282', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440300', '440000', '0,86,440000', '深圳市', '30', '440300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440303', '440300', '0,86,440000,440300', '罗湖区', '30', '440303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440304', '440300', '0,86,440000,440300', '福田区', '30', '440304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440305', '440300', '0,86,440000,440300', '南山区', '30', '440305', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440306', '440300', '0,86,440000,440300', '宝安区', '30', '440306', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440307', '440300', '0,86,440000,440300', '龙岗区', '30', '440307', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440308', '440300', '0,86,440000,440300', '盐田区', '30', '440308', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440309', '440300', '0,86,440000,440300', '光明新区', '30', '440309', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440310', '440300', '0,86,440000,440300', '坪山新区', '30', '440310', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440311', '440300', '0,86,440000,440300', '大鹏新区', '30', '440311', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440312', '440300', '0,86,440000,440300', '龙华新区', '30', '440312', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440400', '440000', '0,86,440000', '珠海市', '30', '440400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440402', '440400', '0,86,440000,440400', '香洲区', '30', '440402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440403', '440400', '0,86,440000,440400', '斗门区', '30', '440403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440404', '440400', '0,86,440000,440400', '金湾区', '30', '440404', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440405', '440400', '0,86,440000,440400', '金唐区', '30', '440405', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440406', '440400', '0,86,440000,440400', '南湾区', '30', '440406', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440500', '440000', '0,86,440000', '汕头市', '30', '440500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440507', '440500', '0,86,440000,440500', '龙湖区', '30', '440507', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440511', '440500', '0,86,440000,440500', '金平区', '30', '440511', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440512', '440500', '0,86,440000,440500', '濠江区', '30', '440512', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440513', '440500', '0,86,440000,440500', '潮阳区', '30', '440513', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440514', '440500', '0,86,440000,440500', '潮南区', '30', '440514', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440515', '440500', '0,86,440000,440500', '澄海区', '30', '440515', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440523', '440500', '0,86,440000,440500', '南澳县', '30', '440523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440600', '440000', '0,86,440000', '佛山市', '30', '440600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440604', '440600', '0,86,440000,440600', '禅城区', '30', '440604', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440605', '440600', '0,86,440000,440600', '南海区', '30', '440605', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440606', '440600', '0,86,440000,440600', '顺德区', '30', '440606', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440607', '440600', '0,86,440000,440600', '三水区', '30', '440607', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440608', '440600', '0,86,440000,440600', '高明区', '30', '440608', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440700', '440000', '0,86,440000', '江门市', '30', '440700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440703', '440700', '0,86,440000,440700', '蓬江区', '30', '440703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440704', '440700', '0,86,440000,440700', '江海区', '30', '440704', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440705', '440700', '0,86,440000,440700', '新会区', '30', '440705', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440781', '440700', '0,86,440000,440700', '台山市', '30', '440781', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440783', '440700', '0,86,440000,440700', '开平市', '30', '440783', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440784', '440700', '0,86,440000,440700', '鹤山市', '30', '440784', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440785', '440700', '0,86,440000,440700', '恩平市', '30', '440785', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440800', '440000', '0,86,440000', '湛江市', '30', '440800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440802', '440800', '0,86,440000,440800', '赤坎区', '30', '440802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440803', '440800', '0,86,440000,440800', '霞山区', '30', '440803', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440804', '440800', '0,86,440000,440800', '坡头区', '30', '440804', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440811', '440800', '0,86,440000,440800', '麻章区', '30', '440811', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440823', '440800', '0,86,440000,440800', '遂溪县', '30', '440823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440825', '440800', '0,86,440000,440800', '徐闻县', '30', '440825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440881', '440800', '0,86,440000,440800', '廉江市', '30', '440881', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440882', '440800', '0,86,440000,440800', '雷州市', '30', '440882', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440883', '440800', '0,86,440000,440800', '吴川市', '30', '440883', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440900', '440000', '0,86,440000', '茂名市', '30', '440900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440902', '440900', '0,86,440000,440900', '茂南区', '30', '440902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440904', '440900', '0,86,440000,440900', '电白区', '30', '440904', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440981', '440900', '0,86,440000,440900', '高州市', '30', '440981', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440982', '440900', '0,86,440000,440900', '化州市', '30', '440982', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('440983', '440900', '0,86,440000,440900', '信宜市', '30', '440983', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441200', '440000', '0,86,440000', '肇庆市', '30', '441200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441202', '441200', '0,86,440000,441200', '端州区', '30', '441202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441203', '441200', '0,86,440000,441200', '鼎湖区', '30', '441203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441223', '441200', '0,86,440000,441200', '广宁县', '30', '441223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441224', '441200', '0,86,440000,441200', '怀集县', '30', '441224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441225', '441200', '0,86,440000,441200', '封开县', '30', '441225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441226', '441200', '0,86,440000,441200', '德庆县', '30', '441226', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441283', '441200', '0,86,440000,441200', '高要市', '30', '441283', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441284', '441200', '0,86,440000,441200', '四会市', '30', '441284', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441300', '440000', '0,86,440000', '惠州市', '30', '441300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441302', '441300', '0,86,440000,441300', '惠城区', '30', '441302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441303', '441300', '0,86,440000,441300', '惠阳区', '30', '441303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441322', '441300', '0,86,440000,441300', '博罗县', '30', '441322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441323', '441300', '0,86,440000,441300', '惠东县', '30', '441323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441324', '441300', '0,86,440000,441300', '龙门县', '30', '441324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441400', '440000', '0,86,440000', '梅州市', '30', '441400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441402', '441400', '0,86,440000,441400', '梅江区', '30', '441402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441403', '441400', '0,86,440000,441400', '梅县区', '30', '441403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441422', '441400', '0,86,440000,441400', '大埔县', '30', '441422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441423', '441400', '0,86,440000,441400', '丰顺县', '30', '441423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441424', '441400', '0,86,440000,441400', '五华县', '30', '441424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441426', '441400', '0,86,440000,441400', '平远县', '30', '441426', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441427', '441400', '0,86,440000,441400', '蕉岭县', '30', '441427', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441481', '441400', '0,86,440000,441400', '兴宁市', '30', '441481', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441500', '440000', '0,86,440000', '汕尾市', '30', '441500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441502', '441500', '0,86,440000,441500', '城区', '30', '441502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441521', '441500', '0,86,440000,441500', '海丰县', '30', '441521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441523', '441500', '0,86,440000,441500', '陆河县', '30', '441523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441581', '441500', '0,86,440000,441500', '陆丰市', '30', '441581', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441600', '440000', '0,86,440000', '河源市', '30', '441600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441602', '441600', '0,86,440000,441600', '源城区', '30', '441602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441621', '441600', '0,86,440000,441600', '紫金县', '30', '441621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441622', '441600', '0,86,440000,441600', '龙川县', '30', '441622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441623', '441600', '0,86,440000,441600', '连平县', '30', '441623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441624', '441600', '0,86,440000,441600', '和平县', '30', '441624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441625', '441600', '0,86,440000,441600', '东源县', '30', '441625', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441700', '440000', '0,86,440000', '阳江市', '30', '441700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441702', '441700', '0,86,440000,441700', '江城区', '30', '441702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441704', '441700', '0,86,440000,441700', '阳东区', '30', '441704', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441721', '441700', '0,86,440000,441700', '阳西县', '30', '441721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441781', '441700', '0,86,440000,441700', '阳春市', '30', '441781', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441800', '440000', '0,86,440000', '清远市', '30', '441800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441802', '441800', '0,86,440000,441800', '清城区', '30', '441802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441803', '441800', '0,86,440000,441800', '清新区', '30', '441803', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441821', '441800', '0,86,440000,441800', '佛冈县', '30', '441821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441823', '441800', '0,86,440000,441800', '阳山县', '30', '441823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441825', '441800', '0,86,440000,441800', '连山壮族瑶族自治县', '30', '441825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441826', '441800', '0,86,440000,441800', '连南瑶族自治县', '30', '441826', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441881', '441800', '0,86,440000,441800', '英德市', '30', '441881', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441882', '441800', '0,86,440000,441800', '连州市', '30', '441882', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('441900', '440000', '0,86,440000', '东莞市', '30', '441900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('442000', '440000', '0,86,440000', '中山市', '30', '442000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445100', '440000', '0,86,440000', '潮州市', '30', '445100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445102', '445100', '0,86,440000,445100', '湘桥区', '30', '445102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445103', '445100', '0,86,440000,445100', '潮安区', '30', '445103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445121', '445100', '0,86,440000,445100', '枫溪区', '30', '445121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445122', '445100', '0,86,440000,445100', '饶平县', '30', '445122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445200', '440000', '0,86,440000', '揭阳市', '30', '445200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445202', '445200', '0,86,440000,445200', '榕城区', '30', '445202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445203', '445200', '0,86,440000,445200', '揭东区', '30', '445203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445222', '445200', '0,86,440000,445200', '揭西县', '30', '445222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445224', '445200', '0,86,440000,445200', '惠来县', '30', '445224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445225', '445200', '0,86,440000,445200', '东山区', '30', '445225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445281', '445200', '0,86,440000,445200', '普宁市', '30', '445281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445300', '440000', '0,86,440000', '云浮市', '30', '445300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445302', '445300', '0,86,440000,445300', '云城区', '30', '445302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445303', '445300', '0,86,440000,445300', '云安区', '30', '445303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445321', '445300', '0,86,440000,445300', '新兴县', '30', '445321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445322', '445300', '0,86,440000,445300', '郁南县', '30', '445322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445381', '445300', '0,86,440000,445300', '罗定市', '30', '445381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('445400', '440000', '0,86,440000', '东沙群岛', '30', '445400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450000', '86', '0,86', '广西壮族自治区', '30', '450000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450100', '450000', '0,86,450000', '南宁市', '30', '450100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450102', '450100', '0,86,450000,450100', '兴宁区', '30', '450102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450103', '450100', '0,86,450000,450100', '青秀区', '30', '450103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450105', '450100', '0,86,450000,450100', '江南区', '30', '450105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450107', '450100', '0,86,450000,450100', '西乡塘区', '30', '450107', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450108', '450100', '0,86,450000,450100', '良庆区', '30', '450108', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450109', '450100', '0,86,450000,450100', '邕宁区', '30', '450109', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450110', '450100', '0,86,450000,450100', '武鸣区', '30', '450110', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450123', '450100', '0,86,450000,450100', '隆安县', '30', '450123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450124', '450100', '0,86,450000,450100', '马山县', '30', '450124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450125', '450100', '0,86,450000,450100', '上林县', '30', '450125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450126', '450100', '0,86,450000,450100', '宾阳县', '30', '450126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450127', '450100', '0,86,450000,450100', '横县', '30', '450127', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450200', '450000', '0,86,450000', '柳州市', '30', '450200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450202', '450200', '0,86,450000,450200', '城中区', '30', '450202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450203', '450200', '0,86,450000,450200', '鱼峰区', '30', '450203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450204', '450200', '0,86,450000,450200', '柳南区', '30', '450204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450205', '450200', '0,86,450000,450200', '柳北区', '30', '450205', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450221', '450200', '0,86,450000,450200', '柳江县', '30', '450221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450222', '450200', '0,86,450000,450200', '柳城县', '30', '450222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450223', '450200', '0,86,450000,450200', '鹿寨县', '30', '450223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450224', '450200', '0,86,450000,450200', '融安县', '30', '450224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450225', '450200', '0,86,450000,450200', '融水苗族自治县', '30', '450225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450226', '450200', '0,86,450000,450200', '三江侗族自治县', '30', '450226', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450300', '450000', '0,86,450000', '桂林市', '30', '450300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450302', '450300', '0,86,450000,450300', '秀峰区', '30', '450302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450303', '450300', '0,86,450000,450300', '叠彩区', '30', '450303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450304', '450300', '0,86,450000,450300', '象山区', '30', '450304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450305', '450300', '0,86,450000,450300', '七星区', '30', '450305', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450311', '450300', '0,86,450000,450300', '雁山区', '30', '450311', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450312', '450300', '0,86,450000,450300', '临桂区', '30', '450312', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450321', '450300', '0,86,450000,450300', '阳朔县', '30', '450321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450323', '450300', '0,86,450000,450300', '灵川县', '30', '450323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450324', '450300', '0,86,450000,450300', '全州县', '30', '450324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450325', '450300', '0,86,450000,450300', '兴安县', '30', '450325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450326', '450300', '0,86,450000,450300', '永福县', '30', '450326', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450327', '450300', '0,86,450000,450300', '灌阳县', '30', '450327', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450328', '450300', '0,86,450000,450300', '龙胜各族自治县', '30', '450328', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450329', '450300', '0,86,450000,450300', '资源县', '30', '450329', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450330', '450300', '0,86,450000,450300', '平乐县', '30', '450330', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450331', '450300', '0,86,450000,450300', '荔浦县', '30', '450331', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450332', '450300', '0,86,450000,450300', '恭城瑶族自治县', '30', '450332', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450400', '450000', '0,86,450000', '梧州市', '30', '450400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450403', '450400', '0,86,450000,450400', '万秀区', '30', '450403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450404', '450400', '0,86,450000,450400', '蝶山区', '30', '450404', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450405', '450400', '0,86,450000,450400', '长洲区', '30', '450405', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450406', '450400', '0,86,450000,450400', '龙圩区', '30', '450406', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450421', '450400', '0,86,450000,450400', '苍梧县', '30', '450421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450422', '450400', '0,86,450000,450400', '藤县', '30', '450422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450423', '450400', '0,86,450000,450400', '蒙山县', '30', '450423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450481', '450400', '0,86,450000,450400', '岑溪市', '30', '450481', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450500', '450000', '0,86,450000', '北海市', '30', '450500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450502', '450500', '0,86,450000,450500', '海城区', '30', '450502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450503', '450500', '0,86,450000,450500', '银海区', '30', '450503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450512', '450500', '0,86,450000,450500', '铁山港区', '30', '450512', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450521', '450500', '0,86,450000,450500', '合浦县', '30', '450521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450600', '450000', '0,86,450000', '防城港市', '30', '450600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450602', '450600', '0,86,450000,450600', '港口区', '30', '450602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450603', '450600', '0,86,450000,450600', '防城区', '30', '450603', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450621', '450600', '0,86,450000,450600', '上思县', '30', '450621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450681', '450600', '0,86,450000,450600', '东兴市', '30', '450681', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450700', '450000', '0,86,450000', '钦州市', '30', '450700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450702', '450700', '0,86,450000,450700', '钦南区', '30', '450702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450703', '450700', '0,86,450000,450700', '钦北区', '30', '450703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450721', '450700', '0,86,450000,450700', '灵山县', '30', '450721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450722', '450700', '0,86,450000,450700', '浦北县', '30', '450722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450800', '450000', '0,86,450000', '贵港市', '30', '450800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450802', '450800', '0,86,450000,450800', '港北区', '30', '450802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450803', '450800', '0,86,450000,450800', '港南区', '30', '450803', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450804', '450800', '0,86,450000,450800', '覃塘区', '30', '450804', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450821', '450800', '0,86,450000,450800', '平南县', '30', '450821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450881', '450800', '0,86,450000,450800', '桂平市', '30', '450881', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450900', '450000', '0,86,450000', '玉林市', '30', '450900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450902', '450900', '0,86,450000,450900', '玉州区', '30', '450902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450903', '450900', '0,86,450000,450900', '福绵区', '30', '450903', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450921', '450900', '0,86,450000,450900', '容县', '30', '450921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450922', '450900', '0,86,450000,450900', '陆川县', '30', '450922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450923', '450900', '0,86,450000,450900', '博白县', '30', '450923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450924', '450900', '0,86,450000,450900', '兴业县', '30', '450924', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('450981', '450900', '0,86,450000,450900', '北流市', '30', '450981', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451000', '450000', '0,86,450000', '百色市', '30', '451000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451002', '451000', '0,86,450000,451000', '右江区', '30', '451002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451021', '451000', '0,86,450000,451000', '田阳县', '30', '451021', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451022', '451000', '0,86,450000,451000', '田东县', '30', '451022', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451023', '451000', '0,86,450000,451000', '平果县', '30', '451023', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451024', '451000', '0,86,450000,451000', '德保县', '30', '451024', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451025', '451000', '0,86,450000,451000', '靖西县', '30', '451025', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451026', '451000', '0,86,450000,451000', '那坡县', '30', '451026', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451027', '451000', '0,86,450000,451000', '凌云县', '30', '451027', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451028', '451000', '0,86,450000,451000', '乐业县', '30', '451028', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451029', '451000', '0,86,450000,451000', '田林县', '30', '451029', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451030', '451000', '0,86,450000,451000', '西林县', '30', '451030', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451031', '451000', '0,86,450000,451000', '隆林各族自治县', '30', '451031', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451100', '450000', '0,86,450000', '贺州市', '30', '451100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451102', '451100', '0,86,450000,451100', '八步区', '30', '451102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451121', '451100', '0,86,450000,451100', '昭平县', '30', '451121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451122', '451100', '0,86,450000,451100', '钟山县', '30', '451122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451123', '451100', '0,86,450000,451100', '富川瑶族自治县', '30', '451123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451200', '450000', '0,86,450000', '河池市', '30', '451200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451202', '451200', '0,86,450000,451200', '金城江区', '30', '451202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451221', '451200', '0,86,450000,451200', '南丹县', '30', '451221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451222', '451200', '0,86,450000,451200', '天峨县', '30', '451222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451223', '451200', '0,86,450000,451200', '凤山县', '30', '451223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451224', '451200', '0,86,450000,451200', '东兰县', '30', '451224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451225', '451200', '0,86,450000,451200', '罗城仫佬族自治县', '30', '451225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451226', '451200', '0,86,450000,451200', '环江毛南族自治县', '30', '451226', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451227', '451200', '0,86,450000,451200', '巴马瑶族自治县', '30', '451227', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451228', '451200', '0,86,450000,451200', '都安瑶族自治县', '30', '451228', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451229', '451200', '0,86,450000,451200', '大化瑶族自治县', '30', '451229', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451281', '451200', '0,86,450000,451200', '宜州市', '30', '451281', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451300', '450000', '0,86,450000', '来宾市', '30', '451300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451302', '451300', '0,86,450000,451300', '兴宾区', '30', '451302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451321', '451300', '0,86,450000,451300', '忻城县', '30', '451321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451322', '451300', '0,86,450000,451300', '象州县', '30', '451322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451323', '451300', '0,86,450000,451300', '武宣县', '30', '451323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451324', '451300', '0,86,450000,451300', '金秀瑶族自治县', '30', '451324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451381', '451300', '0,86,450000,451300', '合山市', '30', '451381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451400', '450000', '0,86,450000', '崇左市', '30', '451400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451402', '451400', '0,86,450000,451400', '江州区', '30', '451402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451421', '451400', '0,86,450000,451400', '扶绥县', '30', '451421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451422', '451400', '0,86,450000,451400', '宁明县', '30', '451422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451423', '451400', '0,86,450000,451400', '龙州县', '30', '451423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451424', '451400', '0,86,450000,451400', '大新县', '30', '451424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451425', '451400', '0,86,450000,451400', '天等县', '30', '451425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('451481', '451400', '0,86,450000,451400', '凭祥市', '30', '451481', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('460000', '86', '0,86', '海南省', '30', '460000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('460100', '460000', '0,86,460000', '海口市', '30', '460100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('460105', '460100', '0,86,460000,460100', '秀英区', '30', '460105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('460106', '460100', '0,86,460000,460100', '龙华区', '30', '460106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('460107', '460100', '0,86,460000,460100', '琼山区', '30', '460107', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('460108', '460100', '0,86,460000,460100', '美兰区', '30', '460108', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('460200', '460000', '0,86,460000', '三亚市', '30', '460200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('460202', '460200', '0,86,460000,460200', '海棠区', '30', '460202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('460203', '460200', '0,86,460000,460200', '吉阳区', '30', '460203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('460204', '460200', '0,86,460000,460200', '天涯区', '30', '460204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('460205', '460200', '0,86,460000,460200', '崖州区', '30', '460205', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('460300', '460000', '0,86,460000', '三沙市', '30', '460300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('460321', '460300', '0,86,460000,460300', '西沙群岛', '30', '460321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('460322', '460300', '0,86,460000,460300', '南沙群岛', '30', '460322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('460323', '460300', '0,86,460000,460300', '中沙群岛的岛礁及其海域', '30', '460323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('460400', '460000', '0,86,460000', '儋州市', '30', '460400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469001', '460000', '0,86,460000', '五指山市', '30', '469001', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469002', '460000', '0,86,460000', '琼海市', '30', '469002', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469005', '460000', '0,86,460000', '文昌市', '30', '469005', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469006', '460000', '0,86,460000', '万宁市', '30', '469006', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469007', '460000', '0,86,460000', '东方市', '30', '469007', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469021', '460000', '0,86,460000', '定安县', '30', '469021', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469022', '460000', '0,86,460000', '屯昌县', '30', '469022', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469023', '460000', '0,86,460000', '澄迈县', '30', '469023', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469024', '460000', '0,86,460000', '临高县', '30', '469024', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469025', '460000', '0,86,460000', '白沙黎族自治县', '30', '469025', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469026', '460000', '0,86,460000', '昌江黎族自治县', '30', '469026', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469027', '460000', '0,86,460000', '乐东黎族自治县', '30', '469027', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469028', '460000', '0,86,460000', '陵水黎族自治县', '30', '469028', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469029', '460000', '0,86,460000', '保亭黎族苗族自治县', '30', '469029', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469030', '460000', '0,86,460000', '琼中黎族苗族自治县', '30', '469030', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469031', '460000', '0,86,460000', '西沙群岛', '30', '469031', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469032', '460000', '0,86,460000', '南沙群岛', '30', '469032', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('469033', '460000', '0,86,460000', '中沙群岛的岛礁及其海域', '30', '469033', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500000', '86', '0,86', '重庆', '30', '500000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500100', '500000', '0,86,500000', '重庆市', '30', '500100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500101', '500100', '0,86,500000,500100', '万州区', '30', '500101', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500102', '500100', '0,86,500000,500100', '涪陵区', '30', '500102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500103', '500100', '0,86,500000,500100', '渝中区', '30', '500103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500104', '500100', '0,86,500000,500100', '大渡口区', '30', '500104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500105', '500100', '0,86,500000,500100', '江北区', '30', '500105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500106', '500100', '0,86,500000,500100', '沙坪坝区', '30', '500106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500107', '500100', '0,86,500000,500100', '九龙坡区', '30', '500107', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500108', '500100', '0,86,500000,500100', '南岸区', '30', '500108', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500109', '500100', '0,86,500000,500100', '北碚区', '30', '500109', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500110', '500100', '0,86,500000,500100', '綦江区', '30', '500110', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500111', '500100', '0,86,500000,500100', '大足区', '30', '500111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500112', '500100', '0,86,500000,500100', '渝北区', '30', '500112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500113', '500100', '0,86,500000,500100', '巴南区', '30', '500113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500114', '500100', '0,86,500000,500100', '黔江区', '30', '500114', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500115', '500100', '0,86,500000,500100', '长寿区', '30', '500115', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500116', '500100', '0,86,500000,500100', '江津区', '30', '500116', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500117', '500100', '0,86,500000,500100', '合川区', '30', '500117', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500118', '500100', '0,86,500000,500100', '永川区', '30', '500118', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500119', '500100', '0,86,500000,500100', '南川区', '30', '500119', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500120', '500100', '0,86,500000,500100', '璧山区', '30', '500120', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500121', '500100', '0,86,500000,500100', '万盛区', '30', '500121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500122', '500100', '0,86,500000,500100', '双桥区', '30', '500122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500151', '500100', '0,86,500000,500100', '铜梁区', '30', '500151', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500223', '500100', '0,86,500000,500100', '潼南县', '30', '500223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500226', '500100', '0,86,500000,500100', '荣昌县', '30', '500226', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500228', '500100', '0,86,500000,500100', '梁平县', '30', '500228', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500229', '500100', '0,86,500000,500100', '城口县', '30', '500229', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500230', '500100', '0,86,500000,500100', '丰都县', '30', '500230', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500231', '500100', '0,86,500000,500100', '垫江县', '30', '500231', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500232', '500100', '0,86,500000,500100', '武隆县', '30', '500232', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500233', '500100', '0,86,500000,500100', '忠县', '30', '500233', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500234', '500100', '0,86,500000,500100', '开县', '30', '500234', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500235', '500100', '0,86,500000,500100', '云阳县', '30', '500235', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500236', '500100', '0,86,500000,500100', '奉节县', '30', '500236', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500237', '500100', '0,86,500000,500100', '巫山县', '30', '500237', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500238', '500100', '0,86,500000,500100', '巫溪县', '30', '500238', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500240', '500100', '0,86,500000,500100', '石柱土家族自治县', '30', '500240', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500241', '500100', '0,86,500000,500100', '秀山土家族苗族自治县', '30', '500241', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500242', '500100', '0,86,500000,500100', '酉阳土家族苗族自治县', '30', '500242', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('500243', '500100', '0,86,500000,500100', '彭水苗族土家族自治县', '30', '500243', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510000', '86', '0,86', '四川省', '30', '510000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510100', '510000', '0,86,510000', '成都市', '30', '510100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510104', '510100', '0,86,510000,510100', '锦江区', '30', '510104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510105', '510100', '0,86,510000,510100', '青羊区', '30', '510105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510106', '510100', '0,86,510000,510100', '金牛区', '30', '510106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510107', '510100', '0,86,510000,510100', '武侯区', '30', '510107', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510108', '510100', '0,86,510000,510100', '成华区', '30', '510108', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510112', '510100', '0,86,510000,510100', '龙泉驿区', '30', '510112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510113', '510100', '0,86,510000,510100', '青白江区', '30', '510113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510114', '510100', '0,86,510000,510100', '新都区', '30', '510114', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510115', '510100', '0,86,510000,510100', '温江区', '30', '510115', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510121', '510100', '0,86,510000,510100', '金堂县', '30', '510121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510122', '510100', '0,86,510000,510100', '双流县', '30', '510122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510124', '510100', '0,86,510000,510100', '郫县', '30', '510124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510129', '510100', '0,86,510000,510100', '大邑县', '30', '510129', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510131', '510100', '0,86,510000,510100', '蒲江县', '30', '510131', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510132', '510100', '0,86,510000,510100', '新津县', '30', '510132', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510181', '510100', '0,86,510000,510100', '都江堰市', '30', '510181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510182', '510100', '0,86,510000,510100', '彭州市', '30', '510182', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510183', '510100', '0,86,510000,510100', '邛崃市', '30', '510183', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510184', '510100', '0,86,510000,510100', '崇州市', '30', '510184', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510300', '510000', '0,86,510000', '自贡市', '30', '510300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510302', '510300', '0,86,510000,510300', '自流井区', '30', '510302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510303', '510300', '0,86,510000,510300', '贡井区', '30', '510303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510304', '510300', '0,86,510000,510300', '大安区', '30', '510304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510311', '510300', '0,86,510000,510300', '沿滩区', '30', '510311', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510321', '510300', '0,86,510000,510300', '荣县', '30', '510321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510322', '510300', '0,86,510000,510300', '富顺县', '30', '510322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510400', '510000', '0,86,510000', '攀枝花市', '30', '510400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510402', '510400', '0,86,510000,510400', '东区', '30', '510402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510403', '510400', '0,86,510000,510400', '西区', '30', '510403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510411', '510400', '0,86,510000,510400', '仁和区', '30', '510411', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510421', '510400', '0,86,510000,510400', '米易县', '30', '510421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510422', '510400', '0,86,510000,510400', '盐边县', '30', '510422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510500', '510000', '0,86,510000', '泸州市', '30', '510500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510502', '510500', '0,86,510000,510500', '江阳区', '30', '510502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510503', '510500', '0,86,510000,510500', '纳溪区', '30', '510503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510504', '510500', '0,86,510000,510500', '龙马潭区', '30', '510504', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510521', '510500', '0,86,510000,510500', '泸县', '30', '510521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510522', '510500', '0,86,510000,510500', '合江县', '30', '510522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510524', '510500', '0,86,510000,510500', '叙永县', '30', '510524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510525', '510500', '0,86,510000,510500', '古蔺县', '30', '510525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510600', '510000', '0,86,510000', '德阳市', '30', '510600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510603', '510600', '0,86,510000,510600', '旌阳区', '30', '510603', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510623', '510600', '0,86,510000,510600', '中江县', '30', '510623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510626', '510600', '0,86,510000,510600', '罗江县', '30', '510626', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510681', '510600', '0,86,510000,510600', '广汉市', '30', '510681', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510682', '510600', '0,86,510000,510600', '什邡市', '30', '510682', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510683', '510600', '0,86,510000,510600', '绵竹市', '30', '510683', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510700', '510000', '0,86,510000', '绵阳市', '30', '510700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510703', '510700', '0,86,510000,510700', '涪城区', '30', '510703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510704', '510700', '0,86,510000,510700', '游仙区', '30', '510704', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510722', '510700', '0,86,510000,510700', '三台县', '30', '510722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510723', '510700', '0,86,510000,510700', '盐亭县', '30', '510723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510724', '510700', '0,86,510000,510700', '安县', '30', '510724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510725', '510700', '0,86,510000,510700', '梓潼县', '30', '510725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510726', '510700', '0,86,510000,510700', '北川羌族自治县', '30', '510726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510727', '510700', '0,86,510000,510700', '平武县', '30', '510727', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510728', '510700', '0,86,510000,510700', '高新区', '30', '510728', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510781', '510700', '0,86,510000,510700', '江油市', '30', '510781', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510800', '510000', '0,86,510000', '广元市', '30', '510800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510802', '510800', '0,86,510000,510800', '利州区', '30', '510802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510811', '510800', '0,86,510000,510800', '昭化区', '30', '510811', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510812', '510800', '0,86,510000,510800', '朝天区', '30', '510812', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510821', '510800', '0,86,510000,510800', '旺苍县', '30', '510821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510822', '510800', '0,86,510000,510800', '青川县', '30', '510822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510823', '510800', '0,86,510000,510800', '剑阁县', '30', '510823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510824', '510800', '0,86,510000,510800', '苍溪县', '30', '510824', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510900', '510000', '0,86,510000', '遂宁市', '30', '510900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510903', '510900', '0,86,510000,510900', '船山区', '30', '510903', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510904', '510900', '0,86,510000,510900', '安居区', '30', '510904', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510921', '510900', '0,86,510000,510900', '蓬溪县', '30', '510921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510922', '510900', '0,86,510000,510900', '射洪县', '30', '510922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('510923', '510900', '0,86,510000,510900', '大英县', '30', '510923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511000', '510000', '0,86,510000', '内江市', '30', '511000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511002', '511000', '0,86,510000,511000', '市中区', '30', '511002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511011', '511000', '0,86,510000,511000', '东兴区', '30', '511011', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511024', '511000', '0,86,510000,511000', '威远县', '30', '511024', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511025', '511000', '0,86,510000,511000', '资中县', '30', '511025', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511028', '511000', '0,86,510000,511000', '隆昌县', '30', '511028', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511100', '510000', '0,86,510000', '乐山市', '30', '511100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511102', '511100', '0,86,510000,511100', '市中区', '30', '511102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511111', '511100', '0,86,510000,511100', '沙湾区', '30', '511111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511112', '511100', '0,86,510000,511100', '五通桥区', '30', '511112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511113', '511100', '0,86,510000,511100', '金口河区', '30', '511113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511123', '511100', '0,86,510000,511100', '犍为县', '30', '511123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511124', '511100', '0,86,510000,511100', '井研县', '30', '511124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511126', '511100', '0,86,510000,511100', '夹江县', '30', '511126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511129', '511100', '0,86,510000,511100', '沐川县', '30', '511129', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511132', '511100', '0,86,510000,511100', '峨边彝族自治县', '30', '511132', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511133', '511100', '0,86,510000,511100', '马边彝族自治县', '30', '511133', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511181', '511100', '0,86,510000,511100', '峨眉山市', '30', '511181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511300', '510000', '0,86,510000', '南充市', '30', '511300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511302', '511300', '0,86,510000,511300', '顺庆区', '30', '511302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511303', '511300', '0,86,510000,511300', '高坪区', '30', '511303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511304', '511300', '0,86,510000,511300', '嘉陵区', '30', '511304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511321', '511300', '0,86,510000,511300', '南部县', '30', '511321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511322', '511300', '0,86,510000,511300', '营山县', '30', '511322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511323', '511300', '0,86,510000,511300', '蓬安县', '30', '511323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511324', '511300', '0,86,510000,511300', '仪陇县', '30', '511324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511325', '511300', '0,86,510000,511300', '西充县', '30', '511325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511381', '511300', '0,86,510000,511300', '阆中市', '30', '511381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511400', '510000', '0,86,510000', '眉山市', '30', '511400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511402', '511400', '0,86,510000,511400', '东坡区', '30', '511402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511403', '511400', '0,86,510000,511400', '彭山区', '30', '511403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511421', '511400', '0,86,510000,511400', '仁寿县', '30', '511421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511423', '511400', '0,86,510000,511400', '洪雅县', '30', '511423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511424', '511400', '0,86,510000,511400', '丹棱县', '30', '511424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511425', '511400', '0,86,510000,511400', '青神县', '30', '511425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511500', '510000', '0,86,510000', '宜宾市', '30', '511500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511502', '511500', '0,86,510000,511500', '翠屏区', '30', '511502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511503', '511500', '0,86,510000,511500', '南溪区', '30', '511503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511521', '511500', '0,86,510000,511500', '宜宾县', '30', '511521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511523', '511500', '0,86,510000,511500', '江安县', '30', '511523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511524', '511500', '0,86,510000,511500', '长宁县', '30', '511524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511525', '511500', '0,86,510000,511500', '高县', '30', '511525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511526', '511500', '0,86,510000,511500', '珙县', '30', '511526', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511527', '511500', '0,86,510000,511500', '筠连县', '30', '511527', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511528', '511500', '0,86,510000,511500', '兴文县', '30', '511528', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511529', '511500', '0,86,510000,511500', '屏山县', '30', '511529', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511600', '510000', '0,86,510000', '广安市', '30', '511600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511602', '511600', '0,86,510000,511600', '广安区', '30', '511602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511603', '511600', '0,86,510000,511600', '前锋区', '30', '511603', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511621', '511600', '0,86,510000,511600', '岳池县', '30', '511621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511622', '511600', '0,86,510000,511600', '武胜县', '30', '511622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511623', '511600', '0,86,510000,511600', '邻水县', '30', '511623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511681', '511600', '0,86,510000,511600', '华蓥市', '30', '511681', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511682', '511600', '0,86,510000,511600', '市辖区', '30', '511682', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511700', '510000', '0,86,510000', '达州市', '30', '511700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511702', '511700', '0,86,510000,511700', '通川区', '30', '511702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511703', '511700', '0,86,510000,511700', '达川区', '30', '511703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511722', '511700', '0,86,510000,511700', '宣汉县', '30', '511722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511723', '511700', '0,86,510000,511700', '开江县', '30', '511723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511724', '511700', '0,86,510000,511700', '大竹县', '30', '511724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511725', '511700', '0,86,510000,511700', '渠县', '30', '511725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511781', '511700', '0,86,510000,511700', '万源市', '30', '511781', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511800', '510000', '0,86,510000', '雅安市', '30', '511800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511802', '511800', '0,86,510000,511800', '雨城区', '30', '511802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511803', '511800', '0,86,510000,511800', '名山区', '30', '511803', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511822', '511800', '0,86,510000,511800', '荥经县', '30', '511822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511823', '511800', '0,86,510000,511800', '汉源县', '30', '511823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511824', '511800', '0,86,510000,511800', '石棉县', '30', '511824', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511825', '511800', '0,86,510000,511800', '天全县', '30', '511825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511826', '511800', '0,86,510000,511800', '芦山县', '30', '511826', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511827', '511800', '0,86,510000,511800', '宝兴县', '30', '511827', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511900', '510000', '0,86,510000', '巴中市', '30', '511900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511902', '511900', '0,86,510000,511900', '巴州区', '30', '511902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511903', '511900', '0,86,510000,511900', '恩阳区', '30', '511903', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511921', '511900', '0,86,510000,511900', '通江县', '30', '511921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511922', '511900', '0,86,510000,511900', '南江县', '30', '511922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('511923', '511900', '0,86,510000,511900', '平昌县', '30', '511923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('512000', '510000', '0,86,510000', '资阳市', '30', '512000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('512002', '512000', '0,86,510000,512000', '雁江区', '30', '512002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('512021', '512000', '0,86,510000,512000', '安岳县', '30', '512021', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('512022', '512000', '0,86,510000,512000', '乐至县', '30', '512022', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('512081', '512000', '0,86,510000,512000', '简阳市', '30', '512081', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513200', '510000', '0,86,510000', '阿坝藏族羌族自治州', '30', '513200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513221', '513200', '0,86,510000,513200', '汶川县', '30', '513221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513222', '513200', '0,86,510000,513200', '理县', '30', '513222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513223', '513200', '0,86,510000,513200', '茂县', '30', '513223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513224', '513200', '0,86,510000,513200', '松潘县', '30', '513224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513225', '513200', '0,86,510000,513200', '九寨沟县', '30', '513225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513226', '513200', '0,86,510000,513200', '金川县', '30', '513226', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513227', '513200', '0,86,510000,513200', '小金县', '30', '513227', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513228', '513200', '0,86,510000,513200', '黑水县', '30', '513228', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513229', '513200', '0,86,510000,513200', '马尔康县', '30', '513229', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513230', '513200', '0,86,510000,513200', '壤塘县', '30', '513230', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513231', '513200', '0,86,510000,513200', '阿坝县', '30', '513231', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513232', '513200', '0,86,510000,513200', '若尔盖县', '30', '513232', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513233', '513200', '0,86,510000,513200', '红原县', '30', '513233', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513300', '510000', '0,86,510000', '甘孜藏族自治州', '30', '513300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513301', '513300', '0,86,510000,513300', '康定市', '30', '513301', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513322', '513300', '0,86,510000,513300', '泸定县', '30', '513322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513323', '513300', '0,86,510000,513300', '丹巴县', '30', '513323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513324', '513300', '0,86,510000,513300', '九龙县', '30', '513324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513325', '513300', '0,86,510000,513300', '雅江县', '30', '513325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513326', '513300', '0,86,510000,513300', '道孚县', '30', '513326', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513327', '513300', '0,86,510000,513300', '炉霍县', '30', '513327', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513328', '513300', '0,86,510000,513300', '甘孜县', '30', '513328', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513329', '513300', '0,86,510000,513300', '新龙县', '30', '513329', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513330', '513300', '0,86,510000,513300', '德格县', '30', '513330', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513331', '513300', '0,86,510000,513300', '白玉县', '30', '513331', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513332', '513300', '0,86,510000,513300', '石渠县', '30', '513332', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513333', '513300', '0,86,510000,513300', '色达县', '30', '513333', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513334', '513300', '0,86,510000,513300', '理塘县', '30', '513334', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513335', '513300', '0,86,510000,513300', '巴塘县', '30', '513335', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513336', '513300', '0,86,510000,513300', '乡城县', '30', '513336', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513337', '513300', '0,86,510000,513300', '稻城县', '30', '513337', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513338', '513300', '0,86,510000,513300', '得荣县', '30', '513338', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513400', '510000', '0,86,510000', '凉山彝族自治州', '30', '513400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513401', '513400', '0,86,510000,513400', '西昌市', '30', '513401', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513422', '513400', '0,86,510000,513400', '木里藏族自治县', '30', '513422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513423', '513400', '0,86,510000,513400', '盐源县', '30', '513423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513424', '513400', '0,86,510000,513400', '德昌县', '30', '513424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513425', '513400', '0,86,510000,513400', '会理县', '30', '513425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513426', '513400', '0,86,510000,513400', '会东县', '30', '513426', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513427', '513400', '0,86,510000,513400', '宁南县', '30', '513427', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513428', '513400', '0,86,510000,513400', '普格县', '30', '513428', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513429', '513400', '0,86,510000,513400', '布拖县', '30', '513429', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513430', '513400', '0,86,510000,513400', '金阳县', '30', '513430', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513431', '513400', '0,86,510000,513400', '昭觉县', '30', '513431', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513432', '513400', '0,86,510000,513400', '喜德县', '30', '513432', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513433', '513400', '0,86,510000,513400', '冕宁县', '30', '513433', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513434', '513400', '0,86,510000,513400', '越西县', '30', '513434', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513435', '513400', '0,86,510000,513400', '甘洛县', '30', '513435', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513436', '513400', '0,86,510000,513400', '美姑县', '30', '513436', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('513437', '513400', '0,86,510000,513400', '雷波县', '30', '513437', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520000', '86', '0,86', '贵州省', '30', '520000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520100', '520000', '0,86,520000', '贵阳市', '30', '520100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520102', '520100', '0,86,520000,520100', '南明区', '30', '520102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520103', '520100', '0,86,520000,520100', '云岩区', '30', '520103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520111', '520100', '0,86,520000,520100', '花溪区', '30', '520111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520112', '520100', '0,86,520000,520100', '乌当区', '30', '520112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520113', '520100', '0,86,520000,520100', '白云区', '30', '520113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520114', '520100', '0,86,520000,520100', '小河区', '30', '520114', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520115', '520100', '0,86,520000,520100', '观山湖区', '30', '520115', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520121', '520100', '0,86,520000,520100', '开阳县', '30', '520121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520122', '520100', '0,86,520000,520100', '息烽县', '30', '520122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520123', '520100', '0,86,520000,520100', '修文县', '30', '520123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520181', '520100', '0,86,520000,520100', '清镇市', '30', '520181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520200', '520000', '0,86,520000', '六盘水市', '30', '520200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520201', '520200', '0,86,520000,520200', '钟山区', '30', '520201', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520203', '520200', '0,86,520000,520200', '六枝特区', '30', '520203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520221', '520200', '0,86,520000,520200', '水城县', '30', '520221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520222', '520200', '0,86,520000,520200', '盘县', '30', '520222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520300', '520000', '0,86,520000', '遵义市', '30', '520300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520302', '520300', '0,86,520000,520300', '红花岗区', '30', '520302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520303', '520300', '0,86,520000,520300', '汇川区', '30', '520303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520321', '520300', '0,86,520000,520300', '遵义县', '30', '520321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520322', '520300', '0,86,520000,520300', '桐梓县', '30', '520322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520323', '520300', '0,86,520000,520300', '绥阳县', '30', '520323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520324', '520300', '0,86,520000,520300', '正安县', '30', '520324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520325', '520300', '0,86,520000,520300', '道真仡佬族苗族自治县', '30', '520325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520326', '520300', '0,86,520000,520300', '务川仡佬族苗族自治县', '30', '520326', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520327', '520300', '0,86,520000,520300', '凤冈县', '30', '520327', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520328', '520300', '0,86,520000,520300', '湄潭县', '30', '520328', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520329', '520300', '0,86,520000,520300', '余庆县', '30', '520329', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520330', '520300', '0,86,520000,520300', '习水县', '30', '520330', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520381', '520300', '0,86,520000,520300', '赤水市', '30', '520381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520382', '520300', '0,86,520000,520300', '仁怀市', '30', '520382', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520400', '520000', '0,86,520000', '安顺市', '30', '520400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520402', '520400', '0,86,520000,520400', '西秀区', '30', '520402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520403', '520400', '0,86,520000,520400', '平坝区', '30', '520403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520422', '520400', '0,86,520000,520400', '普定县', '30', '520422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520423', '520400', '0,86,520000,520400', '镇宁布依族苗族自治县', '30', '520423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520424', '520400', '0,86,520000,520400', '关岭布依族苗族自治县', '30', '520424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520425', '520400', '0,86,520000,520400', '紫云苗族布依族自治县', '30', '520425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520500', '520000', '0,86,520000', '毕节市', '30', '520500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520502', '520500', '0,86,520000,520500', '七星关区', '30', '520502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520521', '520500', '0,86,520000,520500', '大方县', '30', '520521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520522', '520500', '0,86,520000,520500', '黔西县', '30', '520522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520523', '520500', '0,86,520000,520500', '金沙县', '30', '520523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520524', '520500', '0,86,520000,520500', '织金县', '30', '520524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520525', '520500', '0,86,520000,520500', '纳雍县', '30', '520525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520526', '520500', '0,86,520000,520500', '威宁彝族回族苗族自治县', '30', '520526', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520527', '520500', '0,86,520000,520500', '赫章县', '30', '520527', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520600', '520000', '0,86,520000', '铜仁市', '30', '520600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520602', '520600', '0,86,520000,520600', '碧江区', '30', '520602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520603', '520600', '0,86,520000,520600', '万山区', '30', '520603', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520621', '520600', '0,86,520000,520600', '江口县', '30', '520621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520622', '520600', '0,86,520000,520600', '玉屏侗族自治县', '30', '520622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520623', '520600', '0,86,520000,520600', '石阡县', '30', '520623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520624', '520600', '0,86,520000,520600', '思南县', '30', '520624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520625', '520600', '0,86,520000,520600', '印江土家族苗族自治县', '30', '520625', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520626', '520600', '0,86,520000,520600', '德江县', '30', '520626', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520627', '520600', '0,86,520000,520600', '沿河土家族自治县', '30', '520627', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('520628', '520600', '0,86,520000,520600', '松桃苗族自治县', '30', '520628', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522300', '520000', '0,86,520000', '黔西南布依族苗族自治州', '30', '522300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522301', '522300', '0,86,520000,522300', '兴义市', '30', '522301', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522322', '522300', '0,86,520000,522300', '兴仁县', '30', '522322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522323', '522300', '0,86,520000,522300', '普安县', '30', '522323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522324', '522300', '0,86,520000,522300', '晴隆县', '30', '522324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522325', '522300', '0,86,520000,522300', '贞丰县', '30', '522325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522326', '522300', '0,86,520000,522300', '望谟县', '30', '522326', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522327', '522300', '0,86,520000,522300', '册亨县', '30', '522327', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522328', '522300', '0,86,520000,522300', '安龙县', '30', '522328', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522600', '520000', '0,86,520000', '黔东南苗族侗族自治州', '30', '522600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522601', '522600', '0,86,520000,522600', '凯里市', '30', '522601', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522622', '522600', '0,86,520000,522600', '黄平县', '30', '522622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522623', '522600', '0,86,520000,522600', '施秉县', '30', '522623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522624', '522600', '0,86,520000,522600', '三穗县', '30', '522624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522625', '522600', '0,86,520000,522600', '镇远县', '30', '522625', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522626', '522600', '0,86,520000,522600', '岑巩县', '30', '522626', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522627', '522600', '0,86,520000,522600', '天柱县', '30', '522627', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522628', '522600', '0,86,520000,522600', '锦屏县', '30', '522628', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522629', '522600', '0,86,520000,522600', '剑河县', '30', '522629', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522630', '522600', '0,86,520000,522600', '台江县', '30', '522630', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522631', '522600', '0,86,520000,522600', '黎平县', '30', '522631', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522632', '522600', '0,86,520000,522600', '榕江县', '30', '522632', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522633', '522600', '0,86,520000,522600', '从江县', '30', '522633', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522634', '522600', '0,86,520000,522600', '雷山县', '30', '522634', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522635', '522600', '0,86,520000,522600', '麻江县', '30', '522635', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522636', '522600', '0,86,520000,522600', '丹寨县', '30', '522636', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522700', '520000', '0,86,520000', '黔南布依族苗族自治州', '30', '522700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522701', '522700', '0,86,520000,522700', '都匀市', '30', '522701', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522702', '522700', '0,86,520000,522700', '福泉市', '30', '522702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522722', '522700', '0,86,520000,522700', '荔波县', '30', '522722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522723', '522700', '0,86,520000,522700', '贵定县', '30', '522723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522725', '522700', '0,86,520000,522700', '瓮安县', '30', '522725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522726', '522700', '0,86,520000,522700', '独山县', '30', '522726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522727', '522700', '0,86,520000,522700', '平塘县', '30', '522727', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522728', '522700', '0,86,520000,522700', '罗甸县', '30', '522728', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522729', '522700', '0,86,520000,522700', '长顺县', '30', '522729', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522730', '522700', '0,86,520000,522700', '龙里县', '30', '522730', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522731', '522700', '0,86,520000,522700', '惠水县', '30', '522731', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('522732', '522700', '0,86,520000,522700', '三都水族自治县', '30', '522732', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530000', '86', '0,86', '云南省', '30', '530000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530100', '530000', '0,86,530000', '昆明市', '30', '530100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530102', '530100', '0,86,530000,530100', '五华区', '30', '530102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530103', '530100', '0,86,530000,530100', '盘龙区', '30', '530103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530111', '530100', '0,86,530000,530100', '官渡区', '30', '530111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530112', '530100', '0,86,530000,530100', '西山区', '30', '530112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530113', '530100', '0,86,530000,530100', '东川区', '30', '530113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530114', '530100', '0,86,530000,530100', '呈贡区', '30', '530114', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530122', '530100', '0,86,530000,530100', '晋宁县', '30', '530122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530124', '530100', '0,86,530000,530100', '富民县', '30', '530124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530125', '530100', '0,86,530000,530100', '宜良县', '30', '530125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530126', '530100', '0,86,530000,530100', '石林彝族自治县', '30', '530126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530127', '530100', '0,86,530000,530100', '嵩明县', '30', '530127', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530128', '530100', '0,86,530000,530100', '禄劝彝族苗族自治县', '30', '530128', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530129', '530100', '0,86,530000,530100', '寻甸回族彝族自治县', '30', '530129', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530181', '530100', '0,86,530000,530100', '安宁市', '30', '530181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530300', '530000', '0,86,530000', '曲靖市', '30', '530300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530302', '530300', '0,86,530000,530300', '麒麟区', '30', '530302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530321', '530300', '0,86,530000,530300', '马龙县', '30', '530321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530322', '530300', '0,86,530000,530300', '陆良县', '30', '530322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530323', '530300', '0,86,530000,530300', '师宗县', '30', '530323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530324', '530300', '0,86,530000,530300', '罗平县', '30', '530324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530325', '530300', '0,86,530000,530300', '富源县', '30', '530325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530326', '530300', '0,86,530000,530300', '会泽县', '30', '530326', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530328', '530300', '0,86,530000,530300', '沾益县', '30', '530328', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530381', '530300', '0,86,530000,530300', '宣威市', '30', '530381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530400', '530000', '0,86,530000', '玉溪市', '30', '530400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530402', '530400', '0,86,530000,530400', '红塔区', '30', '530402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530421', '530400', '0,86,530000,530400', '江川县', '30', '530421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530422', '530400', '0,86,530000,530400', '澄江县', '30', '530422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530423', '530400', '0,86,530000,530400', '通海县', '30', '530423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530424', '530400', '0,86,530000,530400', '华宁县', '30', '530424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530425', '530400', '0,86,530000,530400', '易门县', '30', '530425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530426', '530400', '0,86,530000,530400', '峨山彝族自治县', '30', '530426', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530427', '530400', '0,86,530000,530400', '新平彝族傣族自治县', '30', '530427', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530428', '530400', '0,86,530000,530400', '元江哈尼族彝族傣族自治县', '30', '530428', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530500', '530000', '0,86,530000', '保山市', '30', '530500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530502', '530500', '0,86,530000,530500', '隆阳区', '30', '530502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530521', '530500', '0,86,530000,530500', '施甸县', '30', '530521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530522', '530500', '0,86,530000,530500', '腾冲县', '30', '530522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530523', '530500', '0,86,530000,530500', '龙陵县', '30', '530523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530524', '530500', '0,86,530000,530500', '昌宁县', '30', '530524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530600', '530000', '0,86,530000', '昭通市', '30', '530600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530602', '530600', '0,86,530000,530600', '昭阳区', '30', '530602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530621', '530600', '0,86,530000,530600', '鲁甸县', '30', '530621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530622', '530600', '0,86,530000,530600', '巧家县', '30', '530622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530623', '530600', '0,86,530000,530600', '盐津县', '30', '530623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530624', '530600', '0,86,530000,530600', '大关县', '30', '530624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530625', '530600', '0,86,530000,530600', '永善县', '30', '530625', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530626', '530600', '0,86,530000,530600', '绥江县', '30', '530626', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530627', '530600', '0,86,530000,530600', '镇雄县', '30', '530627', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530628', '530600', '0,86,530000,530600', '彝良县', '30', '530628', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530629', '530600', '0,86,530000,530600', '威信县', '30', '530629', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530630', '530600', '0,86,530000,530600', '水富县', '30', '530630', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530700', '530000', '0,86,530000', '丽江市', '30', '530700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530702', '530700', '0,86,530000,530700', '古城区', '30', '530702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530721', '530700', '0,86,530000,530700', '玉龙纳西族自治县', '30', '530721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530722', '530700', '0,86,530000,530700', '永胜县', '30', '530722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530723', '530700', '0,86,530000,530700', '华坪县', '30', '530723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530724', '530700', '0,86,530000,530700', '宁蒗彝族自治县', '30', '530724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530800', '530000', '0,86,530000', '普洱市', '30', '530800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530802', '530800', '0,86,530000,530800', '思茅区', '30', '530802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530821', '530800', '0,86,530000,530800', '宁洱哈尼族彝族自治县', '30', '530821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530822', '530800', '0,86,530000,530800', '墨江哈尼族自治县', '30', '530822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530823', '530800', '0,86,530000,530800', '景东彝族自治县', '30', '530823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530824', '530800', '0,86,530000,530800', '景谷傣族彝族自治县', '30', '530824', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530825', '530800', '0,86,530000,530800', '镇沅彝族哈尼族拉祜族自治县', '30', '530825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530826', '530800', '0,86,530000,530800', '江城哈尼族彝族自治县', '30', '530826', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530827', '530800', '0,86,530000,530800', '孟连傣族拉祜族佤族自治县', '30', '530827', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530828', '530800', '0,86,530000,530800', '澜沧拉祜族自治县', '30', '530828', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530829', '530800', '0,86,530000,530800', '西盟佤族自治县', '30', '530829', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530900', '530000', '0,86,530000', '临沧市', '30', '530900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530902', '530900', '0,86,530000,530900', '临翔区', '30', '530902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530921', '530900', '0,86,530000,530900', '凤庆县', '30', '530921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530922', '530900', '0,86,530000,530900', '云县', '30', '530922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530923', '530900', '0,86,530000,530900', '永德县', '30', '530923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530924', '530900', '0,86,530000,530900', '镇康县', '30', '530924', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530925', '530900', '0,86,530000,530900', '双江拉祜族佤族布朗族傣族自治县', '30', '530925', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530926', '530900', '0,86,530000,530900', '耿马傣族佤族自治县', '30', '530926', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('530927', '530900', '0,86,530000,530900', '沧源佤族自治县', '30', '530927', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532300', '530000', '0,86,530000', '楚雄彝族自治州', '30', '532300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532301', '532300', '0,86,530000,532300', '楚雄市', '30', '532301', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532322', '532300', '0,86,530000,532300', '双柏县', '30', '532322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532323', '532300', '0,86,530000,532300', '牟定县', '30', '532323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532324', '532300', '0,86,530000,532300', '南华县', '30', '532324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532325', '532300', '0,86,530000,532300', '姚安县', '30', '532325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532326', '532300', '0,86,530000,532300', '大姚县', '30', '532326', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532327', '532300', '0,86,530000,532300', '永仁县', '30', '532327', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532328', '532300', '0,86,530000,532300', '元谋县', '30', '532328', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532329', '532300', '0,86,530000,532300', '武定县', '30', '532329', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532331', '532300', '0,86,530000,532300', '禄丰县', '30', '532331', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532500', '530000', '0,86,530000', '红河哈尼族彝族自治州', '30', '532500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532501', '532500', '0,86,530000,532500', '个旧市', '30', '532501', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532502', '532500', '0,86,530000,532500', '开远市', '30', '532502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532503', '532500', '0,86,530000,532500', '蒙自市', '30', '532503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532504', '532500', '0,86,530000,532500', '弥勒市', '30', '532504', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532523', '532500', '0,86,530000,532500', '屏边苗族自治县', '30', '532523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532524', '532500', '0,86,530000,532500', '建水县', '30', '532524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532525', '532500', '0,86,530000,532500', '石屏县', '30', '532525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532527', '532500', '0,86,530000,532500', '泸西县', '30', '532527', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532528', '532500', '0,86,530000,532500', '元阳县', '30', '532528', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532529', '532500', '0,86,530000,532500', '红河县', '30', '532529', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532530', '532500', '0,86,530000,532500', '金平苗族瑶族傣族自治县', '30', '532530', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532531', '532500', '0,86,530000,532500', '绿春县', '30', '532531', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532532', '532500', '0,86,530000,532500', '河口瑶族自治县', '30', '532532', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532600', '530000', '0,86,530000', '文山壮族苗族自治州', '30', '532600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532601', '532600', '0,86,530000,532600', '文山市', '30', '532601', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532622', '532600', '0,86,530000,532600', '砚山县', '30', '532622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532623', '532600', '0,86,530000,532600', '西畴县', '30', '532623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532624', '532600', '0,86,530000,532600', '麻栗坡县', '30', '532624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532625', '532600', '0,86,530000,532600', '马关县', '30', '532625', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532626', '532600', '0,86,530000,532600', '丘北县', '30', '532626', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532627', '532600', '0,86,530000,532600', '广南县', '30', '532627', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532628', '532600', '0,86,530000,532600', '富宁县', '30', '532628', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532800', '530000', '0,86,530000', '西双版纳傣族自治州', '30', '532800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532801', '532800', '0,86,530000,532800', '景洪市', '30', '532801', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532822', '532800', '0,86,530000,532800', '勐海县', '30', '532822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532823', '532800', '0,86,530000,532800', '勐腊县', '30', '532823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532900', '530000', '0,86,530000', '大理白族自治州', '30', '532900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532901', '532900', '0,86,530000,532900', '大理市', '30', '532901', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532922', '532900', '0,86,530000,532900', '漾濞彝族自治县', '30', '532922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532923', '532900', '0,86,530000,532900', '祥云县', '30', '532923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532924', '532900', '0,86,530000,532900', '宾川县', '30', '532924', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532925', '532900', '0,86,530000,532900', '弥渡县', '30', '532925', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532926', '532900', '0,86,530000,532900', '南涧彝族自治县', '30', '532926', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532927', '532900', '0,86,530000,532900', '巍山彝族回族自治县', '30', '532927', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532928', '532900', '0,86,530000,532900', '永平县', '30', '532928', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532929', '532900', '0,86,530000,532900', '云龙县', '30', '532929', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532930', '532900', '0,86,530000,532900', '洱源县', '30', '532930', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532931', '532900', '0,86,530000,532900', '剑川县', '30', '532931', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('532932', '532900', '0,86,530000,532900', '鹤庆县', '30', '532932', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('533100', '530000', '0,86,530000', '德宏傣族景颇族自治州', '30', '533100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('533102', '533100', '0,86,530000,533100', '瑞丽市', '30', '533102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('533103', '533100', '0,86,530000,533100', '芒市', '30', '533103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('533122', '533100', '0,86,530000,533100', '梁河县', '30', '533122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('533123', '533100', '0,86,530000,533100', '盈江县', '30', '533123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('533124', '533100', '0,86,530000,533100', '陇川县', '30', '533124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('533300', '530000', '0,86,530000', '怒江傈僳族自治州', '30', '533300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('533321', '533300', '0,86,530000,533300', '泸水县', '30', '533321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('533323', '533300', '0,86,530000,533300', '福贡县', '30', '533323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('533324', '533300', '0,86,530000,533300', '贡山独龙族怒族自治县', '30', '533324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('533325', '533300', '0,86,530000,533300', '兰坪白族普米族自治县', '30', '533325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('533400', '530000', '0,86,530000', '迪庆藏族自治州', '30', '533400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('533401', '533400', '0,86,530000,533400', '香格里拉市', '30', '533401', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('533422', '533400', '0,86,530000,533400', '德钦县', '30', '533422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('533423', '533400', '0,86,530000,533400', '维西傈僳族自治县', '30', '533423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540000', '86', '0,86', '西藏自治区', '30', '540000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540100', '540000', '0,86,540000', '拉萨市', '30', '540100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540102', '540100', '0,86,540000,540100', '城关区', '30', '540102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540121', '540100', '0,86,540000,540100', '林周县', '30', '540121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540122', '540100', '0,86,540000,540100', '当雄县', '30', '540122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540123', '540100', '0,86,540000,540100', '尼木县', '30', '540123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540124', '540100', '0,86,540000,540100', '曲水县', '30', '540124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540125', '540100', '0,86,540000,540100', '堆龙德庆县', '30', '540125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540126', '540100', '0,86,540000,540100', '达孜县', '30', '540126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540127', '540100', '0,86,540000,540100', '墨竹工卡县', '30', '540127', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540200', '540000', '0,86,540000', '日喀则市', '30', '540200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540202', '540200', '0,86,540000,540200', '桑珠孜区', '30', '540202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540221', '540200', '0,86,540000,540200', '南木林县', '30', '540221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540222', '540200', '0,86,540000,540200', '江孜县', '30', '540222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540223', '540200', '0,86,540000,540200', '定日县', '30', '540223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540224', '540200', '0,86,540000,540200', '萨迦县', '30', '540224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540225', '540200', '0,86,540000,540200', '拉孜县', '30', '540225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540226', '540200', '0,86,540000,540200', '昂仁县', '30', '540226', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540227', '540200', '0,86,540000,540200', '谢通门县', '30', '540227', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540228', '540200', '0,86,540000,540200', '白朗县', '30', '540228', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540229', '540200', '0,86,540000,540200', '仁布县', '30', '540229', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540230', '540200', '0,86,540000,540200', '康马县', '30', '540230', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540231', '540200', '0,86,540000,540200', '定结县', '30', '540231', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540232', '540200', '0,86,540000,540200', '仲巴县', '30', '540232', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540233', '540200', '0,86,540000,540200', '亚东县', '30', '540233', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540234', '540200', '0,86,540000,540200', '吉隆县', '30', '540234', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540235', '540200', '0,86,540000,540200', '聂拉木县', '30', '540235', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540236', '540200', '0,86,540000,540200', '萨嘎县', '30', '540236', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540237', '540200', '0,86,540000,540200', '岗巴县', '30', '540237', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540300', '540000', '0,86,540000', '昌都市', '30', '540300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540302', '540300', '0,86,540000,540300', '卡若区', '30', '540302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540321', '540300', '0,86,540000,540300', '江达县', '30', '540321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540322', '540300', '0,86,540000,540300', '贡觉县', '30', '540322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540323', '540300', '0,86,540000,540300', '类乌齐县', '30', '540323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540324', '540300', '0,86,540000,540300', '丁青县', '30', '540324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540325', '540300', '0,86,540000,540300', '察雅县', '30', '540325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540326', '540300', '0,86,540000,540300', '八宿县', '30', '540326', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540327', '540300', '0,86,540000,540300', '左贡县', '30', '540327', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540328', '540300', '0,86,540000,540300', '芒康县', '30', '540328', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540329', '540300', '0,86,540000,540300', '洛隆县', '30', '540329', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('540330', '540300', '0,86,540000,540300', '边坝县', '30', '540330', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542200', '540000', '0,86,540000', '山南地区', '30', '542200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542221', '542200', '0,86,540000,542200', '乃东县', '30', '542221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542222', '542200', '0,86,540000,542200', '扎囊县', '30', '542222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542223', '542200', '0,86,540000,542200', '贡嘎县', '30', '542223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542224', '542200', '0,86,540000,542200', '桑日县', '30', '542224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542225', '542200', '0,86,540000,542200', '琼结县', '30', '542225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542226', '542200', '0,86,540000,542200', '曲松县', '30', '542226', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542227', '542200', '0,86,540000,542200', '措美县', '30', '542227', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542228', '542200', '0,86,540000,542200', '洛扎县', '30', '542228', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542229', '542200', '0,86,540000,542200', '加查县', '30', '542229', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542231', '542200', '0,86,540000,542200', '隆子县', '30', '542231', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542232', '542200', '0,86,540000,542200', '错那县', '30', '542232', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542233', '542200', '0,86,540000,542200', '浪卡子县', '30', '542233', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542400', '540000', '0,86,540000', '那曲地区', '30', '542400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542421', '542400', '0,86,540000,542400', '那曲县', '30', '542421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542422', '542400', '0,86,540000,542400', '嘉黎县', '30', '542422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542423', '542400', '0,86,540000,542400', '比如县', '30', '542423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542424', '542400', '0,86,540000,542400', '聂荣县', '30', '542424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542425', '542400', '0,86,540000,542400', '安多县', '30', '542425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542426', '542400', '0,86,540000,542400', '申扎县', '30', '542426', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542427', '542400', '0,86,540000,542400', '索县', '30', '542427', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542428', '542400', '0,86,540000,542400', '班戈县', '30', '542428', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542429', '542400', '0,86,540000,542400', '巴青县', '30', '542429', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542430', '542400', '0,86,540000,542400', '尼玛县', '30', '542430', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542431', '542400', '0,86,540000,542400', '双湖县', '30', '542431', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542500', '540000', '0,86,540000', '阿里地区', '30', '542500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542521', '542500', '0,86,540000,542500', '普兰县', '30', '542521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542522', '542500', '0,86,540000,542500', '札达县', '30', '542522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542523', '542500', '0,86,540000,542500', '噶尔县', '30', '542523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542524', '542500', '0,86,540000,542500', '日土县', '30', '542524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542525', '542500', '0,86,540000,542500', '革吉县', '30', '542525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542526', '542500', '0,86,540000,542500', '改则县', '30', '542526', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542527', '542500', '0,86,540000,542500', '措勤县', '30', '542527', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542600', '540000', '0,86,540000', '林芝市', '30', '542600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542621', '542600', '0,86,540000,542600', '巴宜区', '30', '542621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542622', '542600', '0,86,540000,542600', '工布江达县', '30', '542622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542623', '542600', '0,86,540000,542600', '米林县', '30', '542623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542624', '542600', '0,86,540000,542600', '墨脱县', '30', '542624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542625', '542600', '0,86,540000,542600', '波密县', '30', '542625', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542626', '542600', '0,86,540000,542600', '察隅县', '30', '542626', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('542627', '542600', '0,86,540000,542600', '朗县', '30', '542627', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610000', '86', '0,86', '陕西省', '30', '610000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610100', '610000', '0,86,610000', '西安市', '30', '610100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610102', '610100', '0,86,610000,610100', '新城区', '30', '610102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610103', '610100', '0,86,610000,610100', '碑林区', '30', '610103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610104', '610100', '0,86,610000,610100', '莲湖区', '30', '610104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610111', '610100', '0,86,610000,610100', '灞桥区', '30', '610111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610112', '610100', '0,86,610000,610100', '未央区', '30', '610112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610113', '610100', '0,86,610000,610100', '雁塔区', '30', '610113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610114', '610100', '0,86,610000,610100', '阎良区', '30', '610114', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610115', '610100', '0,86,610000,610100', '临潼区', '30', '610115', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610116', '610100', '0,86,610000,610100', '长安区', '30', '610116', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610117', '610100', '0,86,610000,610100', '高陵区', '30', '610117', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610122', '610100', '0,86,610000,610100', '蓝田县', '30', '610122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610124', '610100', '0,86,610000,610100', '周至县', '30', '610124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610125', '610100', '0,86,610000,610100', '户县', '30', '610125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610126', '610100', '0,86,610000,610100', '高陵区', '30', '610126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610200', '610000', '0,86,610000', '铜川市', '30', '610200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610202', '610200', '0,86,610000,610200', '王益区', '30', '610202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610203', '610200', '0,86,610000,610200', '印台区', '30', '610203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610204', '610200', '0,86,610000,610200', '耀州区', '30', '610204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610222', '610200', '0,86,610000,610200', '宜君县', '30', '610222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610300', '610000', '0,86,610000', '宝鸡市', '30', '610300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610302', '610300', '0,86,610000,610300', '渭滨区', '30', '610302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610303', '610300', '0,86,610000,610300', '金台区', '30', '610303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610304', '610300', '0,86,610000,610300', '陈仓区', '30', '610304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610322', '610300', '0,86,610000,610300', '凤翔县', '30', '610322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610323', '610300', '0,86,610000,610300', '岐山县', '30', '610323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610324', '610300', '0,86,610000,610300', '扶风县', '30', '610324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610326', '610300', '0,86,610000,610300', '眉县', '30', '610326', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610327', '610300', '0,86,610000,610300', '陇县', '30', '610327', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610328', '610300', '0,86,610000,610300', '千阳县', '30', '610328', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610329', '610300', '0,86,610000,610300', '麟游县', '30', '610329', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610330', '610300', '0,86,610000,610300', '凤县', '30', '610330', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610331', '610300', '0,86,610000,610300', '太白县', '30', '610331', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610400', '610000', '0,86,610000', '咸阳市', '30', '610400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610402', '610400', '0,86,610000,610400', '秦都区', '30', '610402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610403', '610400', '0,86,610000,610400', '杨陵区', '30', '610403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610404', '610400', '0,86,610000,610400', '渭城区', '30', '610404', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610422', '610400', '0,86,610000,610400', '三原县', '30', '610422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610423', '610400', '0,86,610000,610400', '泾阳县', '30', '610423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610424', '610400', '0,86,610000,610400', '乾县', '30', '610424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610425', '610400', '0,86,610000,610400', '礼泉县', '30', '610425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610426', '610400', '0,86,610000,610400', '永寿县', '30', '610426', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610427', '610400', '0,86,610000,610400', '彬县', '30', '610427', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610428', '610400', '0,86,610000,610400', '长武县', '30', '610428', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610429', '610400', '0,86,610000,610400', '旬邑县', '30', '610429', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610430', '610400', '0,86,610000,610400', '淳化县', '30', '610430', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610431', '610400', '0,86,610000,610400', '武功县', '30', '610431', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610481', '610400', '0,86,610000,610400', '兴平市', '30', '610481', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610500', '610000', '0,86,610000', '渭南市', '30', '610500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610502', '610500', '0,86,610000,610500', '临渭区', '30', '610502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610521', '610500', '0,86,610000,610500', '华县', '30', '610521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610522', '610500', '0,86,610000,610500', '潼关县', '30', '610522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610523', '610500', '0,86,610000,610500', '大荔县', '30', '610523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610524', '610500', '0,86,610000,610500', '合阳县', '30', '610524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610525', '610500', '0,86,610000,610500', '澄城县', '30', '610525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610526', '610500', '0,86,610000,610500', '蒲城县', '30', '610526', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610527', '610500', '0,86,610000,610500', '白水县', '30', '610527', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610528', '610500', '0,86,610000,610500', '富平县', '30', '610528', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610581', '610500', '0,86,610000,610500', '韩城市', '30', '610581', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610582', '610500', '0,86,610000,610500', '华阴市', '30', '610582', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610600', '610000', '0,86,610000', '延安市', '30', '610600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610602', '610600', '0,86,610000,610600', '宝塔区', '30', '610602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610621', '610600', '0,86,610000,610600', '延长县', '30', '610621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610622', '610600', '0,86,610000,610600', '延川县', '30', '610622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610623', '610600', '0,86,610000,610600', '子长县', '30', '610623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610624', '610600', '0,86,610000,610600', '安塞县', '30', '610624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610625', '610600', '0,86,610000,610600', '志丹县', '30', '610625', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610626', '610600', '0,86,610000,610600', '吴起县', '30', '610626', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610627', '610600', '0,86,610000,610600', '甘泉县', '30', '610627', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610628', '610600', '0,86,610000,610600', '富县', '30', '610628', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610629', '610600', '0,86,610000,610600', '洛川县', '30', '610629', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610630', '610600', '0,86,610000,610600', '宜川县', '30', '610630', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610631', '610600', '0,86,610000,610600', '黄龙县', '30', '610631', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610632', '610600', '0,86,610000,610600', '黄陵县', '30', '610632', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610700', '610000', '0,86,610000', '汉中市', '30', '610700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610702', '610700', '0,86,610000,610700', '汉台区', '30', '610702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610721', '610700', '0,86,610000,610700', '南郑县', '30', '610721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610722', '610700', '0,86,610000,610700', '城固县', '30', '610722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610723', '610700', '0,86,610000,610700', '洋县', '30', '610723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610724', '610700', '0,86,610000,610700', '西乡县', '30', '610724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610725', '610700', '0,86,610000,610700', '勉县', '30', '610725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610726', '610700', '0,86,610000,610700', '宁强县', '30', '610726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610727', '610700', '0,86,610000,610700', '略阳县', '30', '610727', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610728', '610700', '0,86,610000,610700', '镇巴县', '30', '610728', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610729', '610700', '0,86,610000,610700', '留坝县', '30', '610729', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610730', '610700', '0,86,610000,610700', '佛坪县', '30', '610730', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610800', '610000', '0,86,610000', '榆林市', '30', '610800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610802', '610800', '0,86,610000,610800', '榆阳区', '30', '610802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610821', '610800', '0,86,610000,610800', '神木县', '30', '610821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610822', '610800', '0,86,610000,610800', '府谷县', '30', '610822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610823', '610800', '0,86,610000,610800', '横山县', '30', '610823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610824', '610800', '0,86,610000,610800', '靖边县', '30', '610824', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610825', '610800', '0,86,610000,610800', '定边县', '30', '610825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610826', '610800', '0,86,610000,610800', '绥德县', '30', '610826', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610827', '610800', '0,86,610000,610800', '米脂县', '30', '610827', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610828', '610800', '0,86,610000,610800', '佳县', '30', '610828', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610829', '610800', '0,86,610000,610800', '吴堡县', '30', '610829', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610830', '610800', '0,86,610000,610800', '清涧县', '30', '610830', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610831', '610800', '0,86,610000,610800', '子洲县', '30', '610831', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610900', '610000', '0,86,610000', '安康市', '30', '610900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610902', '610900', '0,86,610000,610900', '汉滨区', '30', '610902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610921', '610900', '0,86,610000,610900', '汉阴县', '30', '610921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610922', '610900', '0,86,610000,610900', '石泉县', '30', '610922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610923', '610900', '0,86,610000,610900', '宁陕县', '30', '610923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610924', '610900', '0,86,610000,610900', '紫阳县', '30', '610924', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610925', '610900', '0,86,610000,610900', '岚皋县', '30', '610925', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610926', '610900', '0,86,610000,610900', '平利县', '30', '610926', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610927', '610900', '0,86,610000,610900', '镇坪县', '30', '610927', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610928', '610900', '0,86,610000,610900', '旬阳县', '30', '610928', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('610929', '610900', '0,86,610000,610900', '白河县', '30', '610929', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('611000', '610000', '0,86,610000', '商洛市', '30', '611000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('611002', '611000', '0,86,610000,611000', '商州区', '30', '611002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('611021', '611000', '0,86,610000,611000', '洛南县', '30', '611021', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('611022', '611000', '0,86,610000,611000', '丹凤县', '30', '611022', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('611023', '611000', '0,86,610000,611000', '商南县', '30', '611023', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('611024', '611000', '0,86,610000,611000', '山阳县', '30', '611024', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('611025', '611000', '0,86,610000,611000', '镇安县', '30', '611025', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('611026', '611000', '0,86,610000,611000', '柞水县', '30', '611026', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620000', '86', '0,86', '甘肃省', '30', '620000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620100', '620000', '0,86,620000', '兰州市', '30', '620100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620102', '620100', '0,86,620000,620100', '城关区', '30', '620102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620103', '620100', '0,86,620000,620100', '七里河区', '30', '620103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620104', '620100', '0,86,620000,620100', '西固区', '30', '620104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620105', '620100', '0,86,620000,620100', '安宁区', '30', '620105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620111', '620100', '0,86,620000,620100', '红古区', '30', '620111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620121', '620100', '0,86,620000,620100', '永登县', '30', '620121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620122', '620100', '0,86,620000,620100', '皋兰县', '30', '620122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620123', '620100', '0,86,620000,620100', '榆中县', '30', '620123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620200', '620000', '0,86,620000', '嘉峪关市', '30', '620200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620300', '620000', '0,86,620000', '金昌市', '30', '620300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620302', '620300', '0,86,620000,620300', '金川区', '30', '620302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620321', '620300', '0,86,620000,620300', '永昌县', '30', '620321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620400', '620000', '0,86,620000', '白银市', '30', '620400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620402', '620400', '0,86,620000,620400', '白银区', '30', '620402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620403', '620400', '0,86,620000,620400', '平川区', '30', '620403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620421', '620400', '0,86,620000,620400', '靖远县', '30', '620421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620422', '620400', '0,86,620000,620400', '会宁县', '30', '620422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620423', '620400', '0,86,620000,620400', '景泰县', '30', '620423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620500', '620000', '0,86,620000', '天水市', '30', '620500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620502', '620500', '0,86,620000,620500', '秦州区', '30', '620502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620503', '620500', '0,86,620000,620500', '麦积区', '30', '620503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620521', '620500', '0,86,620000,620500', '清水县', '30', '620521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620522', '620500', '0,86,620000,620500', '秦安县', '30', '620522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620523', '620500', '0,86,620000,620500', '甘谷县', '30', '620523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620524', '620500', '0,86,620000,620500', '武山县', '30', '620524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620525', '620500', '0,86,620000,620500', '张家川回族自治县', '30', '620525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620600', '620000', '0,86,620000', '武威市', '30', '620600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620602', '620600', '0,86,620000,620600', '凉州区', '30', '620602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620621', '620600', '0,86,620000,620600', '民勤县', '30', '620621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620622', '620600', '0,86,620000,620600', '古浪县', '30', '620622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620623', '620600', '0,86,620000,620600', '天祝藏族自治县', '30', '620623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620700', '620000', '0,86,620000', '张掖市', '30', '620700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620702', '620700', '0,86,620000,620700', '甘州区', '30', '620702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620721', '620700', '0,86,620000,620700', '肃南裕固族自治县', '30', '620721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620722', '620700', '0,86,620000,620700', '民乐县', '30', '620722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620723', '620700', '0,86,620000,620700', '临泽县', '30', '620723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620724', '620700', '0,86,620000,620700', '高台县', '30', '620724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620725', '620700', '0,86,620000,620700', '山丹县', '30', '620725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620800', '620000', '0,86,620000', '平凉市', '30', '620800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620802', '620800', '0,86,620000,620800', '崆峒区', '30', '620802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620821', '620800', '0,86,620000,620800', '泾川县', '30', '620821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620822', '620800', '0,86,620000,620800', '灵台县', '30', '620822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620823', '620800', '0,86,620000,620800', '崇信县', '30', '620823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620824', '620800', '0,86,620000,620800', '华亭县', '30', '620824', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620825', '620800', '0,86,620000,620800', '庄浪县', '30', '620825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620826', '620800', '0,86,620000,620800', '静宁县', '30', '620826', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620900', '620000', '0,86,620000', '酒泉市', '30', '620900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620902', '620900', '0,86,620000,620900', '肃州区', '30', '620902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620921', '620900', '0,86,620000,620900', '金塔县', '30', '620921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620922', '620900', '0,86,620000,620900', '瓜州县', '30', '620922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620923', '620900', '0,86,620000,620900', '肃北蒙古族自治县', '30', '620923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620924', '620900', '0,86,620000,620900', '阿克塞哈萨克族自治县', '30', '620924', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620981', '620900', '0,86,620000,620900', '玉门市', '30', '620981', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('620982', '620900', '0,86,620000,620900', '敦煌市', '30', '620982', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621000', '620000', '0,86,620000', '庆阳市', '30', '621000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621002', '621000', '0,86,620000,621000', '西峰区', '30', '621002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621021', '621000', '0,86,620000,621000', '庆城县', '30', '621021', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621022', '621000', '0,86,620000,621000', '环县', '30', '621022', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621023', '621000', '0,86,620000,621000', '华池县', '30', '621023', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621024', '621000', '0,86,620000,621000', '合水县', '30', '621024', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621025', '621000', '0,86,620000,621000', '正宁县', '30', '621025', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621026', '621000', '0,86,620000,621000', '宁县', '30', '621026', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621027', '621000', '0,86,620000,621000', '镇原县', '30', '621027', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621100', '620000', '0,86,620000', '定西市', '30', '621100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621102', '621100', '0,86,620000,621100', '安定区', '30', '621102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621121', '621100', '0,86,620000,621100', '通渭县', '30', '621121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621122', '621100', '0,86,620000,621100', '陇西县', '30', '621122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621123', '621100', '0,86,620000,621100', '渭源县', '30', '621123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621124', '621100', '0,86,620000,621100', '临洮县', '30', '621124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621125', '621100', '0,86,620000,621100', '漳县', '30', '621125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621126', '621100', '0,86,620000,621100', '岷县', '30', '621126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621200', '620000', '0,86,620000', '陇南市', '30', '621200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621202', '621200', '0,86,620000,621200', '武都区', '30', '621202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621221', '621200', '0,86,620000,621200', '成县', '30', '621221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621222', '621200', '0,86,620000,621200', '文县', '30', '621222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621223', '621200', '0,86,620000,621200', '宕昌县', '30', '621223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621224', '621200', '0,86,620000,621200', '康县', '30', '621224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621225', '621200', '0,86,620000,621200', '西和县', '30', '621225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621226', '621200', '0,86,620000,621200', '礼县', '30', '621226', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621227', '621200', '0,86,620000,621200', '徽县', '30', '621227', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('621228', '621200', '0,86,620000,621200', '两当县', '30', '621228', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('622900', '620000', '0,86,620000', '临夏回族自治州', '30', '622900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('622901', '622900', '0,86,620000,622900', '临夏市', '30', '622901', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('622921', '622900', '0,86,620000,622900', '临夏县', '30', '622921', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('622922', '622900', '0,86,620000,622900', '康乐县', '30', '622922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('622923', '622900', '0,86,620000,622900', '永靖县', '30', '622923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('622924', '622900', '0,86,620000,622900', '广河县', '30', '622924', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('622925', '622900', '0,86,620000,622900', '和政县', '30', '622925', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('622926', '622900', '0,86,620000,622900', '东乡族自治县', '30', '622926', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('622927', '622900', '0,86,620000,622900', '积石山保安族东乡族撒拉族自治县', '30', '622927', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('623000', '620000', '0,86,620000', '甘南藏族自治州', '30', '623000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('623001', '623000', '0,86,620000,623000', '合作市', '30', '623001', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('623021', '623000', '0,86,620000,623000', '临潭县', '30', '623021', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('623022', '623000', '0,86,620000,623000', '卓尼县', '30', '623022', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('623023', '623000', '0,86,620000,623000', '舟曲县', '30', '623023', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('623024', '623000', '0,86,620000,623000', '迭部县', '30', '623024', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('623025', '623000', '0,86,620000,623000', '玛曲县', '30', '623025', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('623026', '623000', '0,86,620000,623000', '碌曲县', '30', '623026', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('623027', '623000', '0,86,620000,623000', '夏河县', '30', '623027', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('630000', '86', '0,86', '青海省', '30', '630000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('630100', '630000', '0,86,630000', '西宁市', '30', '630100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('630102', '630100', '0,86,630000,630100', '城东区', '30', '630102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('630103', '630100', '0,86,630000,630100', '城中区', '30', '630103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('630104', '630100', '0,86,630000,630100', '城西区', '30', '630104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('630105', '630100', '0,86,630000,630100', '城北区', '30', '630105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('630121', '630100', '0,86,630000,630100', '大通回族土族自治县', '30', '630121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('630122', '630100', '0,86,630000,630100', '湟中县', '30', '630122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('630123', '630100', '0,86,630000,630100', '湟源县', '30', '630123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('630200', '630000', '0,86,630000', '海东市', '30', '630200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('630202', '630200', '0,86,630000,630200', '乐都区', '30', '630202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('630203', '630200', '0,86,630000,630200', '平安区', '30', '630203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('630222', '630200', '0,86,630000,630200', '民和回族土族自治县', '30', '630222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('630223', '630200', '0,86,630000,630200', '互助土族自治县', '30', '630223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('630224', '630200', '0,86,630000,630200', '化隆回族自治县', '30', '630224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('630225', '630200', '0,86,630000,630200', '循化撒拉族自治县', '30', '630225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632200', '630000', '0,86,630000', '海北藏族自治州', '30', '632200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632221', '632200', '0,86,630000,632200', '门源回族自治县', '30', '632221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632222', '632200', '0,86,630000,632200', '祁连县', '30', '632222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632223', '632200', '0,86,630000,632200', '海晏县', '30', '632223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632224', '632200', '0,86,630000,632200', '刚察县', '30', '632224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632300', '630000', '0,86,630000', '黄南藏族自治州', '30', '632300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632321', '632300', '0,86,630000,632300', '同仁县', '30', '632321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632322', '632300', '0,86,630000,632300', '尖扎县', '30', '632322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632323', '632300', '0,86,630000,632300', '泽库县', '30', '632323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632324', '632300', '0,86,630000,632300', '河南蒙古族自治县', '30', '632324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632500', '630000', '0,86,630000', '海南藏族自治州', '30', '632500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632521', '632500', '0,86,630000,632500', '共和县', '30', '632521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632522', '632500', '0,86,630000,632500', '同德县', '30', '632522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632523', '632500', '0,86,630000,632500', '贵德县', '30', '632523', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632524', '632500', '0,86,630000,632500', '兴海县', '30', '632524', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632525', '632500', '0,86,630000,632500', '贵南县', '30', '632525', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632600', '630000', '0,86,630000', '果洛藏族自治州', '30', '632600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632621', '632600', '0,86,630000,632600', '玛沁县', '30', '632621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632622', '632600', '0,86,630000,632600', '班玛县', '30', '632622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632623', '632600', '0,86,630000,632600', '甘德县', '30', '632623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632624', '632600', '0,86,630000,632600', '达日县', '30', '632624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632625', '632600', '0,86,630000,632600', '久治县', '30', '632625', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632626', '632600', '0,86,630000,632600', '玛多县', '30', '632626', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632700', '630000', '0,86,630000', '玉树藏族自治州', '30', '632700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632701', '632700', '0,86,630000,632700', '玉树市', '30', '632701', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632722', '632700', '0,86,630000,632700', '杂多县', '30', '632722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632723', '632700', '0,86,630000,632700', '称多县', '30', '632723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632724', '632700', '0,86,630000,632700', '治多县', '30', '632724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632725', '632700', '0,86,630000,632700', '囊谦县', '30', '632725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632726', '632700', '0,86,630000,632700', '曲麻莱县', '30', '632726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632800', '630000', '0,86,630000', '海西蒙古族藏族自治州', '30', '632800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632801', '632800', '0,86,630000,632800', '格尔木市', '30', '632801', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632802', '632800', '0,86,630000,632800', '德令哈市', '30', '632802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632821', '632800', '0,86,630000,632800', '乌兰县', '30', '632821', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632822', '632800', '0,86,630000,632800', '都兰县', '30', '632822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632823', '632800', '0,86,630000,632800', '天峻县', '30', '632823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('632825', '632800', '0,86,630000,632800', '海西蒙古族藏族自治州直辖', '30', '632825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640000', '86', '0,86', '宁夏回族自治区', '30', '640000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640100', '640000', '0,86,640000', '银川市', '30', '640100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640104', '640100', '0,86,640000,640100', '兴庆区', '30', '640104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640105', '640100', '0,86,640000,640100', '西夏区', '30', '640105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640106', '640100', '0,86,640000,640100', '金凤区', '30', '640106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640121', '640100', '0,86,640000,640100', '永宁县', '30', '640121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640122', '640100', '0,86,640000,640100', '贺兰县', '30', '640122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640181', '640100', '0,86,640000,640100', '灵武市', '30', '640181', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640200', '640000', '0,86,640000', '石嘴山市', '30', '640200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640202', '640200', '0,86,640000,640200', '大武口区', '30', '640202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640205', '640200', '0,86,640000,640200', '惠农区', '30', '640205', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640221', '640200', '0,86,640000,640200', '平罗县', '30', '640221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640300', '640000', '0,86,640000', '吴忠市', '30', '640300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640302', '640300', '0,86,640000,640300', '利通区', '30', '640302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640303', '640300', '0,86,640000,640300', '红寺堡区', '30', '640303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640323', '640300', '0,86,640000,640300', '盐池县', '30', '640323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640324', '640300', '0,86,640000,640300', '同心县', '30', '640324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640381', '640300', '0,86,640000,640300', '青铜峡市', '30', '640381', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640400', '640000', '0,86,640000', '固原市', '30', '640400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640402', '640400', '0,86,640000,640400', '原州区', '30', '640402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640422', '640400', '0,86,640000,640400', '西吉县', '30', '640422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640423', '640400', '0,86,640000,640400', '隆德县', '30', '640423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640424', '640400', '0,86,640000,640400', '泾源县', '30', '640424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640425', '640400', '0,86,640000,640400', '彭阳县', '30', '640425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640500', '640000', '0,86,640000', '中卫市', '30', '640500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640502', '640500', '0,86,640000,640500', '沙坡头区', '30', '640502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640521', '640500', '0,86,640000,640500', '中宁县', '30', '640521', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('640522', '640500', '0,86,640000,640500', '海原县', '30', '640522', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('650000', '86', '0,86', '新疆维吾尔族自治区', '30', '650000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('650100', '650000', '0,86,650000', '乌鲁木齐市', '30', '650100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('650102', '650100', '0,86,650000,650100', '天山区', '30', '650102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('650103', '650100', '0,86,650000,650100', '沙依巴克区', '30', '650103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('650104', '650100', '0,86,650000,650100', '新市区', '30', '650104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('650105', '650100', '0,86,650000,650100', '水磨沟区', '30', '650105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('650106', '650100', '0,86,650000,650100', '头屯河区', '30', '650106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('650107', '650100', '0,86,650000,650100', '达坂城区', '30', '650107', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('650108', '650100', '0,86,650000,650100', '东山区', '30', '650108', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('650109', '650100', '0,86,650000,650100', '米东区', '30', '650109', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('650121', '650100', '0,86,650000,650100', '乌鲁木齐县', '30', '650121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('650200', '650000', '0,86,650000', '克拉玛依市', '30', '650200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('650202', '650200', '0,86,650000,650200', '独山子区', '30', '650202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('650203', '650200', '0,86,650000,650200', '克拉玛依区', '30', '650203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('650204', '650200', '0,86,650000,650200', '白碱滩区', '30', '650204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('650205', '650200', '0,86,650000,650200', '乌尔禾区', '30', '650205', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652100', '650000', '0,86,650000', '吐鲁番市', '30', '652100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652101', '652100', '0,86,650000,652100', '高昌区', '30', '652101', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652122', '652100', '0,86,650000,652100', '鄯善县', '30', '652122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652123', '652100', '0,86,650000,652100', '托克逊县', '30', '652123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652200', '650000', '0,86,650000', '哈密地区', '30', '652200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652201', '652200', '0,86,650000,652200', '哈密市', '30', '652201', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652222', '652200', '0,86,650000,652200', '巴里坤哈萨克自治县', '30', '652222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652223', '652200', '0,86,650000,652200', '伊吾县', '30', '652223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652300', '650000', '0,86,650000', '昌吉回族自治州', '30', '652300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652301', '652300', '0,86,650000,652300', '昌吉市', '30', '652301', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652302', '652300', '0,86,650000,652300', '阜康市', '30', '652302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652303', '652300', '0,86,650000,652300', '米泉市', '30', '652303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652323', '652300', '0,86,650000,652300', '呼图壁县', '30', '652323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652324', '652300', '0,86,650000,652300', '玛纳斯县', '30', '652324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652325', '652300', '0,86,650000,652300', '奇台县', '30', '652325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652327', '652300', '0,86,650000,652300', '吉木萨尔县', '30', '652327', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652328', '652300', '0,86,650000,652300', '木垒哈萨克自治县', '30', '652328', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652700', '650000', '0,86,650000', '博尔塔拉蒙古自治州', '30', '652700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652701', '652700', '0,86,650000,652700', '博乐市', '30', '652701', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652702', '652700', '0,86,650000,652700', '阿拉山口市', '30', '652702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652722', '652700', '0,86,650000,652700', '精河县', '30', '652722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652723', '652700', '0,86,650000,652700', '温泉县', '30', '652723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652800', '650000', '0,86,650000', '巴音郭楞蒙古自治州', '30', '652800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652801', '652800', '0,86,650000,652800', '库尔勒市', '30', '652801', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652822', '652800', '0,86,650000,652800', '轮台县', '30', '652822', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652823', '652800', '0,86,650000,652800', '尉犁县', '30', '652823', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652824', '652800', '0,86,650000,652800', '若羌县', '30', '652824', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652825', '652800', '0,86,650000,652800', '且末县', '30', '652825', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652826', '652800', '0,86,650000,652800', '焉耆回族自治县', '30', '652826', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652827', '652800', '0,86,650000,652800', '和静县', '30', '652827', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652828', '652800', '0,86,650000,652800', '和硕县', '30', '652828', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652829', '652800', '0,86,650000,652800', '博湖县', '30', '652829', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652900', '650000', '0,86,650000', '阿克苏地区', '30', '652900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652901', '652900', '0,86,650000,652900', '阿克苏市', '30', '652901', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652922', '652900', '0,86,650000,652900', '温宿县', '30', '652922', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652923', '652900', '0,86,650000,652900', '库车县', '30', '652923', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652924', '652900', '0,86,650000,652900', '沙雅县', '30', '652924', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652925', '652900', '0,86,650000,652900', '新和县', '30', '652925', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652926', '652900', '0,86,650000,652900', '拜城县', '30', '652926', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652927', '652900', '0,86,650000,652900', '乌什县', '30', '652927', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652928', '652900', '0,86,650000,652900', '阿瓦提县', '30', '652928', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('652929', '652900', '0,86,650000,652900', '柯坪县', '30', '652929', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653000', '650000', '0,86,650000', '克孜勒苏柯尔克孜自治州', '30', '653000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653001', '653000', '0,86,650000,653000', '阿图什市', '30', '653001', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653022', '653000', '0,86,650000,653000', '阿克陶县', '30', '653022', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653023', '653000', '0,86,650000,653000', '阿合奇县', '30', '653023', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653024', '653000', '0,86,650000,653000', '乌恰县', '30', '653024', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653100', '650000', '0,86,650000', '喀什地区', '30', '653100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653101', '653100', '0,86,650000,653100', '喀什市', '30', '653101', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653121', '653100', '0,86,650000,653100', '疏附县', '30', '653121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653122', '653100', '0,86,650000,653100', '疏勒县', '30', '653122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653123', '653100', '0,86,650000,653100', '英吉沙县', '30', '653123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653124', '653100', '0,86,650000,653100', '泽普县', '30', '653124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653125', '653100', '0,86,650000,653100', '莎车县', '30', '653125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653126', '653100', '0,86,650000,653100', '叶城县', '30', '653126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653127', '653100', '0,86,650000,653100', '麦盖提县', '30', '653127', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653128', '653100', '0,86,650000,653100', '岳普湖县', '30', '653128', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653129', '653100', '0,86,650000,653100', '伽师县', '30', '653129', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653130', '653100', '0,86,650000,653100', '巴楚县', '30', '653130', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653131', '653100', '0,86,650000,653100', '塔什库尔干塔吉克自治县', '30', '653131', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653200', '650000', '0,86,650000', '和田地区', '30', '653200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653201', '653200', '0,86,650000,653200', '和田市', '30', '653201', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653221', '653200', '0,86,650000,653200', '和田县', '30', '653221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653222', '653200', '0,86,650000,653200', '墨玉县', '30', '653222', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653223', '653200', '0,86,650000,653200', '皮山县', '30', '653223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653224', '653200', '0,86,650000,653200', '洛浦县', '30', '653224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653225', '653200', '0,86,650000,653200', '策勒县', '30', '653225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653226', '653200', '0,86,650000,653200', '于田县', '30', '653226', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('653227', '653200', '0,86,650000,653200', '民丰县', '30', '653227', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654000', '650000', '0,86,650000', '伊犁哈萨克自治州', '30', '654000', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654002', '654000', '0,86,650000,654000', '伊宁市', '30', '654002', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654003', '654000', '0,86,650000,654000', '奎屯市', '30', '654003', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654004', '654000', '0,86,650000,654000', '霍尔果斯市', '30', '654004', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654021', '654000', '0,86,650000,654000', '伊宁县', '30', '654021', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654022', '654000', '0,86,650000,654000', '察布查尔锡伯自治县', '30', '654022', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654023', '654000', '0,86,650000,654000', '霍城县', '30', '654023', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654024', '654000', '0,86,650000,654000', '巩留县', '30', '654024', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654025', '654000', '0,86,650000,654000', '新源县', '30', '654025', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654026', '654000', '0,86,650000,654000', '昭苏县', '30', '654026', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654027', '654000', '0,86,650000,654000', '特克斯县', '30', '654027', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654028', '654000', '0,86,650000,654000', '尼勒克县', '30', '654028', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654200', '650000', '0,86,650000', '塔城地区', '30', '654200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654201', '654200', '0,86,650000,654200', '塔城市', '30', '654201', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654202', '654200', '0,86,650000,654200', '乌苏市', '30', '654202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654221', '654200', '0,86,650000,654200', '额敏县', '30', '654221', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654223', '654200', '0,86,650000,654200', '沙湾县', '30', '654223', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654224', '654200', '0,86,650000,654200', '托里县', '30', '654224', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654225', '654200', '0,86,650000,654200', '裕民县', '30', '654225', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654226', '654200', '0,86,650000,654200', '和布克赛尔蒙古自治县', '30', '654226', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654300', '650000', '0,86,650000', '阿勒泰地区', '30', '654300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654301', '654300', '0,86,650000,654300', '阿勒泰市', '30', '654301', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654321', '654300', '0,86,650000,654300', '布尔津县', '30', '654321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654322', '654300', '0,86,650000,654300', '富蕴县', '30', '654322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654323', '654300', '0,86,650000,654300', '福海县', '30', '654323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654324', '654300', '0,86,650000,654300', '哈巴河县', '30', '654324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654325', '654300', '0,86,650000,654300', '青河县', '30', '654325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('654326', '654300', '0,86,650000,654300', '吉木乃县', '30', '654326', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('659001', '650000', '0,86,650000', '石河子市', '30', '659001', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('659002', '650000', '0,86,650000', '阿拉尔市', '30', '659002', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('659003', '650000', '0,86,650000', '图木舒克市', '30', '659003', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('659004', '650000', '0,86,650000', '五家渠市', '30', '659004', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('659005', '650000', '0,86,650000', '北屯市', '30', '659005', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('659006', '650000', '0,86,650000', '铁门关市', '30', '659006', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('659007', '650000', '0,86,650000', '双河市', '30', '659007', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('659008', '650000', '0,86,650000', '可克达拉市', '30', '659008', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710000', '86', '0,86', '台湾', '30', '710000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710100', '710000', '0,86,710000', '台北市', '30', '710100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710101', '710100', '0,86,710000,710100', '中正区', '30', '710101', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710102', '710100', '0,86,710000,710100', '大同区', '30', '710102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710103', '710100', '0,86,710000,710100', '中山区', '30', '710103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710104', '710100', '0,86,710000,710100', '松山区', '30', '710104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710105', '710100', '0,86,710000,710100', '大安区', '30', '710105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710106', '710100', '0,86,710000,710100', '万华区', '30', '710106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710107', '710100', '0,86,710000,710100', '信义区', '30', '710107', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710108', '710100', '0,86,710000,710100', '士林区', '30', '710108', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710109', '710100', '0,86,710000,710100', '北投区', '30', '710109', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710110', '710100', '0,86,710000,710100', '内湖区', '30', '710110', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710111', '710100', '0,86,710000,710100', '南港区', '30', '710111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710112', '710100', '0,86,710000,710100', '文山区', '30', '710112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710113', '710100', '0,86,710000,710100', '其他区', '30', '710113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710200', '710000', '0,86,710000', '高雄市', '30', '710200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710201', '710200', '0,86,710000,710200', '新兴区', '30', '710201', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710202', '710200', '0,86,710000,710200', '前金区', '30', '710202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710203', '710200', '0,86,710000,710200', '芩雅区', '30', '710203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710204', '710200', '0,86,710000,710200', '盐埕区', '30', '710204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710205', '710200', '0,86,710000,710200', '鼓山区', '30', '710205', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710206', '710200', '0,86,710000,710200', '旗津区', '30', '710206', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710207', '710200', '0,86,710000,710200', '前镇区', '30', '710207', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710208', '710200', '0,86,710000,710200', '三民区', '30', '710208', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710209', '710200', '0,86,710000,710200', '左营区', '30', '710209', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710210', '710200', '0,86,710000,710200', '楠梓区', '30', '710210', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710211', '710200', '0,86,710000,710200', '小港区', '30', '710211', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710241', '710200', '0,86,710000,710200', '苓雅区', '30', '710241', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710242', '710200', '0,86,710000,710200', '仁武区', '30', '710242', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710243', '710200', '0,86,710000,710200', '大社区', '30', '710243', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710244', '710200', '0,86,710000,710200', '冈山区', '30', '710244', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710245', '710200', '0,86,710000,710200', '路竹区', '30', '710245', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710246', '710200', '0,86,710000,710200', '阿莲区', '30', '710246', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710247', '710200', '0,86,710000,710200', '田寮区', '30', '710247', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710248', '710200', '0,86,710000,710200', '燕巢区', '30', '710248', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710249', '710200', '0,86,710000,710200', '桥头区', '30', '710249', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710250', '710200', '0,86,710000,710200', '梓官区', '30', '710250', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710251', '710200', '0,86,710000,710200', '弥陀区', '30', '710251', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710252', '710200', '0,86,710000,710200', '永安区', '30', '710252', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710253', '710200', '0,86,710000,710200', '湖内区', '30', '710253', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710254', '710200', '0,86,710000,710200', '凤山区', '30', '710254', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710255', '710200', '0,86,710000,710200', '大寮区', '30', '710255', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710256', '710200', '0,86,710000,710200', '林园区', '30', '710256', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710257', '710200', '0,86,710000,710200', '鸟松区', '30', '710257', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710258', '710200', '0,86,710000,710200', '大树区', '30', '710258', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710259', '710200', '0,86,710000,710200', '旗山区', '30', '710259', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710260', '710200', '0,86,710000,710200', '美浓区', '30', '710260', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710261', '710200', '0,86,710000,710200', '六龟区', '30', '710261', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710262', '710200', '0,86,710000,710200', '内门区', '30', '710262', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710263', '710200', '0,86,710000,710200', '杉林区', '30', '710263', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710264', '710200', '0,86,710000,710200', '甲仙区', '30', '710264', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710265', '710200', '0,86,710000,710200', '桃源区', '30', '710265', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710266', '710200', '0,86,710000,710200', '那玛夏区', '30', '710266', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710267', '710200', '0,86,710000,710200', '茂林区', '30', '710267', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710268', '710200', '0,86,710000,710200', '茄萣区', '30', '710268', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710300', '710000', '0,86,710000', '台南市', '30', '710300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710301', '710300', '0,86,710000,710300', '中西区', '30', '710301', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710302', '710300', '0,86,710000,710300', '东区', '30', '710302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710303', '710300', '0,86,710000,710300', '南区', '30', '710303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710304', '710300', '0,86,710000,710300', '北区', '30', '710304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710305', '710300', '0,86,710000,710300', '安平区', '30', '710305', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710306', '710300', '0,86,710000,710300', '安南区', '30', '710306', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710307', '710300', '0,86,710000,710300', '永康区', '30', '710307', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710308', '710300', '0,86,710000,710300', '归仁区', '30', '710308', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710309', '710300', '0,86,710000,710300', '新化区', '30', '710309', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710310', '710300', '0,86,710000,710300', '左镇区', '30', '710310', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710311', '710300', '0,86,710000,710300', '玉井区', '30', '710311', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710312', '710300', '0,86,710000,710300', '楠西区', '30', '710312', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710313', '710300', '0,86,710000,710300', '南化区', '30', '710313', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710314', '710300', '0,86,710000,710300', '仁德区', '30', '710314', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710315', '710300', '0,86,710000,710300', '关庙区', '30', '710315', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710316', '710300', '0,86,710000,710300', '龙崎区', '30', '710316', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710317', '710300', '0,86,710000,710300', '官田区', '30', '710317', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710318', '710300', '0,86,710000,710300', '麻豆区', '30', '710318', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710319', '710300', '0,86,710000,710300', '佳里区', '30', '710319', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710320', '710300', '0,86,710000,710300', '西港区', '30', '710320', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710321', '710300', '0,86,710000,710300', '七股区', '30', '710321', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710322', '710300', '0,86,710000,710300', '将军区', '30', '710322', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710323', '710300', '0,86,710000,710300', '学甲区', '30', '710323', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710324', '710300', '0,86,710000,710300', '北门区', '30', '710324', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710325', '710300', '0,86,710000,710300', '新营区', '30', '710325', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710326', '710300', '0,86,710000,710300', '后壁区', '30', '710326', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710327', '710300', '0,86,710000,710300', '白河区', '30', '710327', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710328', '710300', '0,86,710000,710300', '东山区', '30', '710328', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710329', '710300', '0,86,710000,710300', '六甲区', '30', '710329', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710330', '710300', '0,86,710000,710300', '下营区', '30', '710330', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710331', '710300', '0,86,710000,710300', '柳营区', '30', '710331', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710332', '710300', '0,86,710000,710300', '盐水区', '30', '710332', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710333', '710300', '0,86,710000,710300', '善化区', '30', '710333', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710334', '710300', '0,86,710000,710300', '大内区', '30', '710334', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710335', '710300', '0,86,710000,710300', '山上区', '30', '710335', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710336', '710300', '0,86,710000,710300', '新市区', '30', '710336', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710337', '710300', '0,86,710000,710300', '安定区', '30', '710337', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710338', '710300', '0,86,710000,710300', '其他区', '30', '710338', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710400', '710000', '0,86,710000', '台中市', '30', '710400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710401', '710400', '0,86,710000,710400', '中区', '30', '710401', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710402', '710400', '0,86,710000,710400', '东区', '30', '710402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710403', '710400', '0,86,710000,710400', '南区', '30', '710403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710404', '710400', '0,86,710000,710400', '西区', '30', '710404', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710405', '710400', '0,86,710000,710400', '北区', '30', '710405', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710406', '710400', '0,86,710000,710400', '北屯区', '30', '710406', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710407', '710400', '0,86,710000,710400', '西屯区', '30', '710407', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710408', '710400', '0,86,710000,710400', '南屯区', '30', '710408', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710409', '710400', '0,86,710000,710400', '太平区', '30', '710409', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710410', '710400', '0,86,710000,710400', '大里区', '30', '710410', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710411', '710400', '0,86,710000,710400', '雾峰区', '30', '710411', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710412', '710400', '0,86,710000,710400', '乌日区', '30', '710412', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710413', '710400', '0,86,710000,710400', '丰原区', '30', '710413', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710414', '710400', '0,86,710000,710400', '后里区', '30', '710414', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710415', '710400', '0,86,710000,710400', '石冈区', '30', '710415', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710416', '710400', '0,86,710000,710400', '东势区', '30', '710416', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710417', '710400', '0,86,710000,710400', '和平区', '30', '710417', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710418', '710400', '0,86,710000,710400', '新社区', '30', '710418', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710419', '710400', '0,86,710000,710400', '潭子区', '30', '710419', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710420', '710400', '0,86,710000,710400', '大雅区', '30', '710420', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710421', '710400', '0,86,710000,710400', '神冈区', '30', '710421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710422', '710400', '0,86,710000,710400', '大肚区', '30', '710422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710423', '710400', '0,86,710000,710400', '沙鹿区', '30', '710423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710424', '710400', '0,86,710000,710400', '龙井区', '30', '710424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710425', '710400', '0,86,710000,710400', '梧栖区', '30', '710425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710426', '710400', '0,86,710000,710400', '清水区', '30', '710426', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710427', '710400', '0,86,710000,710400', '大甲区', '30', '710427', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710428', '710400', '0,86,710000,710400', '外埔区', '30', '710428', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710429', '710400', '0,86,710000,710400', '大安区', '30', '710429', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710430', '710400', '0,86,710000,710400', '其他区', '30', '710430', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710500', '710000', '0,86,710000', '金门县', '30', '710500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710501', '710500', '0,86,710000,710500', '金沙镇', '30', '710501', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710502', '710500', '0,86,710000,710500', '金湖镇', '30', '710502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710503', '710500', '0,86,710000,710500', '金宁乡', '30', '710503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710504', '710500', '0,86,710000,710500', '金城镇', '30', '710504', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710505', '710500', '0,86,710000,710500', '烈屿乡', '30', '710505', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710506', '710500', '0,86,710000,710500', '乌坵乡', '30', '710506', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710600', '710000', '0,86,710000', '南投县', '30', '710600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710601', '710600', '0,86,710000,710600', '南投市', '30', '710601', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710602', '710600', '0,86,710000,710600', '中寮乡', '30', '710602', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710603', '710600', '0,86,710000,710600', '草屯镇', '30', '710603', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710604', '710600', '0,86,710000,710600', '国姓乡', '30', '710604', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710605', '710600', '0,86,710000,710600', '铺里镇', '30', '710605', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710606', '710600', '0,86,710000,710600', '仁爱乡', '30', '710606', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710607', '710600', '0,86,710000,710600', '民间乡', '30', '710607', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710608', '710600', '0,86,710000,710600', '集集镇', '30', '710608', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710609', '710600', '0,86,710000,710600', '水里乡', '30', '710609', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710610', '710600', '0,86,710000,710600', '鱼池乡', '30', '710610', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710611', '710600', '0,86,710000,710600', '信义乡', '30', '710611', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710612', '710600', '0,86,710000,710600', '竹山镇', '30', '710612', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710613', '710600', '0,86,710000,710600', '鹿谷乡', '30', '710613', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710700', '710000', '0,86,710000', '基隆市', '30', '710700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710701', '710700', '0,86,710000,710700', '仁爱区', '30', '710701', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710702', '710700', '0,86,710000,710700', '信义区', '30', '710702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710703', '710700', '0,86,710000,710700', '中正区', '30', '710703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710704', '710700', '0,86,710000,710700', '中山区', '30', '710704', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710705', '710700', '0,86,710000,710700', '安乐区', '30', '710705', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710706', '710700', '0,86,710000,710700', '暖暖区', '30', '710706', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710707', '710700', '0,86,710000,710700', '七堵区', '30', '710707', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710708', '710700', '0,86,710000,710700', '其他区', '30', '710708', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710800', '710000', '0,86,710000', '新竹市', '30', '710800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710801', '710800', '0,86,710000,710800', '东区', '30', '710801', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710802', '710800', '0,86,710000,710800', '北区', '30', '710802', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710803', '710800', '0,86,710000,710800', '香山区', '30', '710803', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710804', '710800', '0,86,710000,710800', '其他区', '30', '710804', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710900', '710000', '0,86,710000', '嘉义市', '30', '710900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710901', '710900', '0,86,710000,710900', '东区', '30', '710901', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710902', '710900', '0,86,710000,710900', '西区', '30', '710902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('710903', '710900', '0,86,710000,710900', '其他区', '30', '710903', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711100', '710000', '0,86,710000', '新北市', '30', '711100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711101', '711100', '0,86,710000,711100', '万里区', '30', '711101', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711102', '711100', '0,86,710000,711100', '金山区', '30', '711102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711103', '711100', '0,86,710000,711100', '板桥区', '30', '711103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711104', '711100', '0,86,710000,711100', '汐止区', '30', '711104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711105', '711100', '0,86,710000,711100', '深坑区', '30', '711105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711106', '711100', '0,86,710000,711100', '石碇区', '30', '711106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711107', '711100', '0,86,710000,711100', '瑞芳区', '30', '711107', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711108', '711100', '0,86,710000,711100', '平溪区', '30', '711108', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711109', '711100', '0,86,710000,711100', '双溪区', '30', '711109', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711110', '711100', '0,86,710000,711100', '贡寮区', '30', '711110', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711111', '711100', '0,86,710000,711100', '坪林区', '30', '711111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711112', '711100', '0,86,710000,711100', '乌来区', '30', '711112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711113', '711100', '0,86,710000,711100', '永和区', '30', '711113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711114', '711100', '0,86,710000,711100', '中和区', '30', '711114', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711115', '711100', '0,86,710000,711100', '土城区', '30', '711115', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711116', '711100', '0,86,710000,711100', '三峡区', '30', '711116', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711117', '711100', '0,86,710000,711100', '树林区', '30', '711117', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711118', '711100', '0,86,710000,711100', '莺歌区', '30', '711118', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711119', '711100', '0,86,710000,711100', '三重区', '30', '711119', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711120', '711100', '0,86,710000,711100', '新庄区', '30', '711120', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711121', '711100', '0,86,710000,711100', '泰山区', '30', '711121', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711122', '711100', '0,86,710000,711100', '林口区', '30', '711122', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711123', '711100', '0,86,710000,711100', '泸州区', '30', '711123', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711124', '711100', '0,86,710000,711100', '五股区', '30', '711124', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711125', '711100', '0,86,710000,711100', '八里区', '30', '711125', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711126', '711100', '0,86,710000,711100', '淡水区', '30', '711126', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711127', '711100', '0,86,710000,711100', '三芝区', '30', '711127', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711128', '711100', '0,86,710000,711100', '石门区', '30', '711128', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711200', '710000', '0,86,710000', '宜兰县', '30', '711200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711201', '711200', '0,86,710000,711200', '宜兰市', '30', '711201', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711202', '711200', '0,86,710000,711200', '头城镇', '30', '711202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711203', '711200', '0,86,710000,711200', '礁溪乡', '30', '711203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711204', '711200', '0,86,710000,711200', '壮围乡', '30', '711204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711205', '711200', '0,86,710000,711200', '员山乡', '30', '711205', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711206', '711200', '0,86,710000,711200', '罗东镇', '30', '711206', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711207', '711200', '0,86,710000,711200', '三星乡', '30', '711207', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711208', '711200', '0,86,710000,711200', '大同乡', '30', '711208', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711209', '711200', '0,86,710000,711200', '五结乡', '30', '711209', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711210', '711200', '0,86,710000,711200', '冬山乡', '30', '711210', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711211', '711200', '0,86,710000,711200', '苏澳镇', '30', '711211', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711212', '711200', '0,86,710000,711200', '南澳镇', '30', '711212', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711213', '711200', '0,86,710000,711200', '钓鱼台', '30', '711213', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711300', '710000', '0,86,710000', '新竹县', '30', '711300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711301', '711300', '0,86,710000,711300', '竹北市', '30', '711301', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711302', '711300', '0,86,710000,711300', '湖口乡', '30', '711302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711303', '711300', '0,86,710000,711300', '新丰乡', '30', '711303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711304', '711300', '0,86,710000,711300', '新埔镇', '30', '711304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711305', '711300', '0,86,710000,711300', '关西镇', '30', '711305', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711306', '711300', '0,86,710000,711300', '穹林乡', '30', '711306', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711307', '711300', '0,86,710000,711300', '宝山乡', '30', '711307', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711308', '711300', '0,86,710000,711300', '竹东镇', '30', '711308', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711309', '711300', '0,86,710000,711300', '五峰乡', '30', '711309', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711310', '711300', '0,86,710000,711300', '横山乡', '30', '711310', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711311', '711300', '0,86,710000,711300', '尖石乡', '30', '711311', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711312', '711300', '0,86,710000,711300', '北埔乡', '30', '711312', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711313', '711300', '0,86,710000,711300', '峨眉乡', '30', '711313', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711400', '710000', '0,86,710000', '桃园县', '30', '711400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711401', '711400', '0,86,710000,711400', '中坜市', '30', '711401', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711402', '711400', '0,86,710000,711400', '平镇市', '30', '711402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711403', '711400', '0,86,710000,711400', '龙潭乡', '30', '711403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711404', '711400', '0,86,710000,711400', '杨梅市', '30', '711404', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711405', '711400', '0,86,710000,711400', '新屋乡', '30', '711405', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711406', '711400', '0,86,710000,711400', '观音乡', '30', '711406', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711407', '711400', '0,86,710000,711400', '桃园市', '30', '711407', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711408', '711400', '0,86,710000,711400', '龟山乡', '30', '711408', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711409', '711400', '0,86,710000,711400', '八德市', '30', '711409', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711410', '711400', '0,86,710000,711400', '大溪镇', '30', '711410', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711411', '711400', '0,86,710000,711400', '复兴乡', '30', '711411', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711412', '711400', '0,86,710000,711400', '大园乡', '30', '711412', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711413', '711400', '0,86,710000,711400', '芦竹乡', '30', '711413', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711500', '710000', '0,86,710000', '苗栗县', '30', '711500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711501', '711500', '0,86,710000,711500', '竹南镇', '30', '711501', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711502', '711500', '0,86,710000,711500', '头份镇', '30', '711502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711503', '711500', '0,86,710000,711500', '三湾乡', '30', '711503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711504', '711500', '0,86,710000,711500', '南庄乡', '30', '711504', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711505', '711500', '0,86,710000,711500', '狮潭乡', '30', '711505', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711506', '711500', '0,86,710000,711500', '后龙镇', '30', '711506', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711507', '711500', '0,86,710000,711500', '通宵镇', '30', '711507', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711508', '711500', '0,86,710000,711500', '苑里镇', '30', '711508', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711509', '711500', '0,86,710000,711500', '苗栗市', '30', '711509', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711510', '711500', '0,86,710000,711500', '造桥乡', '30', '711510', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711511', '711500', '0,86,710000,711500', '头屋乡', '30', '711511', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711512', '711500', '0,86,710000,711500', '公馆乡', '30', '711512', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711513', '711500', '0,86,710000,711500', '太湖乡', '30', '711513', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711514', '711500', '0,86,710000,711500', '泰安乡', '30', '711514', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711515', '711500', '0,86,710000,711500', '铜锣乡', '30', '711515', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711516', '711500', '0,86,710000,711500', '三义乡', '30', '711516', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711517', '711500', '0,86,710000,711500', '西湖乡', '30', '711517', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711518', '711500', '0,86,710000,711500', '卓兰镇', '30', '711518', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711700', '710000', '0,86,710000', '彰化县', '30', '711700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711701', '711700', '0,86,710000,711700', '彰化市', '30', '711701', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711702', '711700', '0,86,710000,711700', '芬园乡', '30', '711702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711703', '711700', '0,86,710000,711700', '花坛乡', '30', '711703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711704', '711700', '0,86,710000,711700', '秀水乡', '30', '711704', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711705', '711700', '0,86,710000,711700', '鹿港镇', '30', '711705', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711706', '711700', '0,86,710000,711700', '福兴乡', '30', '711706', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711707', '711700', '0,86,710000,711700', '线西乡', '30', '711707', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711708', '711700', '0,86,710000,711700', '和美镇', '30', '711708', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711709', '711700', '0,86,710000,711700', '伸港乡', '30', '711709', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711710', '711700', '0,86,710000,711700', '员林镇', '30', '711710', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711711', '711700', '0,86,710000,711700', '社头乡', '30', '711711', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711712', '711700', '0,86,710000,711700', '永靖乡', '30', '711712', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711713', '711700', '0,86,710000,711700', '埔心乡', '30', '711713', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711714', '711700', '0,86,710000,711700', '溪湖镇', '30', '711714', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711715', '711700', '0,86,710000,711700', '大村乡', '30', '711715', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711716', '711700', '0,86,710000,711700', '埔盐乡', '30', '711716', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711717', '711700', '0,86,710000,711700', '田中镇', '30', '711717', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711718', '711700', '0,86,710000,711700', '北斗镇', '30', '711718', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711719', '711700', '0,86,710000,711700', '田尾乡', '30', '711719', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711720', '711700', '0,86,710000,711700', '埤头乡', '30', '711720', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711721', '711700', '0,86,710000,711700', '溪州乡', '30', '711721', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711722', '711700', '0,86,710000,711700', '竹塘乡', '30', '711722', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711723', '711700', '0,86,710000,711700', '二林镇', '30', '711723', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711724', '711700', '0,86,710000,711700', '大城乡', '30', '711724', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711725', '711700', '0,86,710000,711700', '芳苑乡', '30', '711725', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711726', '711700', '0,86,710000,711700', '二水乡', '30', '711726', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711900', '710000', '0,86,710000', '嘉义县', '30', '711900', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711901', '711900', '0,86,710000,711900', '阿里山乡', '30', '711901', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711902', '711900', '0,86,710000,711900', '鹿草乡', '30', '711902', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711903', '711900', '0,86,710000,711900', '布袋镇', '30', '711903', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711904', '711900', '0,86,710000,711900', '大林镇', '30', '711904', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711905', '711900', '0,86,710000,711900', '大埔乡', '30', '711905', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711906', '711900', '0,86,710000,711900', '东石乡', '30', '711906', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711907', '711900', '0,86,710000,711900', '番路乡', '30', '711907', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711908', '711900', '0,86,710000,711900', '中埔乡', '30', '711908', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711909', '711900', '0,86,710000,711900', '竹崎乡', '30', '711909', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711910', '711900', '0,86,710000,711900', '六脚乡', '30', '711910', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711911', '711900', '0,86,710000,711900', '民雄乡', '30', '711911', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711912', '711900', '0,86,710000,711900', '朴子市', '30', '711912', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711913', '711900', '0,86,710000,711900', '溪口乡', '30', '711913', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711914', '711900', '0,86,710000,711900', '新港乡', '30', '711914', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711915', '711900', '0,86,710000,711900', '太保市', '30', '711915', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711916', '711900', '0,86,710000,711900', '义竹乡', '30', '711916', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711917', '711900', '0,86,710000,711900', '梅山乡', '30', '711917', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('711918', '711900', '0,86,710000,711900', '水上乡', '30', '711918', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712100', '710000', '0,86,710000', '云林县', '30', '712100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712101', '712100', '0,86,710000,712100', '斗南镇', '30', '712101', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712102', '712100', '0,86,710000,712100', '大埤乡', '30', '712102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712103', '712100', '0,86,710000,712100', '虎尾镇', '30', '712103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712104', '712100', '0,86,710000,712100', '土库镇', '30', '712104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712105', '712100', '0,86,710000,712100', '褒忠乡', '30', '712105', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712106', '712100', '0,86,710000,712100', '东势乡', '30', '712106', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712107', '712100', '0,86,710000,712100', '台西乡', '30', '712107', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712108', '712100', '0,86,710000,712100', '仑背乡', '30', '712108', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712109', '712100', '0,86,710000,712100', '麦寮乡', '30', '712109', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712110', '712100', '0,86,710000,712100', '斗六乡', '30', '712110', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712111', '712100', '0,86,710000,712100', '林内乡', '30', '712111', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712112', '712100', '0,86,710000,712100', '古坑乡', '30', '712112', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712113', '712100', '0,86,710000,712100', '莿桐乡', '30', '712113', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712114', '712100', '0,86,710000,712100', '西螺镇', '30', '712114', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712115', '712100', '0,86,710000,712100', '二仑乡', '30', '712115', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712116', '712100', '0,86,710000,712100', '北港镇', '30', '712116', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712117', '712100', '0,86,710000,712100', '水林乡', '30', '712117', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712118', '712100', '0,86,710000,712100', '口湖乡', '30', '712118', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712119', '712100', '0,86,710000,712100', '西湖乡', '30', '712119', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712120', '712100', '0,86,710000,712100', '元长乡', '30', '712120', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712400', '710000', '0,86,710000', '屏东县', '30', '712400', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712401', '712400', '0,86,710000,712400', '屏东市', '30', '712401', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712402', '712400', '0,86,710000,712400', '三地门乡', '30', '712402', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712403', '712400', '0,86,710000,712400', '雾台乡', '30', '712403', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712404', '712400', '0,86,710000,712400', '玛家乡', '30', '712404', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712405', '712400', '0,86,710000,712400', '九如乡', '30', '712405', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712406', '712400', '0,86,710000,712400', '里港乡', '30', '712406', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712407', '712400', '0,86,710000,712400', '高树乡', '30', '712407', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712408', '712400', '0,86,710000,712400', '盐铺乡', '30', '712408', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712409', '712400', '0,86,710000,712400', '长治乡', '30', '712409', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712410', '712400', '0,86,710000,712400', '麟洛乡', '30', '712410', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712411', '712400', '0,86,710000,712400', '竹田乡', '30', '712411', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712412', '712400', '0,86,710000,712400', '内埔乡', '30', '712412', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712413', '712400', '0,86,710000,712400', '万丹乡', '30', '712413', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712414', '712400', '0,86,710000,712400', '潮州镇', '30', '712414', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712415', '712400', '0,86,710000,712400', '泰武乡', '30', '712415', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712416', '712400', '0,86,710000,712400', '来义乡', '30', '712416', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712417', '712400', '0,86,710000,712400', '万峦乡', '30', '712417', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712418', '712400', '0,86,710000,712400', '崁顶乡', '30', '712418', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712419', '712400', '0,86,710000,712400', '新埤乡', '30', '712419', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712420', '712400', '0,86,710000,712400', '南州乡', '30', '712420', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712421', '712400', '0,86,710000,712400', '林边乡', '30', '712421', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712422', '712400', '0,86,710000,712400', '东港镇', '30', '712422', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712423', '712400', '0,86,710000,712400', '琉球乡', '30', '712423', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712424', '712400', '0,86,710000,712400', '佳冬乡', '30', '712424', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712425', '712400', '0,86,710000,712400', '新园乡', '30', '712425', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712426', '712400', '0,86,710000,712400', '枋寮乡', '30', '712426', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712427', '712400', '0,86,710000,712400', '枋山乡', '30', '712427', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712428', '712400', '0,86,710000,712400', '春日乡', '30', '712428', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712429', '712400', '0,86,710000,712400', '狮子乡', '30', '712429', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712430', '712400', '0,86,710000,712400', '车城乡', '30', '712430', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712431', '712400', '0,86,710000,712400', '牡丹乡', '30', '712431', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712432', '712400', '0,86,710000,712400', '恒春镇', '30', '712432', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712433', '712400', '0,86,710000,712400', '满州乡', '30', '712433', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712500', '710000', '0,86,710000', '台东县', '30', '712500', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712501', '712500', '0,86,710000,712500', '台东市', '30', '712501', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712502', '712500', '0,86,710000,712500', '绿岛乡', '30', '712502', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712503', '712500', '0,86,710000,712500', '兰屿乡', '30', '712503', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712504', '712500', '0,86,710000,712500', '延平乡', '30', '712504', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712505', '712500', '0,86,710000,712500', '卑南乡', '30', '712505', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712506', '712500', '0,86,710000,712500', '鹿野乡', '30', '712506', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712507', '712500', '0,86,710000,712500', '关山镇', '30', '712507', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712508', '712500', '0,86,710000,712500', '海端乡', '30', '712508', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712509', '712500', '0,86,710000,712500', '池上乡', '30', '712509', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712510', '712500', '0,86,710000,712500', '东河乡', '30', '712510', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712511', '712500', '0,86,710000,712500', '成功镇', '30', '712511', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712512', '712500', '0,86,710000,712500', '长滨乡', '30', '712512', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712513', '712500', '0,86,710000,712500', '金峰乡', '30', '712513', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712514', '712500', '0,86,710000,712500', '大武乡', '30', '712514', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712515', '712500', '0,86,710000,712500', '达仁乡', '30', '712515', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712516', '712500', '0,86,710000,712500', '太麻里乡', '30', '712516', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712600', '710000', '0,86,710000', '花莲县', '30', '712600', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712615', '712600', '0,86,710000,712600', '花莲市', '30', '712615', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712616', '712600', '0,86,710000,712600', '新城乡', '30', '712616', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712617', '712600', '0,86,710000,712600', '太鲁阁', '30', '712617', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712618', '712600', '0,86,710000,712600', '秀林乡', '30', '712618', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712619', '712600', '0,86,710000,712600', '吉安乡', '30', '712619', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712620', '712600', '0,86,710000,712600', '寿丰乡', '30', '712620', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712621', '712600', '0,86,710000,712600', '凤林镇', '30', '712621', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712622', '712600', '0,86,710000,712600', '光复乡', '30', '712622', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712623', '712600', '0,86,710000,712600', '丰滨乡', '30', '712623', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712624', '712600', '0,86,710000,712600', '瑞穗乡', '30', '712624', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712625', '712600', '0,86,710000,712600', '万荣乡', '30', '712625', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712626', '712600', '0,86,710000,712600', '玉里镇', '30', '712626', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712627', '712600', '0,86,710000,712600', '卓溪乡', '30', '712627', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712628', '712600', '0,86,710000,712600', '富里乡', '30', '712628', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712700', '710000', '0,86,710000', '澎湖县', '30', '712700', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712701', '712700', '0,86,710000,712700', '马公市', '30', '712701', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712702', '712700', '0,86,710000,712700', '西屿乡', '30', '712702', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712703', '712700', '0,86,710000,712700', '望安乡', '30', '712703', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712704', '712700', '0,86,710000,712700', '七美乡', '30', '712704', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712705', '712700', '0,86,710000,712700', '白沙乡', '30', '712705', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712706', '712700', '0,86,710000,712700', '湖西乡', '30', '712706', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712800', '710000', '0,86,710000', '连江县', '30', '712800', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712805', '712800', '0,86,710000,712800', '南竿乡', '30', '712805', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712806', '712800', '0,86,710000,712800', '北竿乡', '30', '712806', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712807', '712800', '0,86,710000,712800', '莒光乡', '30', '712807', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('712808', '712800', '0,86,710000,712800', '东引乡', '30', '712808', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810000', '86', '0,86', '香港特别行政区', '30', '810000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810100', '810000', '0,86,810000', '香港岛', '30', '810100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810101', '810100', '0,86,810000,810100', '中西', '30', '810101', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810102', '810100', '0,86,810000,810100', '湾仔', '30', '810102', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810103', '810100', '0,86,810000,810100', '东区', '30', '810103', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810104', '810100', '0,86,810000,810100', '南区', '30', '810104', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810200', '810000', '0,86,810000', '九龙', '30', '810200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810201', '810200', '0,86,810000,810200', '九龙城', '30', '810201', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810202', '810200', '0,86,810000,810200', '油尖旺', '30', '810202', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810203', '810200', '0,86,810000,810200', '深水埗', '30', '810203', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810204', '810200', '0,86,810000,810200', '黄大仙', '30', '810204', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810205', '810200', '0,86,810000,810200', '观塘', '30', '810205', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810300', '810000', '0,86,810000', '新界', '30', '810300', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810301', '810300', '0,86,810000,810300', '北区', '30', '810301', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810302', '810300', '0,86,810000,810300', '大埔', '30', '810302', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810303', '810300', '0,86,810000,810300', '沙田', '30', '810303', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810304', '810300', '0,86,810000,810300', '西贡', '30', '810304', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810305', '810300', '0,86,810000,810300', '元朗', '30', '810305', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810306', '810300', '0,86,810000,810300', '屯门', '30', '810306', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810307', '810300', '0,86,810000,810300', '荃湾', '30', '810307', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810308', '810300', '0,86,810000,810300', '葵青', '30', '810308', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('810309', '810300', '0,86,810000,810300', '离岛', '30', '810309', '4', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('820000', '86', '0,86', '澳门特别行政区', '30', '820000', '2', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('820100', '820000', '0,86,820000', '澳门半岛', '30', '820100', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('820200', '820000', '0,86,820000', '离岛', '30', '820200', '3', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');
INSERT INTO `sys_area` VALUES ('86', '0', '0', '中国', '10', '100000', '1', '1', '2017-03-06 17:38:45', '1', '2017-03-06 17:38:45', '0');

-- ----------------------------
-- Table structure for sys_dict
-- ----------------------------
DROP TABLE IF EXISTS `sys_dict`;
CREATE TABLE `sys_dict` (
  `id` varchar(64) NOT NULL COMMENT '编号',
  `value` varchar(100) NOT NULL COMMENT '数据值',
  `label` varchar(100) NOT NULL COMMENT '标签名',
  `type` varchar(100) NOT NULL COMMENT '类型',
  `description` varchar(100) NOT NULL COMMENT '描述',
  `sort` decimal(10,0) NOT NULL COMMENT '排序（升序）',
  `parent_id` varchar(64) DEFAULT '0' COMMENT '父级编号',
  `create_by` varchar(64) NOT NULL COMMENT '创建者',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_by` varchar(64) NOT NULL COMMENT '更新者',
  `update_time` datetime NOT NULL COMMENT '更新时间',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `sys_dict_value` (`value`),
  KEY `sys_dict_label` (`label`),
  KEY `sys_dict_del_flag` (`is_del`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='字典表';

-- ----------------------------
-- Records of sys_dict
-- ----------------------------
INSERT INTO `sys_dict` VALUES ('1', '0', '正常', 'del_flag', '删除标记', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_dict` VALUES ('100', 'java.util.Date', 'Date', 'gen_java_type', 'Java类型\0\0', '50', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('101', 'Boolean', 'Boolean', 'gen_java_type', 'Java类型\0\0', '70', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('102', 'com.thinkgem.jeesite.modules.sys.entity.User', 'User', 'gen_java_type', 'Java类型\0\0', '60', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('103', 'com.thinkgem.jeesite.modules.sys.entity.Area', 'Area', 'gen_java_type', 'Java类型\0\0', '80', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('104', 'Custom', 'Custom', 'gen_java_type', 'Java类型\0\0', '90', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('105', '1', '主表', 'table_type', '表类型', '20', '0', '1', '2016-01-05 21:47:14', '1', '2016-01-05 21:53:34', '0');
INSERT INTO `sys_dict` VALUES ('106', '0', '单表', 'table_type', '表类型', '10', '0', '1', '2016-01-05 21:46:39', '1', '2016-01-05 21:53:50', '0');
INSERT INTO `sys_dict` VALUES ('107', '3', '树结构表', 'table_type', '表类型', '40', '0', '1', '2016-01-06 19:48:50', '1', '2016-01-06 19:48:50', '0');
INSERT INTO `sys_dict` VALUES ('108', '2', '附表', 'table_type', '表类型', '30', '0', '1', '2016-01-05 21:47:38', '1', '2016-01-05 21:53:44', '0');
INSERT INTO `sys_dict` VALUES ('17', '1', '国家', 'sys_area_type', '区域类型', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_dict` VALUES ('18', '2', '省份、直辖市', 'sys_area_type', '区域类型', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_dict` VALUES ('19', '3', '地市', 'sys_area_type', '区域类型', '30', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_dict` VALUES ('2', '1', '删除', 'del_flag', '删除标记', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_dict` VALUES ('20', '4', '区县', 'sys_area_type', '区域类型', '40', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_dict` VALUES ('3', '1', '显示', 'show_hide', '显示/隐藏', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_dict` VALUES ('39', '1', '系统管理', 'sys_user_type', '用户类型', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_dict` VALUES ('4', '0', '隐藏', 'show_hide', '显示/隐藏', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_dict` VALUES ('41', '3', '普通用户', 'sys_user_type', '用户类型', '30', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_dict` VALUES ('42', 'basic', '基础主题', 'cms_theme', '站点主题', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('43', 'blue', '蓝色主题', 'cms_theme', '站点主题', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('44', 'red', '红色主题', 'cms_theme', '站点主题', '30', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('45', 'article', '文章模型', 'cms_module', '栏目模型', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('46', 'picture', '图片模型', 'cms_module', '栏目模型', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('47', 'download', '下载模型', 'cms_module', '栏目模型', '30', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('48', 'link', '链接模型', 'cms_module', '栏目模型', '40', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('49', 'special', '专题模型', 'cms_module', '栏目模型', '50', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('5', '1', '是', 'yes_no', '是/否', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_dict` VALUES ('50', '0', '默认展现方式', 'cms_show_modes', '展现方式', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('51', '1', '首栏目内容列表', 'cms_show_modes', '展现方式', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('52', '2', '栏目第一条内容', 'cms_show_modes', '展现方式', '30', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('53', '0', '发布', 'cms_del_flag', '内容状态', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('54', '1', '删除', 'cms_del_flag', '内容状态', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('55', '2', '审核', 'cms_del_flag', '内容状态', '15', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('56', '1', '首页焦点图', 'cms_posid', '推荐位', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('57', '2', '栏目页文章推荐', 'cms_posid', '推荐位', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('58', '1', '咨询', 'cms_guestbook', '留言板分类', '10', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('59', '2', '建议', 'cms_guestbook', '留言板分类', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('6', '0', '否', 'yes_no', '是/否', '20', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_dict` VALUES ('60', '3', '投诉', 'cms_guestbook', '留言板分类', '30', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('61', '4', '其它', 'cms_guestbook', '留言板分类', '40', '0', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('73', 'crud', '增删改查', 'gen_category', '代码生成分类', '10', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('74', 'crud_many', '增删改查（包含从表）', 'gen_category', '代码生成分类', '20', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('75', 'tree', '树结构', 'gen_category', '代码生成分类', '30', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('76', '=', '=', 'gen_query_type', '查询方式', '10', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('77', '!=', '!=', 'gen_query_type', '查询方式', '20', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('78', '&gt;', '&gt;', 'gen_query_type', '查询方式', '30', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('79', '&lt;', '&lt;', 'gen_query_type', '查询方式', '40', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('80', 'between', 'Between', 'gen_query_type', '查询方式', '50', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('81', 'like', 'Like', 'gen_query_type', '查询方式', '60', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('82', 'left_like', 'Left Like', 'gen_query_type', '查询方式', '70', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('83', 'right_like', 'Right Like', 'gen_query_type', '查询方式', '80', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('84', 'input', '文本框', 'gen_show_type', '字段生成方案', '10', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('85', 'textarea', '文本域', 'gen_show_type', '字段生成方案', '20', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('86', 'select', '下拉框', 'gen_show_type', '字段生成方案', '30', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('87', 'checkbox', '复选框', 'gen_show_type', '字段生成方案', '40', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('88', 'radiobox', '单选框', 'gen_show_type', '字段生成方案', '50', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('89', 'dateselect', '日期选择', 'gen_show_type', '字段生成方案', '60', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('90', 'userselect', '人员选择\0', 'gen_show_type', '字段生成方案', '70', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('91', 'officeselect', '部门选择', 'gen_show_type', '字段生成方案', '80', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('92', 'areaselect', '区域选择', 'gen_show_type', '字段生成方案', '90', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('93', 'String', 'String', 'gen_java_type', 'Java类型', '10', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('94', 'Long', 'Long', 'gen_java_type', 'Java类型', '20', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('95', 'dao', '仅持久层', 'gen_category', '代码生成分类\0\0\0\0\0\0', '40', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('96', '1', '男', 'gender', '性别', '10', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '0');
INSERT INTO `sys_dict` VALUES ('97', '2', '女', 'gender', '性别', '20', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '0');
INSERT INTO `sys_dict` VALUES ('98', 'Integer', 'Integer', 'gen_java_type', 'Java类型\0\0', '30', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');
INSERT INTO `sys_dict` VALUES ('99', 'Double', 'Double', 'gen_java_type', 'Java类型\0\0', '40', '0', '1', '2013-10-28 08:00:00', '1', '2013-10-28 08:00:00', '1');

-- ----------------------------
-- Table structure for sys_log
-- ----------------------------
DROP TABLE IF EXISTS `sys_log`;
CREATE TABLE `sys_log` (
  `id` varchar(64) NOT NULL COMMENT '编号',
  `type` char(1) DEFAULT '1' COMMENT '日志类型',
  `title` varchar(255) DEFAULT '' COMMENT '日志标题',
  `create_by` varchar(64) DEFAULT NULL COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `remote_addr` varchar(255) DEFAULT NULL COMMENT '操作IP地址',
  `user_agent` varchar(255) DEFAULT NULL COMMENT '用户代理',
  `request_uri` varchar(255) DEFAULT NULL COMMENT '请求URI',
  `method` varchar(5) DEFAULT NULL COMMENT '操作方式',
  `params` text COMMENT '操作提交的数据',
  `exception` text COMMENT '异常信息',
  PRIMARY KEY (`id`),
  KEY `sys_log_create_by` (`create_by`),
  KEY `sys_log_request_uri` (`request_uri`),
  KEY `sys_log_type` (`type`),
  KEY `sys_log_create_date` (`create_time`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='日志表';

-- ----------------------------
-- Records of sys_log
-- ----------------------------
INSERT INTO `sys_log` VALUES ('0068991f-5507-42bf-bae2-da1c9379604b', '1', '代码生成-表单配置', '1', '2017-04-14 21:17:15', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('00e241aa-35dd-4022-98ff-ee8b34a63c09', '1', '系统设置-用户管理-删除', '1', '2017-04-14 19:01:23', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/delete', 'GET', 'id=5', '');
INSERT INTO `sys_log` VALUES ('02b5177e-acd4-40a6-a3f6-55bf9d1f3ebe', '1', '系统设置-字典管理', '1', '2017-04-14 18:53:42', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/dict/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('07b9d7e2-a18b-481e-9ec7-dff142ba21e8', '1', '代码生成-表单配置', '1', '2017-04-14 22:44:01', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('08a62727-98bf-435b-8701-c8cc2960bd7c', '1', '系统登录', '1', '2017-04-14 21:23:56', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/webpage/modules/gen/genTableList.jsp', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('0a16416f-06c3-430f-929f-863fb05aa138', '1', '系统登录', '1', '2017-04-14 14:04:08', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('0a1ed2d2-2af3-43ac-bf83-cd4dc7fc0cfa', '1', '系统设置-用户管理', '1', '2017-04-14 15:47:04', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('0b110c72-c878-4099-8496-6e47783d4e80', '1', '系统登录', '1', '2017-04-14 19:12:53', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/webpage/modules/gen/genTableList.jsp', 'POST', 'pageNo=1&pageSize=10&orderBy=&nameLike=&comments=&parentTable=', '');
INSERT INTO `sys_log` VALUES ('0bd00b9d-41ca-4488-ba28-932a82bee6f5', '1', '系统登录', '1', '2017-04-14 10:33:02', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a;JSESSIONID=d49cfe4e-52fc-45d8-8e57-440f8db4f1bc', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('0dc6d783-a48e-4e17-a2ad-ced4e67fb602', '1', '系统登录', '1', '2017-04-14 09:48:46', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('0edfd721-c370-4b2c-a896-348e2bb0181b', '1', '系统登录', '1', '2017-04-14 21:01:13', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('0f1e20eb-6984-4277-9818-55fa39a3735e', '1', '系统登录', '1', '2017-04-14 17:51:18', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('1116215d-e557-42b6-aa84-5d6c2acf52cb', '1', '系统登录', '1', '2017-04-14 22:47:07', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('114d56fe-0a05-449f-a5fe-a3b00dc4498f', '1', '代码生成-表单配置-导入', '1', '2017-04-14 21:03:50', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable/importTableFromDB', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('13a44172-6e24-4962-b8b2-107a9b4a6314', '1', '代码生成-表单配置-生成代码', '1', '2017-04-14 19:37:46', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable/genCodeForm', 'GET', 'genTable.id=028cbf9e-768f-4f6d-a4ca-e240e8ecc389', '');
INSERT INTO `sys_log` VALUES ('13e37690-c4b1-468a-8274-4467491c99d2', '1', '系统设置-用户管理', '1', '2017-04-14 14:06:14', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('16e3ed27-1f58-4081-b941-001809c3ff84', '1', '系统设置-角色管理-删除', '1', '2017-04-14 11:20:15', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/role/delete', 'GET', 'id=13838f71-a939-422c-808d-305d15203967', '');
INSERT INTO `sys_log` VALUES ('184f404c-06ce-4387-a06f-a1a870301b4d', '1', '系统登录', '1', '2017-04-14 21:29:39', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('1a1908d7-724b-4e5b-b17c-c07dccddd058', '1', '系统登录', '1', '2017-04-14 19:29:50', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('1ec4f467-0d97-40a6-8157-021e6a35a42c', '1', '系统设置-角色管理', '1', '2017-04-14 11:17:40', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/role/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('230fd014-26db-42c4-b8eb-00660bbca83b', '1', '系统设置-菜单管理', '1', '2017-04-14 21:02:23', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/menu/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('23378941-ef49-43e2-9cd7-da7b3ad6d1d6', '1', '系统设置-菜单管理', '1', '2017-04-14 19:30:29', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/menu/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('24ea9f20-fa01-42d0-afeb-84dd2f7e4a73', '1', '系统登录', '1', '2017-04-14 15:44:58', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a;JSESSIONID=d49cfe4e-52fc-45d8-8e57-440f8db4f1bc', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('27221358-74d4-4bab-a71b-5722ea6c4b25', '1', '系统设置-菜单管理-删除', '1', '2017-04-14 21:02:21', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/menu/delete', 'GET', 'id=e23f5d29-2819-49b1-b905-fb27e7930379', '');
INSERT INTO `sys_log` VALUES ('27e6fd4b-7b89-49fd-90bd-77d5d4661388', '1', '系统设置-角色管理', '1', '2017-04-14 10:27:10', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/role/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('27f35eee-448d-4cf7-b37d-16b9502cddf3', '1', '系统登录', '1', '2017-04-14 22:30:11', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('30af19c1-b9b1-47ba-a9cd-ddc397011e36', '1', '系统设置-字典管理', '1', '2017-04-14 19:01:17', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/dict/', 'POST', 'pageNo=1&pageSize=10&orderBy=&type=&description=', '');
INSERT INTO `sys_log` VALUES ('3143ed65-92ae-47f0-aa8a-f6a998a6fcce', '1', '内容管理-文章', '1', '2017-04-14 22:47:20', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/cms/article/article', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('3c1a9c9d-3fb3-45e5-af67-3bd82820fa53', '1', '代码生成-表单配置', '1', '2017-04-14 22:30:18', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('3c4d5e98-577c-41eb-acf5-112b94aeb9a1', '1', '系统设置-角色管理-删除', '1', '2017-04-14 11:20:26', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/role/delete', 'GET', 'id=1224b09b-cad8-457e-8ebe-76bd07f28abf', '');
INSERT INTO `sys_log` VALUES ('3d412b9d-502c-4fe0-ac64-16b397395293', '1', '系统设置-字典管理', '1', '2017-04-14 09:46:01', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/dict/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('3d48a228-677f-41e2-9190-ad9a9fc0332b', '1', '系统设置-用户管理', '1', '2017-04-14 18:58:22', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('3f2cfc6d-b3de-4af0-a006-dbdc45cededa', '1', '系统设置-用户管理', '1', '2017-04-14 15:47:46', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('3fbec9d5-8dbd-46c4-b2dc-8125abca4cf5', '1', '系统登录', '1', '2017-04-14 13:46:46', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a;JSESSIONID=d49cfe4e-52fc-45d8-8e57-440f8db4f1bc', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('4233b50c-81f4-4076-a68b-2383df04bcef', '1', '系统登录', '1', '2017-04-14 14:23:51', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a;JSESSIONID=d49cfe4e-52fc-45d8-8e57-440f8db4f1bc', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('465b1439-27e5-4f0b-8082-33f0908b7c59', '1', '系统设置-用户管理', '1', '2017-04-14 19:05:36', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('4672ccc2-eb81-444f-a73e-1da25f06086e', '1', '系统设置-用户管理', '1', '2017-04-14 18:52:21', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('47892869-6e46-4940-9e4c-41189a1d31c3', '1', '系统监控-日志查询', '1', '2017-04-14 09:45:41', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/log', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('47ec9cd2-2995-41b1-acfb-4b6ccac09751', '1', '系统设置-字典管理', '1', '2017-04-14 18:58:11', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/dict/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('47fa413b-7817-4623-a019-69b3e1cc2b38', '1', '系统设置-菜单管理', '1', '2017-04-14 19:31:24', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/menu/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('480a68e7-70d3-4dde-bbad-6377170f6736', '1', '代码生成-表单配置', '1', '2017-04-14 19:37:39', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('48be8398-bac7-46f5-9bbd-6399a4e434ef', '1', '系统设置-用户管理', '1', '2017-04-14 18:25:56', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('48d02d95-545b-460e-a430-408514d4af24', '1', '系统设置-角色管理', '1', '2017-04-14 19:06:36', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/role/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('4a0a691c-2f54-47b5-92e8-e08510d19a08', '1', '系统登录', '1', '2017-04-14 21:32:27', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('4a59b9da-0b69-4922-884c-4ef93b76441c', '1', '代码生成-表单配置', '1', '2017-04-14 21:24:00', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('4aee80c2-8e78-4382-93ff-7d5dfb822cd2', '1', '系统登录', '1', '2017-04-14 15:31:46', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a;JSESSIONID=d49cfe4e-52fc-45d8-8e57-440f8db4f1bc', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('4b709d36-1227-4f09-8b68-cf87bd3698df', '1', '系统设置-用户管理', '1', '2017-04-14 18:58:54', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('4d2cdeba-560c-4134-8a33-17ff5a424a0b', '1', '系统登录', '1', '2017-04-14 11:32:58', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/role/', 'POST', 'pageNo=&pageSize=&orderBy=&name=', '');
INSERT INTO `sys_log` VALUES ('4e639b7a-746b-49b7-a2ec-2172e40b4a33', '1', '系统设置-角色管理', '1', '2017-04-14 11:20:17', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/role/', 'GET', 'repage=', '');
INSERT INTO `sys_log` VALUES ('4e729576-974e-4333-a723-e401a51ee94b', '1', '系统登录', '1', '2017-04-14 19:28:49', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('545ee4e7-713c-4795-930b-daa47bcc9bea', '1', '系统设置-用户管理', '1', '2017-04-14 11:37:37', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('5ad23d0d-71d2-4ffe-a09a-d9647c132241', '1', '系统设置-区域管理', '1', '2017-04-14 09:48:59', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/area/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('614d7b2a-3a68-4323-8d4b-9db7668da401', '1', '系统登录', '1', '2017-04-14 17:57:56', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('6364e702-1134-4317-8859-2b3932258c0e', '1', '系统设置-角色管理', '1', '2017-04-14 19:06:46', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/role/', 'GET', 'repage=', '');
INSERT INTO `sys_log` VALUES ('6551996c-1bc9-43b6-b4f6-cdd8f98e482d', '1', '系统登录', '1', '2017-04-14 11:17:29', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a;JSESSIONID=d49cfe4e-52fc-45d8-8e57-440f8db4f1bc', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('660d609e-9620-46f0-aca7-b7129a1c4e55', '1', '系统设置-字典管理', '1', '2017-04-14 18:59:39', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/dict/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('668bce9d-10e4-4b55-8940-5d8b75c01e16', '1', '系统设置-菜单管理', '1', '2017-04-14 18:53:38', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/menu/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('6859c8ff-33e0-425b-aa48-9ebd87064ff0', '1', '系统设置-字典管理', '1', '2017-04-14 09:46:35', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/dict/', 'GET', 'repage=&type=test', '');
INSERT INTO `sys_log` VALUES ('69da3ee0-4772-43ba-b946-6c681945a38b', '1', '系统登录', '1', '2017-04-14 19:02:28', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/form', 'GET', 'id=4', '');
INSERT INTO `sys_log` VALUES ('6adc5428-be6a-4f52-a5c7-4037d4e5a210', '1', '内容管理-文章', '1', '2017-04-14 21:32:43', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/cms/article/article', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('6b099006-236d-45e2-853b-f7a5e0ece99d', '1', '代码生成-表单配置', '1', '2017-04-14 21:15:04', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('6b79e60a-031a-4543-9efe-6e1728ebf5e5', '1', '系统设置-用户管理', '1', '2017-04-14 17:51:25', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('6b9816cf-d4b5-4dc2-8df1-5b1259afe04d', '1', '系统设置-用户管理', '1', '2017-04-14 14:23:57', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('6c4431a5-90cc-411f-9fe6-f1e8c91e5f3a', '1', '代码生成-表单配置-生成代码', '1', '2017-04-14 19:29:02', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable/genCodeForm', 'GET', 'genTable.id=028cbf9e-768f-4f6d-a4ca-e240e8ecc389', '');
INSERT INTO `sys_log` VALUES ('6d1c1d94-648d-4ed1-a416-4f9c9ea60329', '1', '代码生成-表单配置', '1', '2017-04-14 19:29:55', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('6d2f3039-7fb6-44ad-8ec0-27740c5cdff8', '1', '系统登录', '1', '2017-04-14 19:23:29', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('6d480a6a-404c-457e-9d08-d8cc8aa8c5a3', '1', '系统设置-用户管理', '1', '2017-04-14 14:04:09', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('6d85f1e7-e318-43b9-93e4-3afbd1dd3627', '1', '系统登录', '1', '2017-04-14 21:12:57', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('7248dc10-4fa0-4ecc-81d1-79f09e7bda59', '1', '系统设置-区域管理', '1', '2017-04-14 09:58:29', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/area/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('78684acb-a834-46e4-96c3-e6ed348e5191', '1', '系统设置-字典管理', '1', '2017-04-14 09:58:21', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/dict/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('7877e69a-43c4-4743-a2b2-8ba1718d4c89', '1', '系统设置-区域管理', '1', '2017-04-14 09:59:47', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/area/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('7962e673-dd5a-4765-9ca2-7d255418430c', '1', '商城-轮播图', '1', '2017-04-14 19:31:59', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/shop/banner/demoBanner', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('7bce3729-9abc-409e-8a95-40618e7c3c0b', '1', '代码生成-表单配置', '1', '2017-04-14 19:28:57', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('7e793334-e098-4d73-ac1d-a26ea3e679bd', '1', '代码生成-表单配置-生成代码', '1', '2017-04-14 22:44:06', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable/genCodeForm', 'GET', 'genTable.id=82fd6044-9a25-4d11-b467-7e3e5b50befa', '');
INSERT INTO `sys_log` VALUES ('811fa279-9682-45b9-865d-d5cdb300391c', '1', '系统设置-区域管理', '1', '2017-04-14 09:59:19', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/area/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('8128426d-30d4-440a-b8ea-28306f4bde72', '1', '系统登录', '1', '2017-04-14 14:05:41', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a;JSESSIONID=d49cfe4e-52fc-45d8-8e57-440f8db4f1bc', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('84a7129f-532d-40b3-b1aa-a3da1f87dc7a', '1', '代码生成-表单配置-删除', '1', '2017-04-14 21:03:42', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable/delete', 'GET', 'id=028cbf9e-768f-4f6d-a4ca-e240e8ecc389', '');
INSERT INTO `sys_log` VALUES ('87edc804-1488-49e5-8cff-efab007e7cb2', '2', '', '1', '2017-04-14 19:26:47', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable/genCode', 'POST', 'id=&category=curd&packageName=com.jeeplus.modules&moduleName=shop&subModuleName=Banner&functionName=轮播图&functionNameSimple=轮播图&functionAuthor=Rubekid&genTable.id=028cbf9e-768f-4f6d-a4ca-e240e8ecc389', 'org.springframework.web.util.NestedServletException: Handler processing failed; nested exception is java.lang.NoClassDefFoundError: com/jeeplus/common/utils/FileUtils\r\n	at org.springframework.web.servlet.DispatcherServlet.triggerAfterCompletionWithError(DispatcherServlet.java:1280)\r\n	at org.springframework.web.servlet.DispatcherServlet.doDispatch(DispatcherServlet.java:958)\r\n	at org.springframework.web.servlet.DispatcherServlet.doService(DispatcherServlet.java:870)\r\n	at org.springframework.web.servlet.FrameworkServlet.processRequest(FrameworkServlet.java:961)\r\n	at org.springframework.web.servlet.FrameworkServlet.doPost(FrameworkServlet.java:863)\r\n	at javax.servlet.http.HttpServlet.service(HttpServlet.java:650)\r\n	at org.springframework.web.servlet.FrameworkServlet.service(FrameworkServlet.java:837)\r\n	at javax.servlet.http.HttpServlet.service(HttpServlet.java:731)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:303)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at org.apache.tomcat.websocket.server.WsFilter.doFilter(WsFilter.java:52)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:241)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at com.opensymphony.sitemesh.webapp.SiteMeshFilter.obtainContent(SiteMeshFilter.java:129)\r\n	at com.opensymphony.sitemesh.webapp.SiteMeshFilter.doFilter(SiteMeshFilter.java:77)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:241)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at org.apache.shiro.web.servlet.ProxiedFilterChain.doFilter(ProxiedFilterChain.java:61)\r\n	at org.apache.shiro.web.servlet.AdviceFilter.executeChain(AdviceFilter.java:108)\r\n	at org.apache.shiro.web.servlet.AdviceFilter.doFilterInternal(AdviceFilter.java:137)\r\n	at org.apache.shiro.web.servlet.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:125)\r\n	at org.apache.shiro.web.servlet.ProxiedFilterChain.doFilter(ProxiedFilterChain.java:66)\r\n	at org.apache.shiro.web.servlet.AbstractShiroFilter.executeChain(AbstractShiroFilter.java:449)\r\n	at org.apache.shiro.web.servlet.AbstractShiroFilter$1.call(AbstractShiroFilter.java:365)\r\n	at org.apache.shiro.subject.support.SubjectCallable.doCall(SubjectCallable.java:90)\r\n	at org.apache.shiro.subject.support.SubjectCallable.call(SubjectCallable.java:83)\r\n	at org.apache.shiro.subject.support.DelegatingSubject.execute(DelegatingSubject.java:383)\r\n	at org.apache.shiro.web.servlet.AbstractShiroFilter.doFilterInternal(AbstractShiroFilter.java:362)\r\n	at org.apache.shiro.web.servlet.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:125)\r\n	at org.springframework.web.filter.DelegatingFilterProxy.invokeDelegate(DelegatingFilterProxy.java:344)\r\n	at org.springframework.web.filter.DelegatingFilterProxy.doFilter(DelegatingFilterProxy.java:261)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:241)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at org.springframework.web.filter.CharacterEncodingFilter.doFilterInternal(CharacterEncodingFilter.java:88)\r\n	at org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:107)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:241)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at org.apache.catalina.core.StandardWrapperValve.invoke(StandardWrapperValve.java:218)\r\n	at org.apache.catalina.core.StandardContextValve.invoke(StandardContextValve.java:110)\r\n	at org.apache.catalina.authenticator.AuthenticatorBase.invoke(AuthenticatorBase.java:506)\r\n	at org.apache.catalina.core.StandardHostValve.invoke(StandardHostValve.java:169)\r\n	at org.apache.catalina.valves.ErrorReportValve.invoke(ErrorReportValve.java:103)\r\n	at org.apache.catalina.valves.AccessLogValve.invoke(AccessLogValve.java:962)\r\n	at org.apache.catalina.core.StandardEngineValve.invoke(StandardEngineValve.java:116)\r\n	at org.apache.catalina.connector.CoyoteAdapter.service(CoyoteAdapter.java:445)\r\n	at org.apache.coyote.http11.AbstractHttp11Processor.process(AbstractHttp11Processor.java:1087)\r\n	at org.apache.coyote.AbstractProtocol$AbstractConnectionHandler.process(AbstractProtocol.java:637)\r\n	at org.apache.tomcat.util.net.JIoEndpoint$SocketProcessor.run(JIoEndpoint.java:316)\r\n	at java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1142)\r\n	at java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:617)\r\n	at org.apache.tomcat.util.threads.TaskThread$WrappingRunnable.run(TaskThread.java:61)\r\n	at java.lang.Thread.run(Thread.java:745)\r\nCaused by: java.lang.NoClassDefFoundError: com/jeeplus/common/utils/FileUtils\r\n	at com.jeeplus.modules.gen.util.a.a(GenUtils.java:500)\r\n	at com.jeeplus.modules.gen.service.GenSchemeService.generateCode(GenSchemeService.java:175)\r\n	at com.jeeplus.modules.gen.service.GenSchemeService.save(GenSchemeService.java:69)\r\n	at com.jeeplus.modules.gen.service.GenSchemeService$$FastClassBySpringCGLIB$$71d8e7d5.invoke(<generated>)\r\n	at org.springframework.cglib.proxy.MethodProxy.invoke(MethodProxy.java:204)\r\n	at org.springframework.aop.framework.CglibAopProxy$CglibMethodInvocation.invokeJoinpoint(CglibAopProxy.java:708)\r\n	at org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:157)\r\n	at org.springframework.transaction.interceptor.TransactionInterceptor$1.proceedWithInvocation(TransactionInterceptor.java:98)\r\n	at org.springframework.transaction.interceptor.TransactionAspectSupport.invokeWithinTransaction(TransactionAspectSupport.java:262)\r\n	at org.springframework.transaction.interceptor.TransactionInterceptor.invoke(TransactionInterceptor.java:95)\r\n	at org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:179)\r\n	at org.springframework.aop.framework.CglibAopProxy$DynamicAdvisedInterceptor.intercept(CglibAopProxy.java:644)\r\n	at com.jeeplus.modules.gen.service.GenSchemeService$$EnhancerBySpringCGLIB$$513c07e.save(<generated>)\r\n	at com.jeeplus.modules.gen.service.GenSchemeService$$FastClassBySpringCGLIB$$71d8e7d5.invoke(<generated>)\r\n	at org.springframework.cglib.proxy.MethodProxy.invoke(MethodProxy.java:204)\r\n	at org.springframework.aop.framework.CglibAopProxy$CglibMethodInvocation.invokeJoinpoint(CglibAopProxy.java:708)\r\n	at org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:157)\r\n	at org.springframework.transaction.interceptor.TransactionInterceptor$1.proceedWithInvocation(TransactionInterceptor.java:98)\r\n	at org.springframework.transaction.interceptor.TransactionAspectSupport.invokeWithinTransaction(TransactionAspectSupport.java:262)\r\n	at org.springframework.transaction.interceptor.TransactionInterceptor.invoke(TransactionInterceptor.java:95)\r\n	at org.springframework.aop.framework.ReflectiveMethodInvocation.proceed(ReflectiveMethodInvocation.java:179)\r\n	at org.springframework.aop.framework.CglibAopProxy$DynamicAdvisedInterceptor.intercept(CglibAopProxy.java:644)\r\n	at com.jeeplus.modules.gen.service.GenSchemeService$$EnhancerBySpringCGLIB$$e8b993d4.save(<generated>)\r\n	at com.jeeplus.modules.gen.web.GenTableController.a(GenTableController.java:595)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)\r\n	at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:62)\r\n	at sun.reflect.DelegatingMethodAccessorImpl.invoke(DelegatingMethodAccessorImpl.java:43)\r\n	at java.lang.reflect.Method.invoke(Method.java:498)\r\n	at org.springframework.web.method.support.InvocableHandlerMethod.invoke(InvocableHandlerMethod.java:215)\r\n	at org.springframework.web.method.support.InvocableHandlerMethod.invokeForRequest(InvocableHandlerMethod.java:132)\r\n	at org.springframework.web.servlet.mvc.method.annotation.ServletInvocableHandlerMethod.invokeAndHandle(ServletInvocableHandlerMethod.java:104)\r\n	at org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter.invokeHandleMethod(RequestMappingHandlerAdapter.java:749)\r\n	at org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter.handleInternal(RequestMappingHandlerAdapter.java:689)\r\n	at org.springframework.web.servlet.mvc.method.AbstractHandlerMethodAdapter.handle(AbstractHandlerMethodAdapter.java:83)\r\n	at org.springframework.web.servlet.DispatcherServlet.doDispatch(DispatcherServlet.java:938)\r\n	... 50 more\r\nCaused by: java.lang.ClassNotFoundException: com.jeeplus.common.utils.FileUtils\r\n	at org.apache.catalina.loader.WebappClassLoaderBase.loadClass(WebappClassLoaderBase.java:1892)\r\n	at org.apache.catalina.loader.WebappClassLoaderBase.loadClass(WebappClassLoaderBase.java:1735)\r\n	... 85 more\r\n');
INSERT INTO `sys_log` VALUES ('88fc72bc-94ca-464f-b72b-0619e93dea9a', '1', '代码生成-表单配置', '1', '2017-04-14 19:23:41', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('89030a39-3ca7-4a9b-91f7-0c9bdb83823f', '1', '代码生成-表单配置', '1', '2017-04-14 19:06:56', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('89ff9211-955f-4394-aeb9-e1e8873edddb', '1', '代码生成-表单配置-生成代码', '1', '2017-04-14 22:31:55', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable/genCodeForm', 'GET', 'genTable.id=82fd6044-9a25-4d11-b467-7e3e5b50befa', '');
INSERT INTO `sys_log` VALUES ('8ad17dd5-60f1-424d-810d-f543c76f8a38', '2', '', '1', '2017-04-14 19:13:00', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable/form', 'GET', 'id=028cbf9e-768f-4f6d-a4ca-e240e8ecc389', 'javax.el.PropertyNotFoundException: Property \'delFlag\' not found on type com.jeeplus.modules.gen.entity.GenTableColumn\r\n	at javax.el.BeanELResolver$BeanProperties.get(BeanELResolver.java:290)\r\n	at javax.el.BeanELResolver$BeanProperties.access$300(BeanELResolver.java:243)\r\n	at javax.el.BeanELResolver.property(BeanELResolver.java:377)\r\n	at javax.el.BeanELResolver.getValue(BeanELResolver.java:97)\r\n	at org.apache.jasper.el.JasperELResolver.getValue(JasperELResolver.java:104)\r\n	at org.apache.el.parser.AstValue.getValue(AstValue.java:184)\r\n	at org.apache.el.parser.AstEqual.getValue(AstEqual.java:37)\r\n	at org.apache.el.parser.AstChoice.getValue(AstChoice.java:44)\r\n	at org.apache.el.ValueExpressionImpl.getValue(ValueExpressionImpl.java:184)\r\n	at org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate(PageContextImpl.java:950)\r\n	at org.apache.jsp.webpage.modules.gen.genTableForm_jsp._jspx_meth_c_005fforEach_005f4(genTableForm_jsp.java:1697)\r\n	at org.apache.jsp.webpage.modules.gen.genTableForm_jsp._jspService(genTableForm_jsp.java:723)\r\n	at org.apache.jasper.runtime.HttpJspBase.service(HttpJspBase.java:70)\r\n	at javax.servlet.http.HttpServlet.service(HttpServlet.java:731)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:303)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at org.apache.tomcat.websocket.server.WsFilter.doFilter(WsFilter.java:52)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:241)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at org.apache.catalina.core.ApplicationDispatcher.invoke(ApplicationDispatcher.java:743)\r\n	at org.apache.catalina.core.ApplicationDispatcher.processRequest(ApplicationDispatcher.java:485)\r\n	at org.apache.catalina.core.ApplicationDispatcher.doForward(ApplicationDispatcher.java:410)\r\n	at org.apache.catalina.core.ApplicationDispatcher.forward(ApplicationDispatcher.java:337)\r\n	at org.springframework.web.servlet.view.InternalResourceView.renderMergedOutputModel(InternalResourceView.java:209)\r\n	at org.springframework.web.servlet.view.AbstractView.render(AbstractView.java:267)\r\n	at org.springframework.web.servlet.DispatcherServlet.render(DispatcherServlet.java:1221)\r\n	at org.springframework.web.servlet.DispatcherServlet.processDispatchResult(DispatcherServlet.java:1005)\r\n	at org.springframework.web.servlet.DispatcherServlet.doDispatch(DispatcherServlet.java:952)\r\n	at org.springframework.web.servlet.DispatcherServlet.doService(DispatcherServlet.java:870)\r\n	at org.springframework.web.servlet.FrameworkServlet.processRequest(FrameworkServlet.java:961)\r\n	at org.springframework.web.servlet.FrameworkServlet.doGet(FrameworkServlet.java:852)\r\n	at javax.servlet.http.HttpServlet.service(HttpServlet.java:624)\r\n	at org.springframework.web.servlet.FrameworkServlet.service(FrameworkServlet.java:837)\r\n	at javax.servlet.http.HttpServlet.service(HttpServlet.java:731)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:303)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at org.apache.tomcat.websocket.server.WsFilter.doFilter(WsFilter.java:52)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:241)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at com.opensymphony.sitemesh.webapp.SiteMeshFilter.obtainContent(SiteMeshFilter.java:129)\r\n	at com.opensymphony.sitemesh.webapp.SiteMeshFilter.doFilter(SiteMeshFilter.java:77)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:241)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at org.apache.shiro.web.servlet.ProxiedFilterChain.doFilter(ProxiedFilterChain.java:61)\r\n	at org.apache.shiro.web.servlet.AdviceFilter.executeChain(AdviceFilter.java:108)\r\n	at org.apache.shiro.web.servlet.AdviceFilter.doFilterInternal(AdviceFilter.java:137)\r\n	at org.apache.shiro.web.servlet.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:125)\r\n	at org.apache.shiro.web.servlet.ProxiedFilterChain.doFilter(ProxiedFilterChain.java:66)\r\n	at org.apache.shiro.web.servlet.AbstractShiroFilter.executeChain(AbstractShiroFilter.java:449)\r\n	at org.apache.shiro.web.servlet.AbstractShiroFilter$1.call(AbstractShiroFilter.java:365)\r\n	at org.apache.shiro.subject.support.SubjectCallable.doCall(SubjectCallable.java:90)\r\n	at org.apache.shiro.subject.support.SubjectCallable.call(SubjectCallable.java:83)\r\n	at org.apache.shiro.subject.support.DelegatingSubject.execute(DelegatingSubject.java:383)\r\n	at org.apache.shiro.web.servlet.AbstractShiroFilter.doFilterInternal(AbstractShiroFilter.java:362)\r\n	at org.apache.shiro.web.servlet.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:125)\r\n	at org.springframework.web.filter.DelegatingFilterProxy.invokeDelegate(DelegatingFilterProxy.java:344)\r\n	at org.springframework.web.filter.DelegatingFilterProxy.doFilter(DelegatingFilterProxy.java:261)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:241)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at org.springframework.web.filter.CharacterEncodingFilter.doFilterInternal(CharacterEncodingFilter.java:88)\r\n	at org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:107)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:241)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at org.apache.catalina.core.StandardWrapperValve.invoke(StandardWrapperValve.java:218)\r\n	at org.apache.catalina.core.StandardContextValve.invoke(StandardContextValve.java:110)\r\n	at org.apache.catalina.authenticator.AuthenticatorBase.invoke(AuthenticatorBase.java:506)\r\n	at org.apache.catalina.core.StandardHostValve.invoke(StandardHostValve.java:169)\r\n	at org.apache.catalina.valves.ErrorReportValve.invoke(ErrorReportValve.java:103)\r\n	at org.apache.catalina.valves.AccessLogValve.invoke(AccessLogValve.java:962)\r\n	at org.apache.catalina.core.StandardEngineValve.invoke(StandardEngineValve.java:116)\r\n	at org.apache.catalina.connector.CoyoteAdapter.service(CoyoteAdapter.java:445)\r\n	at org.apache.coyote.http11.AbstractHttp11Processor.process(AbstractHttp11Processor.java:1087)\r\n	at org.apache.coyote.AbstractProtocol$AbstractConnectionHandler.process(AbstractProtocol.java:637)\r\n	at org.apache.tomcat.util.net.JIoEndpoint$SocketProcessor.run(JIoEndpoint.java:318)\r\n	at java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1142)\r\n	at java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:617)\r\n	at org.apache.tomcat.util.threads.TaskThread$WrappingRunnable.run(TaskThread.java:61)\r\n	at java.lang.Thread.run(Thread.java:745)\r\n');
INSERT INTO `sys_log` VALUES ('8c9f862c-1260-4d7e-9580-57bde46f2e18', '1', '代码生成-表单配置', '1', '2017-04-14 22:47:15', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('906c7e56-d312-440f-a4c7-31796faa5422', '1', '系统设置-用户管理', '1', '2017-04-14 15:31:51', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('993b77dc-ed31-4241-ae48-4fa775b11522', '1', '系统设置-字典管理', '1', '2017-04-14 09:48:55', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/dict/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('99aa3dbe-c0dd-4302-95de-8b9f5ab21b13', '1', '系统设置-角色管理', '1', '2017-04-14 18:53:32', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/role/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('a0ef91e2-466b-415f-b1c6-231d241e6806', '1', '代码生成-表单配置-生成代码', '1', '2017-04-14 21:31:02', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable/genCodeForm', 'GET', 'genTable.id=82fd6044-9a25-4d11-b467-7e3e5b50befa', '');
INSERT INTO `sys_log` VALUES ('a220833a-9fc2-47b5-92ae-73c57e2704fb', '1', '代码生成-表单配置-生成代码', '1', '2017-04-14 21:24:22', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable/genCodeForm', 'GET', 'genTable.id=82fd6044-9a25-4d11-b467-7e3e5b50befa', '');
INSERT INTO `sys_log` VALUES ('a5a53acd-617a-4afe-9f1c-f60101b4aaa1', '1', '系统登录', '1', '2017-04-14 17:59:47', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('a812847b-3588-4535-b6c0-e9263d1e714d', '1', '代码生成-表单配置-导入', '1', '2017-04-14 21:04:04', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable/importTableFromDB', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('a81ec894-466c-422a-a9e7-3adc480c1d12', '1', '系统设置-用户管理', '1', '2017-04-14 11:17:36', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('acb354b0-05f8-4243-9bca-b2cf6aa31665', '1', '系统设置-菜单管理', '1', '2017-04-14 18:58:19', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/menu/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('b1debb05-2f5b-4639-95cf-c7aa62ccf1b6', '1', '系统登录', '1', '2017-04-14 10:27:02', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a;JSESSIONID=d49cfe4e-52fc-45d8-8e57-440f8db4f1bc', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('b4462928-64c1-4467-8dd3-1132bbbab6a4', '1', '系统登录', '1', '2017-04-14 09:58:11', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a;JSESSIONID=d49cfe4e-52fc-45d8-8e57-440f8db4f1bc', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('bb2467a6-99d8-4149-894d-c330e306cfda', '1', '代码生成-表单配置-生成代码', '1', '2017-04-14 19:25:35', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable/genCodeForm', 'GET', 'genTable.id=028cbf9e-768f-4f6d-a4ca-e240e8ecc389', '');
INSERT INTO `sys_log` VALUES ('bc632eaa-3a5a-431e-a455-f90c6acceac4', '1', '系统登录', '1', '2017-04-14 19:31:56', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('bc6c9e76-2559-4126-be33-f948c4c0cf2f', '1', '代码生成-表单配置-导入', '1', '2017-04-14 21:04:08', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable/importTableFromDB', 'POST', 'id=&name=article', '');
INSERT INTO `sys_log` VALUES ('c1ef4e20-adfc-43ef-acb9-e8cd8f3a3740', '1', '系统设置-角色管理', '1', '2017-04-14 18:58:07', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/role/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('c3315b37-aa89-4d5e-8cb4-2776ab83bdf0', '1', '系统设置-角色管理-权限设置', '1', '2017-04-14 19:06:39', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/role/auth', 'GET', 'id=1c54e003c1fc4dcd9b087ef8d48abac3', '');
INSERT INTO `sys_log` VALUES ('c4931cd0-5115-48b6-b5df-c9f8addeb026', '1', '系统设置-用户管理-导出', '1', '2017-04-14 18:52:50', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/export', 'POST', 'pageNo=-1&pageSize=-1&orderBy=&loginName=&name=', '');
INSERT INTO `sys_log` VALUES ('c83ddc2a-1fdc-4d14-b6d3-4f471179debf', '1', '代码生成-表单配置', '1', '2017-04-14 21:23:57', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('c9e2e66d-f926-41a7-ae8b-f1843e8997e4', '1', '代码生成-表单配置', '1', '2017-04-14 21:30:17', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('ce49b7b7-6e48-42e2-82ac-996ab11e54fa', '1', '系统设置-角色管理', '1', '2017-04-14 18:28:33', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/role/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('d138f99f-fe9e-42e8-9136-19d95c478196', '1', '系统登录', '1', '2017-04-14 19:05:31', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('d1ca05d1-e7ad-4ca8-a4c8-1006b9511eba', '1', '系统登录', '1', '2017-04-14 19:37:39', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/webpage/modules/gen/genTableList.jsp', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('d33d5774-da6d-4498-8c3e-dec55a4774c6', '1', '代码生成-表单配置', '1', '2017-04-14 21:13:12', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('d34f74ee-2fcd-4382-90b2-e8e1125182dd', '1', '代码生成-表单配置-同步数据库', '1', '2017-04-14 19:25:25', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable/synchDb', 'GET', 'id=028cbf9e-768f-4f6d-a4ca-e240e8ecc389', '');
INSERT INTO `sys_log` VALUES ('d587efbd-f2ce-4e31-8544-c1830e104234', '1', '系统设置-用户管理', '1', '2017-04-14 17:59:04', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('d6cc8081-eb02-4e01-bb2e-0995d2c032c9', '1', '系统登录', '1', '2017-04-14 18:25:56', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('d71fc2b9-abec-40e5-bbf7-5653ba1f6b7f', '1', '内容管理-文章', '1', '2017-04-14 21:32:30', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/cms/article/article', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('d7335a0f-35f9-4b4a-8792-28d22e1b6475', '1', '系统登录', '1', '2017-04-14 22:43:54', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('dca6ea7b-5f8f-4f00-a109-992e4b8e77ec', '2', '', '1', '2017-04-14 19:01:29', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/form', 'GET', 'id=4', 'org.apache.jasper.JasperException: javax.el.PropertyNotFoundException: Property \'createDate\' not found on type com.jeeplus.modules.sys.entity.User\r\n	at org.apache.jasper.servlet.JspServletWrapper.handleJspException(JspServletWrapper.java:561)\r\n	at org.apache.jasper.servlet.JspServletWrapper.service(JspServletWrapper.java:477)\r\n	at org.apache.jasper.servlet.JspServlet.serviceJspFile(JspServlet.java:395)\r\n	at org.apache.jasper.servlet.JspServlet.service(JspServlet.java:339)\r\n	at javax.servlet.http.HttpServlet.service(HttpServlet.java:731)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:303)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at org.apache.tomcat.websocket.server.WsFilter.doFilter(WsFilter.java:52)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:241)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at org.apache.catalina.core.ApplicationDispatcher.invoke(ApplicationDispatcher.java:743)\r\n	at org.apache.catalina.core.ApplicationDispatcher.processRequest(ApplicationDispatcher.java:485)\r\n	at org.apache.catalina.core.ApplicationDispatcher.doForward(ApplicationDispatcher.java:410)\r\n	at org.apache.catalina.core.ApplicationDispatcher.forward(ApplicationDispatcher.java:337)\r\n	at org.springframework.web.servlet.view.InternalResourceView.renderMergedOutputModel(InternalResourceView.java:209)\r\n	at org.springframework.web.servlet.view.AbstractView.render(AbstractView.java:267)\r\n	at org.springframework.web.servlet.DispatcherServlet.render(DispatcherServlet.java:1221)\r\n	at org.springframework.web.servlet.DispatcherServlet.processDispatchResult(DispatcherServlet.java:1005)\r\n	at org.springframework.web.servlet.DispatcherServlet.doDispatch(DispatcherServlet.java:952)\r\n	at org.springframework.web.servlet.DispatcherServlet.doService(DispatcherServlet.java:870)\r\n	at org.springframework.web.servlet.FrameworkServlet.processRequest(FrameworkServlet.java:961)\r\n	at org.springframework.web.servlet.FrameworkServlet.doGet(FrameworkServlet.java:852)\r\n	at javax.servlet.http.HttpServlet.service(HttpServlet.java:624)\r\n	at org.springframework.web.servlet.FrameworkServlet.service(FrameworkServlet.java:837)\r\n	at javax.servlet.http.HttpServlet.service(HttpServlet.java:731)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:303)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at org.apache.tomcat.websocket.server.WsFilter.doFilter(WsFilter.java:52)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:241)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at com.opensymphony.sitemesh.webapp.SiteMeshFilter.obtainContent(SiteMeshFilter.java:129)\r\n	at com.opensymphony.sitemesh.webapp.SiteMeshFilter.doFilter(SiteMeshFilter.java:77)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:241)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at org.apache.shiro.web.servlet.ProxiedFilterChain.doFilter(ProxiedFilterChain.java:61)\r\n	at org.apache.shiro.web.servlet.AdviceFilter.executeChain(AdviceFilter.java:108)\r\n	at org.apache.shiro.web.servlet.AdviceFilter.doFilterInternal(AdviceFilter.java:137)\r\n	at org.apache.shiro.web.servlet.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:125)\r\n	at org.apache.shiro.web.servlet.ProxiedFilterChain.doFilter(ProxiedFilterChain.java:66)\r\n	at org.apache.shiro.web.servlet.AbstractShiroFilter.executeChain(AbstractShiroFilter.java:449)\r\n	at org.apache.shiro.web.servlet.AbstractShiroFilter$1.call(AbstractShiroFilter.java:365)\r\n	at org.apache.shiro.subject.support.SubjectCallable.doCall(SubjectCallable.java:90)\r\n	at org.apache.shiro.subject.support.SubjectCallable.call(SubjectCallable.java:83)\r\n	at org.apache.shiro.subject.support.DelegatingSubject.execute(DelegatingSubject.java:383)\r\n	at org.apache.shiro.web.servlet.AbstractShiroFilter.doFilterInternal(AbstractShiroFilter.java:362)\r\n	at org.apache.shiro.web.servlet.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:125)\r\n	at org.springframework.web.filter.DelegatingFilterProxy.invokeDelegate(DelegatingFilterProxy.java:344)\r\n	at org.springframework.web.filter.DelegatingFilterProxy.doFilter(DelegatingFilterProxy.java:261)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:241)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at org.springframework.web.filter.CharacterEncodingFilter.doFilterInternal(CharacterEncodingFilter.java:88)\r\n	at org.springframework.web.filter.OncePerRequestFilter.doFilter(OncePerRequestFilter.java:107)\r\n	at org.apache.catalina.core.ApplicationFilterChain.internalDoFilter(ApplicationFilterChain.java:241)\r\n	at org.apache.catalina.core.ApplicationFilterChain.doFilter(ApplicationFilterChain.java:208)\r\n	at org.apache.catalina.core.StandardWrapperValve.invoke(StandardWrapperValve.java:218)\r\n	at org.apache.catalina.core.StandardContextValve.invoke(StandardContextValve.java:110)\r\n	at org.apache.catalina.authenticator.AuthenticatorBase.invoke(AuthenticatorBase.java:506)\r\n	at org.apache.catalina.core.StandardHostValve.invoke(StandardHostValve.java:169)\r\n	at org.apache.catalina.valves.ErrorReportValve.invoke(ErrorReportValve.java:103)\r\n	at org.apache.catalina.valves.AccessLogValve.invoke(AccessLogValve.java:962)\r\n	at org.apache.catalina.core.StandardEngineValve.invoke(StandardEngineValve.java:116)\r\n	at org.apache.catalina.connector.CoyoteAdapter.service(CoyoteAdapter.java:445)\r\n	at org.apache.coyote.http11.AbstractHttp11Processor.process(AbstractHttp11Processor.java:1087)\r\n	at org.apache.coyote.AbstractProtocol$AbstractConnectionHandler.process(AbstractProtocol.java:637)\r\n	at org.apache.tomcat.util.net.JIoEndpoint$SocketProcessor.run(JIoEndpoint.java:318)\r\n	at java.util.concurrent.ThreadPoolExecutor.runWorker(ThreadPoolExecutor.java:1142)\r\n	at java.util.concurrent.ThreadPoolExecutor$Worker.run(ThreadPoolExecutor.java:617)\r\n	at org.apache.tomcat.util.threads.TaskThread$WrappingRunnable.run(TaskThread.java:61)\r\n	at java.lang.Thread.run(Thread.java:745)\r\nCaused by: javax.el.PropertyNotFoundException: Property \'createDate\' not found on type com.jeeplus.modules.sys.entity.User\r\n	at javax.el.BeanELResolver$BeanProperties.get(BeanELResolver.java:290)\r\n	at javax.el.BeanELResolver$BeanProperties.access$300(BeanELResolver.java:243)\r\n	at javax.el.BeanELResolver.property(BeanELResolver.java:377)\r\n	at javax.el.BeanELResolver.getValue(BeanELResolver.java:97)\r\n	at org.apache.jasper.el.JasperELResolver.getValue(JasperELResolver.java:104)\r\n	at org.apache.el.parser.AstValue.getValue(AstValue.java:184)\r\n	at org.apache.el.ValueExpressionImpl.getValue(ValueExpressionImpl.java:184)\r\n	at org.apache.jasper.runtime.PageContextImpl.proprietaryEvaluate(PageContextImpl.java:950)\r\n	at org.apache.jsp.webpage.modules.sys.userForm_jsp._jspx_meth_fmt_005fformatDate_005f0(userForm_jsp.java:900)\r\n	at org.apache.jsp.webpage.modules.sys.userForm_jsp._jspx_meth_c_005fif_005f3(userForm_jsp.java:861)\r\n	at org.apache.jsp.webpage.modules.sys.userForm_jsp._jspx_meth_form_005fform_005f0(userForm_jsp.java:382)\r\n	at org.apache.jsp.webpage.modules.sys.userForm_jsp._jspService(userForm_jsp.java:197)\r\n	at org.apache.jasper.runtime.HttpJspBase.service(HttpJspBase.java:70)\r\n	at javax.servlet.http.HttpServlet.service(HttpServlet.java:731)\r\n	at org.apache.jasper.servlet.JspServletWrapper.service(JspServletWrapper.java:439)\r\n	... 67 more\r\n');
INSERT INTO `sys_log` VALUES ('de1a1c34-d1c9-4870-85b2-10c9fc97dcd4', '1', '系统设置-区域管理-删除', '1', '2017-04-14 09:59:41', '0:0:0:0:0:0:0:1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/area/delete', 'GET', 'id=a58fc167-43db-440e-b19c-0b854a5d901e', '');
INSERT INTO `sys_log` VALUES ('de505fc4-bba3-4d2d-b5e2-b62c197757e3', '1', '代码生成-表单配置', '1', '2017-04-14 21:13:01', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('e0c3e762-4230-40d9-bfb2-9769b0526a3b', '1', '代码生成-表单配置-同步数据库', '1', '2017-04-14 21:07:07', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable/synchDb', 'GET', 'id=82fd6044-9a25-4d11-b467-7e3e5b50befa', '');
INSERT INTO `sys_log` VALUES ('e10fc46a-0047-499e-9683-6fc6bdbdde09', '1', '代码生成-表单配置', '1', '2017-04-14 21:15:00', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('e520ffb3-c5ab-407e-9f20-c88765ce81d7', '1', '代码生成-表单配置', '1', '2017-04-14 21:03:36', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/gen/genTable', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('ead40dc8-c91b-4495-8d1d-16d044b61879', '1', '系统设置-菜单管理', '1', '2017-04-14 21:25:24', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/menu/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('eb11c388-ccc8-4bf5-b206-204469cc6fe5', '1', '系统登录', '1', '2017-04-14 18:52:10', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a', 'GET', 'login=', '');
INSERT INTO `sys_log` VALUES ('ebcee3df-9748-464b-ae30-8d8b7f653ecb', '1', '系统设置-角色管理', '1', '2017-04-14 11:32:59', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/role/', 'POST', 'pageNo=&pageSize=&orderBy=&name=', '');
INSERT INTO `sys_log` VALUES ('ec21fd8c-5cbb-4383-9c3c-23ffe3169c57', '1', '系统设置-菜单管理', '1', '2017-04-14 21:02:15', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/menu/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('f06287cf-68a8-4de7-b2cc-c207659ef7db', '1', '系统设置-菜单管理', '1', '2017-04-14 19:06:32', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/menu/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('f20842bb-28a0-4d20-904b-6e2d54d440ec', '1', '系统设置-角色管理', '1', '2017-04-14 11:17:53', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/role/', 'GET', 'repage=', '');
INSERT INTO `sys_log` VALUES ('f43bc018-28d7-461b-a204-ade114c4ffac', '1', '系统设置-用户管理', '1', '2017-04-14 14:18:30', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('f516a3e7-fd98-4f94-a70d-25432b896ecb', '1', '系统登录', '1', '2017-04-14 14:14:31', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a;JSESSIONID=d49cfe4e-52fc-45d8-8e57-440f8db4f1bc', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('fc6434f3-65ad-406b-9bce-5c9e567122e9', '1', '系统设置-菜单管理', '1', '2017-04-14 21:03:26', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/menu/', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('fd70893f-4074-45c2-9c59-35f02017e3b8', '1', '内容管理-文章', '1', '2017-04-14 21:29:45', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/cms/article/article', 'GET', '', '');
INSERT INTO `sys_log` VALUES ('fed9db33-ad78-4861-887b-e3fb66882dee', '1', '系统设置-角色管理', '1', '2017-04-14 11:20:28', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/role/', 'GET', 'repage=', '');
INSERT INTO `sys_log` VALUES ('ff2a57c6-d066-4aef-85c3-6ecd4136e8e3', '1', '系统设置-用户管理', '1', '2017-04-14 14:24:52', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/57.0.2987.133 Safari/537.36', '/a/sys/user/index', 'GET', '', '');

-- ----------------------------
-- Table structure for sys_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_menu`;
CREATE TABLE `sys_menu` (
  `id` varchar(64) NOT NULL COMMENT '编号',
  `parent_id` varchar(64) NOT NULL COMMENT '父级编号',
  `parent_ids` varchar(2000) NOT NULL COMMENT '所有父级编号',
  `name` varchar(100) NOT NULL COMMENT '名称',
  `sort` decimal(10,0) NOT NULL COMMENT '排序',
  `href` varchar(2000) DEFAULT NULL COMMENT '链接',
  `target` varchar(20) DEFAULT NULL COMMENT '目标',
  `icon` varchar(100) DEFAULT NULL COMMENT '图标',
  `is_show` tinyint(1) NOT NULL COMMENT '是否在菜单中显示',
  `permission` varchar(200) DEFAULT NULL COMMENT '权限标识',
  `create_by` int(11) NOT NULL COMMENT '创建者',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_by` int(11) NOT NULL COMMENT '更新者',
  `update_time` datetime NOT NULL COMMENT '更新时间',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `sys_menu_parent_id` (`parent_id`),
  KEY `sys_menu_del_flag` (`is_del`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='菜单表';

-- ----------------------------
-- Records of sys_menu
-- ----------------------------
INSERT INTO `sys_menu` VALUES ('1', '0', '0,', '功能菜单', '0', null, null, null, '1', null, '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_menu` VALUES ('10', '3', '0,1,3,', '字典管理', '60', '/sys/dict/', '', 'th-list', '1', 'sys:dict:list', '1', '2013-05-27 08:00:00', '1', '2015-12-24 22:23:07', '0');
INSERT INTO `sys_menu` VALUES ('11', '10', '0,1,3,10,', '查看', '30', null, null, null, '0', 'sys:dict:view', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_menu` VALUES ('12', '10', '0,1,3,10,', '修改', '40', null, null, null, '0', 'sys:dict:edit', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_menu` VALUES ('14', '3', '0,1,3,', '区域管理', '50', '/sys/area/', '', 'th', '1', 'sys:area:list', '1', '2013-05-27 08:00:00', '1', '2015-12-24 21:35:11', '0');
INSERT INTO `sys_menu` VALUES ('15', '14', '0,1,3,14,', '查看', '30', null, null, null, '0', 'sys:area:view', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_menu` VALUES ('16', '14', '0,1,3,14,', '修改', '40', null, null, null, '0', 'sys:area:edit', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_menu` VALUES ('20', '3', '0,1,3,', '用户管理', '30', '/sys/user/index', '', 'icon-adjust', '1', 'sys:user:index', '1', '2013-05-27 08:00:00', '1', '2015-12-19 21:46:20', '0');
INSERT INTO `sys_menu` VALUES ('21', '20', '0,1,3,20,', '查看', '30', null, null, null, '0', 'sys:user:view', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_menu` VALUES ('22', '20', '0,1,3,20,', '修改', '40', null, null, null, '0', 'sys:user:edit', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_menu` VALUES ('25c90d71-e04c-4909-bc0d-ff75d59b6eef', '1', '0,1,', '内容管理', '1015', '', '', 'fa-sticky-note-o', '1', '', '1', '2017-04-14 21:03:23', '1', '2017-04-14 21:03:23', '0');
INSERT INTO `sys_menu` VALUES ('2a0f940fbe304a05a6b4040ddf6df279', '20', '0,1,3,20,', '增加', '70', '', '', '', '0', 'sys:user:add', '1', '2015-12-19 21:47:00', '1', '2015-12-19 21:47:00', '0');
INSERT INTO `sys_menu` VALUES ('3', '1', '0,1,', '系统设置', '500', '', '', 'fa-cog', '1', '', '1', '2013-05-27 08:00:00', '1', '2015-11-04 17:27:37', '0');
INSERT INTO `sys_menu` VALUES ('31c5ace5-38c3-4c8c-bb1c-519116aef368', '501c03e1-828e-4767-b705-9f0c7cbc4861', '0,1,25c90d71-e04c-4909-bc0d-ff75d59b6eef,501c03e1-828e-4767-b705-9f0c7cbc4861,', '删除', '60', null, null, null, '0', 'cms:article:article:del', '1', '2017-04-14 21:26:19', '1', '2017-04-14 21:26:19', '0');
INSERT INTO `sys_menu` VALUES ('3c1c639c76f14f6f9903b0143371ea09', '7', '0,1,3,7,', '添加', '70', '', '', '', '0', 'sys:role:add', '1', '2015-12-23 21:35:08', '1', '2015-12-23 21:36:18', '0');
INSERT INTO `sys_menu` VALUES ('4', '3', '0,1,3,', '菜单管理', '30', '/sys/menu/', '', 'list-alt', '1', 'sys:menu:list', '1', '2013-05-27 08:00:00', '1', '2015-12-20 18:59:32', '0');
INSERT INTO `sys_menu` VALUES ('5', '4', '0,1,3,4,', '增加', '30', '', '', '', '0', 'sys:menu:add', '1', '2013-05-27 08:00:00', '1', '2015-12-20 19:00:22', '0');
INSERT INTO `sys_menu` VALUES ('501c03e1-828e-4767-b705-9f0c7cbc4861', '25c90d71-e04c-4909-bc0d-ff75d59b6eef', '0,1,25c90d71-e04c-4909-bc0d-ff75d59b6eef,', '文章', '1045', '/cms/article/article', null, 'fa-sticky-note-o', '1', 'cms:article:article:list', '1', '2017-04-14 21:26:19', '1', '2017-04-14 21:26:19', '0');
INSERT INTO `sys_menu` VALUES ('5239527958e94d418997b584b85d8b80', '14', '0,1,3,14,', '删除', '100', '', '', '', '0', 'sys:area:del', '1', '2015-12-24 21:37:13', '1', '2015-12-24 21:37:13', '0');
INSERT INTO `sys_menu` VALUES ('57f1f00d6cb14819bef388acd10e6f5a', '68', '0,1,67,68,', '删除', '60', '', '', '', '0', 'sys:log:del', '1', '2015-12-25 20:25:55', '1', '2015-12-25 20:25:55', '0');
INSERT INTO `sys_menu` VALUES ('5e755e57-02ab-4ee4-8a50-fcf8f5fd7dcc', '501c03e1-828e-4767-b705-9f0c7cbc4861', '0,1,25c90d71-e04c-4909-bc0d-ff75d59b6eef,501c03e1-828e-4767-b705-9f0c7cbc4861,', '导入', '150', null, null, null, '0', 'cms:article:article:import', '1', '2017-04-14 21:26:20', '1', '2017-04-14 21:26:20', '0');
INSERT INTO `sys_menu` VALUES ('5fd361a6-f5b0-4d06-8910-f0c00ec0d589', '501c03e1-828e-4767-b705-9f0c7cbc4861', '0,1,25c90d71-e04c-4909-bc0d-ff75d59b6eef,501c03e1-828e-4767-b705-9f0c7cbc4861,', '增加', '30', null, null, null, '0', 'cms:article:article:add', '1', '2017-04-14 21:26:19', '1', '2017-04-14 21:26:19', '0');
INSERT INTO `sys_menu` VALUES ('6', '4', '0,1,3,4,', '修改', '40', null, null, null, '0', 'sys:menu:edit', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_menu` VALUES ('6509eed6eb634030a46723a18814035c', '7', '0,1,3,7,', '分配用户', '100', '', '', '', '0', 'sys:role:assign', '1', '2015-12-23 21:35:37', '1', '2015-12-23 21:53:23', '0');
INSERT INTO `sys_menu` VALUES ('65e33f66-43c2-4b69-a025-bca5507d9066', '501c03e1-828e-4767-b705-9f0c7cbc4861', '0,1,25c90d71-e04c-4909-bc0d-ff75d59b6eef,501c03e1-828e-4767-b705-9f0c7cbc4861,', '导出', '180', null, null, null, '0', 'cms:article:article:export', '1', '2017-04-14 21:26:20', '1', '2017-04-14 21:26:20', '0');
INSERT INTO `sys_menu` VALUES ('67', '1', '0,1,', '系统监控', '985', '', '', 'fa-video-camera', '1', '', '1', '2013-06-03 08:00:00', '1', '2016-03-05 10:18:41', '0');
INSERT INTO `sys_menu` VALUES ('68', '67', '0,1,67,', '日志查询', '30', '/sys/log', '', 'pencil', '1', 'sys:log:list', '1', '2013-06-03 08:00:00', '1', '2015-12-25 20:26:16', '0');
INSERT INTO `sys_menu` VALUES ('68f9151151174868ab436e11e03bf548', '4', '0,1,3,4,', '删除', '70', '', '', '', '0', 'sys:menu:del', '1', '2015-12-20 19:01:16', '1', '2015-12-20 19:03:05', '0');
INSERT INTO `sys_menu` VALUES ('6c672b854d2b4821b89297640df5fc26', '82', '0,1,79,82,', '同步数据库', '180', '', '', '', '0', 'gen:genTable:synchDb', '1', '2016-01-07 11:31:00', '1', '2016-01-07 11:32:23', '0');
INSERT INTO `sys_menu` VALUES ('6d3a6777693f47c98e9b3051cacbcfdb', '10', '0,1,3,10,', '增加', '70', '', '', '', '0', 'sys:dict:add', '1', '2015-12-24 22:23:39', '1', '2015-12-24 22:24:22', '0');
INSERT INTO `sys_menu` VALUES ('7', '3', '0,1,3,', '角色管理', '50', '/sys/role/', '', 'lock', '1', 'sys:role:list', '1', '2013-05-27 08:00:00', '1', '2015-12-23 21:33:46', '0');
INSERT INTO `sys_menu` VALUES ('79', '1', '0,1,', '代码生成', '20', '', '', 'fa-codepen', '1', '', '1', '2013-10-16 08:00:00', '1', '2016-05-31 08:56:25', '0');
INSERT INTO `sys_menu` VALUES ('79f0ffa47dbe43ffa8824d97612d344f', '4', '0,1,3,4,', '保存排序', '100', '', '', '', '0', 'sys:menu:updateSort', '1', '2015-12-20 19:02:08', '1', '2015-12-20 19:02:08', '0');
INSERT INTO `sys_menu` VALUES ('79fca849d3da4a82a4ade3f6b9f45126', '20', '0,1,3,20,', '删除', '100', '', '', '', '0', 'sys:user:del', '1', '2015-12-19 21:47:44', '1', '2015-12-19 21:48:52', '0');
INSERT INTO `sys_menu` VALUES ('8', '7', '0,1,3,7,', '查看', '30', null, null, null, '0', 'sys:role:view', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_menu` VALUES ('82', '79', '0,1,79,', '表单配置', '20', '/gen/genTable', '', '', '1', 'gen:genTable:list', '1', '2013-10-16 08:00:00', '1', '2016-01-07 20:48:49', '0');
INSERT INTO `sys_menu` VALUES ('9', '7', '0,1,3,7,', '修改', '40', null, null, null, '0', 'sys:role:edit', '1', '2013-05-27 08:00:00', '1', '2013-05-27 08:00:00', '0');
INSERT INTO `sys_menu` VALUES ('91aa429a6cdc4a9b954d84ff1456934b', '68', '0,1,67,68,', '查看', '30', '', '', '', '0', 'sys:log:view', '1', '2015-12-25 20:25:25', '1', '2015-12-25 20:25:25', '0');
INSERT INTO `sys_menu` VALUES ('9bc1aa1053144a608b73f6fbd841d1c6', '10', '0,1,3,10,', '删除', '100', '', '', '', '0', 'sys:dict:del', '1', '2015-12-24 22:24:04', '1', '2015-12-24 22:24:31', '0');
INSERT INTO `sys_menu` VALUES ('afe18c81-dad8-4300-a8d9-1ba355ad2629', '501c03e1-828e-4767-b705-9f0c7cbc4861', '0,1,25c90d71-e04c-4909-bc0d-ff75d59b6eef,501c03e1-828e-4767-b705-9f0c7cbc4861,', '查看', '120', null, null, null, '0', 'cms:article:article:view', '1', '2017-04-14 21:26:20', '1', '2017-04-14 21:26:20', '0');
INSERT INTO `sys_menu` VALUES ('b9a776f5d7194406bb466388e3af9d08', '20', '0,1,3,20,', '导出', '160', '', '', '', '0', 'sys:user:export', '1', '2015-12-19 21:48:34', '1', '2015-12-19 21:48:34', '0');
INSERT INTO `sys_menu` VALUES ('c3de25a76785419b8a6820db3935941d', '82', '0,1,79,82,', '导入', '150', '', '', '', '0', 'gen:genTable:importDb', '1', '2016-01-07 11:30:25', '1', '2016-01-07 11:30:25', '0');
INSERT INTO `sys_menu` VALUES ('c6e0080e06014abd9240f870aadf3200', '14', '0,1,3,14,', '增加', '70', '', '', '', '0', 'sys:area:add', '1', '2015-12-24 21:35:39', '1', '2015-12-24 21:35:39', '0');
INSERT INTO `sys_menu` VALUES ('ca986372-cf91-4610-b961-08958091d2da', '501c03e1-828e-4767-b705-9f0c7cbc4861', '0,1,25c90d71-e04c-4909-bc0d-ff75d59b6eef,501c03e1-828e-4767-b705-9f0c7cbc4861,', '编辑', '90', null, null, null, '0', 'cms:article:article:edit', '1', '2017-04-14 21:26:20', '1', '2017-04-14 21:26:20', '0');
INSERT INTO `sys_menu` VALUES ('d3f1b6f292904ef5b95f7800cc777a48', '82', '0,1,79,82,', '查看', '30', '', '', '', '0', 'gen:genTable:view,gen:genTableColumn:view', '1', '2016-01-07 11:26:42', '1', '2016-01-07 11:26:42', '0');
INSERT INTO `sys_menu` VALUES ('d64d25d7b3014f9ba7736867cb2ffc43', '82', '0,1,79,82,', '生成代码', '210', '', '', '', '1', 'gen:genTable:genCode', '1', '2016-01-07 11:31:24', '1', '2016-01-07 11:31:24', '0');
INSERT INTO `sys_menu` VALUES ('d75f64438d994fc4830b1b3d138cde32', '82', '0,1,79,82,', '删除', '120', '', '', '', '0', 'gen:genTable:del', '1', '2016-01-07 11:29:23', '1', '2016-01-07 11:29:23', '0');
INSERT INTO `sys_menu` VALUES ('de7c50d276454f80881c41a096ecf55c', '7', '0,1,3,7,', '删除', '160', '', '', '', '0', 'sys:role:del', '1', '2015-12-23 21:59:46', '1', '2015-12-23 21:59:46', '0');
INSERT INTO `sys_menu` VALUES ('e03f8b6a5e454addb04fc08033b6f60b', '82', '0,1,79,82,', '增加', '90', '', '', '', '0', 'gen:genTable:add', '1', '2016-01-07 11:28:59', '1', '2016-01-07 11:28:59', '0');
INSERT INTO `sys_menu` VALUES ('e824b7c20bb34c9ca9ad023e8873e67b', '82', '0,1,79,82,', '编辑', '60', '', '', '', '0', 'gen:genTable:edit,gen:genTableColumn:edit', '1', '2016-01-07 11:27:55', '1', '2016-01-07 11:31:46', '0');
INSERT INTO `sys_menu` VALUES ('ec7cf7a144a440cab217aabd4ffb7788', '4', '0,1,3,4,', '查看', '130', '', '', '', '0', 'sys:menu:view', '1', '2015-12-20 19:02:54', '1', '2015-12-20 19:02:54', '0');
INSERT INTO `sys_menu` VALUES ('f34887a78fa245c1977603ca7dc98e11', '20', '0,1,3,20,', '导入', '130', '', '', '', '0', 'sys:user:import', '1', '2015-12-19 21:48:13', '1', '2015-12-19 21:48:44', '0');
INSERT INTO `sys_menu` VALUES ('f93f9a3a2226461dace3b8992cf055ba', '7', '0,1,3,7,', '权限设置', '130', '', '', '', '0', 'sys:role:auth', '1', '2015-12-23 21:36:06', '1', '2015-12-23 21:36:06', '0');

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role` (
  `id` varchar(64) NOT NULL COMMENT '编号',
  `name` varchar(100) NOT NULL COMMENT '角色名称',
  `enname` varchar(255) DEFAULT NULL COMMENT '英文名称',
  `role_type` varchar(255) DEFAULT NULL COMMENT '角色类型',
  `is_sys` tinyint(1) DEFAULT NULL COMMENT '是否系统数据',
  `useable` tinyint(1) DEFAULT NULL COMMENT '是否可用',
  `create_by` int(11) NOT NULL COMMENT '创建者',
  `create_time` datetime NOT NULL COMMENT '创建时间',
  `update_by` int(11) NOT NULL COMMENT '更新者',
  `update_time` datetime NOT NULL COMMENT '更新时间',
  `is_del` tinyint(1) NOT NULL DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  KEY `sys_role_del_flag` (`is_del`),
  KEY `sys_role_enname` (`enname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='角色表';

-- ----------------------------
-- Records of sys_role
-- ----------------------------
INSERT INTO `sys_role` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '管理员', 'system', 'assignment', '1', '1', '1', '2015-11-11 15:59:43', '1', '2017-04-14 19:06:44', '0');

-- ----------------------------
-- Table structure for sys_role_menu
-- ----------------------------
DROP TABLE IF EXISTS `sys_role_menu`;
CREATE TABLE `sys_role_menu` (
  `role_id` varchar(64) NOT NULL COMMENT '角色编号',
  `menu_id` varchar(64) NOT NULL COMMENT '菜单编号',
  PRIMARY KEY (`role_id`,`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='角色-菜单';

-- ----------------------------
-- Records of sys_role_menu
-- ----------------------------
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '1');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '10');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '11');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '12');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '14');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '15');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '16');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '20');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '21');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '22');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '2a0f940fbe304a05a6b4040ddf6df279');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '3');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '3c1c639c76f14f6f9903b0143371ea09');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '4');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '5');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '5239527958e94d418997b584b85d8b80');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '57f1f00d6cb14819bef388acd10e6f5a');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '6');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '6509eed6eb634030a46723a18814035c');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '67');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '68');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '68f9151151174868ab436e11e03bf548');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '6c672b854d2b4821b89297640df5fc26');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '6d3a6777693f47c98e9b3051cacbcfdb');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '7');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '79');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '79f0ffa47dbe43ffa8824d97612d344f');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '79fca849d3da4a82a4ade3f6b9f45126');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '8');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '82');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '9');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '91aa429a6cdc4a9b954d84ff1456934b');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', '9bc1aa1053144a608b73f6fbd841d1c6');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', 'b9a776f5d7194406bb466388e3af9d08');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', 'c3de25a76785419b8a6820db3935941d');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', 'c6e0080e06014abd9240f870aadf3200');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', 'd3f1b6f292904ef5b95f7800cc777a48');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', 'd64d25d7b3014f9ba7736867cb2ffc43');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', 'd75f64438d994fc4830b1b3d138cde32');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', 'de7c50d276454f80881c41a096ecf55c');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', 'e03f8b6a5e454addb04fc08033b6f60b');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', 'e824b7c20bb34c9ca9ad023e8873e67b');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', 'ec7cf7a144a440cab217aabd4ffb7788');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', 'f34887a78fa245c1977603ca7dc98e11');
INSERT INTO `sys_role_menu` VALUES ('1c54e003c1fc4dcd9b087ef8d48abac3', 'f93f9a3a2226461dace3b8992cf055ba');

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `login_name` varchar(100) NOT NULL COMMENT '登录名',
  `password` varchar(100) NOT NULL COMMENT '密码',
  `name` varchar(100) DEFAULT NULL COMMENT '姓名',
  `email` varchar(200) DEFAULT NULL COMMENT '邮箱',
  `phone` varchar(15) DEFAULT NULL COMMENT '电话',
  `avatar` varchar(255) DEFAULT NULL COMMENT '用户头像',
  `user_type` tinyint(1) DEFAULT NULL COMMENT '系统用户类型：保留字段',
  `login_ip` char(15) DEFAULT NULL COMMENT '最后登陆IP',
  `login_time` datetime DEFAULT NULL COMMENT '最后登陆时间',
  `locked` tinyint(1) DEFAULT '0' COMMENT '是否可登录',
  `create_by` int(11) DEFAULT NULL COMMENT '创建者',
  `create_time` datetime DEFAULT NULL COMMENT '创建时间',
  `update_by` int(11) DEFAULT NULL COMMENT '更新者',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `is_del` tinyint(1) DEFAULT '0' COMMENT '删除标记',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sys_user_login_name` (`login_name`) USING BTREE,
  KEY `sys_user_update_date` (`update_time`),
  KEY `sys_user_del_flag` (`is_del`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COMMENT='用户表';

-- ----------------------------
-- Records of sys_user
-- ----------------------------
INSERT INTO `sys_user` VALUES ('1', 'admin', '31cd27c74f010ba318d77f6eb7b96300122cecc0490e0f05b9f2e6b2', '超级管理员', '', '', 'http://oo1e5sko2.bkt.clouddn.com/crawler.jpg', null, '127.0.0.1', '2017-04-14 22:47:07', '0', '1', '2017-03-17 18:06:53', '1', '2017-04-05 15:55:22', '0');
INSERT INTO `sys_user` VALUES ('2', 'developer', 'd6a33a2456338a88acec133487d38ccf163abb4575b368b074e327ee', '系统运维', '', '', 'http://oo1e5sko2.bkt.clouddn.com/crawler.jpg', null, '127.0.0.1', '2017-04-05 22:52:32', '0', '1', '2013-05-27 08:00:00', '1', '2017-03-14 11:23:34', '0');
INSERT INTO `sys_user` VALUES ('4', '1111', '1cdf43a662d03cb8bf4734f6287a89b01a5cb236b1c7ded916d3753a', '12323', '', '', 'http://oo1e5sko2.bkt.clouddn.com/crawler.jpg', null, null, null, '0', '1', '2017-04-14 15:32:07', '1', '2017-04-14 19:05:45', '0');

-- ----------------------------
-- Table structure for sys_user_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_user_role`;
CREATE TABLE `sys_user_role` (
  `user_id` int(11) NOT NULL COMMENT '用户编号',
  `role_id` varchar(64) NOT NULL COMMENT '角色编号',
  PRIMARY KEY (`user_id`,`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='用户-角色';

-- ----------------------------
-- Records of sys_user_role
-- ----------------------------
INSERT INTO `sys_user_role` VALUES ('1', '1c54e003c1fc4dcd9b087ef8d48abac3');
INSERT INTO `sys_user_role` VALUES ('1', '781acb2361244e49aef509c8688c3ec2');
INSERT INTO `sys_user_role` VALUES ('1', 'caacf61017114120bcf7bf1049b6d4c3');
INSERT INTO `sys_user_role` VALUES ('2', '1c54e003c1fc4dcd9b087ef8d48abac3');
INSERT INTO `sys_user_role` VALUES ('4', '1c54e003c1fc4dcd9b087ef8d48abac3');
INSERT INTO `sys_user_role` VALUES ('5', '1c54e003c1fc4dcd9b087ef8d48abac3');
