<%@ tag language="java" pageEncoding="UTF-8"%>
<%@ include file="/webpage/include/taglib.jsp"%>
<%@ attribute name="input" type="java.lang.String" required="true" description="输入框"%>
<%@ attribute name="selectMultiple" type="java.lang.Boolean" required="false" description="是否允许多选"%>
<%@ attribute name="readonly" type="java.lang.Boolean" required="false" description="是否查看模式"%>
<%@ attribute name="maxWidth" type="java.lang.String" required="false" description="最大宽度"%>
<%@ attribute name="maxHeight" type="java.lang.String" required="false" description="最大高度"%>
<%@ attribute name="width" type="java.lang.String" required="false" description="图片宽度" %>
<%@ attribute name="height" type="java.lang.String" required="false" description="图片高度" %>
<%@ attribute name="queueSizeLimit" type="java.lang.String" required="false" description="图片限制" %>
<%@ attribute name="uploadLimit" type="java.lang.String" required="false" description="图片张数限制" %>

<c:if test="${empty width}">
	<c:set var="width" value="80"/>
</c:if>
<c:if test="${empty height}">
	<c:set var="height" value="80" />
</c:if>
<c:if test="${!selectMultiple}">
	<c:set var="queueSizeLimit" value="1" />
</c:if>
<c:if test="${selectMultiple and empty queueSizeLimit}">
	<c:set var="queueSizeLimit" value="0" />
</c:if>
<c:if test="${selectMultiple and empty uploadLimit}">
	<c:set var="uploadLimit" value="1" />
</c:if>
<ul id="${input}-preview" class="form-image-preview">
	<a class="image-uploader" id="${input}-uploader" style="height:${height}px;width:${width}px;" href="javascript:;"></a>
</ul>

<script type="text/javascript">
	$(function(){
		var previewTarget = $("#${input}-preview");
		var inputTarget = $("#${input}");
		<c:if test="${selectMultiple}">
		var uploaderBtn = previewTarget.find(".image-uploader");
		var uploadLimit =${uploadLimit};
		var hasInitDragSort = false;
		//编辑初始化
		var images = inputTarget.val().split(",");
		for(var i=0;i<images.length;i++){
			var image = images[i];
			if(image){
				uploaderBtn.before('<li class="image-item" style="height:${height}px;width:${width}px;" data-url="'+ image +'"><img src="'+ image +'?imageView2/1/w/${width}/h/${height}" alt="" /><i class="btn-remove" data-url="'+ image +'">×</i></li>');
			}
		}
		
		//初始化拖拽排序
		var initDragSort = function(){
			if(hasInitDragSort){
				return ;
			}
			
			previewTarget.dragsort({
				dragSelector: "li.image-item",
				dragBetween: false, 
				placeHolderTemplate: '<li class="image-item" style="height:${height}px;width:${width}px;"></li>',
				dragSelectorExclude:'input,textarea,a,span,i',
				dragEnd: function(){
					var arr = [];
					previewTarget.find(".image-item").each(function(){
						arr.push($(this).data("url"));
					});
					inputTarget.val(arr.join(","));

				}
			});
			hasInitDragSort = true;

		};
		
		//图片上传
		imageUploadify($("#${input}-uploader"),{
			fileObjName:"images",
			multi:true,
			queueSizeLimit:${queueSizeLimit},
			checkUploadLimit:function(size){
				var total = size + previewTarget.find(".image-item").length;
				if(total > uploadLimit){
					layer.msg("最多上传"+uploadLimit+"张图片");
					return false;
				}
				return true;
			},
			showError:function(code, message){
				layer.msg(message);
			},
			afterSuccess:function(items){
				if(items && items.length > 0){
					
					var oldUrl = inputTarget.val();

					var urls = oldUrl ? inputTarget.val().split(',') : [];
					for(var i=0; i<items.length; i++){
						var item = items[i];
						
						uploaderBtn.before('<li class="image-item" style="height:${height}px;width:${width}px;" data-url="'+ item.url +'"><img src="'+ item.url +'?imageView2/1/w/${width}/h/${height}" alt="" /><i class="btn-remove" data-url="'+ item.url +'">×</i></li>');
						urls.push(item.url);
						
					}
					inputTarget.val(urls.join(','));
					
					initDragSort();
				}

			},
			uploader : "${ctx}/sys/uploader/images"
		});
		
		previewTarget.on("click", ".btn-remove", function(){
			var url = $(this).data("url");
			$(this).closest(".image-item").remove();
			var tmpUrl = "," + inputTarget.val() + ",";
			tmpUrl = tmpUrl.replace("," +url + ",", ',').replace(/^,|,$/g, '');
			inputTarget.val(tmpUrl);
		});
		if(previewTarget.find(".image-item").length > 0){
			initDragSort();
		}
		
		
		
		
		</c:if>
		
		<c:if test="${!selectMultiple}">
		
		var uploaderBtn = previewTarget.find(".image-uploader");

		//编辑初始化
		var image = inputTarget.val();
		if(image){
			uploaderBtn.find("img").remove();
			uploaderBtn.prepend('<img src="' + image + '?imageView2/1/w/${width}/h/${height}" alt="" />');	
		}
		
		
		//单图片上传
		imageUploadify($("#${input}-uploader"),{
			multi:false,
			queueSizeLimit:1,
			afterSuccess:function(item){
				uploaderBtn.find("img").remove();
				uploaderBtn.prepend('<img src="' + item.url + '?imageView2/1/w/${width}/h/${height}" alt="" />');
				inputTarget.val(item.url);

			},
			uploader : "${ctx}/sys/uploader/image"
		});
		</c:if>
		
	});
</script>