<%@ tag language="java" pageEncoding="UTF-8"%>
<%@ include file="/webpage/include/taglib.jsp"%>
<%@ attribute name="input" type="java.lang.String" required="true" description="输入框"%>
<%@ attribute name="latitude" type="java.lang.String" required="false" description="经度"%>
<%@ attribute name="longitude" type="java.lang.String" required="false" description="纬度"%>
<%@ attribute name="province" type="java.lang.String" required="true" description="省"%>
<%@ attribute name="city" type="java.lang.String" required="true" description="市"%>
<%@ attribute name="district" type="java.lang.String" required="true" description="区"%>
<%@ attribute name="placeholder" type="java.lang.String" required="false" description="提示信息"%>
<%@ attribute name="width" type="java.lang.String" required="false" description="地图宽度" %>
<%@ attribute name="height" type="java.lang.String" required="false" description="地图高度" %>
<%@ attribute name="required" type="java.lang.String" required="false" description="是否必填" %>

<c:if test="${empty width}">
	<c:set var="width" value="600px"/>
</c:if>
<c:if test="${empty height}">
	<c:set var="height" value="400px" />
</c:if>
<c:if test="${empty placeholder}">
	<c:set var="placeholder" value="请输入地址" />
</c:if>
<div class="relative">
	<input type="text" class="form-control " id="${input}-input" name="${input}-input" placeholder="${placeholder}" maxlength="200" />
	<a class="add-on" id="btn-${input}-search"><i class="fa fa-search"></i></a>
</div>

<div class="preview-box">
    <div class="map-wrapper" id="${input}-map" style="width:${width};height:${height};">地图正在加载中....</div>
</div>


<script type="text/javascript">
	$(function(){
		 var inputTarget = $("#${input}");
		 var addressTarget = $("#${input}-input");
		 var longitudeTarget = $("#${longitude}");
		 var latitudeTarget = $("#${latitude}");
		 var provinceTarget = $("#${province}");
		 var cityTarget = $("#${city}");
		 var districtTarget = $("#${district}");
		 var address = inputTarget.val();
		 var longitude = longitudeTarget.val();
		 var latitude = latitudeTarget.val();
		 var navigate = "";
		 if(address && latitude && longitude){
			 navigate = longitude + "," + latitude + "," + address;
		 }
		 $("#${input}-map").baiduMap({
	            searchBtn:$("#btn-${input}-search"),
	            longitudeTarget:longitudeTarget,
	            latitudeTarget:latitudeTarget,
	            addressTarget:addressTarget,
	            navigate: navigate,
	            markerChange:function(response){
	            	inputTarget.val(response.address);
	            	provinceTarget.val(response.province);
	            	cityTarget.val(response.city);
	                districtTarget.val(response.district);
	            }
	     });
		
	});
</script>