<%@ page contentType="text/html;charset=UTF-8" %>
<%@ page import="org.apache.shiro.web.filter.authc.FormAuthenticationFilter"%>
<%@ include file="/webpage/include/taglib.jsp"%>
<!DOCTYPE html>
<html>
<head>
	<meta name="description" content="User login page" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<script src="${ctxStatic}/jquery/jquery-2.1.1.min.js" type="text/javascript"></script>
	<script src="${ctxStatic}/jquery/jquery-migrate-1.1.1.min.js" type="text/javascript"></script>
	<script src="${ctxStatic}/jquery-validation/1.14.0/jquery.validate.js" type="text/javascript"></script>
	<script src="${ctxStatic}/jquery-validation/1.14.0/localization/messages_zh.min.js" type="text/javascript"></script>
	<link href="${ctxStatic}/bootstrap/3.3.4/css_default/bootstrap.min.css" type="text/css" rel="stylesheet" />
	<script src="${ctxStatic}/bootstrap/3.3.4/js/bootstrap.min.js"  type="text/javascript"></script>
	<link href="${ctxStatic}/awesome/4.4/css/font-awesome.min.css" rel="stylesheet" />
	<!-- jeeplus -->
	<link href="${ctxStatic}/common/jeeplus.css" type="text/css" rel="stylesheet" />
	<script src="${ctxStatic}/common/jeeplus.js" type="text/javascript"></script>
	<link rel="shortcut icon" href="images/favicon.png" type="image/png">

	<!-- ace styles -->
	<link rel="stylesheet" href="${ctxStatic }/common/login/ace.css?v=${version}" />
	
	<link rel="stylesheet" href="${ctxStatic }/common/css/login.css?v=${version}" />

	<!-- 引入layer插件 -->
	<script src="${ctxStatic}/layer-v2.0/layer/layer.js"></script>
	<script src="${ctxStatic}/layer-v2.0/layer/laydate/laydate.js"></script>
	<link rel="stylesheet" href="${ctxStatic }/common/login/ace-rtl.css" />
	<title>${fns:getConfig('productName')} 登录</title>
	<script>
		if (window.top !== window.self) {
			window.top.location = window.location;
		}
	</script>
	<script type="text/javascript">
			$(document).ready(function() {
				$("#loginForm").validate({
					rules: {
						validateCode: {remote: "${pageContext.request.contextPath}/servlet/validateCodeServlet"}
					},
					messages: {
						username: {required: "请填写用户名."},password: {required: "请填写密码."},
						validateCode: {remote: "验证码不正确.", required: "请填写验证码."}
					},
					errorLabelContainer: "#messageBox",
					errorPlacement: function(error, element) {
						error.appendTo($("#loginError").parent());
					} 
				});
				
				setTimeout(function(){
					var errorMessage = "${message}";
					if(errorMessage){
						$("#messageBox").show();
					}	
				}, 0);
			});
			// 如果在框架或在对话框中，则弹出提示并跳转到首页
			if(self.frameElement && self.frameElement.tagName == "IFRAME" || $('#left').length > 0 || $('.jbox').length > 0){
				alert('未登录或登录超时。请重新登录，谢谢！');
				top.location = "${ctx}";
			}
	</script>
	<script type="text/javascript">
	$(document).ready(function() {
		

		
		// 手机号码验证
		jQuery.validator.addMethod("isMobile", function(value, element) {
		    var length = value.length;
		    var mobile = /^(13[0-9]{9})|(18[0-9]{9})|(14[0-9]{9})|(17[0-9]{9})|(15[0-9]{9})$/;
		    return (length == 11 && mobile.test(value));
		}, "请正确填写您的手机号码");



		$('#sendPassBtn').click(function () { 
			if($("#tel_resetpass").val()=="" || $("#tel_resetpass-error").text()!=""){
				top.layer.alert("请输入有效的注册手机号码！", {icon: 0});//讨厌的白色字体问题
				return;

			}
			$("#sendPassBtn").attr("disabled", true); 
			$.get("${ctx}/sys/user/resetPassword?mobile="+$("#tel_resetpass").val(),function(data){
					if(data.success == false){
						top.layer.alert(data.msg, {icon: 0});//讨厌的白色字体问题
						//alert(data.msg);
						$("#sendPassBtn").html("重新发送").removeAttr("disabled"); 
						clearInterval(countdown); 

					}

				});
			var count = 60; 
			var countdown = setInterval(CountDown, 1000); 
			function CountDown() { 
				$("#sendPassBtn").attr("disabled", true); 
				$("#sendPassBtn").html("等待 " + count + "秒!"); 
				if (count == 0) { 
					$("#sendPassBtn").html("重新发送").removeAttr("disabled"); 
					clearInterval(countdown); 
				} 
				count--; 
			}

			
		}) ;
		

		$('#sendCodeBtn').click(function () { 
			if($("#tel").val()=="" || $("#tel-error").text()!=""){
				top.layer.alert("请输入有效的注册手机号码！", {icon: 0});//讨厌的白色字体问题
				return;

			}
			$("#sendCodeBtn").attr("disabled", true); 
			$.get("${ctx}/sys/register/getRegisterCode?mobile="+$("#tel").val(),function(data){
					if(data.success == false){
						//top.layer.alert(data.msg, {icon: 0});讨厌的白色字体问题
						alert(data.msg);
						$("#sendCodeBtn").html("重新发送").removeAttr("disabled"); 
						clearInterval(countdown); 

					}

				});
			var count = 60; 
			var countdown = setInterval(CountDown, 1000); 
			function CountDown() { 
				$("#sendCodeBtn").attr("disabled", true); 
				$("#sendCodeBtn").html("等待 " + count + "秒!"); 
				if (count == 0) { 
					$("#sendCodeBtn").html("重新发送").removeAttr("disabled"); 
					clearInterval(countdown); 
				} 
				count--; 
			}

			
		}) ;
		
	});

</script>
</head>
<body class="login-layout light-login">
	<div class="main-container">
		<div class="main-content">

			<div class="login-container">
				
				<div class="center">
					<sys:message content="${message}"/>
				</div>

				<div class="space-6"></div>

				<div class="position-relative">
					<div id="login-box" class="login-box visible widget-box no-border bound">
						<div class="widget-body bound">
							<div class="widget-main bound">
								<h4 class="header blue lighter bigger">
									${fns:getConfig('productName')}管理后台
								</h4>

								<div class="space-6"></div>

								<form id="loginForm" class="form-signin" action="${ctx}/login" method="post">
									<fieldset>
										<label class="block clearfix">
											<span class="block input-icon input-icon-right">
												<input type="text"  id="username" name="username" class="form-control required"  value="${username}" placeholder="用户名" />
												<i class="ace-icon fa fa-user"></i>
											</span>
										</label>

										<label class="block clearfix">
											<span class="block input-icon input-icon-right">
												<input type="password" id="password" name="password" class="form-control required" placeholder="密码" />
												<i class="ace-icon fa fa-lock"></i>
											</span>
										</label>
										<c:if test="${isValidateCodeLogin}">
											<div class="input-group m-b text-muted validateCode">
											<label class="input-label mid" for="validateCode">验证码：</label>
											<sys:validateCode name="validateCode"/>
											</div>
										</c:if>
										<div class="space"></div>

										<div class="clearfix">
											<label class="inline">
												<input  type="checkbox" id="rememberMe" name="rememberMe" ${rememberMe ? 'checked' : ''} class="ace" />
												<span class="lbl"> 记住我</span>
											</label>

											<button type="submit" class="width-35 pull-right btn btn-sm btn-primary btn-login">
												<i class="ace-icon fa fa-key"></i>
												<span class="bigger-110">登录</span>
											</button>
										</div>


									</fieldset>
								</form>

							</div><!-- /.widget-main -->
						</div><!-- /.widget-body -->
					</div><!-- /.login-box -->
				</div><!-- /.position-relative -->
			</div>
		</div><!-- /.main-content -->
	</div><!-- /.main-container -->

	<!-- basic scripts -->

	<!--[if !IE]> -->
	<script type="text/javascript">
		window.jQuery || document.write("<script src='../assets/js/jquery.js'>"+"<"+"/script>");
	</script>

	<!-- <![endif]-->

	<!--[if IE]>
	<script type="text/javascript">
	 window.jQuery || document.write("<script src='../assets/js/jquery1x.js'>"+"<"+"/script>");
	</script>
	<![endif]-->

	<script type="text/javascript">
		if('ontouchstart' in document.documentElement) document.write("<script src='../assets/js/jquery.mobile.custom.js'>"+"<"+"/script>");
	</script>
	<!-- inline scripts related to this page -->
	<script type="text/javascript">
	$(document).ready(function() {
		 $(document).on('click', '.form-options a[data-target]', function(e) {
			e.preventDefault();
			var target = $(this).data('target');
			$('.widget-box.visible').removeClass('visible');//hide others
			$(target).addClass('visible');//show target
		 });
	});
	</script>
	
		<script type="text/javascript" src="${ctxStatic}/cloud/js/ThreeWebGL.js"></script>
		<script type="text/javascript" src="${ctxStatic}/cloud/js/ThreeExtras.js"></script>

		<script type="text/javascript" src="${ctxStatic}/cloud/js/Detector.js"></script>
		<script type="text/javascript" src="${ctxStatic}/cloud/js/RequestAnimationFrame.js"></script>

		<script id="vs" type="x-shader/x-vertex">

			varying vec2 vUv;

			void main() {

				vUv = uv;
				gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );

			}

		</script>

		<script id="fs" type="x-shader/x-fragment">

			uniform sampler2D map;

			uniform vec3 fogColor;
			uniform float fogNear;
			uniform float fogFar;

			varying vec2 vUv;

			void main() {

				float depth = gl_FragCoord.z / gl_FragCoord.w;
				float fogFactor = smoothstep( fogNear, fogFar, depth );

				gl_FragColor = texture2D( map, vUv );
				gl_FragColor.w *= pow( gl_FragCoord.z, 20.0 );
				gl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );

			}

		</script>

		<script type="text/javascript">

			if ( ! Detector.webgl ) Detector.addGetWebGLMessage();

			// Bg gradient

			var canvas = document.createElement( 'canvas' );
			canvas.width = 32;
			canvas.height = window.innerHeight;

			var context = canvas.getContext( '2d' );

			var gradient = context.createLinearGradient( 0, 0, 0, canvas.height );
			gradient.addColorStop(0, "#1e4877");
			gradient.addColorStop(0.5, "#4584b4");

			context.fillStyle = gradient;
			context.fillRect(0, 0, canvas.width, canvas.height);

			document.body.style.background = 'url(' + canvas.toDataURL('image/png') + ')';

			// Clouds

			var container;
			var camera, scene, renderer, sky, mesh, geometry, material,
			i, h, color, colors = [], sprite, size, x, y, z;

			var mouseX = 0, mouseY = 0;
			var start_time = new Date().getTime();

			var windowHalfX = window.innerWidth / 2;
			var windowHalfY = window.innerHeight / 2;

			init();
			animate();

			function init() {

				container = document.createElement( 'div' );
				document.body.appendChild( container );

				camera = new THREE.Camera( 30, window.innerWidth / window.innerHeight, 1, 3000 );
				camera.position.z = 6000;

				scene = new THREE.Scene();

				geometry = new THREE.Geometry();

				var texture = THREE.ImageUtils.loadTexture( '${ctxStatic}/cloud/images/cloud10.png' );
				texture.magFilter = THREE.LinearMipMapLinearFilter;
				texture.minFilter = THREE.LinearMipMapLinearFilter;

				var fog = new THREE.Fog( 0x4584b4, - 100, 3000 );

				material = new THREE.MeshShaderMaterial( {

					uniforms: {

						"map": { type: "t", value:2, texture: texture },
						"fogColor" : { type: "c", value: fog.color },
						"fogNear" : { type: "f", value: fog.near },
						"fogFar" : { type: "f", value: fog.far },

					},
					vertexShader: document.getElementById( 'vs' ).textContent,
					fragmentShader: document.getElementById( 'fs' ).textContent,
					depthTest: false

				} );

				var plane = new THREE.Mesh( new THREE.Plane( 64, 64 ) );

				for ( i = 0; i < 8000; i++ ) {

					plane.position.x = Math.random() * 1000 - 500;
					plane.position.y = - Math.random() * Math.random() * 200 - 15;
					plane.position.z = i;
					plane.rotation.z = Math.random() * Math.PI;
					plane.scale.x = plane.scale.y = Math.random() * Math.random() * 1.5 + 0.5;

					GeometryUtils.merge( geometry, plane );

				}

				mesh = new THREE.Mesh( geometry, material );
				scene.addObject( mesh );

				mesh = new THREE.Mesh( geometry, material );
				mesh.position.z = - 8000;
				scene.addObject( mesh );

				renderer = new THREE.WebGLRenderer( { antialias: false } );
				renderer.setSize( window.innerWidth, window.innerHeight );
				container.appendChild( renderer.domElement );

				document.addEventListener( 'mousemove', onDocumentMouseMove, false );
				window.addEventListener( 'resize', onWindowResize, false );

			}

			function onDocumentMouseMove( event ) {

				mouseX = ( event.clientX - windowHalfX ) * 0.25;
				mouseY = ( event.clientY - windowHalfY ) * 0.15;

			}

			function onWindowResize( event ) {

				camera.aspect = window.innerWidth / window.innerHeight;
				camera.updateProjectionMatrix();

				renderer.setSize( window.innerWidth, window.innerHeight );

			}

			function animate() {

				requestAnimationFrame( animate );
				render();

			}

			function render() {

				position = ( ( new Date().getTime() - start_time ) * 0.03 ) % 8000;

				camera.position.x += ( mouseX - camera.target.position.x ) * 0.01;
				camera.position.y += ( - mouseY - camera.target.position.y ) * 0.01;
				camera.position.z = - position + 8000;

				camera.target.position.x = camera.position.x;
				camera.target.position.y = camera.position.y;
				camera.target.position.z = camera.position.z - 1000;

				renderer.render( scene, camera );

			}

		</script>
	
	
</body>
</html>
