<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/webpage/include/taglib.jsp"%>
<html>
<head>
	<title>个人信息</title>
	<meta name="decorator" content="default"/>
</head>
<body>

	<body class="gray-bg">
		<div class="wrapper wrapper-content">
			<div class="row animated fadeInRight">
				<sys:message hideType="1" content="${message}"/>
				<div class="col-sm-12">
					<div class="ibox float-e-margins">
						<div class="ibox-title">
							<h5>个人资料</h5>
						</div>
						<div class="ibox-content">
							<div class="row">
								<div class="col-sm-4" style="margin-bottom: 10px;">
									<img alt="image" class="img-responsive" src="${user.avatar }" />
								</div>
								<div class="col-sm-8">
									<div class="table-responsive">
										<table class="table table-bordered">
											<tbody>
												<tr>
													<td><strong>登录账号</strong></td>
													<td>${user.loginName}</td>
												</tr>
												<tr>
													<td><strong>用户角色</strong></td>
													<td>${user.roleNames}</td>
												</tr>
												<tr>
													<td><strong>姓名</strong></td>
													<td>${user.name}</td>
												</tr>
												<tr>
													<td><strong>电话</strong></td>
													<td>${user.phone}</td>
												</tr>
												<tr>
													<td><strong>上次登录时间：</strong></td>
													<td><fmt:formatDate value="${user.oldLoginDate}" type="both" dateStyle="full"/></td>
												</tr>
												<tr>
													<td><strong>上次登录IP：</strong></td>
													<td>${user.oldLoginIp}</td>
												</tr>
												
											</tbody>
										</table>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				

			</div>
		</div>
</body>
</html>