<%@ page contentType="text/html;charset=UTF-8" %>
<%@ include file="/webpage/include/taglib.jsp"%>
<html>
<head>
	<title>修改密码</title>
	<meta name="decorator" content="default"/>
	<script type="text/javascript">
	var validateForm;
	var iframeIndex;
	function doSubmit(index){//回调函数，在编辑和保存动作时，供openDialog调用提交表单。
	  iframeIndex = index;
	  if(validateForm.form()){
		  var newPassword = $.trim($("#newPassword").val());
		  var confirmNewPassword = $.trim($("#confirmNewPassword").val());
		  if(confirmNewPassword != newPassword){
				layer.msg("两次密码输入不一致");
				return false;
		  }
		  $("#inputForm").submit();
		  return false;
	  }
	 
	  
	  return false;
	}
	$(document).ready(function() {
		validateForm = $("#inputForm").validate({
			submitHandler: function(form){
				//显示loading提示
			    var loading = layer.load();
				$.ajax({
					type:"POST",
			        url: $("#inputForm").attr("action"),
			        data:$("#inputForm").serialize(),
			        dataType: "json",
			        success: function (response) {
			        	layer.msg(response.msg);
			        	if(response.success){
			        		setTimeout(function(){			        			
			        			top.layer.close(iframeIndex);
			        		}, 1000);
			        	}
			        },
			        complete:function(){
			        	layer.close(loading);
			        }
				});
				return false;
			},
			errorContainer: "#messageBox",
			errorPlacement: function(error, element) {
				$("#messageBox").text("输入有误，请先更正。");
				if (element.is(":checkbox")||element.is(":radio")||element.parent().is(".input-append")){
					error.appendTo(element.parent().parent());
				} else {
					error.insertAfter(element);
				}
			}
		});
		
	});
	

	</script>
</head>
<body>
	<form:form id="inputForm" modelAttribute="user" action="${ctx}/sys/user/modifyPwd" onsubmit="return false;"  method="post" class="form-horizontal form-group">
		<form:hidden path="id"/>
		<sys:message hideType="1" content="${message}"/>
		<div class="control-group">
		</div>
		
		<div class="control-group">
			<label class="col-sm-3 control-label"><font color="red">*</font>旧密码:</label>
			<div class="controls">
				<input id="oldPassword" name="oldPassword" type="password" value="" maxlength="50" minlength="3"  class="form-control  max-width-250 required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="col-sm-3 control-label"><font color="red">*</font>新密码:</label>
			<div class="controls">
				<input id="newPassword" name="newPassword" type="password" value="" maxlength="50" minlength="3" class="form-control  max-width-250 required"/>
			</div>
		</div>
		<div class="control-group">
			<label class="control-label"><font color="red">*</font>确认新密码:</label>
			<div class="controls">
				<input id="confirmNewPassword" name="confirmNewPassword" type="password" value="" maxlength="50" minlength="3" class="form-control  max-width-250 required" equalTo="#newPassword"></input>
			</div>
		</div>
		<div class="form-actions">
			<input id="btnSubmit" class="btn btn-primary" type="submit" style="display:none" value="保 存"/>
		</div>
	</form:form>
</body>
</html>