/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.cache;

import com.club.framework.log.ClubLogManager;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.Ehcache;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class EhCacheService {
    private static final ClubLogManager logger = ClubLogManager.getLogger(EhCacheService.class);
    private CacheManager ehCacheCacheManager;
    private ConcurrentMap<String, Cache> cacheMap = new ConcurrentHashMap<String, Cache>();

    private Cache getCache(String cacheName) {
        return this.ehCacheCacheManager.getCache(cacheName);
    }

    public Object get(String cacheName, Object key) {
        Cache.ValueWrapper valueWrapper = this.getCache(cacheName).get(key);
        if (valueWrapper != null) {
            return this.getCache(cacheName).get(key).get();
        }
        return valueWrapper;
    }

    public void put(String cacheName, Object key, Object value) {
        this.getCache(cacheName).put(key, value);
    }

    public void evict(String cacheName, Object key) {
        this.getCache(cacheName).evict(key);
    }

    public void clear(String cacheName) {
        this.getCache(cacheName).clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        EhCacheService ehCacheService = this;
        synchronized (ehCacheService) {
            Collection cacheNames = this.ehCacheCacheManager.getCacheNames();
            Iterator it = cacheNames.iterator();
            while (it.hasNext()) {
                this.clear((String)it.next());
            }
        }
    }

    public Collection<String> getCacheNames() {
        return this.ehCacheCacheManager.getCacheNames();
    }

    public int getSize(String cacheName) {
        return this.getNativeCache(cacheName).getSize();
    }

    public Ehcache getNativeCache(String cacheName) {
        return (Ehcache)this.getCache(cacheName).getNativeCache();
    }

    public CacheManager getEhCacheCacheManager() {
        return this.ehCacheCacheManager;
    }

    public void setEhCacheCacheManager(CacheManager ehCacheCacheManager) {
        this.ehCacheCacheManager = ehCacheCacheManager;
    }
}

