/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.RowBounds;

public class Page<T>
extends RowBounds {
    @JsonIgnore
    private int page = 1;
    @JsonIgnore
    private int start;
    @JsonIgnore
    private int limit = 15;
    @JsonIgnore
    private int offset;
    private int totalPages;
    private int totalRecords;
    private List<T> resultList;
    @JsonIgnore
    private Map<String, Object> conditons = new HashMap<String, Object>();

    public Page() {
    }

    public Page(int start, int pageSize) {
        this.setStart(start);
        this.setLimit(pageSize);
    }

    public void initOtherData() {
        if (this.totalRecords == 0) {
            this.setTotalPages(0);
        } else {
            this.setTotalPages((this.totalRecords - 1) / this.limit + 1);
        }
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(int totalPages) {
        this.totalPages = totalPages;
    }

    public int getTotalRecords() {
        return this.totalRecords;
    }

    public void setTotalRecords(int totalRecords) {
        this.totalRecords = totalRecords;
        this.initOtherData();
    }

    public List<T> getResultList() {
        return this.resultList;
    }

    public void setResultList(List<T> resultList) {
        this.resultList = resultList;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public Map<String, Object> getConditons() {
        return this.conditons;
    }

    public void setConditons(Map<String, Object> conditons) {
        this.conditons = conditons;
    }
}

