/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.common;

import com.club.core.common.Inflector;
import com.club.core.common.Page;
import com.club.framework.util.TortoiseClassUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResultData {
    private boolean success;
    private String msg;
    private static final long serialVersionUID = 1L;
    private final Map<String, Object> data = new HashMap<String, Object>();
    private final List<String> entitiesKeys = new ArrayList<String>();
    private final List<String> entityKeys = new ArrayList<String>();
    @JsonIgnore
    private final Meta meta = new Meta();
    private boolean beenSeted = false;
    private static final Inflector INFLECTOR = Inflector.getInstance();
    public static final String META = "meta";
    public static final String TOTAL = "total";

    public ResultData() {
    }

    public ResultData(boolean success, String msg) {
        this.success = success;
        this.msg = msg;
    }

    public ResultData(Class clazz, Object object) {
        if (object instanceof Page) {
            Page page = (Page)((Object)object);
            this.putEntities(clazz, page.getResultList());
            this.setTotal(page.getTotalRecords(), page.getLimit());
        } else if (object instanceof List) {
            this.putEntities(clazz, (Collection)object);
        } else {
            this.putEntity(clazz, object);
        }
    }

    public ResultData(String key, Object object) {
        this.put(key, object);
    }

    public ResultData setTotal(int total) {
        this.beenSeted = true;
        this.meta.total = total;
        return this;
    }

    public ResultData setTotal(int total, int limit) {
        this.beenSeted = true;
        this.meta.total = total;
        this.meta.totalPage = (total + limit - 1) / limit;
        return this;
    }

    @Deprecated
    public ResultData setTotalPage(int totalPage) {
        this.beenSeted = true;
        this.meta.totalPage = totalPage;
        return this;
    }

    public <T> ResultData putEntities(Class entityClass, Collection<T> entities) {
        String key = this.getPluralKey(entityClass);
        if (this.entitiesKeys.contains(key)) {
            ((Collection)this.data.get(key)).addAll(entities);
        } else {
            this.entitiesKeys.add(key);
            this.data.put(key, entities);
        }
        return this;
    }

    public <E> ResultData putEntity(Class clz, E e) {
        String key = INFLECTOR.lowerCamelCase(INFLECTOR.singularize(TortoiseClassUtils.getEntityNameWithoutDto(clz)), new char[0]);
        if (!this.entityKeys.contains(key)) {
            this.entityKeys.add(key);
        }
        this.data.put(key, e);
        return this;
    }

    @Deprecated
    public <E> ResultData putEntity(E e) {
        String key = INFLECTOR.lowerCamelCase(INFLECTOR.singularize(TortoiseClassUtils.getEntityNameWithoutDto(e.getClass())), new char[0]);
        if (!this.entityKeys.contains(key)) {
            this.entityKeys.add(key);
        }
        this.data.put(key, e);
        return this;
    }

    public <E> ResultData put(String key, E e) {
        if (this.entitiesKeys.contains(key) || this.entityKeys.contains(key)) {
            throw new IllegalArgumentException("\u6dfb\u52a0\u7684key: [" + key + "] \u548cEntities\u3001Entity\u7684Key\u51b2\u7a81\u3002");
        }
        this.data.put(key, e);
        return this;
    }

    public Map<String, Object> getEntities() {
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            results.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(results);
    }

    public int getTotal() {
        return this.meta.total;
    }

    public int getTotalPage() {
        return this.meta.totalPage;
    }

    private String getPluralKey(Class entityClass) {
        return INFLECTOR.lowerCamelCase(INFLECTOR.pluralize(TortoiseClassUtils.getEntityNameWithoutDto(entityClass)), new char[0]);
    }

    public void setReturnMsg(boolean success, String msg) {
        this.success = success;
        this.msg = msg;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    private class Meta
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int total;
        private int totalPage;

        private Meta() {
        }

        public int getTotal() {
            return this.total;
        }

        public int getTotalPage() {
            return this.totalPage;
        }
    }
}

