/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.convert;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.StringUtils;

public class DateConverter
implements Converter<String, Date> {
    private static final ThreadLocal<DateFormat> ThreadLocal_DATEFORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    private static final ThreadLocal<DateFormat> ThreadLocal_TIMEFORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private DateFormat dateFormat;
    private boolean allowEmpty = true;

    public DateConverter(String pattern, boolean allowEmpty) {
        this.dateFormat = StringUtils.hasText((String)pattern) ? new SimpleDateFormat(pattern) : null;
        this.allowEmpty = allowEmpty;
    }

    public Date convert(String text) {
        if (this.allowEmpty && !StringUtils.hasText((String)text)) {
            return null;
        }
        try {
            if (this.dateFormat != null) {
                return this.dateFormat.parse(text);
            }
            if (text.contains(":")) {
                return ThreadLocal_TIMEFORMAT.get().parse(text);
            }
            return ThreadLocal_DATEFORMAT.get().parse(text);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Could not parse date: " + ex.getMessage(), ex);
        }
    }
}

