/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.convert;

import com.club.core.common.QueryCondition;
import com.club.core.convert.IArgConversionService;
import com.club.framework.dto.AbstractDto;
import com.club.framework.exception.BaseAppException;
import com.club.framework.exception.ExceptionHandler;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.AssertUtils;
import com.club.framework.util.JsonUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.support.FormattingConversionServiceFactoryBean;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

@Service(value="defaultArgConversionService")
public class DefaultArgConversionService
implements IArgConversionService {
    private static final ClubLogManager logger = ClubLogManager.getLogger(DefaultArgConversionService.class);
    @Autowired
    private FormattingConversionServiceFactoryBean conversionService;

    @Override
    public <T> T invokeArg(Class<T> argClass, AbstractDto vo) throws BaseAppException {
        AssertUtils.isNotNull(argClass, "this argClass not allow null!");
        String queryConditions = vo.getQueryConditions();
        T arg = null;
        try {
            arg = argClass.newInstance();
        }
        catch (Exception ex) {
            ExceptionHandler.publish("APP-00-0050", ex);
        }
        if (null == queryConditions || queryConditions.trim().length() == 0) {
            return arg;
        }
        List<QueryCondition> queryConditionsList = JsonUtil.toList(queryConditions, QueryCondition.class);
        if (null == queryConditionsList) {
            return arg;
        }
        Object criteria = null;
        Method[] criteriaMethods = null;
        try {
            Method argMethod = argClass.getMethod("createCriteria", new Class[0]);
            criteria = argMethod.invoke(arg, new Object[0]);
            criteriaMethods = criteria.getClass().getDeclaredMethods();
        }
        catch (Exception ex) {
            logger.error(ex);
            ExceptionHandler.publish("APP-00-0051", ex);
        }
        for (QueryCondition thizondition : queryConditionsList) {
            try {
                String paramName = thizondition.getParamName();
                String operation = thizondition.getOperation().toString();
                String[] paramValue = thizondition.getParamValue();
                String methodName = "and" + paramName.replaceFirst(paramName.substring(0, 1), paramName.substring(0, 1).toUpperCase()) + operation;
                for (Method criteriamethod : criteriaMethods) {
                    if (!criteriamethod.getName().equals(methodName)) continue;
                    Class<?>[] paramsType = criteriamethod.getParameterTypes();
                    if (QueryCondition.ConditionOperation.Between.toString().equals(operation) || QueryCondition.ConditionOperation.NotBetween.toString().equals(operation)) {
                        ReflectionUtils.invokeMethod((Method)criteriamethod, (Object)criteria, (Object[])new Object[]{this.conversionService.getObject().convert((Object)paramValue[0], paramsType[0]), this.conversionService.getObject().convert((Object)paramValue[1], paramsType[1])});
                        continue;
                    }
                    if (QueryCondition.ConditionOperation.In.toString().equals(operation) || QueryCondition.ConditionOperation.NotIn.toString().equals(operation)) {
                        ArrayList<Object> invokeArgs = new ArrayList<Object>();
                        for (int i = 0; i < paramValue.length; ++i) {
                            invokeArgs.add(this.conversionService.getObject().convert((Object)paramValue[i], Object.class));
                        }
                        ReflectionUtils.invokeMethod((Method)criteriamethod, (Object)criteria, (Object[])new Object[]{invokeArgs});
                        continue;
                    }
                    ReflectionUtils.invokeMethod((Method)criteriamethod, (Object)criteria, (Object[])new Object[]{this.conversionService.getObject().convert((Object)thizondition.getParamValue()[0], paramsType[0])});
                }
            }
            catch (Exception ex) {
                logger.error(ex);
                ExceptionHandler.publish("APP-00-0051", ex);
            }
        }
        return arg;
    }

    public static void main(String[] args) throws BaseAppException {
    }
}

