/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.db.ds;

import com.club.core.db.ds.DBType;
import com.club.framework.dto.AbstractDto;

public class DbcpConfig
extends AbstractDto {
    private DBType dbtype;
    private boolean defaultAutoCommit = true;
    private boolean defaultReadOnly = false;
    private String driverClassName;
    private int maxActive = 8;
    private int maxIdle = 8;
    private int minIdle = 0;
    private long maxWait = -1L;
    private int initialSize = 0;
    private String password;
    private String url;
    private String username;
    private String validationQuery;
    private boolean removeAbandoned = false;
    private int removeAbandonedTimeout = 300;
    private boolean logAbandoned = false;
    private long minEvictableIdleTimeMillis = 1800000L;
    private long timeBetweenEvictionRunsMillis = -1L;
    private boolean testOnBorrow = false;
    private boolean testOnReturn = false;
    private boolean testWhileIdle = false;
    private int numTestsPerEvictionRun = 3;

    public DbcpConfig(String typeName) {
        this.dbtype = DBType.getInstance(typeName);
        this.setDefaultProperties();
    }

    public DbcpConfig(DBType dbtype) {
        this.dbtype = dbtype;
        this.setDefaultProperties();
    }

    private void setDefaultProperties() {
        if (null == this.dbtype) {
            return;
        }
        switch (this.dbtype) {
            case MYSQL: {
                this.setValidationQuery("SELECT 1 ");
                this.setDriverClassName("com.mysql.jdbc.Driver");
                break;
            }
            case ORACLE: {
                this.setValidationQuery("SELECT 1 FROM DUAL ");
                this.setDriverClassName("oracle.jdbc.driver.OracleDriver");
                break;
            }
            case INFORMIX: {
                this.setValidationQuery("SELECT 1 FROM systables ");
                this.setDriverClassName("com.informix.jdbc.IfxDriver");
                break;
            }
            case TIMESTEN: {
                break;
            }
            case MDB: {
                break;
            }
            case DB2: {
                this.setValidationQuery("select 1 from sysibm.sysdummy1 ");
                this.setDriverClassName("com.ibm.db2.jcc.DB2Driver");
                break;
            }
            case SQLSERVER2000: {
                this.setValidationQuery("SELECT 1 ");
                this.setDriverClassName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
                break;
            }
            case SQLSERVER2005: {
                this.setValidationQuery("SELECT 1 ");
                this.setDriverClassName("com.microsoft.sqlserver.jdbc.SQLServerDriver");
            }
        }
    }

    public DBType getDbtype() {
        return this.dbtype;
    }

    public void setDbtype(DBType dbtype) {
        this.dbtype = dbtype;
    }

    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public boolean isRemoveAbandoned() {
        return this.removeAbandoned;
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    public int getRemoveAbandonedTimeout() {
        return this.removeAbandonedTimeout;
    }

    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
        this.removeAbandonedTimeout = removeAbandonedTimeout;
    }

    public boolean isLogAbandoned() {
        return this.logAbandoned;
    }

    public void setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.minEvictableIdleTimeMillis = minEvictableIdleTimeMillis;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
    }
}

