/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.db.ds;

import com.club.core.db.ds.DbcpConfig;
import com.club.framework.exception.ExceptionHandler;
import com.club.framework.log.ClubLogManager;
import java.sql.SQLException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="dynamicDataSourceManager")
public class DynamicDataSourceManager {
    private static final ClubLogManager logger = ClubLogManager.getLogger(DynamicDataSourceManager.class);
    private static final ConcurrentMap<String, BasicDataSource> dataSourcePoolMap = new ConcurrentHashMap<String, BasicDataSource>();

    private ConcurrentMap<String, BasicDataSource> getPoolMap() {
        return dataSourcePoolMap;
    }

    private void validate(DbcpConfig dbcpConfig) {
        Assert.notNull((Object)dbcpConfig, (String)"dbcpConfig must not be null.");
        Assert.notNull((Object)((Object)dbcpConfig.getDbtype()), (String)"dbtype must not be null.");
        Assert.notNull((Object)dbcpConfig.getDriverClassName(), (String)"driverClassName must not be null.");
        Assert.notNull((Object)dbcpConfig.getUrl(), (String)"url must not be null.");
        Assert.notNull((Object)dbcpConfig.getUsername(), (String)"username must not be null.");
        Assert.notNull((Object)dbcpConfig.getPassword(), (String)"password must not be null.");
    }

    public synchronized void createDataSourcePool(String poolId, DbcpConfig dbcpConfig) {
        this.validate(dbcpConfig);
        BasicDataSource basicDataSource = new BasicDataSource();
        basicDataSource.setDriverClassName(dbcpConfig.getDriverClassName());
        basicDataSource.setUrl(dbcpConfig.getUrl());
        basicDataSource.setUsername(dbcpConfig.getUsername());
        basicDataSource.setPassword(dbcpConfig.getPassword());
        basicDataSource.setDefaultAutoCommit(dbcpConfig.isDefaultAutoCommit());
        basicDataSource.setDefaultReadOnly(dbcpConfig.isDefaultReadOnly());
        basicDataSource.setMaxActive(dbcpConfig.getMaxActive());
        basicDataSource.setMaxIdle(dbcpConfig.getMaxIdle());
        basicDataSource.setMinIdle(dbcpConfig.getMinIdle());
        basicDataSource.setMaxWait(dbcpConfig.getMaxWait());
        basicDataSource.setInitialSize(dbcpConfig.getInitialSize());
        basicDataSource.setValidationQuery(dbcpConfig.getValidationQuery());
        basicDataSource.setRemoveAbandoned(dbcpConfig.isRemoveAbandoned());
        basicDataSource.setRemoveAbandonedTimeout(dbcpConfig.getRemoveAbandonedTimeout());
        basicDataSource.setLogAbandoned(dbcpConfig.isLogAbandoned());
        basicDataSource.setMinEvictableIdleTimeMillis(dbcpConfig.getMinEvictableIdleTimeMillis());
        basicDataSource.setTimeBetweenEvictionRunsMillis(dbcpConfig.getTimeBetweenEvictionRunsMillis());
        basicDataSource.setTestOnBorrow(dbcpConfig.isTestOnBorrow());
        basicDataSource.setTestOnReturn(dbcpConfig.isTestOnReturn());
        basicDataSource.setTestWhileIdle(dbcpConfig.isTestWhileIdle());
        basicDataSource.setNumTestsPerEvictionRun(dbcpConfig.getNumTestsPerEvictionRun());
        this.getPoolMap().put(poolId, basicDataSource);
    }

    public synchronized BasicDataSource getDataSourcePoolByPoolId(String poolId, DbcpConfig dbcpConfig) throws Exception {
        BasicDataSource basicDataSource = (BasicDataSource)this.getPoolMap().get(poolId);
        if (basicDataSource == null) {
            logger.info(String.format("Could not found datasource pool by this poolId[poolId=%s],created it now... ", poolId));
            this.createDataSourcePool(poolId, dbcpConfig);
            basicDataSource = (BasicDataSource)this.getPoolMap().get(poolId);
        } else {
            logger.info(String.format("Found datasource pool by this poolId[poolId=%s]!", poolId));
        }
        return basicDataSource;
    }

    public synchronized BasicDataSource getDataSourcePoolByPoolId(String poolId) throws Exception {
        BasicDataSource basicDataSource = (BasicDataSource)this.getPoolMap().get(poolId);
        if (basicDataSource == null) {
            logger.error(String.format("Could not found datasource pool by this poolId[poolId=%s]!Throw Exception...", poolId));
            throw ExceptionHandler.publish("APP-00-0008", String.format("Could not found this datasource pool by this poolId[poolId=%s]!Please created it first!", poolId));
        }
        logger.info(String.format("Found datasource pool by this poolId[poolId=%s]!", poolId));
        return basicDataSource;
    }

    public synchronized void close(String poolId) throws SQLException {
        logger.debug(String.format("Close datasource pool by poolId[poolId=%s]!", poolId));
        BasicDataSource basicDataSource = (BasicDataSource)this.getPoolMap().get(poolId);
        if (basicDataSource == null) {
            logger.error(String.format("Close pool,Could not found datasource pool by this poolId[poolId=%s],skip close it...", poolId));
            return;
        }
        basicDataSource.close();
        dataSourcePoolMap.remove(poolId);
    }

    public synchronized void closeAll() {
        logger.debug(String.format("Close all datasource pool!", new Object[0]));
        Set key = dataSourcePoolMap.keySet();
        for (String poolId : key) {
            BasicDataSource basicDataSource = (BasicDataSource)dataSourcePoolMap.get(poolId);
            try {
                basicDataSource.close();
                dataSourcePoolMap.remove(poolId);
            }
            catch (Exception e) {
                logger.error(String.format("CloseAll Pool cast Exception [poolId=%s]", ToStringBuilder.reflectionToString((Object)basicDataSource)));
                e.printStackTrace();
            }
        }
    }

    public synchronized boolean isPoolExist(String poolId) {
        BasicDataSource basicDataSource = (BasicDataSource)this.getPoolMap().get(poolId);
        return basicDataSource != null;
    }

    public synchronized int getPoolSize() {
        return this.getPoolMap().size();
    }
}

