/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.db.plugin;

import com.club.core.common.Page;
import com.club.core.db.plugin.Dialect;
import com.club.framework.log.ClubLogManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class})})
public class PaginationInterceptor<K, V>
implements Interceptor {
    private static final ClubLogManager logger = ClubLogManager.getLogger(PaginationInterceptor.class);
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    private static final ReflectorFactory DEFAULT_REFLETOR_FACTORY = new DefaultReflectorFactory();
    private String dialect = null;

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaStatementHandler = MetaObject.forObject((Object)statementHandler, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLETOR_FACTORY);
        RowBounds rowBounds = (RowBounds)metaStatementHandler.getValue("delegate.rowBounds");
        if (rowBounds == null || rowBounds == RowBounds.DEFAULT) {
            return invocation.proceed();
        }
        MappedStatement mappedStatement = (MappedStatement)metaStatementHandler.getValue("delegate.mappedStatement");
        BoundSql boundSql = (BoundSql)metaStatementHandler.getValue("delegate.boundSql");
        Object additionalParameters = metaStatementHandler.getValue("delegate.boundSql.additionalParameters");
        Map parameterObject = this.getParameterObject(boundSql, additionalParameters);
        Connection connection = (Connection)invocation.getArgs()[0];
        Page page = (Page)rowBounds;
        this.setTotalSql(boundSql.getSql(), connection, mappedStatement, boundSql, parameterObject, page);
        int start = page.getStart();
        int limit = page.getLimit();
        this.setPageParameter(boundSql, metaStatementHandler, page);
        Object result = invocation.proceed();
        page.setStart(start);
        page.setLimit(limit);
        return result;
    }

    public Map getParameterObject(BoundSql boundSql, Object additionalParameters) {
        Object parameterObject = boundSql.getParameterObject();
        Map<String, Object> paramMap = null;
        if (parameterObject == null) {
            paramMap = new HashMap();
        } else if (parameterObject instanceof Map) {
            paramMap = (Map)parameterObject;
        } else {
            String[] metaParamsNames;
            paramMap = new HashMap();
            MetaObject metaObject = MetaObject.forObject((Object)parameterObject, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLETOR_FACTORY);
            if (boundSql.getParameterMappings() != null && boundSql.getParameterMappings().size() > 0) {
                for (ParameterMapping parameterMapping : boundSql.getParameterMappings()) {
                    String name = parameterMapping.getProperty();
                    if (!parameterMapping.getJavaType().isAssignableFrom(parameterObject.getClass())) continue;
                    paramMap.put(name, parameterObject);
                }
            }
            if (null != (metaParamsNames = metaObject.getGetterNames())) {
                for (String paramName : metaParamsNames) {
                    paramMap.put(paramName, metaObject.getValue(paramName));
                }
            }
        }
        if (null != additionalParameters) {
            paramMap.putAll((Map)additionalParameters);
        }
        return paramMap;
    }

    public void setPageParameter(BoundSql boundSql, MetaObject metaStatementHandler, Page<?> page) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Dialect dialect = (Dialect)Class.forName(this.dialect).newInstance();
        metaStatementHandler.setValue("delegate.boundSql.sql", (Object)dialect.getLimitString(boundSql.getSql(), page.getStart(), page.getLimit()));
        metaStatementHandler.setValue("delegate.rowBounds.offset", (Object)0);
        metaStatementHandler.setValue("delegate.rowBounds.limit", (Object)Integer.MAX_VALUE);
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTotalSql(String sql, Connection connection, MappedStatement mappedStatement, BoundSql boundSql, Object parameterObject, Page<?> page) {
        String countSql = "select count(0) total from (" + sql + ") b";
        PreparedStatement countStmt = null;
        ResultSet rs = null;
        try {
            countStmt = connection.prepareStatement(countSql);
            BoundSql countBS = new BoundSql(mappedStatement.getConfiguration(), countSql, boundSql.getParameterMappings(), parameterObject);
            this.setParameters(countStmt, mappedStatement, countBS, parameterObject);
            rs = countStmt.executeQuery();
            int totalCount = 0;
            if (rs.next()) {
                totalCount = rs.getInt(1);
            }
            page.setTotalRecords(totalCount);
        }
        catch (SQLException e) {
            logger.error("paging on exception", e);
        }
        finally {
            try {
                if (null != rs) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.error("Ignore this exception", e);
            }
            try {
                if (null != countStmt) {
                    countStmt.close();
                }
            }
            catch (SQLException e) {
                logger.error("Ignore this exception", e);
            }
        }
    }

    private void setParameters(PreparedStatement ps, MappedStatement mappedStatement, BoundSql boundSql, Object parameterObject) throws SQLException {
        DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, parameterObject, boundSql);
        parameterHandler.setParameters(ps);
    }

    public void setProperties(Properties properties) {
        this.dialect = properties.getProperty("dialect");
    }
}

