/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.idproduce;

import com.club.core.db.dao.SequenceProcDao;
import com.club.core.idproduce.AbstractSequenceGenerator;
import com.club.core.spring.context.SpringApplicationContextHolder;
import com.club.framework.exception.BaseAppException;
import com.club.framework.exception.ExceptionHandler;
import com.club.framework.util.Utils;
import com.club.web.common.service.IBaseService;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="sequenceProcGenerator")
public class SequenceProcGenerator
extends AbstractSequenceGenerator {
    private static final SequenceProcDao sequenceProcDao = SpringApplicationContextHolder.getBean(SequenceProcDao.class);
    @Autowired
    private IBaseService baseService;

    @Override
    public Long[] sequenceBatchLongValue(String tableName, String columnName, String schemaName, Integer count) throws BaseAppException {
        if (Utils.isEmpty(tableName) || Utils.isEmpty(schemaName) || Utils.isEmpty(columnName) || Utils.isEmpty(count)) {
            throw ExceptionHandler.publish("APP-00-0022");
        }
        Long[] resultLongs = this.selectSeqFunc(tableName, columnName, schemaName, count);
        if (null == resultLongs || resultLongs.length < 1) {
            throw ExceptionHandler.publish("APP-00-0048");
        }
        return resultLongs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long[] selectSeqFunc(String tableName, String columnName, String schemaName, Integer count) throws BaseAppException {
        SequenceProcDao sequenceProcDao = SequenceProcGenerator.sequenceProcDao;
        synchronized (sequenceProcDao) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("tableName", tableName.toUpperCase());
            params.put("columnName", columnName.toUpperCase());
            params.put("schemaName", schemaName.toUpperCase());
            params.put("count", count);
            SequenceProcGenerator.sequenceProcDao.selectSequence(params);
            String resultStr = (String)params.get("resultStr");
            if (null == resultStr || Utils.isEmpty(resultStr)) {
                params.put("schemaName", "DEF");
                SequenceProcGenerator.sequenceProcDao.selectSequence(params);
                resultStr = (String)params.get("resultStr");
                if (null == resultStr || Utils.isEmpty(resultStr)) {
                    throw ExceptionHandler.publish("APP-00-0049");
                }
            }
            String[] strArray = resultStr.split(",");
            Long[] longArray = new Long[strArray.length];
            for (int i = 0; i < strArray.length; ++i) {
                longArray[i] = Long.valueOf(strArray[i].trim());
            }
            return longArray;
        }
    }
}

