/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.mybatis.cache;

import com.club.core.common.Page;
import com.club.framework.log.ClubLogManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.ibatis.builder.SqlSourceBuilder;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.cache.TransactionalCacheManager;
import org.apache.ibatis.executor.CachingExecutor;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class CacheInterceptor
implements Interceptor {
    private static final ClubLogManager logger = ClubLogManager.getLogger(CacheInterceptor.class);
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    private static final ReflectorFactory DEFAULT_REFLETOR_FACTORY = new DefaultReflectorFactory();
    private static String defaultPageSqlId = ".*Page$";
    private static String pageSqlId = "";
    public static final String CACHEPAGE = "cachePage";
    public static final String RESULTLIST = "resultList";

    public Object intercept(Invocation invocation) throws Throwable {
        Object object;
        Executor executorProxy = (Executor)invocation.getTarget();
        MetaObject metaExecutor = MetaObject.forObject((Object)executorProxy, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLETOR_FACTORY);
        while (metaExecutor.hasGetter("h")) {
            object = metaExecutor.getValue("h");
            metaExecutor = MetaObject.forObject((Object)object, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLETOR_FACTORY);
        }
        while (metaExecutor.hasGetter("target")) {
            object = metaExecutor.getValue("target");
            metaExecutor = MetaObject.forObject((Object)object, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLETOR_FACTORY);
        }
        Object[] args = invocation.getArgs();
        return this.query(metaExecutor, args);
    }

    public <E> List<E> query(MetaObject metaExecutor, Object[] args) throws SQLException {
        MappedStatement ms = (MappedStatement)args[0];
        Object parameterObject = args[1];
        RowBounds rowBounds = (RowBounds)args[2];
        ResultHandler resultHandler = (ResultHandler)args[3];
        BoundSql boundSql = ms.getBoundSql(parameterObject);
        CacheKey cacheKey = this.createCacheKey(ms, parameterObject, rowBounds, boundSql);
        return this.query(metaExecutor, ms, cacheKey, parameterObject, rowBounds, resultHandler, boundSql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E> List<E> query(MetaObject metaExecutor, MappedStatement ms, CacheKey cacheKey, Object parameterObject, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        Cache cache;
        MetaObject metaParameter = MetaObject.forObject((Object)parameterObject, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLETOR_FACTORY);
        if ((rowBounds instanceof Page || ms.getId().matches(pageSqlId)) && (cache = ms.getCache()) != null) {
            if (ms.isUseCache() && resultHandler == null && !((Boolean)metaExecutor.getValue("dirty")).booleanValue()) {
                cache.getReadWriteLock().readLock().lock();
                try {
                    Object value = cache.getObject((Object)cacheKey);
                    if (value != null) {
                        HashMap cachedMap = (HashMap)value;
                        Page cachedPage = (Page)((Object)cachedMap.get(CACHEPAGE));
                        Page originalPage = (Page)rowBounds;
                        if (null != originalPage) {
                            int totalRecords = cachedPage.getTotalRecords();
                            originalPage.setTotalRecords(totalRecords);
                            int totalPages = totalRecords / originalPage.getLimit() + (totalRecords % originalPage.getLimit() == 0 ? 0 : 1);
                            originalPage.setTotalPages(totalPages);
                            List list = (List)cachedMap.get(RESULTLIST);
                            return list;
                        }
                    }
                }
                finally {
                    cache.getReadWriteLock().readLock().unlock();
                }
            }
            Executor delegate = (Executor)metaExecutor.getValue("delegate");
            List list = delegate.query(ms, parameterObject, rowBounds, resultHandler, cacheKey, boundSql);
            TransactionalCacheManager tcm = (TransactionalCacheManager)metaExecutor.getValue("tcm");
            HashMap<String, Object> cachedMap = new HashMap<String, Object>();
            cachedMap.put(CACHEPAGE, rowBounds);
            cachedMap.put(RESULTLIST, list);
            tcm.putObject(cache, cacheKey, cachedMap);
            return list;
        }
        Executor executor = (Executor)metaExecutor.getOriginalObject();
        return executor.query(ms, parameterObject, rowBounds, resultHandler, cacheKey, boundSql);
    }

    private CacheKey createCacheKey(MappedStatement ms, Object parameterObject, RowBounds rowBounds, BoundSql boundSql) {
        Page page;
        Configuration configuration = ms.getConfiguration();
        pageSqlId = configuration.getVariables().getProperty("pageSqlId");
        if (null == pageSqlId || "".equals(pageSqlId)) {
            logger.warn("Property pageSqlId is not setted,use default '.*Page$' ");
            pageSqlId = defaultPageSqlId;
        }
        CacheKey cacheKey = new CacheKey();
        cacheKey.update((Object)ms.getId());
        cacheKey.update((Object)rowBounds.getOffset());
        cacheKey.update((Object)rowBounds.getLimit());
        List parameterMappings = boundSql.getParameterMappings();
        logger.debug("boundSql.getSql():[%s]", (Object)boundSql.getSql());
        cacheKey.update((Object)boundSql.getSql());
        MetaObject metaObject = MetaObject.forObject((Object)parameterObject, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLETOR_FACTORY);
        if (parameterMappings.size() > 0 && parameterObject != null) {
            TypeHandlerRegistry typeHandlerRegistry = ms.getConfiguration().getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                cacheKey.update(parameterObject);
            } else {
                for (ParameterMapping parameterMapping : parameterMappings) {
                    String propertyName = parameterMapping.getProperty();
                    if (metaObject.hasGetter(propertyName)) {
                        cacheKey.update(metaObject.getValue(propertyName));
                        continue;
                    }
                    if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                    cacheKey.update(boundSql.getAdditionalParameter(propertyName));
                }
            }
        }
        if ((rowBounds instanceof Page || ms.getId().matches(pageSqlId)) && null != (page = (Page)rowBounds)) {
            cacheKey.update((Object)page.getPage());
            cacheKey.update((Object)page.getLimit());
        }
        return cacheKey;
    }

    public Object plugin(Object target) {
        if (target instanceof CachingExecutor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    private SqlSource buildSqlSource(Configuration configuration, String originalSql, Class<?> parameterType) {
        SqlSourceBuilder builder = new SqlSourceBuilder(configuration);
        return builder.parse(originalSql, parameterType, null);
    }
}

