/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.protocol.jsch;

import com.club.core.protocol.pool.JSchSessionKeyedObjectPool;
import com.club.core.protocol.pool.ServerConfig;
import com.club.framework.exception.BaseAppException;
import com.club.framework.exception.ExceptionHandler;
import com.club.framework.log.ClubLogManager;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class JSchClient {
    private static final ClubLogManager logger = ClubLogManager.getLogger(JSchClient.class);

    public static Session creatSession(ServerConfig serverConfig) throws BaseAppException {
        Session session = null;
        try {
            session = (Session)JSchSessionKeyedObjectPool.getInstance().getPool().borrowObject((Object)serverConfig);
        }
        catch (Exception e) {
            logger.error("ERROR: Unrecoverable error when trying to get session to serverConfig :  " + serverConfig, e);
            throw ExceptionHandler.publish("APP-00-0081", "ERROR: Unrecoverable error when trying to get session to serverConfig :  " + serverConfig, (Throwable)e);
        }
        return session;
    }

    public static Session creatSession(String host, String user, String password, int port) throws BaseAppException {
        Session session = null;
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.setHost(host);
        serverConfig.setUser(user);
        serverConfig.setPassword(password);
        serverConfig.setPort(port);
        try {
            session = (Session)JSchSessionKeyedObjectPool.getInstance().getPool().borrowObject((Object)serverConfig);
        }
        catch (Exception e) {
            logger.error("ERROR: Unrecoverable error when trying to get session to serverConfig :  " + serverConfig, e);
            throw ExceptionHandler.publish("APP-00-0081", "ERROR: Unrecoverable error when trying to get session to serverConfig :  " + serverConfig, (Throwable)e);
        }
        return session;
    }

    public static Session creatSession(String host, String user, String password) throws BaseAppException {
        return JSchClient.creatSession(host, user, password, 22);
    }

    public static Channel getExecChannel(Session session) throws BaseAppException {
        try {
            Channel channel = session.openChannel("exec");
            return channel;
        }
        catch (JSchException e) {
            logger.error("ERROR: Cann't open ChannelExec from this session : ", e);
            throw ExceptionHandler.publish("APP-00-0082", "ERROR: Cann't open ChannelExec from this session : ", (Throwable)e);
        }
    }

    public static Channel getShellChannel(Session session) throws BaseAppException {
        try {
            Channel channel = session.openChannel("shell");
            return channel;
        }
        catch (JSchException e) {
            logger.error("ERROR: Cann't open ChannelShell from this session : ", e);
            throw ExceptionHandler.publish("APP-00-0082", "ERROR: Cann't open ChannelShell from this session : ", (Throwable)e);
        }
    }

    public static Channel getSftpChannel(Session session) throws BaseAppException {
        try {
            Channel channel = session.openChannel("sftp");
            return channel;
        }
        catch (JSchException e) {
            logger.error("ERROR: Cann't open ChannelSftp from this session : ", e);
            throw ExceptionHandler.publish("APP-00-0082", "ERROR: Cann't open ChannelSftp from this session : ", (Throwable)e);
        }
    }

    public static void closeChannel(Channel channel) {
        if (channel != null) {
            channel.disconnect();
        }
    }

    public static void returnSession(String host, String user, String password, int port, Session session) throws BaseAppException {
        ServerConfig serverConfig = new ServerConfig();
        serverConfig.setHost(host);
        serverConfig.setUser(user);
        serverConfig.setPassword(password);
        serverConfig.setPort(port);
        if (session != null) {
            try {
                JSchSessionKeyedObjectPool.getInstance().getPool().returnObject((Object)serverConfig, (Object)session);
            }
            catch (Exception e) {
                logger.error("ERROR: Return session to pool cast exception : ", e);
                throw ExceptionHandler.publish("APP-00-0083", "ERROR: Return session to pool cast exception : ", (Throwable)e);
            }
        }
    }

    public static void returnSession(ServerConfig serverConfig, Session session) throws BaseAppException {
        if (session != null) {
            try {
                JSchSessionKeyedObjectPool.getInstance().getPool().returnObject((Object)serverConfig, (Object)session);
            }
            catch (Exception e) {
                logger.error("ERROR: Return session to pool cast exception : ", e);
                throw ExceptionHandler.publish("APP-00-0083", "ERROR: Return session to pool cast exception : ", (Throwable)e);
            }
        }
    }

    public static String execNormalCommand(ChannelExec channel, String command) throws IOException, JSchException {
        return JSchClient.execNormalCommand(channel, command, 30000);
    }

    public static String execNormalCommand(ChannelExec channel, String command, int connectTimeout) throws IOException, JSchException {
        channel.setCommand(command);
        InputStream in = channel.getInputStream();
        channel.connect(connectTimeout);
        byte[] tmp = new byte[1024];
        StringBuffer buffer = new StringBuffer();
        while (true) {
            int i;
            if (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                buffer.append(new String(tmp, 0, i));
                continue;
            }
            if (channel.isClosed() && in.available() <= 0) break;
        }
        return buffer.toString();
    }

    public static String execShellCommand(ChannelShell channel, String command) throws IOException, JSchException {
        return JSchClient.execShellCommand(channel, command, 30000);
    }

    public static String execShellCommand(ChannelShell channel, String command, int connectTimeout) throws IOException, JSchException {
        channel.connect(connectTimeout);
        InputStream in = channel.getInputStream();
        OutputStream out = channel.getOutputStream();
        command = command + " \n";
        out.write(command.getBytes());
        out.flush();
        byte[] tmp = new byte[1024];
        StringBuffer buffer = new StringBuffer();
        while (true) {
            int i;
            if (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                buffer.append(new String(tmp, 0, i));
                continue;
            }
            if (channel.isClosed() && in.available() <= 0) break;
        }
        out.close();
        in.close();
        return buffer.toString();
    }
}

