/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.protocol.jsch;

import com.club.framework.log.ClubLogManager;
import com.club.framework.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.apache.commons.net.telnet.TelnetClient;

public class TelnetClientUtil {
    private static final ClubLogManager logger = ClubLogManager.getLogger(TelnetClientUtil.class);
    private TelnetClient telnetClient;
    private InputStream in;
    private PrintStream out;
    private char promptChar = (char)36;
    private String prompt = ">";

    public TelnetClient getTelnetClient(String ip, int port, String user, String password) {
        this.telnetClient = new TelnetClient("VT100");
        boolean valid = true;
        try {
            this.telnetClient.setDefaultTimeout(5000);
            this.telnetClient.connect(ip, port);
            this.in = this.telnetClient.getInputStream();
            this.out = new PrintStream(this.telnetClient.getOutputStream());
            valid = this.login(user, password);
        }
        catch (Exception e) {
            valid = false;
            logger.error(e);
        }
        if (!valid) {
            this.disconnect();
            return null;
        }
        return this.telnetClient;
    }

    public void disconnect() {
        try {
            if (this.telnetClient != null && this.telnetClient.isConnected()) {
                this.telnetClient.disconnect();
            }
        }
        catch (IOException e) {
            logger.error(e);
        }
    }

    public boolean login(String user, String password) {
        this.readUntil("login:");
        this.write(user);
        this.readUntil("password:");
        this.write(password);
        String rs = this.readUntil(null);
        return !Utils.isEmpty(rs) && !rs.contains("failed") && !rs.contains("incorrect");
    }

    public String readUntil(String pattern) {
        StringBuffer sb = new StringBuffer();
        try {
            boolean flag;
            char lastChar = '\uffff';
            boolean bl = flag = pattern != null && pattern.length() > 0;
            if (flag) {
                lastChar = pattern.charAt(pattern.length() - 1);
            }
            Integer code = this.in.read();
            while (code != null && code != -1) {
                char ch = (char)code.intValue();
                sb.append(ch);
                if (flag ? ch == lastChar && sb.toString().toLowerCase().endsWith(pattern) : ch == '$' || ch == '#' || ch == '>') {
                    return sb.toString();
                }
                code = this.in.read();
                String result = sb.toString().toLowerCase();
                if (!result.contains("failed") && !result.contains("incorrect")) continue;
                return sb.toString();
            }
        }
        catch (Exception e) {
            logger.error(e);
        }
        return null;
    }

    public void write(String value) {
        try {
            this.out.println(value);
            this.out.flush();
        }
        catch (Exception e) {
            logger.error(e);
        }
    }
}

