/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.protocol.pool;

import com.club.core.protocol.pool.JSchUserInfo;
import com.club.core.protocol.pool.ServerConfig;
import com.club.framework.exception.BaseAppException;
import com.club.framework.exception.ExceptionHandler;
import com.club.framework.log.ClubLogManager;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;

public class JSchSessionFactory
extends BaseKeyedPoolableObjectFactory<ServerConfig, Session> {
    private static final ClubLogManager logger = ClubLogManager.getLogger(JSchSessionFactory.class);

    public Session makeObject(ServerConfig serverConfig) throws BaseAppException {
        Session session = null;
        try {
            JSch jsch = new JSch();
            session = jsch.getSession(serverConfig.getUser(), serverConfig.getHost(), serverConfig.getPort());
            session.setConfig("StrictHostKeyChecking", serverConfig.getStrictHostKeyChecking());
            JSchUserInfo userInfo = new JSchUserInfo(serverConfig.getUser(), serverConfig.getPassword());
            session.setUserInfo((UserInfo)userInfo);
            session.setTimeout(serverConfig.getTimeout());
            session.setPassword(serverConfig.getPassword());
            session.connect();
        }
        catch (Exception e) {
            logger.error("ERROR: Unrecoverable error when trying to connect to serverConfig :  " + serverConfig, e);
            throw ExceptionHandler.publish("APP-00-0080", "ERROR: Unrecoverable error when trying to connect to serverConfig :  " + serverConfig, (Throwable)e);
        }
        return session;
    }

    public void destroyObject(ServerConfig serverConfig, Session session) {
        session.disconnect();
    }

    public boolean validateObject(ServerConfig key, Session session) {
        return session.isConnected();
    }

    public void activateObject(ServerConfig key, Session obj) throws Exception {
        super.activateObject((Object)key, (Object)obj);
    }

    public void passivateObject(ServerConfig key, Session obj) throws Exception {
        super.passivateObject((Object)key, (Object)obj);
    }
}

