/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.protocol.pool;

import com.club.core.protocol.pool.JSchSessionFactory;
import com.club.core.protocol.pool.ServerConfig;
import com.jcraft.jsch.Session;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class JSchSessionKeyedObjectPool {
    private KeyedObjectPool<ServerConfig, Session> pool;
    private GenericKeyedObjectPool.Config config;

    public static synchronized JSchSessionKeyedObjectPool getInstance() {
        if (null != SingletonHolder.INSTANCE) {
            return SingletonHolder.INSTANCE;
        }
        SingletonHolder.INSTANCE = new JSchSessionKeyedObjectPool();
        return SingletonHolder.INSTANCE;
    }

    public static synchronized JSchSessionKeyedObjectPool getInstance(GenericKeyedObjectPool.Config config) {
        if (null != SingletonHolder.INSTANCE) {
            return SingletonHolder.INSTANCE;
        }
        SingletonHolder.INSTANCE = new JSchSessionKeyedObjectPool(config);
        return SingletonHolder.INSTANCE;
    }

    private JSchSessionKeyedObjectPool() {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        config.maxActive = 8;
        config.whenExhaustedAction = 1;
        config.testOnBorrow = true;
        config.testOnReturn = true;
        config.testWhileIdle = true;
        config.timeBetweenEvictionRunsMillis = 300000L;
        config.minEvictableIdleTimeMillis = 900000L;
        this.config = config;
        this.pool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new JSchSessionFactory(), config);
    }

    private JSchSessionKeyedObjectPool(GenericKeyedObjectPool.Config config) {
        this.config = config;
        this.pool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new JSchSessionFactory(), config);
    }

    public synchronized KeyedObjectPool<ServerConfig, Session> getPool() {
        return this.pool;
    }

    public GenericKeyedObjectPool.Config getPoolConfig() {
        return this.config;
    }

    private static class SingletonHolder {
        public static JSchSessionKeyedObjectPool INSTANCE;

        private SingletonHolder() {
        }
    }
}

