/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.spring.cache;

import com.club.framework.log.ClubLogManager;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.cache.interceptor.DefaultKeyGenerator;

public class HashCodeKeyGenerator
extends DefaultKeyGenerator {
    private static final ClubLogManager logger = ClubLogManager.getLogger(HashCodeKeyGenerator.class);

    public Object generate(Object target, Method method, Object ... params) {
        StringBuffer buffer = new StringBuffer();
        Class<?> entityClass = target.getClass();
        buffer.append(entityClass.getName());
        if (params != null && params.length >= 1) {
            for (Object obj : params) {
                if (obj == null) continue;
                if (obj instanceof AtomicInteger || obj instanceof AtomicLong || obj instanceof BigDecimal || obj instanceof BigInteger || obj instanceof Byte || obj instanceof Double || obj instanceof Float || obj instanceof Integer || obj instanceof Long || obj instanceof Short) {
                    buffer.append(obj);
                    continue;
                }
                if (obj instanceof List || obj instanceof Set || obj instanceof Map) {
                    buffer.append(obj);
                    continue;
                }
                buffer.append(obj.hashCode());
            }
        }
        int keyGenerator = buffer.toString().hashCode();
        logger.debug("HashCodeKeyGenerator created key:" + buffer.toString() + " -- " + keyGenerator);
        return keyGenerator;
    }
}

