/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.spring.web.servlet.handler;

import com.club.framework.exception.BaseAppException;
import com.club.framework.exception.SysRuntimeException;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.MessageResourceUtils;
import com.club.framework.util.Utils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.validation.BindException;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;
import org.springframework.web.servlet.mvc.multiaction.NoSuchRequestHandlingMethodException;

public class CustomMappingExceptionResolver
extends SimpleMappingExceptionResolver {
    private static final ClubLogManager logger = ClubLogManager.getLogger(CustomMappingExceptionResolver.class);

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        String msg;
        String errCode;
        logger.error(ex);
        if (ex instanceof BaseAppException) {
            errCode = ((BaseAppException)ex).getCode();
            if (Utils.isEmpty(errCode)) {
                errCode = "";
                msg = ((BaseAppException)ex).getDesc();
            } else {
                msg = MessageResourceUtils.getMessage(errCode);
            }
        } else if (ex instanceof DuplicateKeyException) {
            errCode = "APP-00-0002";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof DataIntegrityViolationException) {
            errCode = "APP-00-0003";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof BadSqlGrammarException) {
            errCode = "APP-00-0004";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof DataAccessException) {
            errCode = "APP-00-0005";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof CannotCreateTransactionException) {
            errCode = "APP-00-0005";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof MaxUploadSizeExceededException) {
            errCode = "APP-00-0030";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof NoSuchRequestHandlingMethodException) {
            errCode = "APP-00-0060";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof HttpRequestMethodNotSupportedException) {
            errCode = "APP-00-0061";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof HttpMediaTypeNotSupportedException) {
            errCode = "APP-00-0062";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof HttpMediaTypeNotAcceptableException) {
            errCode = "APP-00-0063";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof MissingServletRequestParameterException) {
            errCode = "APP-00-0064";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof ServletRequestBindingException) {
            errCode = "APP-00-0065";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof ConversionNotSupportedException) {
            errCode = "APP-00-0066";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof TypeMismatchException) {
            errCode = "APP-00-0067";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof HttpMessageNotReadableException) {
            errCode = "APP-00-0068";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof HttpMessageNotWritableException) {
            errCode = "APP-00-0069";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof MethodArgumentNotValidException) {
            errCode = "APP-00-0070";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof MissingServletRequestPartException) {
            errCode = "APP-00-0071";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof BindException) {
            errCode = "APP-00-0072";
            msg = MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof SysRuntimeException) {
            errCode = ((SysRuntimeException)ex).getErrorCode();
            msg = null == errCode ? MessageResourceUtils.getMessage("APP-00-0100") : MessageResourceUtils.getMessage(errCode);
        } else if (ex instanceof RuntimeException) {
            errCode = "APP-00-0100";
            msg = MessageResourceUtils.getMessage(errCode);
        } else {
            errCode = "APP-00-0000";
            msg = MessageResourceUtils.getMessage(errCode);
        }
        String responseMsg = "{\"msg\":\"" + msg + "\",\"success\":false,\"errCode\":\"" + errCode + "\"}";
        String viewName = this.determineViewName(ex, request);
        if (viewName != null) {
            if (request.getHeader("accept").indexOf("application/json") <= -1 && (request.getHeader("X-Requested-With") == null || request.getHeader("X-Requested-With").indexOf("XMLHttpRequest") <= -1)) {
                Integer statusCode = this.determineStatusCode(request, viewName);
                if (statusCode != null) {
                    this.applyStatusCodeIfPossible(request, response, statusCode);
                }
                return this.getModelAndView(viewName, ex, request);
            }
            try {
                response.setContentType("application/json;charset=utf-8");
                PrintWriter writer = response.getWriter();
                writer.write(responseMsg);
                writer.flush();
            }
            catch (IOException e) {
                logger.error(e);
            }
            return null;
        }
        return null;
    }
}

