/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.threadpool;

import com.club.core.threadpool.SimpleTaskExecutor;
import com.club.core.threadpool.ThreadPoolFactory;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.StringUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GeneralThreadPool {
    private static final ClubLogManager LOGGER = ClubLogManager.getLogger(GeneralThreadPool.class);
    private ThreadPoolExecutor threadPool = null;
    private int poolType = 0;
    private String name = null;

    public GeneralThreadPool(String name, ThreadPoolExecutor threadPool) {
        this.name = name;
        this.threadPool = threadPool;
    }

    public String getName() {
        return this.name;
    }

    public void execute(Runnable command) {
        if (this.poolType == 0) {
            this.threadPool.execute(command);
        }
    }

    public void execute(SimpleTaskExecutor executor) {
        if (this.poolType == 0) {
            this.threadPool.execute(executor.getConcurrentTask());
        }
    }

    public Future<?> submit(Runnable command) {
        if (this.poolType == 0) {
            return this.threadPool.submit(command);
        }
        return null;
    }

    public <T> Future<T> submit(Runnable task, T result) {
        if (this.poolType == 0) {
            return this.threadPool.submit(task, result);
        }
        return null;
    }

    public <T> Future<T> submit(Callable<T> task) {
        if (this.poolType == 0) {
            return this.threadPool.submit(task);
        }
        return null;
    }

    public void setCorePoolSize(int corePoolSize) {
        if (this.poolType == 0) {
            this.threadPool.setCorePoolSize(corePoolSize);
        }
    }

    public void setKeepAliveTime(long time) {
        this.setKeepAliveTime(time, TimeUnit.SECONDS);
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        if (this.poolType == 0) {
            this.threadPool.setKeepAliveTime(time, TimeUnit.SECONDS);
        }
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        if (this.poolType == 0) {
            this.threadPool.setMaximumPoolSize(maximumPoolSize);
        }
    }

    public int getBlockQueueSize() {
        if (this.poolType == 0) {
            return this.threadPool.getQueue().size();
        }
        return 0;
    }

    public int getActiveCount() {
        if (this.poolType == 0) {
            return this.threadPool.getActiveCount();
        }
        return 0;
    }

    public long getCompletedTaskCount() {
        if (this.poolType == 0) {
            return this.threadPool.getCompletedTaskCount();
        }
        return 0L;
    }

    public long getTaskCount() {
        if (this.poolType == 0) {
            return this.threadPool.getTaskCount();
        }
        return 0L;
    }

    public boolean hasMoreAcquire() {
        if (this.poolType == 0) {
            return !this.threadPool.getQueue().isEmpty();
        }
        return false;
    }

    public void shutdown() {
        if (this.poolType == 0) {
            this.threadPool.shutdown();
            ThreadPoolFactory.removeThreadPoolByName(this.name);
            this.threadPool = null;
            LOGGER.info(StringUtils.format("The thread pool[{0}] is shutdown.", this.name));
        }
    }

    public void shutdownNow() {
        if (this.poolType == 0) {
            this.threadPool.shutdownNow();
            ThreadPoolFactory.removeThreadPoolByName(this.name);
            this.threadPool = null;
            LOGGER.info(StringUtils.format("The thread pool[{0}] is shutdown.", this.name));
        }
    }
}

