/*
 * Decompiled with CFR 0.152.
 */
package com.club.core.threadpool;

import com.club.core.threadpool.GeneralThreadPool;
import com.club.core.threadpool.SimpleTaskExecutor;
import com.club.framework.exception.BaseAppException;
import com.club.framework.exception.ExceptionHandler;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.AssertUtils;
import com.club.framework.util.StringUtils;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolFactory {
    private static final ClubLogManager LOGGER = ClubLogManager.getLogger(SimpleTaskExecutor.class);
    private static ConcurrentHashMap<String, GeneralThreadPool> tpHash = new ConcurrentHashMap();
    private static final long DEFAULTKEEPALIVETIME = 60L;
    private static final TimeUnit DEFAULTUNIT = TimeUnit.SECONDS;
    private static final RejectedExecutionHandler DEFAULTHANDLER = new ThreadPoolExecutor.CallerRunsPolicy();

    public static GeneralThreadPool createSingleThreadPool(String name) throws BaseAppException {
        return ThreadPoolFactory.createGeneralThreadPool(name, 1, 1, 60L, DEFAULTUNIT, new LinkedBlockingQueue<Runnable>(), DEFAULTHANDLER);
    }

    public static GeneralThreadPool createGeneralThreadPool(String name, int corePoolSize) throws BaseAppException {
        return ThreadPoolFactory.createGeneralThreadPool(name, corePoolSize, corePoolSize, 60L, DEFAULTUNIT, new SynchronousQueue<Runnable>(), DEFAULTHANDLER);
    }

    public static GeneralThreadPool createGeneralBoundedThreadPool(String name, int corePoolSize, int queueSize) throws BaseAppException {
        return ThreadPoolFactory.createGeneralThreadPool(name, corePoolSize, corePoolSize, 60L, DEFAULTUNIT, new ArrayBlockingQueue<Runnable>(queueSize), DEFAULTHANDLER);
    }

    public static GeneralThreadPool createGeneralUnboundedThreadPool(String name, int corePoolSize) throws BaseAppException {
        return ThreadPoolFactory.createGeneralThreadPool(name, corePoolSize, corePoolSize, 60L, DEFAULTUNIT, new LinkedBlockingQueue<Runnable>(), DEFAULTHANDLER);
    }

    public static GeneralThreadPool createGeneralThreadPool(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> queue, RejectedExecutionHandler handler) throws BaseAppException {
        ThreadPoolFactory.checkThreadPoolName(name);
        ThreadPoolExecutor executor = null;
        executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, queue, handler);
        GeneralThreadPool cte = new GeneralThreadPool(name, executor);
        LOGGER.info(StringUtils.format("Create concurrent thread pool,the name:[{0}],corePoolSize:[{1}],maxPoolSize:[{2}]]", name, String.valueOf(corePoolSize), String.valueOf(corePoolSize)));
        GeneralThreadPool pool = tpHash.putIfAbsent(name, cte);
        return cte;
    }

    public static boolean checkThreadPoolExist(String name) {
        return tpHash.containsKey(name);
    }

    private static void checkThreadPoolName(String name) throws BaseAppException {
        AssertUtils.isNotEmpty(name);
        if (tpHash.containsKey(name)) {
            ExceptionHandler.publish("S-SYS-00100");
        }
    }

    static void removeThreadPoolByName(String name) {
        tpHash.remove(name);
    }

    static GeneralThreadPool getThreadPoolByName(String name) {
        AssertUtils.isNotEmpty(name);
        if (tpHash.containsKey(name)) {
            return tpHash.get(name);
        }
        return null;
    }
}

