/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.cache;

import com.club.framework.cache.Cache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CacheHelper {
    private static HashMap cacheMap = new HashMap();

    private CacheHelper() {
    }

    public static boolean getBooleanFlag(String key) {
        try {
            return (Boolean)cacheMap.get(key);
        }
        catch (NullPointerException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized boolean setBooleanFlag(String key, boolean flag) {
        if (flag && CacheHelper.getBooleanFlag(key)) {
            return false;
        }
        cacheMap.put(key, flag);
        return true;
    }

    public static long getLongFlag(String key) {
        try {
            return (Long)cacheMap.get(key);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static synchronized boolean setLongFlag(String key, long serverbegrundt) {
        if (cacheMap.get(key) == null) {
            cacheMap.put(key, serverbegrundt);
            return true;
        }
        return false;
    }

    private static synchronized Cache getCache(String key) {
        return (Cache)cacheMap.get(key);
    }

    public static Cache getCacheInfo(String key) {
        if (CacheHelper.hasCache(key)) {
            Cache cache = CacheHelper.getCache(key);
            if (CacheHelper.cacheExpired(cache)) {
                cache.setExpired(true);
            }
            return cache;
        }
        return null;
    }

    private static synchronized boolean hasCache(String key) {
        return cacheMap.containsKey(key);
    }

    public static synchronized void clearAll() {
        cacheMap.clear();
    }

    public static synchronized void clearAll(String type) {
        Iterator i = cacheMap.entrySet().iterator();
        ArrayList<String> arr = new ArrayList<String>();
        try {
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                if (!key.startsWith(type)) continue;
                arr.add(key);
            }
            for (int k = 0; k < arr.size(); ++k) {
                CacheHelper.clearOnly((String)arr.get(k));
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static synchronized void clearOnly(String key) {
        cacheMap.remove(key);
    }

    public static synchronized void putCache(String key, Cache obj) {
        cacheMap.put(key, obj);
    }

    public static void putCacheInfo(String key, Cache obj, long dt, boolean expired) {
        Cache cache = new Cache();
        cache.setKey(key);
        cache.setTimeOut(dt + System.currentTimeMillis());
        cache.setValue(obj);
        cache.setExpired(expired);
        cacheMap.put(key, cache);
    }

    public static void putCacheInfo(String key, Cache obj, long dt) {
        Cache cache = new Cache();
        cache.setKey(key);
        cache.setTimeOut(dt + System.currentTimeMillis());
        cache.setValue(obj);
        cache.setExpired(false);
        cacheMap.put(key, cache);
    }

    public static boolean cacheExpired(Cache cache) {
        if (null == cache) {
            return false;
        }
        long nowDt = System.currentTimeMillis();
        long cacheDt = cache.getTimeOut();
        return cacheDt > 0L && cacheDt <= nowDt;
    }

    public static int getCacheSize() {
        return cacheMap.size();
    }

    public static int getCacheSize(String type) {
        int k = 0;
        Iterator i = cacheMap.entrySet().iterator();
        try {
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String key = (String)entry.getKey();
                if (key.indexOf(type) == -1) continue;
                ++k;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return k;
    }

    public static ArrayList<String> getCacheAllkey() {
        ArrayList<String> a = new ArrayList<String>();
        try {
            for (Map.Entry entry : cacheMap.entrySet()) {
                a.add((String)entry.getKey());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            return a;
        }
    }

    public static ArrayList<String> getCacheListkey(String type) {
        ArrayList<String> a = new ArrayList<String>();
        try {
            for (Map.Entry entry : cacheMap.entrySet()) {
                String key = (String)entry.getKey();
                if (key.indexOf(type) == -1) continue;
                a.add(key);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            return a;
        }
    }
}

