/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.cipher.arithmetic;

import com.club.framework.cipher.handle.SymmericEncryptionHandle;
import com.club.framework.exception.SysRuntimeException;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.AssertUtils;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class DESIt
implements SymmericEncryptionHandle {
    private String arithmetic = System.getProperty("DES.algorithm", "DES");
    private static final ClubLogManager LOG = ClubLogManager.getLogger(DESIt.class);

    @Override
    public byte[] decrypt(byte[] bInputArr, Key symmetricKey) {
        AssertUtils.isNotEmpty(bInputArr);
        AssertUtils.isNotNull(symmetricKey);
        byte[] bOutputArr = this.doFinal(bInputArr, 2, symmetricKey);
        return bOutputArr;
    }

    @Override
    public byte[] encrypt(byte[] bInputArr, Key symmetricKey) {
        AssertUtils.isNotEmpty(bInputArr);
        AssertUtils.isNotNull(symmetricKey);
        byte[] bOutputArr = this.doFinal(bInputArr, 1, symmetricKey);
        return bOutputArr;
    }

    @Override
    public Key generateSymmetricKey() {
        SecureRandom sr = new SecureRandom();
        SecretKey key = null;
        try {
            KeyGenerator kg = KeyGenerator.getInstance(this.arithmetic);
            kg.init(sr);
            key = kg.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error(this.arithmetic + " No such alorithm", e);
            throw new SysRuntimeException(e, " No such alorithm " + e.getMessage());
        }
        return key;
    }

    private byte[] doFinal(byte[] bInputArr, int cipherMode, Key key) {
        byte[] bOutputArr = null;
        try {
            Cipher cipher = Cipher.getInstance(this.arithmetic);
            cipher.init(cipherMode, key);
            bOutputArr = cipher.doFinal(bInputArr);
        }
        catch (Exception e) {
            LOG.error(" Encrypt or decrypt error in des arithmetic operation doFinal ", e);
            throw new SysRuntimeException(e, " Encrypt or decrypt error in des arithmetic operation doFinal " + e.getMessage());
        }
        return bOutputArr;
    }
}

