/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.cipher.arithmetic;

import com.club.framework.cipher.handle.EncryptionHandle;
import com.club.framework.exception.SysRuntimeException;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.AssertUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5It
implements EncryptionHandle {
    private String algorithm = System.getProperty("MD5.algorithm", "MD5");
    private static final ClubLogManager LOG = ClubLogManager.getLogger(MD5It.class);

    @Override
    public byte[] encrypt(byte[] bInputArr) {
        MessageDigest md = null;
        AssertUtils.isNotEmpty(bInputArr);
        try {
            md = MessageDigest.getInstance(this.algorithm);
        }
        catch (SecurityException se) {
            LOG.error(" Security failure. md5 encryption error ", se);
            throw new SysRuntimeException(se, " Security failure. md5 encryption error " + se.getMessage());
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.error(" No Such Algorithm failure. md5 encryption error", ex);
            throw new SysRuntimeException(ex, " No Such Algorithm failure. md5 encryption error " + ex.getMessage());
        }
        md.update(bInputArr);
        byte[] bDigest = md.digest();
        return bDigest;
    }

    @Override
    public byte[] decrypt(byte[] bInputArr) {
        throw new SysRuntimeException(" MD5 decryption unsupported operation ! ");
    }
}

