/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.cipher.arithmetic;

import com.club.framework.cipher.handle.AsymmericEncryptionHandle;
import com.club.framework.exception.SysRuntimeException;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.AssertUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSAIt
implements AsymmericEncryptionHandle {
    private String algorithm = System.getProperty("MD5.algorithm", "RSA");
    private int keysize = 1024;
    private static final ClubLogManager LOG = ClubLogManager.getLogger(RSAIt.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decrypt(byte[] bInputArr, Key privateKey) {
        ByteArrayOutputStream bout = null;
        byte[] bOutputArr = null;
        AssertUtils.isNotEmpty(bInputArr);
        AssertUtils.isNotNull(privateKey);
        try {
            Cipher cipher = this.getCipher(privateKey, 2);
            int blockSize = cipher.getBlockSize();
            bout = new ByteArrayOutputStream(64);
            int j = 0;
            while (bInputArr.length - j * blockSize > 0) {
                boolean isExec;
                boolean bl = isExec = bInputArr.length > (j + 1) * blockSize;
                if (isExec) {
                    bout.write(cipher.doFinal(bInputArr, j * blockSize, blockSize));
                } else {
                    bout.write(cipher.doFinal(bInputArr, j * blockSize, bInputArr.length - j * blockSize));
                }
                ++j;
            }
            bOutputArr = bout.toByteArray();
        }
        catch (IOException ie) {
            LOG.error(" RSA decryption IO Exception ! ", ie);
            throw new SysRuntimeException(ie, " RSA decryption IO Exception ! " + ie.getMessage());
        }
        catch (Exception is) {
            LOG.error(" RSA decrption error ! ", is);
            throw new SysRuntimeException(is, " RSA decrption error ! " + is.getMessage());
        }
        finally {
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (IOException iOException) {
                }
                finally {
                    bout = null;
                }
            }
        }
        return bOutputArr;
    }

    @Override
    public byte[] encrypt(byte[] bInputArr, Key publicKey) {
        AssertUtils.isNotEmpty(bInputArr);
        AssertUtils.isNotNull(publicKey);
        byte[] bOutputArr = null;
        try {
            Cipher cipher = this.getCipher(publicKey, 1);
            int blockSize = cipher.getBlockSize();
            int outputSize = cipher.getOutputSize(bInputArr.length);
            int leavedSize = bInputArr.length % blockSize;
            int blocksSize = leavedSize != 0 ? bInputArr.length / blockSize + 1 : bInputArr.length / blockSize;
            bOutputArr = new byte[outputSize * blocksSize];
            int i = 0;
            while (bInputArr.length - i * blockSize > 0) {
                if (bInputArr.length - i * blockSize > blockSize) {
                    cipher.doFinal(bInputArr, i * blockSize, blockSize, bOutputArr, i * outputSize);
                } else {
                    cipher.doFinal(bInputArr, i * blockSize, bInputArr.length - i * blockSize, bOutputArr, i * outputSize);
                }
                ++i;
            }
        }
        catch (Exception e) {
            LOG.error(" RSA encryption error ! ", e);
            throw new SysRuntimeException(e, " RSA encryption error ! " + e.getMessage());
        }
        return bOutputArr;
    }

    private Cipher getCipher(Key key, int mode) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException {
        Cipher cipher = Cipher.getInstance(this.algorithm, (Provider)new BouncyCastleProvider());
        cipher.init(mode, key);
        return cipher;
    }

    @Override
    public KeyPair generateAsymmericKey() {
        KeyPair pair = null;
        try {
            KeyPairGenerator kg = KeyPairGenerator.getInstance(this.algorithm, (Provider)new BouncyCastleProvider());
            kg.initialize(this.keysize);
            pair = kg.genKeyPair();
        }
        catch (Exception e) {
            LOG.error(" RSA generate key error ! ", e);
            throw new SysRuntimeException(e, " RSA generate key error ! " + e.getMessage());
        }
        return pair;
    }
}

