/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.cipher.arithmetic;

import com.club.framework.cipher.handle.EncryptionHandle;
import com.club.framework.exception.SysRuntimeException;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.AssertUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHAIt
implements EncryptionHandle {
    private String algorithm = System.getProperty("SHA.algorithm", "SHA");
    private static final ClubLogManager LOG = ClubLogManager.getLogger(SHAIt.class);

    @Override
    public byte[] encrypt(byte[] bInputArr) {
        MessageDigest sha = null;
        AssertUtils.isNotEmpty(bInputArr);
        try {
            sha = MessageDigest.getInstance(this.algorithm);
        }
        catch (SecurityException se) {
            LOG.error(" Security failure. SHA encryption error ! ", se);
            throw new SysRuntimeException(se, " Security failure. SHA encryption error ! " + se.getMessage());
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.error(" No Such Algorithm fail  ure. SHA encryption error ! ", ex);
            throw new SysRuntimeException(ex, " No Such Algorithm failure. SHA encryption error ! " + ex.getMessage());
        }
        sha.update(bInputArr);
        return sha.digest();
    }

    @Override
    public byte[] decrypt(byte[] bInputArr) {
        throw new SysRuntimeException(" SHA decryption unsupported operation !");
    }
}

