/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.cipher.digest;

import com.club.framework.cipher.arithmetic.Base64It;
import com.club.framework.cipher.arithmetic.DESIt;
import com.club.framework.cipher.arithmetic.MD5It;
import com.club.framework.cipher.arithmetic.RSAIt;
import com.club.framework.cipher.arithmetic.SHAIt;
import com.club.framework.cipher.handle.AsymmericEncryptionHandle;
import com.club.framework.cipher.handle.EncryptionHandle;
import com.club.framework.cipher.handle.SymmericEncryptionHandle;
import com.club.framework.log.ClubLogManager;
import java.security.Key;
import java.security.KeyPair;
import java.util.HashMap;
import java.util.Map;

public class CipherDigest
implements AsymmericEncryptionHandle,
EncryptionHandle,
SymmericEncryptionHandle {
    private static final ClubLogManager logger = ClubLogManager.getLogger(CipherDigest.class);
    private static Map digestMap = new HashMap();
    private static byte[] rwLock = new byte[0];
    private static boolean isInitDigestMap = false;
    private EncryptionHandle encryptionHandle = null;
    private AsymmericEncryptionHandle asymmericEncryptionHandle = null;
    private SymmericEncryptionHandle symmericEncryptionHandle = null;
    private String name = null;

    protected CipherDigest(String name) {
        this(name, null, null, null);
    }

    protected CipherDigest(String name, EncryptionHandle encryptionHandle) {
        this(name, encryptionHandle, null, null);
    }

    protected CipherDigest(String name, SymmericEncryptionHandle symmericEncryptionHandle) {
        this(name, null, null, symmericEncryptionHandle);
    }

    protected CipherDigest(String name, AsymmericEncryptionHandle asymmericEncryptionHandle) {
        this(name, null, asymmericEncryptionHandle, null);
    }

    protected CipherDigest(String name, EncryptionHandle encryptionHandle, AsymmericEncryptionHandle asymmericEncryptionHandle, SymmericEncryptionHandle symmericEncryptionHandle) {
        this.setName(name);
        this.setEncryptionHandle(encryptionHandle);
        this.setAsymmericEncryptionHandle(asymmericEncryptionHandle);
        this.setSymmericEncryptionHandle(symmericEncryptionHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CipherDigest instance(String cryptDigestName) {
        CipherDigest.registerAllDigest();
        CipherDigest digest = null;
        byte[] byArray = rwLock;
        synchronized (rwLock) {
            digest = (CipherDigest)digestMap.get(cryptDigestName);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return digest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean registerAllDigest() {
        if (!isInitDigestMap) {
            byte[] byArray = rwLock;
            synchronized (rwLock) {
                CipherDigest.registerDigest(new CipherDigest("base64Digest", new Base64It()));
                CipherDigest.registerDigest(new CipherDigest("desDigest", new DESIt()));
                CipherDigest.registerDigest(new CipherDigest("md5Digest", new MD5It()));
                CipherDigest.registerDigest(new CipherDigest("rsaDigest", new RSAIt()));
                CipherDigest.registerDigest(new CipherDigest("shaDigest", new SHAIt()));
                // ** MonitorExit[var0] (shouldn't be in output)
                isInitDigestMap = true;
                return true;
            }
        }
        return false;
    }

    public static boolean registerDigest(CipherDigest digestImpl) {
        if (digestImpl != null) {
            String digestName = digestImpl.getName();
            digestMap.put(digestName, digestImpl);
            return true;
        }
        return false;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public EncryptionHandle getHandle() {
        return this.encryptionHandle;
    }

    public void setEncryptionHandle(EncryptionHandle encryptionHandle) {
        this.encryptionHandle = encryptionHandle;
    }

    public void setAsymmericEncryptionHandle(AsymmericEncryptionHandle asymmericEncryptionHandle) {
        this.asymmericEncryptionHandle = asymmericEncryptionHandle;
    }

    public void setSymmericEncryptionHandle(SymmericEncryptionHandle symmericEncryptionHandle) {
        this.symmericEncryptionHandle = symmericEncryptionHandle;
    }

    @Override
    public byte[] encrypt(byte[] bInput) {
        if (this.encryptionHandle != null) {
            return this.encryptionHandle.encrypt(bInput);
        }
        logger.error(this.getName() + " not support this operation! because encryptionHandle is null! by encrypt(byte[] bInput) ");
        throw new UnsupportedOperationException(this.getName() + " not support this operation because " + this.getName() + " is not {SHA,MD5,Base64} ! ");
    }

    @Override
    public byte[] decrypt(byte[] bInput) {
        if (this.encryptionHandle != null) {
            return this.encryptionHandle.decrypt(bInput);
        }
        logger.error(this.getName() + " not support this operation! because encryptionHandle is null! by decrypt(byte[] bInput) ");
        throw new UnsupportedOperationException(this.getName() + " not support this operation because " + this.getName() + " is not {SHA,MD5,Base64} ! ");
    }

    @Override
    public byte[] encrypt(byte[] sInput, Key encryptKey) {
        if (this.asymmericEncryptionHandle != null) {
            return this.asymmericEncryptionHandle.encrypt(sInput, encryptKey);
        }
        if (this.symmericEncryptionHandle != null) {
            return this.symmericEncryptionHandle.encrypt(sInput, encryptKey);
        }
        logger.error(this.getName() + " not support this operation! because asymmericEncryptionHandle is null and symmericEncryptionHandle is null ! by encrypt(byte[] sInput, Key encryptKey) ");
        throw new UnsupportedOperationException(this.getName() + " not support this operation because " + this.getName() + " is not an asymmetric or symmetric algorithm ! ");
    }

    @Override
    public KeyPair generateAsymmericKey() {
        if (this.asymmericEncryptionHandle != null) {
            return this.asymmericEncryptionHandle.generateAsymmericKey();
        }
        throw new UnsupportedOperationException(this.getName() + " not support this operation because " + this.getName() + " is not an asymmetric algorithm ! ");
    }

    @Override
    public byte[] decrypt(byte[] sInput, Key decryptKey) {
        if (this.symmericEncryptionHandle != null) {
            return this.symmericEncryptionHandle.decrypt(sInput, decryptKey);
        }
        if (this.asymmericEncryptionHandle != null) {
            return this.asymmericEncryptionHandle.decrypt(sInput, decryptKey);
        }
        throw new UnsupportedOperationException(this.getName() + " not support this operation because " + this.getName() + " is not an  algorithm ! ");
    }

    @Override
    public Key generateSymmetricKey() {
        if (this.symmericEncryptionHandle != null) {
            return this.symmericEncryptionHandle.generateSymmetricKey();
        }
        throw new UnsupportedOperationException(this.getName() + " not support this operation because " + this.getName() + " is not an symmetric algorithm ! ");
    }
}

