/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.exception;

import com.club.framework.util.ExceptionUtils;
import com.club.framework.util.MessageResourceUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class BaseAppException
extends IOException
implements Serializable {
    private static final long serialVersionUID = 2630051619397959471L;
    private int id;
    private String code;
    private String desc;
    private String localeMessage;
    private Date time;
    private int type;

    public BaseAppException() {
    }

    public BaseAppException(String code) {
        this(code, null, 1, null, null, null, null);
    }

    public BaseAppException(String code, String msg) {
        this(code, msg, 1, null, null, null, null);
    }

    public BaseAppException(String code, String msg, String arg0) {
        this(code, msg, 1, null, arg0, null, null);
    }

    public BaseAppException(String code, Throwable cause) {
        this(code, null, 1, cause, null, null, null);
    }

    public BaseAppException(String code, int errorType, Throwable cause) {
        this(code, null, errorType, cause, null, null, null);
    }

    public BaseAppException(String code, String msg, int errorType) {
        this(code, msg, errorType, null, null, null, null);
    }

    public BaseAppException(String code, String param1, Throwable cause) {
        this(code, null, 1, cause, param1, null, null);
    }

    public BaseAppException(String code, String param1, String param2, Throwable cause) {
        this(code, null, 1, cause, param1, param2, null);
    }

    public BaseAppException(String errorCode, String message, int errorType, Throwable cause, String arg0, String arg1, String arg2) {
        super(message, cause);
        ArrayList<String> list = new ArrayList<String>(3);
        if (arg0 != null) {
            list.add(arg0);
        }
        if (arg1 != null) {
            list.add(arg1);
        }
        if (arg2 != null) {
            list.add(arg2);
        }
        String[] args = null;
        if (list.size() > 0) {
            args = new String[list.size()];
            int i = 0;
            for (String s : list) {
                args[i++] = s;
            }
        }
        this.code = errorCode;
        this.desc = message;
        BaseAppException beCause = ExceptionUtils.getFirstBaseAppException(cause);
        this.type = beCause == null ? errorType : beCause.getType();
        String string = this.localeMessage = this.code == null ? "" : MessageResourceUtils.getMessage(this.code);
        if (args != null && args.length > 0) {
            this.localeMessage = this.replaceArgs(this.localeMessage, args);
        }
    }

    private String replaceArgs(String s, String[] args) {
        int i = 0;
        if (s != null && args != null && args.length > 0) {
            StringBuilder sb = new StringBuilder();
            Pattern p = Pattern.compile("\\{(.*?)\\}");
            Matcher m = p.matcher(s);
            while (m.find()) {
                s = s.replaceFirst("\\{(.*?)\\}", args[i++]);
            }
            sb.append(s);
            return sb.toString();
        }
        return "";
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public Date getTime() {
        if (this.time == null) {
            this.time = new Date();
        }
        return this.time;
    }

    public int getType() {
        return this.type;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.localeMessage != null) {
            sb.append(this.localeMessage);
        }
        if (this.desc != null) {
            sb.append(this.desc);
        }
        return sb.toString();
    }

    public String toStringNonTrace() {
        Throwable cause;
        StringBuilder sb = new StringBuilder();
        if (this.localeMessage != null) {
            sb.append(this.localeMessage);
        }
        if (this.desc != null) {
            sb.append(this.desc);
        }
        if ((cause = this.getCause()) != null) {
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
        }
        if (cause != null) {
            sb.append(cause.getMessage());
        }
        return sb.toString();
    }

    @Override
    public String getMessage() {
        String message = super.getMessage();
        return message;
    }

    public String getLocaleMessage() {
        return this.localeMessage;
    }

    public void setLocaleMessage(String localeMessage) {
        this.localeMessage = localeMessage;
    }

    public String getDetailMessage() {
        String message;
        StringBuilder content = new StringBuilder();
        if (this.localeMessage != null) {
            content.append('[').append(this.localeMessage.trim()).append("] ");
        }
        if ((message = super.getMessage()) != null) {
            content.append('[').append(message.trim()).append("] ");
        }
        return content.toString();
    }
}

