/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.exception;

import com.club.framework.exception.BaseAppException;
import com.club.framework.exception.BaseAppExceptionDto;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.AssertUtils;
import com.club.framework.util.MessageResourceUtils;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;

public final class ExceptionHandler {
    public static final int SYS_ERROR_TYPE = 1;
    public static final int BUSI_ERROR_TYPE = 2;
    public static final String ENCODE_CONFIG_NODE = "ExceptionHandler";
    private static ClubLogManager logger = ClubLogManager.getLogger(ExceptionHandler.class);
    private static long appExceptionCount = 0L;

    public static synchronized long getAppExceptionCount() {
        return appExceptionCount;
    }

    public static synchronized void increaseAppExceptionCount() {
        ++appExceptionCount;
    }

    private ExceptionHandler() {
    }

    public static BaseAppException publishMsg(String msg) throws BaseAppException {
        return ExceptionHandler.publish("APP-00-0200", msg, 1, null, null, null, null);
    }

    public static BaseAppException publishMsg(String msg, Throwable t) throws BaseAppException {
        return ExceptionHandler.publish("APP-00-0200", msg, 1, t, null, null, null);
    }

    public static BaseAppException publish(String errorCode, Throwable t) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, null, 1, t, null, null, null);
    }

    public static BaseAppException publish(String errorCode, int errorType, Throwable t) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, null, errorType, t, null, null, null);
    }

    public static BaseAppException publish(String errorCode) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, null, 1, null, null, null, null);
    }

    public static BaseAppException publish(String errorCode, int errorType) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, null, errorType, null, null, null, null);
    }

    public static BaseAppException publish(String errorCode, String msg) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, msg, 1, null, null, null, null);
    }

    public static BaseAppException publish(String errorCode, String msg, int errorType) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, msg, errorType, null, null, null, null);
    }

    public static BaseAppException publish(String errorCode, String msg, Throwable t) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, msg, 1, t, null, null, null);
    }

    public static BaseAppException publish(String errorCode, String msg, int errorType, Throwable t) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, msg, errorType, t, null, null, null);
    }

    public static BaseAppException publish(String errorCode, String msg, Throwable t, String param) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, msg, 1, t, param, null, null);
    }

    public static BaseAppException publish(String errorCode, String msg, int errorType, Throwable t, String param) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, msg, errorType, t, param, null, null);
    }

    public static BaseAppException publish(String errorCode, String msg, String param1) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, msg, 1, null, param1, null, null);
    }

    public static BaseAppException publish(String errorCode, String msg, int errorType, String param1) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, msg, errorType, null, param1, null, null);
    }

    public static BaseAppException publish(String errorCode, String msg, String param1, String param2) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, msg, 1, null, param1, param2, null);
    }

    public static BaseAppException publish(String errorCode, String msg, int errorType, String param1, String param2) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, msg, errorType, null, param1, param2, null);
    }

    public static BaseAppException publish(String errorCode, String msg, String param1, String param2, String param3) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, msg, 1, null, param1, param2, param3);
    }

    public static BaseAppException publish(String errorCode, String msg, int errorType, String param1, String param2, String param3) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, msg, errorType, null, param1, param2, param3);
    }

    public static BaseAppException publish(String errorCode, int errorType, String param1) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, null, errorType, null, param1, null, null);
    }

    public static BaseAppException publish(String errorCode, int errorType, String param1, String param2) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, null, errorType, null, param1, param2, null);
    }

    public static BaseAppException publish(String errorCode, int errorType, String param1, String param2, String param3) throws BaseAppException {
        return ExceptionHandler.publish(errorCode, null, errorType, null, param1, param2, param3);
    }

    public static BaseAppException publish(String errorCode, String msg, int errorType, Throwable t, String param1, String param2, String param3) throws BaseAppException {
        Throwable cause;
        BaseAppException baseAppException = t instanceof BaseAppException ? (BaseAppException)t : (t instanceof InvocationTargetException ? ((cause = t.getCause()) instanceof BaseAppException ? (BaseAppException)cause : new BaseAppException(errorCode, msg, errorType, t, param1, param2, param3)) : new BaseAppException(errorCode, msg, errorType, t, param1, param2, param3));
        throw baseAppException;
    }

    public static BaseAppExceptionDto getMostExactException(Throwable ex) {
        AssertUtils.isNotNull(ex, "Exception");
        BaseAppExceptionDto bae = new BaseAppExceptionDto();
        Throwable cause = ex;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof BaseAppException) {
            bae.setErrorCode(((BaseAppException)cause).getCode());
            bae.setErrorMessage(((BaseAppException)cause).getLocaleMessage());
        } else if (cause instanceof SQLException) {
            bae.setErrorCode("APP-00-0001");
            bae.setErrorMessage(MessageResourceUtils.getMessage("APP-00-0001") + " :" + cause.getMessage() == null ? "" : cause.getMessage());
        } else {
            bae.setErrorCode("APP-00-0000");
            bae.setErrorMessage(MessageResourceUtils.getMessage("APP-00-0000") + " :" + cause.getMessage() == null ? "" : cause.getMessage());
        }
        return bae;
    }

    public static void logErrorInfo(String m, Throwable ex) {
        ExceptionHandler.increaseAppExceptionCount();
        logger.error(m, ex);
    }

    private static void logErrorInfo(BaseAppException baseAppException) {
        ExceptionHandler.increaseAppExceptionCount();
        StringBuilder sb = new StringBuilder();
        sb.append(baseAppException.toString());
        if (baseAppException.getDesc() != null) {
            sb.append("\r\n").append(baseAppException.getDesc());
        }
        Throwable cause = baseAppException.getCause();
        while (cause != null) {
            sb.append("\r\nCause by: ");
            sb.append(cause.toString());
            for (int i = 0; i < cause.getStackTrace().length; ++i) {
                sb.append("\r\n\tat ");
                sb.append(cause.getStackTrace()[i]);
            }
            if ((cause = cause.getCause()) == null) continue;
            sb.append("\r\nCaused by: ");
        }
        logger.error(sb.toString());
    }
}

