/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.log;

import com.club.framework.exception.ExceptionHandler;
import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClubLogManager {
    Logger logger = null;
    public String name = "";
    public static final ConcurrentHashMap<String, ClubLogManager> loggerMap = new ConcurrentHashMap();

    private ClubLogManager(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static ClubLogManager getLogger(String name) {
        ClubLogManager zsmartLogger = loggerMap.get(name);
        if (zsmartLogger == null) {
            zsmartLogger = new ClubLogManager(name);
            loggerMap.remove(name, zsmartLogger);
            loggerMap.putIfAbsent(name, zsmartLogger);
        }
        return loggerMap.get(name);
    }

    public static ClubLogManager getLogger(Class<?> clazz) {
        return ClubLogManager.getLogger(clazz.getName());
    }

    public void debug(String msg) {
        if (this.logger.isDebugEnabled()) {
            msg = this.dealMsg(msg, new Object[0]);
            this.logger.debug(msg);
        }
    }

    public void debug(String msg, Object arg) {
        if (this.logger.isDebugEnabled()) {
            msg = this.dealMsg(msg, arg);
            this.logger.debug(msg);
        }
    }

    public void debug(String msg, Object arg1, Object arg2) {
        if (this.logger.isDebugEnabled()) {
            msg = this.dealMsg(msg, arg1, arg2);
            this.logger.debug(msg);
        }
    }

    public void debug(String msg, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            msg = this.dealMsg(msg, args);
            this.logger.debug(msg);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(msg, t);
        }
    }

    public void debug(Throwable t) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("", t);
        }
    }

    public void info(String msg) {
        if (this.logger.isInfoEnabled()) {
            msg = this.dealMsg(msg, new Object[0]);
            this.logger.info(msg);
        }
    }

    public void info(String msg, Object arg) {
        if (this.logger.isInfoEnabled()) {
            msg = this.dealMsg(msg, arg);
            this.logger.info(msg);
        }
    }

    public void info(String msg, Object arg1, Object arg2) {
        if (this.logger.isInfoEnabled()) {
            msg = this.dealMsg(msg, arg1, arg2);
            this.logger.info(msg);
        }
    }

    public void info(String msg, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            msg = this.dealMsg(msg, args);
            this.logger.info(msg);
        }
    }

    public void info(String msg, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(msg, t);
        }
    }

    public void info(Throwable t) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("", t);
        }
    }

    public void warn(String msg) {
        if (this.logger.isWarnEnabled()) {
            msg = this.dealMsg(msg, new Object[0]);
            this.logger.warn(msg);
        }
    }

    public void warn(String msg, Object arg) {
        if (this.logger.isWarnEnabled()) {
            msg = this.dealMsg(msg, arg);
            this.logger.warn(msg);
        }
    }

    public void warn(String msg, Object arg1, Object arg2) {
        if (this.logger.isWarnEnabled()) {
            msg = this.dealMsg(msg, arg1, arg2);
            this.logger.warn(msg);
        }
    }

    public void warn(String msg, Object ... args) {
        if (this.logger.isWarnEnabled()) {
            msg = this.dealMsg(msg, args);
            this.logger.warn(msg);
        }
    }

    public void warn(String msg, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn(msg, t);
        }
    }

    public void warn(Throwable t) {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("", t);
        }
    }

    public void error(String msg) {
        if (this.logger.isErrorEnabled()) {
            msg = this.dealMsg(msg, new Object[0]);
            this.logger.error(msg);
        }
    }

    public void error(String msg, Object arg) {
        if (this.logger.isErrorEnabled()) {
            msg = this.dealMsg(msg, arg);
            this.logger.error(msg);
        }
    }

    public void error(String msg, Object arg1, Object arg2) {
        if (this.logger.isErrorEnabled()) {
            msg = this.dealMsg(msg, arg1, arg2);
            this.logger.error(msg);
        }
    }

    public void error(String msg, Object ... args) {
        if (this.logger.isErrorEnabled()) {
            msg = this.dealMsg(msg, args);
            this.logger.error(msg);
        }
    }

    public void error(String msg, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(msg, t);
        }
    }

    public void error(Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error("", t);
        }
    }

    private String dealMsg(String msg, Object ... args) {
        if (args != null && args.length > 0) {
            msg = MessageFormat.format(msg, args);
        }
        return new StringBuffer().append(this.name).append(": ").append(msg).toString();
    }

    public static void main(String[] args) {
        String res = MessageFormat.format("{1}  {0} {2}", "abc", "cde");
        System.out.println(res);
        ClubLogManager log = ClubLogManager.getLogger(ClubLogManager.class);
        try {
            throw ExceptionHandler.publish("111", 2);
        }
        catch (Exception e) {
            log.error(e);
            log.error("{0} sssssss{1}", (Object)"1111111111", (Object)"3333333333333");
            return;
        }
    }
}

