/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

public class AssertUtils {
    public static <T> void isNotNull(T obj, String msg) {
        if (obj == null) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static <T> void isNotNull(T obj) {
        AssertUtils.isNotNull(obj, "The value is null.");
    }

    public static void isNotEmpty(String str, String msg) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isNotEmpty(String str) {
        AssertUtils.isNotEmpty(str, "The value is null.");
    }

    public static void isFalse(boolean blVal, String msg) {
        if (blVal) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isFalse(boolean blVal) {
        AssertUtils.isFalse(blVal, "The value is not false.");
    }

    public static void isTrue(boolean blVal, String msg) {
        if (!blVal) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void isTrue(boolean blVal) {
        AssertUtils.isTrue(blVal, "The value is not true.");
    }

    public static <T, V> void areEqual(T obj1, V obj2, String msg) {
        if (!obj1.equals(obj2)) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static <T, V> void areEqual(T obj1, V obj2) {
        AssertUtils.areEqual(obj1, obj2, "The object is not equal.");
    }

    public static <T> void isNotEmpty(T[] array, String message) {
        if (AssertUtils.isEmpty(array)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static void isNotEmpty(byte[] array, String message) {
        if (AssertUtils.isEmpty(array)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isNotEmpty(byte[] array) {
        AssertUtils.isNotEmpty(array, "[Assertion failed] - this byte array must not be empty: it must contain at least 1 element");
    }

    public static <T> void notEmpty(T[] array) {
        AssertUtils.isNotEmpty(array, "[Assertion failed] - this array must not be empty: it must contain at least 1 element");
    }

    public static void main(String[] argsw) {
        byte[] l = null;
        AssertUtils.isNotEmpty(l);
    }

    public static void hasLength(String str, String string) {
        if (str.length() == 0) {
            throw new IllegalArgumentException(string);
        }
    }
}

