/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import com.club.framework.util.CustomConverter;
import com.club.framework.util.JsonUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.beans.BeanCopier;
import net.sf.cglib.core.Converter;

public class BeanUtils {
    private static Map<String, BeanCopier> beanCopierMap = new ConcurrentHashMap<String, BeanCopier>();

    public static void copyProperties(Object source, Object target, boolean overFlag) {
        String compKey = source.getClass().getName() + target.getClass().getName();
        BeanCopier copier = beanCopierMap.get(compKey);
        if (copier == null) {
            copier = BeanCopier.create(source.getClass(), target.getClass(), (!overFlag ? 1 : 0) != 0);
            beanCopierMap.put(compKey, copier);
        }
        CustomConverter converter = null;
        if (!overFlag) {
            converter = new CustomConverter(target);
        }
        copier.copy(source, target, (Converter)converter);
    }

    public static void copyProperties(Object source, Object target) {
        BeanUtils.copyProperties(source, target, true);
    }

    public static <T> T copy(Object orig, Class<T> clazzT) {
        try {
            T dest = clazzT.newInstance();
            if (orig == null) {
                return null;
            }
            org.apache.commons.beanutils.BeanUtils.copyProperties(dest, (Object)orig);
            return dest;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> copy(List<?> origList, Class<T> clazzT) {
        try {
            ArrayList<T> destList = new ArrayList<T>();
            if (origList == null || origList.size() <= 0) {
                return null;
            }
            for (int i = 0; i < origList.size(); ++i) {
                destList.add(BeanUtils.copy(origList.get(i), clazzT));
            }
            return destList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T convertMap(Class<T> type, Map<String, Object> map) {
        return JsonUtil.toBean(JsonUtil.toJson(map), type);
    }

    public static <T> T map2Bean(Map<String, Object> map, Class<T> class1) {
        T bean = null;
        try {
            bean = class1.newInstance();
            org.apache.commons.beanutils.BeanUtils.populate(bean, map);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return bean;
    }

    public static <T> List<T> convertList(Class<T> type, List<Map<String, Object>> list) {
        return JsonUtil.toList(JsonUtil.toJson(list), type);
    }

    public static Map<String, Object> convertBean(Object bean) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Class<?> type = bean.getClass();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(type);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if (propertyName.equals("class")) continue;
            Method readMethod = descriptor.getReadMethod();
            Object result = readMethod.invoke(bean, new Object[0]);
            if (result != null) {
                returnMap.put(propertyName, result);
                continue;
            }
            returnMap.put(propertyName, "");
        }
        return returnMap;
    }

    public static Map<String, Object> convertBean(Object bean, Object nullField) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Class<?> type = bean.getClass();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(type);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if (propertyName.equals("class")) continue;
            Method readMethod = descriptor.getReadMethod();
            Object result = readMethod.invoke(bean, new Object[0]);
            if (result != null) {
                returnMap.put(propertyName, result);
                continue;
            }
            returnMap.put(propertyName, nullField);
        }
        return returnMap;
    }

    public static Map<String, Object> convertBeanNotNull(Object bean) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Class<?> type = bean.getClass();
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        BeanInfo beanInfo = Introspector.getBeanInfo(type);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            Method readMethod;
            Object result;
            PropertyDescriptor descriptor = propertyDescriptors[i];
            String propertyName = descriptor.getName();
            if (propertyName.equals("class") || (result = (readMethod = descriptor.getReadMethod()).invoke(bean, new Object[0])) == null) continue;
            returnMap.put(propertyName, result);
        }
        return returnMap;
    }
}

