/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import com.club.framework.log.ClubLogManager;
import com.club.framework.util.Utils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import net.sf.cglib.core.Converter;

public class CustomConverter
implements Converter {
    public static final ClubLogManager logger = ClubLogManager.getLogger(CustomConverter.class);
    public Object target;

    public CustomConverter(Object target) {
        this.target = target;
    }

    public Object convert(Object sourceValue, Class target, Object context) {
        if (context.toString().startsWith("set")) {
            String methodName = context.toString().replace(context.toString().substring(0, 3), "get");
            Map<String, PropertyDescriptor> getterMap = this.getPropertiesHelper(this.target.getClass());
            if (getterMap.containsKey(methodName)) {
                try {
                    Object targetValue = getterMap.get(methodName).getReadMethod().invoke(this.target, null);
                    if (targetValue instanceof String && Utils.isEmpty((String)targetValue)) {
                        return sourceValue;
                    }
                    if (Utils.isEmpty(targetValue)) {
                        return sourceValue;
                    }
                    return targetValue;
                }
                catch (Exception e) {
                    logger.error("reflect get value error:", e);
                }
            }
        }
        return sourceValue;
    }

    private Map<String, PropertyDescriptor> getPropertiesHelper(Class type) {
        HashMap<String, PropertyDescriptor> propertyMap = new HashMap<String, PropertyDescriptor>();
        try {
            BeanInfo info = Introspector.getBeanInfo(type, Object.class);
            PropertyDescriptor[] all = info.getPropertyDescriptors();
            for (int i = 0; i < all.length; ++i) {
                PropertyDescriptor pd = all[i];
                if (pd.getReadMethod() == null) continue;
                propertyMap.put(pd.getReadMethod().getName(), pd);
            }
        }
        catch (Exception e) {
            logger.error("reflect get value error:", e);
        }
        return propertyMap;
    }
}

