/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import com.club.framework.exception.BaseAppException;
import com.club.framework.exception.ExceptionHandler;
import com.club.framework.log.ClubLogManager;
import com.club.framework.util.Utils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class DateUtils {
    public static String STR_DEFAULT_DATE_FORMAT_WITH_SPLIT = "yyyy-MM-dd HH:mm:ss";
    public static String STR_DEFAULT_DATE_FORMAT_WITHOUT_SPLIT = "yyyyMMddHHmmss";
    public static String STR_NAME_FILE_DATE_FORMAT = "yyyyMMdd_HHmmss";
    public static String STR_DATE_FORMAT_DAY_WITH_SPLIT = "yyyy-MM-dd";
    public static String STR_DATE_FORMAT_DAY_WITHOUT_SPLIT = "yyyyMMdd";
    public static String STR_DATE_FORMAT_MONTH_WITH_SPLIT = "yyyy-MM";
    public static String STR_DATE_FORMAT_MONTH_WITHOUT_SPLIT = "yyyyMM";
    public static String STR_DATE_FORMAT_YEAR = "yyyy";
    public static String STR_DATE_FORMAT_MINUTE = "yyyy-MM-dd HH:mm";
    public static final ClubLogManager logger = ClubLogManager.getLogger(DateUtils.class);
    public static String POSTGRESQL_GETTIME = " SELECT CURRENT_TIMESTAMP ";
    public static String ORACLE_GETTIME = " SELECT SYSDATE FROM DUAL ";

    private DateUtils() {
    }

    public static String date2String(Date date, String format) {
        if (date == null) {
            date = new Date();
        }
        SimpleDateFormat sdf = null;
        try {
            sdf = new SimpleDateFormat(format);
        }
        catch (Exception e) {
            sdf = new SimpleDateFormat(STR_DEFAULT_DATE_FORMAT_WITH_SPLIT);
        }
        return sdf.format(date);
    }

    public static String date2StringDay(Date date) {
        return DateUtils.date2String(date, STR_DATE_FORMAT_DAY_WITH_SPLIT);
    }

    public static String date2StringMonth(Date date) {
        return DateUtils.date2String(date, STR_DATE_FORMAT_MONTH_WITH_SPLIT);
    }

    public static String date2StringYear(Date date) {
        return DateUtils.date2String(date, STR_DATE_FORMAT_YEAR);
    }

    public static String date2SuitString(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int sec = calendar.get(13);
        int minute = calendar.get(12);
        int hour = calendar.get(11);
        if (sec == 0 && minute != 0) {
            return DateUtils.date2String(date, STR_DATE_FORMAT_MINUTE);
        }
        if (minute == 0 && hour == 0) {
            return DateUtils.date2String(date, STR_DATE_FORMAT_DAY_WITH_SPLIT);
        }
        return DateUtils.date2String(date, STR_DATE_FORMAT_MINUTE);
    }

    public static String date2String(Date date) {
        return DateUtils.date2String(date, STR_DEFAULT_DATE_FORMAT_WITH_SPLIT);
    }

    public static String getCurrentDate() {
        Date date = new Date();
        return DateUtils.date2String(date, STR_DEFAULT_DATE_FORMAT_WITH_SPLIT);
    }

    public static String getNameFileCurrentDate() {
        Date date = new Date();
        return DateUtils.date2String(date, STR_NAME_FILE_DATE_FORMAT);
    }

    public static Date string2Date(String date) {
        return DateUtils.string2Date(date, STR_DEFAULT_DATE_FORMAT_WITH_SPLIT);
    }

    public static Date string2Date(String date, String dateFormat) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            long time = sdf.parse(date).getTime();
            return new Date(time);
        }
        catch (Exception e) {
            logger.error("convert date error, " + date, e);
            return null;
        }
    }

    public static String getStandardNowTime() {
        return DateUtils.getStandardTimeFormat().format(new Date());
    }

    public static SimpleDateFormat getStandardTimeFormat() {
        return new SimpleDateFormat(STR_DEFAULT_DATE_FORMAT_WITH_SPLIT);
    }

    public static Date getNowDate() {
        return new Date();
    }

    public static Date offsetSecond(Date date, long seconds) {
        long time = date.getTime();
        return new Date(time += seconds * 1000L);
    }

    public static Date offsetMinute(Date date, long minutes) {
        return DateUtils.offsetSecond(date, 60L * minutes);
    }

    public static Date offsetHour(Date date, long hours) {
        return DateUtils.offsetMinute(date, 60L * hours);
    }

    public static Date offsetDay(Date date, int days) {
        return DateUtils.offsetHour(date, 24 * days);
    }

    public static Date offsetWeek(Date date, int weeks) {
        return DateUtils.offsetDay(date, 7 * weeks);
    }

    public static Date getMonthLastday(Date date) {
        Date newDate = new Date(date.getTime());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(newDate);
        int maxDay = calendar.getActualMaximum(5);
        calendar.set(5, maxDay);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        newDate.setTime(calendar.getTimeInMillis());
        return newDate;
    }

    public static int getMonthMaxDay(Date date) {
        Date newDate = new Date(date.getTime());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(newDate);
        int maxDay = calendar.getActualMaximum(5);
        return maxDay;
    }

    public static Date geYesterday(Date date) {
        Date newDate = new Date(date.getTime());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(newDate);
        int maxDay = calendar.getActualMaximum(5);
        calendar.set(5, maxDay);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        newDate.setTime(calendar.getTimeInMillis());
        return newDate;
    }

    public static Date getMinuteFisrt(Date date) {
        Date newDate = new Date(date.getTime());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(newDate);
        calendar.set(13, 0);
        newDate.setTime(calendar.getTimeInMillis());
        return newDate;
    }

    public static Date getMinuteLast(Date date) {
        Date newDate = new Date(date.getTime());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(newDate);
        calendar.set(13, 59);
        newDate.setTime(calendar.getTimeInMillis());
        return newDate;
    }

    public static Date getMonthBeginday(Date date) {
        Date newDate = new Date(date.getTime());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(newDate);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        newDate.setTime(calendar.getTimeInMillis());
        return newDate;
    }

    public static int getDateDay(Date date) {
        Date newDate = new Date(date.getTime());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(newDate);
        return calendar.get(5);
    }

    public static int getDateMonth(Date date) {
        Date newDate = new Date(date.getTime());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(newDate);
        return calendar.get(2);
    }

    public static java.sql.Date offersetMonth(java.sql.Date date, int months) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int curDay = calendar.get(5);
        int maxDay = calendar.getActualMaximum(5);
        calendar.set(5, 1);
        calendar.add(2, months);
        int newMaxDay = calendar.getActualMaximum(5);
        if (curDay == maxDay) {
            calendar.set(5, newMaxDay);
        } else if (curDay > newMaxDay) {
            calendar.set(5, newMaxDay);
        } else {
            calendar.set(5, curDay);
        }
        date.setTime(calendar.getTimeInMillis());
        return date;
    }

    public static Date offersetMonth(Date date, int months) {
        Calendar calendar = Calendar.getInstance();
        Date reDate = new Date();
        calendar.setTime(date);
        int curDay = calendar.get(5);
        int maxDay = calendar.getActualMaximum(5);
        calendar.set(5, 1);
        calendar.add(2, months);
        int newMaxDay = calendar.getActualMaximum(5);
        if (curDay == maxDay) {
            calendar.set(5, newMaxDay);
        } else if (curDay > newMaxDay) {
            calendar.set(5, newMaxDay);
        } else {
            calendar.set(5, curDay);
        }
        reDate.setTime(calendar.getTimeInMillis());
        return reDate;
    }

    public static boolean isInRange(String date, String beginDate, String endDate) throws BaseAppException {
        boolean asc;
        if (Utils.isEmpty(date) || Utils.isEmpty(beginDate) || Utils.isEmpty(endDate)) {
            ExceptionHandler.publish("");
        }
        int dateLen = date.length();
        int beginDateLen = date.length();
        if (beginDateLen != dateLen) {
            ExceptionHandler.publish("");
        }
        return (asc = DateUtils.isAsc(beginDate, endDate)) ? date.compareTo(beginDate) >= 0 && date.compareTo(endDate) <= 0 : date.compareTo(beginDate) >= 0 || date.compareTo(endDate) <= 0;
    }

    public static boolean isInRange(Date date, Date beginDate, Date endDate) {
        return date.compareTo(beginDate) >= 0 && date.compareTo(endDate) <= 0;
    }

    public static boolean isLaterThan(Date date1, Date date2) {
        return DateUtils.isCompare(date1, date2) == 2;
    }

    public static boolean isEarlyThan(Date date1, Date date2) {
        return DateUtils.isCompare(date1, date2) == 0;
    }

    public static int isCompare(Date beginDate, Date endDate) {
        int ret = 1;
        if (beginDate.after(endDate)) {
            ret = 2;
        }
        if (beginDate.equals(endDate)) {
            ret = 1;
        }
        if (beginDate.before(endDate)) {
            ret = 0;
        }
        return ret;
    }

    private static boolean isAsc(String firstStr, String secondStr) {
        return firstStr.compareTo(secondStr) < 0;
    }

    public static Date getDBCurrentTime() {
        return DateUtils.getNowDate();
    }

    public static Date getDayStartTime(Date start) {
        Calendar todayStart = Calendar.getInstance();
        todayStart.setTime(start);
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime();
    }

    public static Date getDayEndTime(Date start) {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.setTime(start);
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime();
    }

    public static Date[] getDateArrays(Date start, Date end, int calendarType) {
        ArrayList<Date> ret = new ArrayList<Date>();
        Calendar calendar = Calendar.getInstance();
        Date tmpEndDate = DateUtils.getDayEndTime(start);
        calendar.setTime(tmpEndDate);
        long endTime = end.getTime();
        ret.add(start);
        int i = 0;
        while (tmpEndDate.before(end) || tmpEndDate.getTime() == endTime) {
            if (i != 0) {
                ret.add(DateUtils.getDayStartTime(calendar.getTime()));
            }
            ret.add(calendar.getTime());
            calendar.add(calendarType, 1);
            tmpEndDate = calendar.getTime();
            ++i;
        }
        ret.add(end);
        Date[] dates = new Date[ret.size()];
        return ret.toArray(dates);
    }

    public static ArrayList<Date> getDateArraysWithoutEndTime(Date start, Date end, int calendarType) {
        ArrayList<Date> ret = new ArrayList<Date>();
        Calendar calendar = Calendar.getInstance();
        Date tmpEndDate = DateUtils.getDayEndTime(start);
        calendar.setTime(tmpEndDate);
        long endTime = end.getTime();
        ret.add(start);
        int i = 0;
        while (tmpEndDate.before(end) || tmpEndDate.getTime() == endTime) {
            if (i != 0) {
                ret.add(DateUtils.getDayStartTime(calendar.getTime()));
            }
            ret.add(calendar.getTime());
            calendar.add(calendarType, 1);
            tmpEndDate = calendar.getTime();
            ++i;
        }
        if (DateUtils.getDayStartTime(tmpEndDate).before(end) && DateUtils.getDayStartTime(tmpEndDate).after(start)) {
            ret.add(DateUtils.getDayStartTime(end));
        }
        ret.add(end);
        return ret;
    }

    public static ArrayList<Date> getDateArraysByWeek(Date start, Date end) {
        ArrayList<Date> ret = new ArrayList<Date>();
        Date tmpDate = start;
        ret.add(start);
        GregorianCalendar c = new GregorianCalendar();
        c.set(7, c.getFirstDayOfWeek() + 6);
        c.setFirstDayOfWeek(2);
        c.setTime(tmpDate);
        c.set(7, c.getFirstDayOfWeek() + 6);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 0);
        tmpDate = c.getTime();
        if (DateUtils.isCompare(tmpDate, end) == 0) {
            ret.add(tmpDate);
        }
        ret.add(end);
        return ret;
    }

    public static Date getWeekDate(Date date, Date timeSpanDate) {
        GregorianCalendar c = new GregorianCalendar();
        Date tmpDate = new Date();
        c.setTime(timeSpanDate);
        int week = c.get(7);
        c.setTime(date);
        c.set(7, c.getFirstDayOfWeek() + (week - 1));
        tmpDate = c.getTime();
        return tmpDate;
    }

    public static Date getWeekDate(Date timeSpanDate, int week) {
        GregorianCalendar c = new GregorianCalendar();
        Date tmpDate = new Date();
        c.setTime(timeSpanDate);
        c.set(7, c.getFirstDayOfWeek() + (week - 1));
        tmpDate = c.getTime();
        return tmpDate;
    }

    public static Date setWeekDateHHMMSS(Date start, Date timeSpanDate) {
        GregorianCalendar c = new GregorianCalendar();
        GregorianCalendar c1 = new GregorianCalendar();
        Date tmpDate = new Date();
        c1.setTime(timeSpanDate);
        c.setTime(start);
        c.set(7, c1.get(7));
        c.set(11, c1.get(11));
        c.set(12, c1.get(12));
        c.set(13, c1.get(13));
        tmpDate = c.getTime();
        return tmpDate;
    }

    public static ArrayList<Date> getIntervalDay(Date lastExsitDate, Date lastday) throws Exception {
        if (lastExsitDate == null || lastday == null) {
            return null;
        }
        int beginDay = DateUtils.getDateDay(lastExsitDate);
        int lastDay = DateUtils.getDateDay(lastday);
        String str = DateUtils.date2String(lastExsitDate, "yyyy-MM");
        ArrayList<Date> al = new ArrayList<Date>();
        for (int i = beginDay; i <= lastDay; ++i) {
            al.add(DateUtils.string2Date(str + "-" + i, "yyyy-MM-dd"));
        }
        return al;
    }
}

