/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import com.club.framework.exception.BaseAppException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;

public class ExceptionUtils {
    public static final int SQLException_ORA = 1;
    public static final int SQLException_TT = 2;
    public static final int SQLException_ABD = 3;
    public static final int SQLException_QDB = 4;
    public static final int SQLException_ZSMART = 10;
    public static final int SQLException_MYSQL = 11;
    public static final int SQLException_UNKNOWN = 1000;

    public static Throwable findMostUsefulInner(Throwable t) {
        if (t == null) {
            return null;
        }
        Throwable target = t;
        while (target.getCause() != null) {
            if ((target = target.getCause()) instanceof Error) {
                return target;
            }
            if (!(target instanceof SQLException)) continue;
            int type = ExceptionUtils.getSQLExceptionVernderType(target);
            switch (type) {
                case 1: 
                case 2: 
                case 10: {
                    return target;
                }
            }
        }
        return target;
    }

    public static Throwable getMostInnerException(Throwable t) {
        if (t == null) {
            return null;
        }
        Throwable target = t;
        while (target.getCause() != null) {
            target = target.getCause();
        }
        return target;
    }

    public static BaseAppException getFirstBaseAppException(Throwable t) {
        for (Throwable cause = t; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof BaseAppException)) continue;
            return (BaseAppException)cause;
        }
        return null;
    }

    public static Object exCheck(Object arg) {
        if (arg instanceof Throwable) {
            arg = ExceptionUtils.exToString((Throwable)arg);
        }
        return arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exToString(Throwable t) {
        StringWriter sw = new StringWriter(5120);
        try (PrintWriter pw = new PrintWriter(sw);){
            t.printStackTrace(pw);
            String string = sw.toString();
            return string;
        }
    }

    public static String getExceptionStackTrace(Throwable e) {
        String exception = "";
        exception = e.getMessage() + "\n\t";
        for (StackTraceElement stack : e.getStackTrace()) {
            exception = exception + stack.toString() + "\n\t";
        }
        while (e.getCause() != null) {
            e = e.getCause();
            exception = e.getMessage() + "\n\t";
            for (StackTraceElement stack : e.getStackTrace()) {
                exception = exception + stack.toString() + "\n\t";
            }
        }
        return exception;
    }

    public static int getSQLExceptionVernderType(Throwable t) {
        StackTraceElement[] steList = t.getStackTrace();
        if (steList == null || steList.length <= 0) {
            return 1000;
        }
        String name = steList[0].getClassName();
        if (name == null) {
            return 1000;
        }
        if ((name = name.toLowerCase()).startsWith("oracle")) {
            return 1;
        }
        if (name.startsWith("mysql")) {
            return 11;
        }
        if (name.startsWith("com.timesten")) {
            return 2;
        }
        if (name.startsWith("altibase")) {
            return 3;
        }
        if (name.startsWith("com.club.zsmart.core.jdbc.qdbdriver")) {
            return 4;
        }
        if (name.startsWith("com.club")) {
            return 10;
        }
        return 1000;
    }
}

