/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import com.club.framework.log.ClubLogManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class FileUtils {
    private static final ClubLogManager logger = ClubLogManager.getLogger(FileUtils.class);
    private String message;

    public String getMessage() {
        return this.message;
    }

    public String getFileNameFromPath(String path) {
        path = path.replace('\\', '/');
        return path.substring(path.lastIndexOf("/") + 1);
    }

    public String getFolderPathFromPath(String path, int index) {
        String strSplit = path = path.replace('\\', '/');
        for (int i = 0; i < index; ++i) {
            strSplit = path.substring(0, strSplit.lastIndexOf("/"));
        }
        return strSplit;
    }

    public String getFileNameFromPath2And3(String path) {
        path = path.replace('\\', '/');
        String[] st = path.split("/");
        return st[st.length - 3];
    }

    public String getFileNameFromPath1And2(String path) {
        path = path.replace('\\', '/');
        String[] st = path.split("/");
        return st[st.length - 2];
    }

    public String getFileNameFromPathFistAndSec(String path, String value) {
        String strSplit = path.substring(path.indexOf(value));
        return strSplit.substring(strSplit.indexOf("/"));
    }

    public String filePathFormat(String path) {
        return path.replace("\\", "/").endsWith("/") ? path.replace("\\", "/") : path.replace("\\", "/") + "/";
    }

    public String filePathFormat2(String path) {
        return path.replace("\\", "/").endsWith("/") ? path.replace("\\", "/") : path.replace("\\", "/");
    }

    public String filePathFormatEnds(String path) {
        return path.endsWith("/") || path.endsWith("\\") ? path : path + "/";
    }

    public String filePathFormatEndsRemove(String path) {
        return path.endsWith("/") || path.endsWith("\\") ? path.substring(0, path.length() - 1) : path;
    }

    public void renameFile(String oldFile, String newFile) {
        File file = new File(oldFile);
        file.renameTo(new File(newFile));
    }

    public boolean isFileExist(String fullFilePath) {
        File file = new File(fullFilePath);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFileAsString(String fileName) {
        StringBuilder sb = new StringBuilder();
        File file = new File(fileName);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                sb.append(tempString);
            }
            reader.close();
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            logger.error(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFileAsString(InputStream in) {
        StringBuilder sb = new StringBuilder();
        if (in == null) {
            return "";
        }
        InputStreamReader inreader = null;
        try {
            inreader = new InputStreamReader(in, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            logger.error(e1);
        }
        if (inreader == null) {
            return "";
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(inreader);
            String tempString = null;
            while ((tempString = reader.readLine()) != null) {
                sb.append(tempString);
            }
            reader.close();
            String string = sb.toString();
            return string;
        }
        catch (IOException e) {
            logger.error(e);
        }
        finally {
            try {
                in.close();
                inreader.close();
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return "";
    }

    public String createFolder(String folderPath) throws Exception {
        String txt = folderPath;
        File myFilePath = new File(txt);
        if (!myFilePath.exists()) {
            myFilePath.mkdir();
        }
        return txt;
    }

    public String createFolders(String folderPath, String paths) throws Exception {
        String[] st;
        String txts = folderPath;
        for (String str : st = paths.split("\\|")) {
            if (str.equals("")) continue;
            txts = txts.lastIndexOf("/") == txts.length() - 1 ? this.createFolder(txts + str) : this.createFolder(txts + "/" + str);
        }
        return txts;
    }

    public void createFile(String fullFilePath, String fileContent) throws Exception {
        String filePath = fullFilePath.replace("\\", "/");
        filePath = filePath.toString();
        String folderPath = "";
        if (filePath.startsWith("/")) {
            folderPath = "/";
        } else if (filePath.substring(1, 2).equals(":")) {
            folderPath = filePath.substring(0, 2) + "/";
            filePath = filePath.substring(3);
        }
        this.createFolders(folderPath, filePath.substring(0, filePath.lastIndexOf("/") + 1).replace('/', '|'));
        File myFilePath = new File(fullFilePath.replace("\\", "/"));
        if (!myFilePath.exists()) {
            myFilePath.createNewFile();
        }
        if (fileContent != null && !fileContent.equals("")) {
            FileWriter resultFile = new FileWriter(myFilePath);
            PrintWriter myFile = new PrintWriter(resultFile);
            myFile.println(fileContent);
            myFile.close();
            resultFile.close();
        }
    }

    public void createFile(String fullFilePath, String fileContent, String encoding) throws Exception {
        String filePath = fullFilePath.replace("\\", "/");
        filePath = filePath.toString();
        String folderPath = "";
        if (filePath.startsWith("/")) {
            folderPath = "/";
        } else if (filePath.substring(1, 2).equals(":")) {
            folderPath = filePath.substring(0, 2) + "/";
            filePath = filePath.substring(3);
        }
        this.createFolders(folderPath, filePath.substring(0, filePath.lastIndexOf("/") + 1).replace('/', '|'));
        File myFilePath = new File(fullFilePath.replace("\\", "/"));
        if (!myFilePath.exists()) {
            myFilePath.createNewFile();
        }
        if (fileContent != null && !fileContent.equals("")) {
            PrintWriter myFile = new PrintWriter(myFilePath, encoding);
            myFile.println(fileContent);
            myFile.close();
        }
    }

    public boolean delFile(String fullFilePath) throws Exception {
        boolean bea = false;
        this.message = "";
        String filePath = fullFilePath;
        File myDelFile = new File(filePath);
        if (myDelFile.exists()) {
            myDelFile.delete();
            bea = true;
        } else {
            bea = false;
            this.message = fullFilePath + "\u6587\u4ef6\u4e0d\u5b58\u5728";
        }
        return bea;
    }

    public boolean delFolder(String folderPath) {
        try {
            this.delAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            this.message = e.getMessage();
            return false;
        }
        return true;
    }

    public boolean delAllFile(String path) throws Exception {
        boolean bea = false;
        File file = new File(path);
        if (!file.exists()) {
            return bea;
        }
        if (!file.isDirectory()) {
            return bea;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            this.delAllFile(path + "/" + tempList[i]);
            this.delFolder(path + "/" + tempList[i]);
            bea = true;
        }
        return bea;
    }

    public void copyFile(String oldPathFile, String newPathFile) throws Exception {
        int bytesum = 0;
        int byteread = 0;
        File oldfile = new File(oldPathFile);
        if (oldfile.exists()) {
            FileInputStream inStream = new FileInputStream(oldPathFile);
            FileOutputStream fs = new FileOutputStream(newPathFile);
            byte[] buffer = new byte[1444];
            while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
                bytesum += byteread;
                fs.write(buffer, 0, byteread);
            }
            ((InputStream)inStream).close();
        }
    }

    public void copyFolder(String oldPath, String newPath) {
        try {
            new File(newPath).mkdirs();
            File a = new File(oldPath);
            String[] file = a.list();
            File temp = null;
            for (int i = 0; i < file.length; ++i) {
                temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
                if (temp.isFile()) {
                    int len;
                    FileInputStream input = new FileInputStream(temp);
                    FileOutputStream output = new FileOutputStream(newPath + "/" + temp.getName().toString());
                    byte[] b = new byte[5120];
                    while ((len = input.read(b)) != -1) {
                        output.write(b, 0, len);
                    }
                    output.flush();
                    output.close();
                    input.close();
                }
                if (!temp.isDirectory()) continue;
                this.copyFolder(oldPath + "/" + file[i], newPath + "/" + file[i]);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void moveFile(String oldPath, String newPath) throws Exception {
        this.copyFile(oldPath, newPath);
        this.delFile(oldPath);
    }

    public void moveFolder(String oldPath, String newPath) throws Exception {
        this.copyFolder(oldPath, newPath);
        this.delFolder(oldPath);
    }

    public long getFileSizes(String fullFilePath) throws Exception {
        long s = 0L;
        File f = new File(fullFilePath);
        if (f.exists()) {
            FileInputStream fis = null;
            fis = new FileInputStream(f);
            s = fis.available();
        } else {
            f.createNewFile();
            this.message = "\u6587\u4ef6\u4e0d\u5b58\u5728";
        }
        return s;
    }
}

