/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import com.club.framework.exception.SysRuntimeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class HttpUtils {
    private HttpURLConnection urlc = null;
    private String encoding = "UTF-8";
    private HttpMethod method = HttpMethod.GET;
    private int timeout = 2000;
    private Map<String, String> properties = new HashMap<String, String>();

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void addProperties(String key, String value) {
        if (this.properties.containsKey(key)) {
            this.properties.remove(key);
        }
        this.properties.put(key, value);
    }

    private String prepareParam(Map<String, Object> paramMap) {
        StringBuffer sb = new StringBuffer();
        if (paramMap.isEmpty()) {
            return "";
        }
        for (String key : paramMap.keySet()) {
            String value = (String)paramMap.get(key);
            if (sb.length() < 1) {
                sb.append(key).append("=").append(value);
                continue;
            }
            sb.append("&").append(key).append("=").append(value);
        }
        return sb.toString();
    }

    public void sendRequest(String urlStr, Map<String, Object> paramMap) throws Exception {
        String paramStr = this.prepareParam(paramMap);
        if (paramStr != null && paramStr.trim().length() >= 1) {
            urlStr = urlStr + "?" + paramStr;
        }
        this.sendRequest(urlStr, "");
    }

    public void sendRequest(String url, byte[] data) {
        try {
            if (this.method.equals((Object)HttpMethod.GET)) {
                StringBuffer param = new StringBuffer();
                int i = 0;
                for (String key : this.properties.keySet()) {
                    if (i == 0) {
                        param.append("?");
                    } else {
                        param.append("&");
                    }
                    param.append(key).append("=").append(this.properties.get(key));
                    ++i;
                }
                url = url + param;
            }
            URL u = new URL(url);
            this.urlc = (HttpURLConnection)u.openConnection();
            this.urlc.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            this.urlc.setReadTimeout(this.timeout);
            this.urlc.addRequestProperty("method", String.valueOf((Object)this.method));
            this.urlc.setDoOutput(true);
            this.urlc.setDoInput(true);
            this.urlc.setUseCaches(false);
            for (String key : this.properties.keySet()) {
                this.urlc.addRequestProperty(key, this.properties.get(key));
            }
            if (this.method.equals((Object)HttpMethod.POST)) {
                this.urlc.getOutputStream().write(data);
            }
        }
        catch (Throwable e) {
            throw new SysRuntimeException(e, "HttpUtil\u53d1\u9001http\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
        }
    }

    public void sendRequest(String url, String data) {
        byte[] sdata = null;
        try {
            sdata = data.getBytes(this.encoding);
        }
        catch (Throwable e) {
            throw new SysRuntimeException(e, "HttpUtil\u53d1\u9001http\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38" + e.getMessage());
        }
        this.sendRequest(url, sdata);
    }

    public static String getRootPath(HttpServletRequest request) {
        return request.getSession().getServletContext().getRealPath("/");
    }

    public static void main(String[] args) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendGet(String url, String param) {
        String result = "";
        BufferedReader in = null;
        try {
            String line;
            String urlName = url + "?" + param;
            URL realUrl = new URL(urlName);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.connect();
            Map<String, List<String>> map = conn.getHeaderFields();
            for (String key : map.keySet()) {
                System.out.println(key + "--->" + map.get(key));
            }
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + "\n" + line;
            }
        }
        catch (Exception e) {
            System.out.println("\u53d1\u9001GET\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPost(String url, String param) {
        PrintWriter out = null;
        BufferedReader in = null;
        String result = "";
        try {
            String line;
            URL realUrl = new URL(url);
            URLConnection conn = realUrl.openConnection();
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            out = new PrintWriter(conn.getOutputStream());
            out.print(param);
            out.flush();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + "\n" + line;
            }
        }
        catch (Exception e) {
            System.out.println("\u53d1\u9001POST\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e);
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public static enum HttpMethod {
        GET,
        POST,
        DELETE,
        PUT;

    }
}

