/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.map.ListOrderedMap;

public class JsonTools {
    public static List<Map<String, Object>> parseJSON2List(String jsonStr) {
        JSONArray jsonArr = JSONArray.fromObject((Object)jsonStr);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (JSONObject json2 : jsonArr) {
            list.add(JsonTools.parseJSON2Map(json2.toString()));
        }
        return list;
    }

    public static Map<String, Object> parseJSON2Map(String jsonStr) {
        ListOrderedMap map = new ListOrderedMap();
        JSONObject json = JSONObject.fromObject((Object)jsonStr);
        for (Object k : json.keySet()) {
            Object v = json.get(k);
            if (v instanceof JSONArray) {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                for (JSONObject json2 : (JSONArray)v) {
                    list.add(JsonTools.parseJSON2Map(json2.toString()));
                }
                map.put((Object)k.toString(), list);
                continue;
            }
            map.put((Object)k.toString(), v);
        }
        return map;
    }

    public static List<Map<String, Object>> getListByUrl(String url) {
        try {
            String line;
            InputStream in = new URL(url).openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            return JsonTools.parseJSON2List(sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> getMapByUrl(String url) {
        try {
            String line;
            InputStream in = new URL(url).openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
            return JsonTools.parseJSON2Map(sb.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String mapToJson(Map<String, String> map) {
        Set<String> keys = map.keySet();
        String key = "";
        String value = "";
        StringBuffer jsonBuffer = new StringBuffer();
        jsonBuffer.append("{");
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            key = it.next();
            value = map.get(key);
            jsonBuffer.append(key + ":\"" + value + "\"");
            if (!it.hasNext()) continue;
            jsonBuffer.append(",");
        }
        jsonBuffer.append("}");
        return jsonBuffer.toString();
    }

    public static void main(String[] args) {
        String url = "http://localhost:8090/shanguoyinyi/data/cityData.json";
        List<Map<String, Object>> list = JsonTools.getListByUrl(url);
        ArrayList provinces = new ArrayList();
        ArrayList citys = new ArrayList();
        ArrayList countrys = new ArrayList();
        for (Map<String, Object> map : list) {
            HashMap<String, Object> provinceMap = new HashMap<String, Object>();
            provinceMap.put("id", map.get("id"));
            provinceMap.put("name", map.get("name"));
            provinceMap.put("children", map.get("children"));
            List cityList = (List)map.get("children");
            for (Map tmpCity : cityList) {
                HashMap cityMap = new HashMap();
                cityMap.put("id", tmpCity.get("id"));
                cityMap.put("name", tmpCity.get("name"));
                cityMap.put("children", tmpCity.get("children"));
                List countryList = (List)tmpCity.get("children");
                if (countryList != null && countryList.size() > 0) {
                    for (Map tmpCountry : countryList) {
                        HashMap countryMap = new HashMap();
                        countryMap.put("id", tmpCountry.get("id"));
                        countryMap.put("name", tmpCountry.get("name"));
                        countrys.add(countryMap);
                    }
                }
                citys.add(cityMap);
            }
            provinces.add(provinceMap);
        }
        for (Map<String, Object> map : provinces) {
            String id = map.get("id").toString();
            System.out.println(id);
            if (!id.equals("0")) continue;
            System.out.println(map.get("name").toString());
        }
    }
}

