/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import com.club.core.common.JsonObjectMapper;
import com.club.framework.log.ClubLogManager;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class JsonUtil {
    public static final ClubLogManager logger = ClubLogManager.getLogger(JsonUtil.class);
    private static final JsonObjectMapper mapper = new JsonObjectMapper();

    public static <T> T toBean(String content, Class<T> valueType) {
        try {
            return (T)mapper.readValue(content, valueType);
        }
        catch (Exception e) {
            logger.error(e);
            return null;
        }
    }

    public static String toJson(Object object) {
        try {
            return mapper.writeValueAsString(object);
        }
        catch (Exception e) {
            logger.error(e);
            return null;
        }
    }

    public static <T> List<T> toList(String content, Class<T> T) {
        try {
            JavaType javaType = mapper.getTypeFactory().constructParametricType(List.class, new Class[]{T});
            return (List)mapper.readValue(content, javaType);
        }
        catch (Exception e) {
            logger.error(e);
            return null;
        }
    }

    public static <T> T[] toArray(String content, Class<T> T) {
        try {
            List<Object> list = JsonUtil.toList(content, T);
            Object[] a = (Object[])Array.newInstance(T, list.size());
            return list.toArray(a);
        }
        catch (Exception e) {
            logger.error(e);
            return null;
        }
    }

    public static <T> T[] toArray(List<T> list, Class<T> T) {
        try {
            Object[] a = (Object[])Array.newInstance(T, list.size());
            return list.toArray(a);
        }
        catch (Exception e) {
            logger.error(e);
            return null;
        }
    }

    public static Map<String, Object> toMap(String content) {
        try {
            return (Map)mapper.readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            logger.error(e);
            return null;
        }
    }

    public static Map<String, Object> toMap(Object object) {
        try {
            return (Map)mapper.convertValue(object, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            logger.error(e);
            return null;
        }
    }

    public static <T, V> Map<T, V> toJavaMap(String jsonString, Class<T> keyClass, Class<V> valueClass) throws Exception {
        return (Map)mapper.readValue(jsonString, (JavaType)mapper.getTypeFactory().constructMapLikeType(Map.class, keyClass, valueClass));
    }

    public static void writeJson(HttpServletResponse response, Map<?, ?> map) {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter print = null;
        try {
            print = response.getWriter();
        }
        catch (IOException e) {
            logger.error(e);
        }
        print.write(JsonUtil.toJson(map).toString());
    }

    public static void writeJson(HttpServletResponse response, Object object) {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        PrintWriter print = null;
        try {
            print = response.getWriter();
        }
        catch (IOException e) {
            logger.error(e);
        }
        if (object instanceof String) {
            print.write(object.toString());
        } else {
            print.write(JsonUtil.toJson(object).toString());
        }
    }

    static {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        mapper.registerModule((Module)simpleModule);
    }
}

