/*
 * Decompiled with CFR 0.152.
 */
package com.club.framework.util;

import com.club.framework.log.ClubLogManager;
import com.club.framework.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class ListUtils {
    private static final ClubLogManager logger = ClubLogManager.getLogger(ListUtils.class);
    public static final String SPLIT = ",";

    public static boolean isEmpty(List list) {
        return list == null || list.size() == 0;
    }

    public static boolean isNotEmpty(List list) {
        return !ListUtils.isEmpty(list);
    }

    public static List<Long> strToLongList(String str) {
        return ListUtils.strToLongList(str, SPLIT);
    }

    public static List<Long> strToLongList(String str, String split) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (StringUtils.isEmpty(split)) {
            split = SPLIT;
        }
        try {
            if (StringUtils.isNotEmpty(str)) {
                String[] newStrs;
                for (String string : newStrs = str.split(split)) {
                    list.add(Long.valueOf(string));
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return list;
    }

    public static Long[] strToLongs(String str) {
        return ListUtils.strToLongs(str, SPLIT);
    }

    public static Long[] strToLongs(String str, String split) {
        Long[] list = null;
        try {
            if (StringUtils.isEmpty(split)) {
                split = SPLIT;
            }
            if (StringUtils.isNotEmpty(str)) {
                String[] newStrs = str.split(split);
                list = new Long[newStrs.length];
                for (int i = 0; i < newStrs.length; ++i) {
                    list[i] = Long.valueOf(newStrs[i]);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return list;
    }

    public static List<String> strToStrList(String str) {
        return ListUtils.strToStrList(str, SPLIT);
    }

    public static List<String> strToStrList(String str, String split) {
        List<String> list = new ArrayList<String>();
        try {
            if (StringUtils.isEmpty(split)) {
                split = SPLIT;
            }
            if (StringUtils.isNotEmpty(str)) {
                String[] newStrs = str.split(split);
                list = Arrays.asList(newStrs);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return list;
    }
}

